/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static void sleep(long ms) {
        try {
            LOG.trace("Sleeping for {} ms", (Object)ms);
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.trace("", (Throwable)e);
            LOG.warn("Interrupted while sleeping for {} ms", (Object)ms);
        }
    }

    public static void sleepAfter(long startTime, long ms) {
        long now = System.currentTimeMillis();
        long until = startTime + ms;
        LOG.trace("Sleeping until {}", (Object)until);
        if (now < until) {
            Util.sleep(until - now);
        }
    }
}

