/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataComposite;
import org.meteoinfo.ndarray.StructureDataW;
import org.meteoinfo.ndarray.StructureMembers;

public class StructureDataFactory {
    public static StructureData make(String name, Object value) {
        StructureMembers members = new StructureMembers("");
        DataType dtype = DataType.getType(value.getClass());
        StructureMembers.Member m = members.addMember(name, null, null, dtype, new int[]{1});
        StructureDataW sw = new StructureDataW(members);
        Array dataArray = Array.factory(dtype, new int[]{1});
        dataArray.setObject(dataArray.getIndex(), value);
        sw.setMemberData(m, dataArray);
        return sw;
    }

    public static StructureData make(StructureData s1, StructureData s2) {
        return StructureDataFactory.make(new StructureData[]{s1, s2});
    }

    public static StructureData make(StructureData[] sdatas) {
        if (sdatas.length == 1) {
            return sdatas[0];
        }
        int count = 0;
        StructureData result = null;
        for (StructureData sdata : sdatas) {
            if (sdata == null) continue;
            ++count;
            result = sdata;
        }
        if (count == 1) {
            return result;
        }
        StructureDataComposite result2 = new StructureDataComposite();
        for (StructureData sdata : sdatas) {
            if (sdata == null) continue;
            result2.add(sdata);
        }
        return result2;
    }
}

