/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy.dict;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.meteoinfo.ndarray.io.npy.dict.Token;

class Lexer {
    private final char EOF = '\u0000';
    private final String input;
    private final List<Token> tokens = new ArrayList<Token>();
    private int pos = -1;

    private Lexer(String input) {
        this.input = input;
    }

    static List<Token> lex(String input) {
        Lexer lexer = new Lexer(input);
        lexer.loop();
        return lexer.tokens;
    }

    void loop() {
        for (StateFunction stateFn = this::lexText; stateFn != null; stateFn = stateFn.execute()) {
        }
    }

    private StateFunction lexText() {
        char c = this.peek();
        while (Character.isWhitespace(c)) {
            ++this.pos;
            c = this.peek();
        }
        if (c == '\u0000') {
            this.tokens.add(Token.eof(this.pos));
            return null;
        }
        if (c == '\"' || c == '\'') {
            return this::lexString;
        }
        if (Character.isDigit(c)) {
            return this::lexNumber;
        }
        if (Character.isJavaIdentifierStart(c)) {
            return this::lexIdentifier;
        }
        Optional<Token> charToken = Token.of(this.pos, c);
        if (charToken.isPresent()) {
            ++this.pos;
            this.tokens.add(charToken.get());
            return this::lexText;
        }
        this.tokens.add(Token.error(this.pos, "unexpected character: '" + c + "'"));
        return null;
    }

    private StateFunction lexString() {
        char quote = this.next();
        StringBuilder buffer = new StringBuilder();
        int start = this.pos;
        while (true) {
            char c;
            if ((c = this.next()) == '\u0000') {
                this.tokens.add(Token.eof(this.pos));
                return null;
            }
            if (c == quote) break;
            buffer.append(c);
        }
        this.tokens.add(Token.string(start, buffer));
        return this::lexText;
    }

    private StateFunction lexIdentifier() {
        char c;
        StringBuilder buffer = new StringBuilder();
        int start = this.pos + 1;
        while ((c = this.peek()) != '\u0000' && Character.isJavaIdentifierPart(c)) {
            ++this.pos;
            buffer.append(c);
        }
        this.tokens.add(Token.identifier(start, buffer));
        return this::lexText;
    }

    private StateFunction lexNumber() {
        char c;
        StringBuilder buffer = new StringBuilder();
        int start = this.pos + 1;
        while (Character.isDigit(c = this.peek())) {
            ++this.pos;
            buffer.append(c);
        }
        this.tokens.add(Token.integer(start, buffer));
        return this::lexText;
    }

    private char next() {
        int nextPos = this.pos + 1;
        if (nextPos >= this.input.length()) {
            return '\u0000';
        }
        this.pos = nextPos;
        return this.input.charAt(nextPos);
    }

    private char peek() {
        int nextPos = this.pos + 1;
        return nextPos >= this.input.length() ? (char)'\u0000' : this.input.charAt(nextPos);
    }

    @FunctionalInterface
    static interface StateFunction {
        public StateFunction execute();
    }
}

