/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.colors;

import java.awt.Color;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geometry.colors.BoundaryNorm;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.legend.LegendFactory;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class ScalarMappable {
    private ColorMap colorMap;
    private Normalize normalize;

    public ScalarMappable() {
        this.normalize = new Normalize();
        this.colorMap = new ColorMap();
    }

    public ScalarMappable(ColorMap colorMap, Normalize normalize) {
        this.colorMap = colorMap;
        this.normalize = normalize;
    }

    public ScalarMappable(ColorMap colorMap) {
        this(colorMap, new Normalize());
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap value) {
        this.colorMap = value;
    }

    public Normalize getNormalize() {
        return this.normalize;
    }

    public void setNormalize(Normalize value) {
        this.normalize = value;
    }

    public Color getColor(double v) {
        float ratio = this.normalize.apply(v).floatValue();
        return this.colorMap.map((double)ratio);
    }

    public Color[] getColors() {
        if (this.normalize instanceof BoundaryNorm) {
            return this.colorMap.getColors(((BoundaryNorm)this.normalize).getNRegions());
        }
        return this.colorMap.getColors();
    }

    public LegendScheme toLegendScheme(double min, double max) {
        if (min == max) {
            return LegendFactory.createSingleSymbolLegendScheme(ShapeTypes.IMAGE);
        }
        double[] values = MIMath.getIntervalValues((double)min, (double)max);
        int n = values.length;
        Color[] colors = new Color[n + 1];
        colors[0] = this.getColor(min);
        for (int i = 1; i < n + 1; ++i) {
            colors[i] = this.getColor(values[i - 1]);
        }
        LegendScheme ls = LegendFactory.createGraduatedLegendScheme(values, colors, ShapeTypes.IMAGE, min, max);
        ls.setColorMap(this.colorMap);
        ls.setNormalize(this.normalize);
        return ls;
    }

    public LegendScheme toLegendScheme(double min, double max, int n) {
        if (min == max) {
            return LegendFactory.createSingleSymbolLegendScheme(ShapeTypes.IMAGE);
        }
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = new Color[n + 1];
        colors[0] = this.getColor(min);
        for (int i = 1; i < n + 1; ++i) {
            colors[i] = this.getColor(values[i - 1]);
        }
        LegendScheme ls = LegendFactory.createGraduatedLegendScheme(values, colors, ShapeTypes.IMAGE, min, max);
        ls.setColorMap(this.colorMap);
        ls.setNormalize(this.normalize);
        return ls;
    }
}

