/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.transform;

import java.util.Arrays;
import java.util.List;
import org.meteoinfo.math.transform.FastFourierTransform;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;

public class FastFourierTransform2D
extends FastFourierTransform {
    public FastFourierTransform2D() {
    }

    public FastFourierTransform2D(boolean inverse) {
        super(inverse);
    }

    @Override
    public Array apply(Array f) {
        f = f.copyIfView();
        int[] shape = f.getShape();
        int nRow = shape[0];
        int nCol = shape[1];
        Array r = Array.factory((DataType)DataType.COMPLEX, (int[])shape);
        try {
            Array data;
            List<Range> ranges;
            Range yRange;
            int i;
            FastFourierTransform fastFourierTransform = new FastFourierTransform(this.normalization, this.inverse);
            Range xRange = new Range(0, nCol - 1, 1);
            for (i = 0; i < nRow; ++i) {
                yRange = new Range(i, i);
                ranges = Arrays.asList(yRange, xRange);
                data = ArrayMath.section((Array)f, ranges).copy();
                data = fastFourierTransform.apply(data);
                ArrayMath.setSection((Array)r, ranges, (Array)data);
            }
            yRange = new Range(0, nRow - 1, 1);
            for (i = 0; i < nCol; ++i) {
                xRange = new Range(i, i);
                ranges = Arrays.asList(yRange, xRange);
                data = ArrayMath.section((Array)r, ranges).copy();
                data = fastFourierTransform.apply(data);
                ArrayMath.setSection((Array)r, ranges, (Array)data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        return r;
    }
}

