/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.nio.ByteOrder;
import us.hebi.matlab.mat.util.ByteConverter;

class ArrayBoundsCheck
implements ByteConverter {
    final ByteConverter impl;

    @Override
    public short getShort(ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 2);
        return this.impl.getShort(order, bytes, offset);
    }

    @Override
    public int getInt(ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 4);
        return this.impl.getInt(order, bytes, offset);
    }

    @Override
    public long getLong(ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 8);
        return this.impl.getLong(order, bytes, offset);
    }

    @Override
    public float getFloat(ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 4);
        return this.impl.getFloat(order, bytes, offset);
    }

    @Override
    public double getDouble(ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 8);
        return this.impl.getDouble(order, bytes, offset);
    }

    @Override
    public void putShort(short value, ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 2);
        this.impl.putShort(value, order, bytes, offset);
    }

    @Override
    public void putInt(int value, ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 4);
        this.impl.putInt(value, order, bytes, offset);
    }

    @Override
    public void putLong(long value, ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 8);
        this.impl.putLong(value, order, bytes, offset);
    }

    @Override
    public void putFloat(float value, ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 4);
        this.impl.putFloat(value, order, bytes, offset);
    }

    @Override
    public void putDouble(double value, ByteOrder order, byte[] bytes, int offset) {
        this.checkBounds(bytes, offset, 8);
        this.impl.putDouble(value, order, bytes, offset);
    }

    private void checkBounds(byte[] bytes, int offset, int length) {
        if (bytes == null || offset < 0 || offset + length > bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    ArrayBoundsCheck(ByteConverter impl) {
        this.impl = impl;
    }
}

