/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.InserterSource;
import bibliothek.gui.dock.station.StationDropOperation;
import java.util.ArrayList;
import java.util.List;

public class MultiInserter
implements Inserter {
    private List<Inserter> inserters = new ArrayList<Inserter>();

    public void add(Inserter inserter) {
        if (inserter == null) {
            throw new IllegalArgumentException("inserter must not be null");
        }
        this.inserters.add(inserter);
    }

    public void remove(Inserter inserter) {
        this.inserters.remove(inserter);
    }

    public int size() {
        return this.inserters.size();
    }

    public Inserter get(int index) {
        return this.inserters.get(index);
    }

    @Override
    public StationDropOperation before(InserterSource source) {
        for (Inserter inserter : this.inserters) {
            StationDropOperation result = inserter.before(source);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public StationDropOperation after(InserterSource source) {
        for (Inserter inserter : this.inserters) {
            StationDropOperation result = inserter.after(source);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

