/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.DockStationDelegate;
import bibliothek.gui.dock.station.DockStationIcon;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.io.IOException;
import javax.swing.Icon;

public abstract class AbstractDockableStation
extends AbstractDockable
implements DockStation {
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;

    public AbstractDockableStation() {
        super(PropertyKey.DOCK_STATION_TITLE, PropertyKey.DOCK_STATION_TOOLTIP);
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockStationIcon("dockStation.default", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                AbstractDockableStation.this.fireTitleIconChanged(oldValue, newValue);
            }
        };
    }

    public AbstractDockableStation(DockTheme theme) {
        this();
        this.theme = theme;
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme newTheme;
        DockController controller = this.getController();
        if (controller != null && (newTheme = controller.getTheme()) != this.theme) {
            this.theme = newTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    @Override
    public DockActionSource getDirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public void addDockStationListener(DockStationListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeDockStationListener(DockStationListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    @Deprecated
    public boolean isVisible(Dockable dockable) {
        return this.isStationShowing();
    }

    @Override
    public boolean isChildShowing(Dockable dockable) {
        return this.isVisible(dockable);
    }

    @Override
    public boolean isStationShowing() {
        return this.isStationVisible();
    }

    @Override
    @Deprecated
    public boolean isStationVisible() {
        boolean visible = this.isDockableShowing();
        if (visible) {
            return true;
        }
        if (this.getController() != null) {
            return this.getComponent().isShowing();
        }
        return false;
    }

    @Override
    public boolean accept(Dockable child) {
        return true;
    }

    public boolean acceptable(Dockable child) {
        return DockUtilities.acceptable(this, child);
    }

    public boolean acceptable(Dockable old, Dockable next) {
        return DockUtilities.acceptable(this, old, next);
    }

    @Override
    public void changed(Dockable dockable, DockTitle title, boolean active) {
        title.changed(new ActivityDockTitleEvent(this, dockable, active));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest request) {
    }

    @Override
    public void requestChildDisplayer(DisplayerRequest request) {
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this)};
    }

    protected void fireDockablesRepositioned(int fromIndex) {
        this.fireDockablesRepositioned(fromIndex, this.getDockableCount() - 1);
    }

    protected void fireDockablesRepositioned(int fromIndex, int toIndex) {
        int count = toIndex - fromIndex + 1;
        if (count > 0) {
            Dockable[] moved = new Dockable[count];
            for (int i = 0; i < count; ++i) {
                moved[i] = this.getDockable(i + fromIndex);
            }
            this.listeners.fireDockablesRepositioned(moved);
        }
    }

    protected DockStationDelegate delegate() {
        return new DockStationDelegate();
    }
}

