/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Index;
import ucar.ma2.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;

@Immutable
public class CoordsSet
implements Iterable<SubsetParams> {
    private final boolean constantForecast;
    private final List<CoverageCoordAxis> axes;
    private final int[] shape;

    public static CoordsSet factory(boolean constantForecast, List<CoverageCoordAxis> axes) {
        return new CoordsSet(constantForecast, axes);
    }

    private CoordsSet(boolean constantForecast, List<CoverageCoordAxis> axes) {
        this.constantForecast = constantForecast;
        ArrayList<CoverageCoordAxis1D> indAxes = new ArrayList<CoverageCoordAxis1D>();
        int rank = 0;
        for (CoverageCoordAxis axis : axes) {
            if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.dependent) {
                indAxes.add((CoverageCoordAxis1D)axis);
            }
            if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
            ++rank;
        }
        this.axes = axes;
        this.shape = new int[rank];
        int count = 0;
        for (CoverageCoordAxis1D axis : indAxes) {
            if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
            this.shape[count++] = axis.getNcoords();
        }
    }

    public int[] getShape() {
        return this.shape;
    }

    public int[] getShape(RangeIterator y, RangeIterator x) {
        int[] result = new int[this.getRank() + 2];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        result[this.shape.length] = y.length();
        result[this.shape.length + 1] = x.length();
        return result;
    }

    public int getRank() {
        return this.shape.length;
    }

    @Override
    public Iterator<SubsetParams> iterator() {
        return new CoordIterator();
    }

    private void addAdjustedTimeCoords(SubsetParams result, CoverageCoordAxis1D axis, int coordIdx, CalendarDate runtime) {
        double adjust = axis.getOffsetInTimeUnits(runtime, axis.getRefDate());
        if (axis.isInterval()) {
            double[] adjustVal = new double[]{axis.getCoordEdge1(coordIdx) + adjust, axis.getCoordEdge2(coordIdx) + adjust};
            result.setTimeOffsetIntv(adjustVal);
            double mid = (adjustVal[0] + adjustVal[1]) / 2.0;
            result.set("timeOffsetDate", axis.makeDateInTimeUnits(runtime, mid));
            result.set("timeOffsetUnit", axis.getCalendarDateUnit());
        } else {
            double adjustVal = axis.getCoordMidpoint(coordIdx) + adjust;
            result.setTimeOffset(adjustVal);
            result.set("timeOffsetDate", axis.makeDateInTimeUnits(runtime, adjustVal));
            result.set("timeOffsetUnit", axis.getCalendarDateUnit());
        }
    }

    private CoverageCoordAxis1D findDependent(CoverageCoordAxis independentAxis, AxisType axisType) {
        for (CoverageCoordAxis axis : this.axes) {
            if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.dependent) continue;
            for (String axisName : axis.dependsOn) {
                if (!axisName.equalsIgnoreCase(independentAxis.getName()) || axis.getAxisType() != axisType) continue;
                return (CoverageCoordAxis1D)axis;
            }
        }
        return null;
    }

    private class CoordIterator
    implements Iterator<SubsetParams> {
        private int[] odo;
        private int[] shape;
        private long done;
        private long total;

        CoordIterator() {
            this.odo = new int[CoordsSet.this.getRank()];
            this.shape = CoordsSet.this.getShape();
            this.done = 0L;
            this.total = Index.computeSize(this.shape);
        }

        @Override
        public boolean hasNext() {
            return this.done < this.total;
        }

        @Override
        public SubsetParams next() {
            SubsetParams next = this.currentElement();
            ++this.done;
            if (this.done < this.total) {
                this.incr();
            }
            return next;
        }

        private void incr() {
            for (int digit = CoordsSet.this.getRank() - 1; digit >= 0; --digit) {
                int n = digit;
                this.odo[n] = this.odo[n] + 1;
                if (this.odo[digit] < this.shape[digit]) break;
                this.odo[digit] = 0;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private SubsetParams currentElement() {
            SubsetParams result = new SubsetParams();
            int odoIndex = 0;
            CalendarDate runtime = null;
            for (CoverageCoordAxis axis : CoordsSet.this.axes) {
                if (axis.getDependenceType() == CoverageCoordAxis.DependenceType.dependent) continue;
                CoverageCoordAxis1D axis1D = (CoverageCoordAxis1D)axis;
                int coordIdx = axis.getDependenceType() == CoverageCoordAxis.DependenceType.scalar ? 0 : this.odo[odoIndex];
                Object coord = axis1D.getCoordObject(coordIdx);
                if (axis.getAxisType() == AxisType.RunTime) {
                    CoverageCoordAxis1D timeOffsetCF;
                    runtime = (CalendarDate)coord;
                    result.setRunTime(runtime);
                    if (CoordsSet.this.constantForecast && (timeOffsetCF = CoordsSet.this.findDependent(axis, AxisType.TimeOffset)) != null) {
                        CoordsSet.this.addAdjustedTimeCoords(result, timeOffsetCF, coordIdx, runtime);
                    }
                } else if (axis.getAxisType() == AxisType.Time) {
                    CoverageCoordAxis1D runtimeForBest = CoordsSet.this.findDependent(axis, AxisType.RunTime);
                    if (runtimeForBest != null) {
                        runtime = (CalendarDate)runtimeForBest.getCoordObject(coordIdx);
                        result.setRunTime(runtime);
                    }
                    assert (runtime != null);
                    CoordsSet.this.addAdjustedTimeCoords(result, axis1D, coordIdx, runtime);
                } else if (axis.getAxisType().isVert()) {
                    if (coord instanceof Double) {
                        result.setVertCoord((Double)coord);
                    } else {
                        if (!(coord instanceof double[])) throw new IllegalStateException("unknow vert coord type " + coord.getClass().getName());
                        result.setVertCoordIntv((double[])coord);
                    }
                } else if (axis.getAxisType() == AxisType.Ensemble) {
                    result.setEnsCoord((Double)coord);
                } else if (!CoordsSet.this.constantForecast && axis.getAxisType() == AxisType.TimeOffset) {
                    double val;
                    if (coord instanceof Double) {
                        result.setTimeOffset((Double)coord);
                    } else {
                        if (!(coord instanceof double[])) throw new IllegalStateException("unknow time coord type " + coord.getClass().getName());
                        result.setTimeOffsetIntv((double[])coord);
                    }
                    double d = val = axis.isInterval() ? (axis1D.getCoordEdge1(coordIdx) + axis1D.getCoordEdge2(coordIdx)) / 2.0 : axis1D.getCoordMidpoint(coordIdx);
                    assert (runtime != null);
                    result.set("timeOffsetDate", axis.makeDateInTimeUnits(runtime, val));
                    result.set("timeOffsetUnit", axis.getCalendarDateUnit());
                }
                if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
                ++odoIndex;
            }
            return result;
        }
    }
}

