/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.util.CancelTask;

@Deprecated
public class AggregationNew
extends AggregationOuterDimension {
    public AggregationNew(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.joinNew, recheckS);
    }

    @Override
    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, null);
        String dimName = this.getDimensionName();
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        this.promoteGlobalAttributes((AggregationOuterDimension.DatasetOuterDimension)typicalDataset);
        List<String> aggVarNames = this.getAggVariableNames();
        Variable joinAggCoord = this.ncDataset.findVariable(dimName);
        if (joinAggCoord == null) {
            DataType coordType = this.getCoordinateType();
            joinAggCoord = new VariableDS(this.ncDataset, null, null, dimName, coordType, dimName, null, null);
            this.ncDataset.addVariable(null, joinAggCoord);
            joinAggCoord.setProxyReader(this);
            if (this.isDate) {
                joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
                String coordUnits = ((AggregationOuterDimension.DatasetOuterDimension)typicalDataset).coordUdunit;
                if (coordUnits != null && !coordUnits.isEmpty()) {
                    joinAggCoord.addAttribute(new Attribute("units", coordUnits));
                }
            }
            AggregationOuterDimension.CoordValueVar cv = new AggregationOuterDimension.CoordValueVar(joinAggCoord.getFullName(), joinAggCoord.getDataType(), joinAggCoord.getUnitsString());
            joinAggCoord.setSPobject(cv);
            this.cacheList.add(cv);
        } else if (joinAggCoord.isScalar()) {
            if (!aggVarNames.contains(joinAggCoord.getShortName())) {
                aggVarNames.add(joinAggCoord.getShortName());
            }
        } else {
            throw new IllegalArgumentException("Variable " + dimName + " already exists, but is not a scalar (suitable for aggregating as a coordinate).");
        }
        if (aggVarNames.isEmpty()) {
            for (Variable v : typical.getVariables()) {
                if (v instanceof CoordinateAxis) continue;
                aggVarNames.add(v.getShortName());
            }
        }
        for (String varname : aggVarNames) {
            Variable aggVar = this.ncDataset.findVariable(varname);
            if (aggVar == null) {
                logger.error(this.ncDataset.getLocation() + " aggNewDimension cant find variable " + varname);
                continue;
            }
            Group newGroup = DatasetConstructor.findGroup(this.ncDataset, aggVar.getParentGroupOrRoot());
            VariableDS vagg = new VariableDS(this.ncDataset, newGroup, null, aggVar.getShortName(), aggVar.getDataType(), dimName + " " + aggVar.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(aggVar, vagg);
            Attribute att = vagg.findAttribute("_CoordinateAxes");
            if (att != null) {
                String axes = dimName + " " + att.getStringValue();
                vagg.addAttribute(new Attribute("_CoordinateAxes", axes));
            }
            newGroup.removeVariable(aggVar.getShortName());
            newGroup.addVariable(vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
        if (this.isDate && this.timeUnitsChange) {
            this.readTimeCoordinates(this.ncDataset.findVariable(dimName), cancelTask);
        }
        this.ncDataset.finish();
    }

    private DataType getCoordinateType() {
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        AggregationOuterDimension.DatasetOuterDimension first = (AggregationOuterDimension.DatasetOuterDimension)nestedDatasets.get(0);
        return first.coordDataType;
    }
}

