/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.util.Objects;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class UnstructuredProjection
extends ProjectionImpl {
    public static final String EARTH_SHAPE = "earth_shape";
    public static final String NUMBER_OF_GRID_USED = "number_of_grid_used";
    public static final String NUMBER_OF_GRID_IN_REFERENCE = "number_of_grid_in_reference";
    public static final String UUID = "uuid";
    int earthShape;
    int numberOfGridUsed;
    int numberOfGridInReference;
    String uuid;

    public UnstructuredProjection(int earthShape, int numberOfGridUsed, int numberOfGridInReference, String uuid) {
        super("UnstructuredProjection", false);
        this.earthShape = earthShape;
        this.numberOfGridUsed = numberOfGridUsed;
        this.numberOfGridInReference = numberOfGridInReference;
        this.uuid = uuid;
        this.addParameter(EARTH_SHAPE, earthShape);
        this.addParameter(NUMBER_OF_GRID_USED, numberOfGridUsed);
        this.addParameter(NUMBER_OF_GRID_IN_REFERENCE, numberOfGridInReference);
        this.addParameter(UUID, uuid);
    }

    private UnstructuredProjection(UnstructuredProjection that) {
        this(that.earthShape, that.numberOfGridUsed, that.numberOfGridInReference, that.uuid);
    }

    @Override
    public ProjectionImpl constructCopy() {
        return new UnstructuredProjection(this);
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl dest) {
        throw new UnsupportedOperationException("UnstructuredProjection: no formula-based transform available");
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl dest) {
        throw new UnsupportedOperationException("UnstructuredProjection: no formula-based transform available");
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public String paramsToString() {
        return "UnstructuredProjection: no transform parameters";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UnstructuredProjection)) {
            return false;
        }
        UnstructuredProjection that = (UnstructuredProjection)o;
        return this.earthShape == that.earthShape && this.numberOfGridUsed == that.numberOfGridUsed && this.numberOfGridInReference == that.numberOfGridInReference && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.earthShape, this.numberOfGridUsed, this.numberOfGridInReference, this.uuid);
    }
}

