fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
ps = f['PS'][:]
ps = ps[:,'10:60','60:140']
lon = arange(50, 142, 2.5)
lat = arange(5, 66, 2.5)

#Interpolate
nps = interpolate.linint2(ps.dimvalue(2), ps.dimvalue(1), ps, lon, lat)

#Plot
levs = arange(500, 1021, 20)
subplot(2,1,1,axestype='map')
geoshow('country', edgecolor=(0,0,255))
imshow(ps[1,:,:], levs)
title('Pressure - origin')
colorbar()

subplot(2,1,2,axestype='map')
geoshow('country', edgecolor=(0,0,255))
imshow(lon, lat, nps[1,:,:], levs)
title('Pressure - linint2')
colorbar()