/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.jna.platform.windows.IPHlpAPI;

public class WindowsNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworks.class);
    private static final byte majorVersion;

    public static void updateNetworkStats(NetworkIF netIF) {
        if (majorVersion >= 6) {
            IPHlpAPI.MIB_IFROW2 ifRow = new IPHlpAPI.MIB_IFROW2();
            ifRow.InterfaceIndex = new WinDef.ULONG((long)netIF.getNetworkInterface().getIndex());
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.getNetworkInterface().getIndex(), (Object)netIF.getName());
                return;
            }
            netIF.setBytesSent(ifRow.OutOctets);
            netIF.setBytesRecv(ifRow.InOctets);
            netIF.setPacketsSent(ifRow.OutUcastPkts);
            netIF.setPacketsRecv(ifRow.InUcastPkts);
            netIF.setOutErrors(ifRow.OutErrors);
            netIF.setInErrors(ifRow.InErrors);
            netIF.setSpeed(ifRow.ReceiveLinkSpeed);
        } else {
            IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
            ifRow.dwIndex = netIF.getNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.getNetworkInterface().getIndex(), (Object)netIF.getName());
                return;
            }
            netIF.setBytesSent(ifRow.dwOutOctets);
            netIF.setBytesRecv(ifRow.dwInOctets);
            netIF.setPacketsSent(ifRow.dwOutUcastPkts);
            netIF.setPacketsRecv(ifRow.dwInUcastPkts);
            netIF.setOutErrors(ifRow.dwOutErrors);
            netIF.setInErrors(ifRow.dwInErrors);
            netIF.setSpeed(ifRow.dwSpeed);
        }
        netIF.setTimeStamp(System.currentTimeMillis());
    }

    static {
        WinNT.OSVERSIONINFO lpVersionInfo = new WinNT.OSVERSIONINFO();
        majorVersion = !Kernel32.INSTANCE.GetVersionEx(lpVersionInfo) ? lpVersionInfo.dwMajorVersion.byteValue() : (byte)0;
    }
}

