/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.legend;

import java.awt.Color;
import java.util.HashMap;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;

public class PolylineBreak
extends ColorBreak {
    protected float width = 1.0f;
    protected LineStyles style = LineStyles.SOLID;
    protected boolean drawPolyline = true;
    protected boolean drawSymbol = false;
    protected float symbolSize = 8.0f;
    protected PointStyle symbolStyle = PointStyle.UP_TRIANGLE;
    protected Color symbolColor = Color.BLACK;
    protected Color symbolFillColor = Color.BLACK;
    protected boolean fillSymbol = false;
    protected int symbolInterval = 1;
    protected float capSize = 0.0f;

    public PolylineBreak() {
        this.breakType = BreakTypes.POLYLINE_BREAK;
    }

    public static PolylineBreak of(PointBreak pb) {
        PolylineBreak plb = new PolylineBreak();
        plb.setDrawSymbol(true);
        plb.setFillSymbol(pb.drawFill);
        plb.setSymbolFillColor(pb.color);
        plb.setSymbolColor(pb.color);
        plb.setSymbolSize(pb.size);
        plb.setSymbolStyle(pb.style);
        return plb;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float size) {
        this.width = size;
    }

    @Deprecated
    public float getSize() {
        return this.width;
    }

    @Deprecated
    public void setSize(float size) {
        this.width = size;
    }

    public LineStyles getStyle() {
        return this.style;
    }

    public void setStyle(LineStyles value) {
        if (value != null) {
            this.style = value;
        }
    }

    public boolean isDrawPolyline() {
        return this.drawPolyline;
    }

    public void setDrawPolyline(boolean isTrue) {
        this.drawPolyline = isTrue;
    }

    public boolean isDrawSymbol() {
        return this.drawSymbol;
    }

    public void setDrawSymbol(boolean isTrue) {
        this.drawSymbol = isTrue;
    }

    public boolean isDrawSymbolOutline() {
        return this.symbolColor != null;
    }

    public float getSymbolSize() {
        return this.symbolSize;
    }

    public void setSymbolSize(float size) {
        this.symbolSize = size;
    }

    public PointStyle getSymbolStyle() {
        return this.symbolStyle;
    }

    public void setSymbolStyle(PointStyle style) {
        if (style != null) {
            this.symbolStyle = style;
        }
    }

    public Color getSymbolColor() {
        return this.symbolColor;
    }

    public void setSymbolColor(Color c) {
        this.symbolColor = c;
    }

    public Color getSymbolFillColor() {
        return this.symbolFillColor;
    }

    public void setSymbolFillColor(Color value) {
        this.symbolFillColor = value;
    }

    public boolean isFillSymbol() {
        return this.fillSymbol;
    }

    public void setFillSymbol(boolean value) {
        this.fillSymbol = value;
    }

    public int getSymbolInterval() {
        return this.symbolInterval;
    }

    public void setSymbolInterval(int interval) {
        this.symbolInterval = interval;
    }

    public boolean isUsingDashStyle() {
        switch (this.style) {
            case SOLID: 
            case DASH: 
            case DOT: 
            case DASH_DOT: 
            case DASH_DOT_DOT: {
                return true;
            }
        }
        return false;
    }

    public float getCapSize() {
        return this.capSize;
    }

    public void setCapSize(float value) {
        this.capSize = value;
    }

    public void setSymbol(PointBreak pb) {
        this.drawSymbol = true;
        this.fillSymbol = pb.drawFill;
        this.symbolColor = pb.color;
        this.symbolFillColor = pb.color;
        this.symbolSize = pb.size;
        this.symbolStyle = pb.style;
    }

    @Override
    public Object getPropertyObject() {
        HashMap<String, String> objAttr = new HashMap<String, String>();
        objAttr.put("Color", "Color");
        objAttr.put("Width", "Width");
        objAttr.put("Style", "Style");
        objAttr.put("DrawPolyline", "DrawPolyline");
        objAttr.put("DrawSymbol", "DrawSymbol");
        objAttr.put("SymbolSize", "SymbolSize");
        objAttr.put("SymbolStyle", "SymbolStyle");
        objAttr.put("SymbolColor", "SymbolColor");
        objAttr.put("SymbolInterval", "SymbolInterval");
        return objAttr;
    }

    @Override
    public Object clone() {
        PolylineBreak aCB = new PolylineBreak();
        aCB.setCaption(this.getCaption());
        aCB.setColor(this.getColor());
        aCB.setDrawShape(this.isDrawShape());
        aCB.setEndValue(this.getEndValue());
        aCB.setNoData(this.isNoData());
        aCB.setStartValue(this.getStartValue());
        aCB.setWidth(this.width);
        aCB.setStyle(this.style);
        aCB.setDrawPolyline(this.drawPolyline);
        aCB.setDrawSymbol(this.drawSymbol);
        aCB.setFillSymbol(this.fillSymbol);
        aCB.setSymbolSize(this.symbolSize);
        aCB.setSymbolColor(this.symbolColor);
        aCB.setSymbolFillColor(this.symbolFillColor);
        aCB.setSymbolStyle(this.symbolStyle);
        aCB.setSymbolInterval(this.symbolInterval);
        return aCB;
    }
}

