/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.Polygon;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PolygonShape
extends Shape
implements Cloneable {
    protected List<? extends Polygon> _polygons;
    public double lowValue;
    public double highValue;
    protected int _numParts;
    public int[] parts;

    public PolygonShape() {
        this.points = new ArrayList();
        this._numParts = 1;
        this.parts = new int[1];
        this.parts[0] = 0;
        this._polygons = new ArrayList<Polygon>();
    }

    public PolygonShape(Geometry geometry) {
        this();
        Coordinate[] cs = geometry.getCoordinates();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (Coordinate c : cs) {
            points.add(new PointD(c.x, c.y));
        }
        this.points = points;
        switch (geometry.getGeometryType()) {
            case "MultiPolygon": {
                ArrayList<PointD> pp;
                int i;
                int n = geometry.getNumGeometries();
                this._numParts = 0;
                ArrayList<Integer> partlist = new ArrayList<Integer>();
                int idx = 0;
                for (i = 0; i < n; ++i) {
                    int j;
                    org.locationtech.jts.geom.Polygon poly = (org.locationtech.jts.geom.Polygon)geometry.getGeometryN(i);
                    this._numParts += poly.getNumInteriorRing() + 1;
                    partlist.add(idx);
                    Polygon polygon = new Polygon();
                    pp = new ArrayList();
                    for (j = idx; j < idx + poly.getExteriorRing().getNumPoints(); ++j) {
                        pp.add((PointD)points.get(j));
                    }
                    polygon.setOutLine(pp);
                    idx += poly.getExteriorRing().getNumPoints();
                    for (j = 0; j < poly.getNumInteriorRing(); ++j) {
                        partlist.add(idx);
                        pp = new ArrayList();
                        for (int k = idx; k < idx + poly.getInteriorRingN(j).getNumPoints(); ++k) {
                            pp.add((PointD)points.get(k));
                        }
                        polygon.addHole(pp);
                        idx += poly.getInteriorRingN(j).getNumPoints();
                    }
                    this._polygons.add(polygon);
                }
                this.parts = new int[partlist.size()];
                for (i = 0; i < this.parts.length; ++i) {
                    this.parts[i] = (Integer)partlist.get(i);
                }
                break;
            }
            default: {
                int j;
                org.locationtech.jts.geom.Polygon poly = (org.locationtech.jts.geom.Polygon)geometry;
                this._numParts = poly.getNumInteriorRing() + 1;
                this.parts = new int[this._numParts];
                this.parts[0] = 0;
                Polygon polygon = new Polygon();
                ArrayList<PointD> pp = new ArrayList<PointD>();
                for (j = 0; j < poly.getExteriorRing().getNumPoints(); ++j) {
                    pp.add((PointD)points.get(j));
                }
                polygon.setOutLine(pp);
                int idx = poly.getExteriorRing().getNumPoints();
                for (j = 0; j < poly.getNumInteriorRing(); ++j) {
                    this.parts[j + 1] = idx;
                    pp = new ArrayList();
                    for (int k = idx; k < idx + poly.getInteriorRingN(j).getNumPoints(); ++k) {
                        pp.add((PointD)points.get(k));
                    }
                    polygon.addHole(pp);
                    idx += poly.getInteriorRingN(j).getNumPoints();
                }
                this._polygons.add(polygon);
            }
        }
        this.updateExtent();
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POLYGON;
    }

    public boolean isMultiPolygon() {
        return this._numParts > 1;
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        if (this._polygons.size() == 1) {
            return this._polygons.get(0).toGeometry(factory);
        }
        org.locationtech.jts.geom.Polygon[] polygons = new org.locationtech.jts.geom.Polygon[this._polygons.size()];
        for (int j = 0; j < polygons.length; ++j) {
            polygons[j] = (org.locationtech.jts.geom.Polygon)this._polygons.get(j).toGeometry(factory);
        }
        MultiPolygon mls = factory.createMultiPolygon(polygons);
        return mls;
    }

    @Override
    public void setPoints(List<? extends PointD> points) {
        this.points = points;
        this.updateExtent();
        this.updatePolygons();
    }

    public void setPoints_keep(List<? extends PointD> points) {
        this.points = points;
        this.updateExtent();
        this.updatePolygons_keep();
    }

    public void setPoints_keep(PointF[] points) {
        ArrayList<PointD> ps = new ArrayList<PointD>();
        for (int i = 0; i < points.length; ++i) {
            ps.add(new PointD((double)points[i].X, (double)points[i].Y));
        }
        this.points = ps;
        this.updateExtent();
        this.updatePolygons_keep();
    }

    public void setPoints(PointF[] points) {
        ArrayList<PointD> ps = new ArrayList<PointD>();
        for (PointF point : points) {
            ps.add(new PointD((double)point.X, (double)point.Y));
        }
        this.setPoints(ps);
    }

    @Override
    public int getPartNum() {
        return this._numParts;
    }

    public void setPartNum(int value) {
        this._numParts = value;
    }

    public int[] getParts() {
        return this.parts;
    }

    public void setParts(int[] value) {
        this.parts = value;
    }

    @Override
    public int getPointNum() {
        return this.points.size();
    }

    public List<? extends Polygon> getPolygons() {
        return this._polygons;
    }

    public Polygon getPolygon(int index) {
        return this._polygons.get(index);
    }

    public void setPolygons(List<? extends Polygon> polygons) {
        this._polygons = polygons;
        this.updatePartsPoints();
    }

    public double getArea() {
        double area = 0.0;
        for (Polygon polygon : this._polygons) {
            area += GeoComputation.getArea(polygon.getOutLine());
            for (List<? extends PointD> hole : polygon.getHoleLines()) {
                area -= GeoComputation.getArea(hole);
            }
        }
        return area;
    }

    public double getSphericalArea() {
        double area = 0.0;
        for (Polygon polygon : this._polygons) {
            area += GeoComputation.sphericalPolygonArea(polygon.getOutLine());
            for (List<? extends PointD> hole : polygon.getHoleLines()) {
                area -= GeoComputation.sphericalPolygonArea(hole);
            }
        }
        return area;
    }

    protected void updatePolygons_keep() {
        if (this._numParts == 1) {
            this._polygons.get(0).setOutLine(this.points);
        } else {
            int sidx = 0;
            int eidx = 0;
            for (Polygon polygon : this._polygons) {
                eidx = sidx + polygon.getOutLine().size();
                polygon.setOutLine(this.points.subList(sidx, eidx));
                sidx = eidx;
                if (!polygon.hasHole()) continue;
                for (int i = 0; i < polygon.getHoleLineNumber(); ++i) {
                    eidx = sidx + polygon.getHoleLine(i).size();
                    polygon.setHoleLine(i, this.points.subList(sidx, eidx));
                    sidx = eidx;
                }
            }
        }
    }

    protected void updatePolygons() {
        this._polygons = new ArrayList<Polygon>();
        if (this._numParts == 1) {
            Polygon aPolygon = new Polygon();
            aPolygon.setOutLine(this.points);
            this._polygons.add(aPolygon);
        } else {
            Polygon aPolygon = null;
            int numPoints = this.getPointNum();
            for (int p = 0; p < this._numParts; ++p) {
                int pp;
                PointD[] Pointps;
                if (p == this._numParts - 1) {
                    Pointps = new PointD[numPoints - this.parts[p]];
                    for (pp = this.parts[p]; pp < numPoints; ++pp) {
                        Pointps[pp - this.parts[p]] = (PointD)this.points.get(pp);
                    }
                } else {
                    Pointps = new PointD[this.parts[p + 1] - this.parts[p]];
                    for (pp = this.parts[p]; pp < this.parts[p + 1]; ++pp) {
                        Pointps[pp - this.parts[p]] = (PointD)this.points.get(pp);
                    }
                }
                if (GeoComputation.isClockwise(Pointps)) {
                    if (p > 0) {
                        this._polygons.add(aPolygon);
                    }
                    aPolygon = new Polygon();
                    aPolygon.setOutLine(Arrays.asList(Pointps));
                    continue;
                }
                if (aPolygon == null) {
                    MIMath.arrayReverse((PointD[])Pointps);
                    aPolygon = new Polygon();
                    aPolygon.setOutLine(Arrays.asList(Pointps));
                    continue;
                }
                aPolygon.addHole(Arrays.asList(Pointps));
            }
            this._polygons.add(aPolygon);
        }
    }

    private void updatePartsPoints() {
        int i;
        this._numParts = 0;
        this.points = new ArrayList();
        ArrayList<Integer> partList = new ArrayList<Integer>();
        for (i = 0; i < this._polygons.size(); ++i) {
            this._numParts += this._polygons.get(i).getRingNumber();
            for (int j = 0; j < this._polygons.get(i).getRingNumber(); ++j) {
                partList.add(this.points.size());
                this.points.addAll((Collection)this._polygons.get(i).getRings().get(j));
            }
        }
        this.parts = new int[partList.size()];
        for (i = 0; i < partList.size(); ++i) {
            this.parts[i] = (Integer)partList.get(i);
        }
        if (this.points.size() > 0) {
            this.updateExtent();
        }
    }

    public int addHole(List<? extends PointD> points) {
        return this.addHole(points, 0);
    }

    public int addHole(List<? extends PointD> points, int polygonIdx) {
        Polygon aPolygon = this._polygons.get(polygonIdx);
        aPolygon.addHole(points);
        this.updatePartsPoints();
        return aPolygon.getHoleLines().size() - 1;
    }

    public void removeHole(int polygonIdx, int holeIdx) {
        Polygon poly = this._polygons.get(polygonIdx);
        poly.removeHole(holeIdx);
        this.updatePartsPoints();
    }

    public int getPartIndex(int vIdx) {
        if (this._numParts == 1) {
            return 0;
        }
        for (int p = 1; p < this._numParts; ++p) {
            if (vIdx >= this.parts[p]) continue;
            return p - 1;
        }
        return this._numParts - 1;
    }

    @Override
    public void addVertice(int vIdx, PointD vertice) {
        int partIdx = this.getPartIndex(vIdx);
        if (partIdx < this._numParts - 1) {
            int n = partIdx + 1;
            this.parts[n] = this.parts[n] + 1;
        }
        this.points.add(vIdx, vertice);
        this.updateExtent();
        this.updatePolygons();
    }

    @Override
    public void removeVertice(int vIdx) {
        int partIdx = this.getPartIndex(vIdx);
        if (partIdx < this._numParts - 1) {
            int n = partIdx + 1;
            this.parts[n] = this.parts[n] - 1;
        }
        this.points.remove(vIdx);
        this.updateExtent();
        this.updatePolygons();
    }

    @Override
    public void reverse() {
        Collections.reverse(this.points);
    }

    public Object clone_back() {
        return (PolygonShape)super.clone();
    }

    @Override
    public Object clone() {
        PolygonShape aPGS = new PolygonShape();
        aPGS.setExtent(this.getExtent());
        aPGS.highValue = this.highValue;
        aPGS.lowValue = this.lowValue;
        aPGS._numParts = this._numParts;
        aPGS.parts = (int[])this.parts.clone();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (PointD p : this.points) {
            points.add((PointD)p.clone());
        }
        aPGS.setPoints(points);
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        aPGS.setLegendIndex(this.getLegendIndex());
        return aPGS;
    }

    public PolygonShape valueClone() {
        PolygonShape aPGS = new PolygonShape();
        aPGS.highValue = this.highValue;
        aPGS.lowValue = this.lowValue;
        aPGS.setVisible(this.isVisible());
        aPGS.setSelected(this.isSelected());
        aPGS.setLegendIndex(this.getLegendIndex());
        return aPGS;
    }

    @Override
    public void cloneValue(Shape other) {
        PolygonShape o = (PolygonShape)other;
        this.setExtent(o.getExtent());
        this.highValue = o.highValue;
        this.lowValue = o.lowValue;
        this._numParts = o._numParts;
        this.parts = (int[])o.parts.clone();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (PointD p : o.points) {
            points.add((PointD)p.clone());
        }
        this.setPoints(points);
        this.setVisible(o.isVisible());
        this.setSelected(o.isSelected());
        this.setLegendIndex(o.getLegendIndex());
    }

    @Override
    public Shape difference(Shape b) {
        if (this.contains(b)) {
            PolygonShape r = (PolygonShape)this.clone();
            r.addHole(b.getPoints(), 0);
            return r;
        }
        return super.difference(b);
    }
}

