/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.gempak.GempakGridReader;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakLookup;
import ucar.nc2.iosp.grid.GridIndex;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class GempakGridServiceProvider
extends GridServiceProvider {
    protected GempakGridReader gemreader;
    public static boolean extendIndex = true;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.gemreader = new GempakGridReader(raf.getLocation());
            return this.gemreader.init(raf, false);
        }
        catch (Exception ioe) {
            return false;
        }
    }

    public String getFileTypeId() {
        return "GempakGrid";
    }

    public String getFileTypeDescription() {
        return "GEMPAK Gridded Data";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        long start = System.currentTimeMillis();
        if (this.gemreader == null) {
            this.gemreader = new GempakGridReader(raf.getLocation());
        }
        this.initTables();
        this.gemreader.init(raf, true);
        GridIndex index = this.gemreader.getGridIndex();
        this.open(index, cancelTask);
        if (debugOpen) {
            System.out.println(" GridServiceProvider.open " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    protected void open(GridIndex index, CancelTask cancelTask) throws IOException {
        GempakLookup lookup = new GempakLookup((GempakGridRecord)index.getGridRecords().get(0));
        GridIndexToNC delegate = new GridIndexToNC(index.filename);
        delegate.open(index, lookup, 4, this.ncfile, cancelTask);
        this.ncfile.finish();
    }

    public boolean sync() throws IOException {
        if (this.gemreader.getInitFileSize() < this.raf.length() && extendIndex) {
            this.gemreader.init(true);
            GridIndex index = this.gemreader.getGridIndex();
            this.ncfile.empty();
            this.open(index, null);
            return true;
        }
        return false;
    }

    @Override
    protected float[] _readData(GridRecord gr) throws IOException {
        return this.gemreader.readGrid(gr);
    }

    private void initTables() {
        try {
            GempakGridParameterTable.addParameters("resources/nj22/tables/gempak/wmogrib3.tbl");
            GempakGridParameterTable.addParameters("resources/nj22/tables/gempak/ncepgrib2.tbl");
        }
        catch (Exception e) {
            throw new RuntimeException("unable to init tables", e);
        }
    }

    public static void setExtendIndex(boolean b) {
        extendIndex = b;
    }
}

