/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.DenseCapacityStrategy;
import org.ojalgo.array.SparseArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.Exchange;
import org.ojalgo.array.operation.FillAll;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.OperationVoid;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.special.PowerOf2;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.type.math.MathType;

public abstract class BasicArray<N extends Comparable<N>>
implements Access1D<N>,
Access1D.Aggregatable<N>,
Access1D.Visitable<N>,
Mutate1D,
Mutate1D.Fillable<N>,
Mutate1D.Modifiable<N>,
Access1D.Collectable<N, Mutate1D> {
    private final ArrayFactory<N, ?> myFactory;

    private BasicArray() {
        this(null);
    }

    protected BasicArray(ArrayFactory<N, ?> factory) {
        this.myFactory = factory;
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myFactory.aggregator());
        this.visitRange(first, limit, visitor);
        return (N)((Comparable)visitor.get());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicArray)) {
            return false;
        }
        BasicArray other = (BasicArray)obj;
        return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
    }

    public final MathType getMathType() {
        return this.myFactory.getMathType();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return prime * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
    }

    @Override
    public long indexOfLargest() {
        return this.indexOfLargest(0L, this.count(), 1L);
    }

    public final boolean isPrimitive() {
        return this.myFactory.getMathType().isPrimitive();
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.modify(0L, this.count(), 1L, modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        long limit = Math.min(left.count(), this.count());
        this.modify(0L, limit, 1L, left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        long limit = Math.min(this.count(), right.count());
        this.modify(0L, limit, 1L, function, right);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        this.modify(first, limit, 1L, modifier);
    }

    @Override
    public void supplyTo(Mutate1D receiver) {
        long limit = Math.min(this.count(), receiver.count());
        for (long i = 0L; i < limit; ++i) {
            receiver.set(i, (Comparable<?>)this.get(i));
        }
    }

    public String toString() {
        return Access1D.toString(this);
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.visit(first, limit, 1L, visitor);
    }

    protected void exchange(long firstA, long firstB, long step, long count) {
        Exchange.exchange(this, firstA, firstB, step, count);
    }

    protected void fill(long first, long limit, long step, N value) {
        FillAll.fill(this, first, limit, step, value);
    }

    protected void fill(long first, long limit, long step, NullaryFunction<?> supplier) {
        FillAll.fill(this, first, limit, step, supplier);
    }

    protected long indexOfLargest(long first, long limit, long step) {
        return AMAX.invoke(this, first, limit, step);
    }

    protected void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        OperationBinary.invoke(this, first, limit, step, left, function, this);
    }

    protected void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        OperationBinary.invoke(this, first, limit, step, this, function, right);
    }

    protected void modify(long first, long limit, long step, UnaryFunction<N> function) {
        OperationUnary.invoke(this, first, limit, step, this, function);
    }

    protected void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        OperationVoid.invoke(this, first, limit, step, visitor);
    }

    protected final Array1D<N> wrapInArray1D() {
        return new Array1D(this);
    }

    protected final Array2D<N> wrapInArray2D(long structure) {
        return new Array2D(this, structure);
    }

    protected final ArrayAnyD<N> wrapInArrayAnyD(long[] structure) {
        return new ArrayAnyD(this, structure);
    }

    final ArrayFactory<N, ?> factory() {
        return this.myFactory;
    }

    public static final class Factory<N extends Comparable<N>>
    extends ArrayFactory<N, BasicArray<N>> {
        private static final long SPARSE_SEGMENTATION_LIMIT = PowerOf2.powerOfLong2(46);
        private final DenseArray.Factory<N> myDenseFactory;

        Factory(DenseArray.Factory<N> denseFactory) {
            this.myDenseFactory = denseFactory;
        }

        @Override
        public AggregatorSet<N> aggregator() {
            return this.myDenseFactory.aggregator();
        }

        @Override
        public FunctionSet<N> function() {
            return this.myDenseFactory.function();
        }

        @Override
        public Scalar.Factory<N> scalar() {
            return this.myDenseFactory.scalar();
        }

        @Override
        long getCapacityLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        MathType getMathType() {
            return this.myDenseFactory.getMathType();
        }

        @Override
        BasicArray<N> makeStructuredZero(long ... structure) {
            long total = StructureAnyD.count(structure);
            DenseCapacityStrategy<N> strategy = this.strategy();
            if (total > SPARSE_SEGMENTATION_LIMIT) {
                return this.makeSegmented(structure);
            }
            if (strategy.isChunked(total)) {
                return new SparseArray<N>(strategy.limit(total));
            }
            return strategy.make(total);
        }

        @Override
        BasicArray<N> makeToBeFilled(long ... structure) {
            long total = StructureAnyD.count(structure);
            DenseCapacityStrategy<N> strategy = this.strategy();
            if (strategy.isSegmented(total)) {
                return strategy.makeSegmented(total);
            }
            return strategy.make(total);
        }

        DenseCapacityStrategy<N> strategy() {
            return new DenseCapacityStrategy<N>(this.myDenseFactory);
        }
    }
}

