/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.ojalgo.array.BufferArray;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.NumberDefinition;

final class BufferR064
extends BufferArray {
    private final DoubleBuffer myBuffer;

    BufferR064(BufferArray.Factory factory, ByteBuffer buffer, AutoCloseable closeable) {
        this(factory, buffer.asDoubleBuffer(), closeable);
    }

    BufferR064(BufferArray.Factory factory, DoubleBuffer buffer, AutoCloseable closeable) {
        super(factory, buffer, closeable);
        this.myBuffer = buffer;
    }

    @Override
    public void supplyTo(Mutate1D receiver) {
        int limit = Math.min(this.size(), receiver.size());
        for (int i = 0; i < limit; ++i) {
            receiver.set((long)i, this.doubleValue(i));
        }
    }

    @Override
    protected byte byteValue(int index) {
        return (byte)Math.round(this.myBuffer.get(index));
    }

    @Override
    protected double doubleValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void fillOne(int index, NullaryFunction<?> supplier) {
        this.myBuffer.put(index, supplier.doubleValue());
    }

    @Override
    protected float floatValue(int index) {
        return (float)this.myBuffer.get(index);
    }

    @Override
    protected int intValue(int index) {
        return (int)Math.round(this.myBuffer.get(index));
    }

    @Override
    protected long longValue(int index) {
        return Math.round(this.myBuffer.get(index));
    }

    @Override
    protected void set(int index, double value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void set(int index, long value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        this.set(index, this.doubleValue(index) + NumberDefinition.doubleValue(addend));
    }
}

