/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.ojalgo.array.BufferArray;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.type.NumberDefinition;

final class BufferZ016
extends BufferArray {
    private final ShortBuffer myBuffer;

    BufferZ016(BufferArray.Factory factory, ByteBuffer buffer, AutoCloseable closeable) {
        this(factory, buffer.asShortBuffer(), closeable);
    }

    BufferZ016(BufferArray.Factory factory, ShortBuffer buffer, AutoCloseable closeable) {
        super(factory, buffer, closeable);
        this.myBuffer = buffer;
    }

    @Override
    protected byte byteValue(int index) {
        return (byte)this.myBuffer.get(index);
    }

    @Override
    protected void fillOne(int index, NullaryFunction<?> supplier) {
        this.myBuffer.put(index, supplier.shortValue());
    }

    @Override
    protected float floatValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void set(int index, double value) {
        this.myBuffer.put(index, (short)Math.round(value));
    }

    @Override
    protected short shortValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void set(int index, long value) {
        this.myBuffer.put(index, (short)value);
    }

    @Override
    protected void set(int index, short value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        this.set(index, this.shortValue(index) + NumberDefinition.shortValue(addend));
    }
}

