/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.structure.Structure1D;

final class Pivot {
    private boolean myModified;
    private int[] myOrder;
    private int mySign;

    Pivot() {
    }

    void change(int ind1, int ind2) {
        if (ind1 != ind2) {
            int tmpRow = this.myOrder[ind1];
            this.myOrder[ind1] = this.myOrder[ind2];
            this.myOrder[ind2] = tmpRow;
            this.mySign = -this.mySign;
            this.myModified = true;
        }
    }

    int[] getInverseOrder() {
        int[] inverse = new int[this.myOrder.length];
        for (int i = 0; i < this.myOrder.length; ++i) {
            inverse[this.myOrder[i]] = i;
        }
        return inverse;
    }

    int[] getOrder() {
        return this.myOrder;
    }

    boolean isModified() {
        return this.myModified;
    }

    void reset(int numberOf) {
        if (this.myOrder == null || this.myOrder.length != numberOf) {
            this.myOrder = Structure1D.newIncreasingRange(0, numberOf);
        } else {
            for (int i = 0; i < this.myOrder.length; ++i) {
                this.myOrder[i] = i;
            }
        }
        this.myModified = false;
        this.mySign = 1;
    }

    int signum() {
        return this.mySign;
    }
}

