/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayR032;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.operation.FillMatchingSingle;
import org.ojalgo.array.operation.RotateLeft;
import org.ojalgo.array.operation.RotateRight;
import org.ojalgo.array.operation.SubstituteBackwards;
import org.ojalgo.array.operation.SubstituteForwards;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.operation.HouseholderLeft;
import org.ojalgo.matrix.operation.HouseholderRight;
import org.ojalgo.matrix.operation.MultiplyBoth;
import org.ojalgo.matrix.operation.MultiplyLeft;
import org.ojalgo.matrix.operation.MultiplyNeither;
import org.ojalgo.matrix.operation.MultiplyRight;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.PrimitiveFactory;
import org.ojalgo.matrix.store.Subregion2D;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;
import org.ojalgo.type.NumberDefinition;

public final class Primitive32Store
extends ArrayR032
implements PhysicalStore<Double> {
    public static final PhysicalStore.Factory<Double, Primitive32Store> FACTORY = new PrimitiveFactory<Primitive32Store>(){

        @Override
        public DenseArray.Factory<Double> array() {
            return ArrayR032.FACTORY;
        }

        @Override
        public Primitive32Store columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn.floatValue(i);
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store columns(Comparable<?>[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Comparable<?>[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.floatValue(tmpColumn[i]);
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = (float)tmpColumn[i];
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store columns(List<? extends Comparable<?>> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<Comparable<?>> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.floatValue(tmpColumn.get(i));
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final Primitive32Store retVal = new Primitive32Store(tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.copy(retVal.data, tmpRowDim, aFirst, aLimit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.copy(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public Primitive32Store make(long rows, long columns) {
            return new Primitive32Store((int)rows, (int)columns);
        }

        @Override
        public Householder<Double> makeHouseholder(int length) {
            return new Householder.Primitive32(length);
        }

        @Override
        public Primitive32Store rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow.floatValue(j);
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store rows(Comparable<?>[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Comparable<?>[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.floatValue(tmpRow[j]);
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = (float)tmpRow[j];
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store rows(List<? extends Comparable<?>> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            float[] tmpData = new float[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<Comparable<?>> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.floatValue(tmpRow.get(j));
                }
            }
            return new Primitive32Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive32Store transpose(final Access2D<?> source) {
            final Primitive32Store retVal = new Primitive32Store((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose(retVal.data, tmpRowDim, first, limit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }
    };
    private final MultiplyBoth.Primitive multiplyBoth;
    private final MultiplyLeft.Primitive32 multiplyLeft;
    private final MultiplyNeither.Primitive32 multiplyNeither;
    private final MultiplyRight.Primitive32 multiplyRight;
    private final int myColDim;
    private final int myRowDim;
    private final Array2D<Double> myUtility;
    private transient float[] myWorkerColumn;

    static Primitive32Store cast(Access1D<Double> matrix) {
        if (matrix instanceof Primitive32Store) {
            return (Primitive32Store)matrix;
        }
        if (matrix instanceof Access2D) {
            return (Primitive32Store)FACTORY.copy((Access2D)matrix);
        }
        return (Primitive32Store)FACTORY.columns(matrix);
    }

    static Householder.Primitive32 cast(Householder<Double> transformation) {
        if (transformation instanceof Householder.Primitive32) {
            return (Householder.Primitive32)transformation;
        }
        if (transformation instanceof HouseholderReference) {
            return ((Householder.Primitive32)((HouseholderReference)transformation).getWorker(FACTORY)).copy(transformation);
        }
        return new Householder.Primitive32(transformation);
    }

    static Rotation.Primitive cast(Rotation<Double> transformation) {
        if (transformation instanceof Rotation.Primitive) {
            return (Rotation.Primitive)transformation;
        }
        return new Rotation.Primitive(transformation);
    }

    Primitive32Store(int numbRows, int numbCols, float[] dataArray) {
        super(dataArray);
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.newPrimitive32(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.newPrimitive32(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.newPrimitive32(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.newPrimitive32(this.myRowDim, this.myColDim);
    }

    Primitive32Store(long numbRows, long numbCols) {
        super(Math.toIntExact(numbRows * numbCols));
        this.myRowDim = Math.toIntExact(numbRows);
        this.myColDim = Math.toIntExact(numbCols);
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.newPrimitive32(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.newPrimitive32(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.newPrimitive32(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.newPrimitive32(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<?> supplied) {
        this.myUtility.accept(supplied);
    }

    @Override
    public void add(long row, long col, Comparable<?> addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public Double aggregateColumn(long col, Aggregator aggregator) {
        return (Double)this.myUtility.aggregateColumn(col, aggregator);
    }

    @Override
    public Double aggregateColumn(long row, long col, Aggregator aggregator) {
        return this.myUtility.aggregateColumn(row, col, aggregator);
    }

    @Override
    public Double aggregateDiagonal(Aggregator aggregator) {
        return (Double)this.myUtility.aggregateDiagonal(aggregator);
    }

    @Override
    public Double aggregateDiagonal(long row, long col, Aggregator aggregator) {
        return this.myUtility.aggregateDiagonal(row, col, aggregator);
    }

    @Override
    public Double aggregateRange(long first, long limit, Aggregator aggregator) {
        return this.myUtility.aggregateRange(first, limit, aggregator);
    }

    @Override
    public Double aggregateRow(long row, Aggregator aggregator) {
        return (Double)this.myUtility.aggregateRow(row, aggregator);
    }

    @Override
    public Double aggregateRow(long row, long col, Aggregator aggregator) {
        return this.myUtility.aggregateRow(row, col, aggregator);
    }

    @Override
    public <NN extends Comparable<NN>, R extends Mutate2D.Receiver<NN>> Access2D.Collectable<NN, R> asCollectable2D() {
        return this.myUtility.asCollectable2D();
    }

    @Override
    public Array1D<Double> asList() {
        return this.myUtility.flatten();
    }

    @Override
    public byte byteValue(long row, long col) {
        return this.myUtility.byteValue(row, col);
    }

    @Override
    public Access2D.ColumnView<Double> columns() {
        return this.myUtility.columns();
    }

    @Override
    public MatrixStore<Double> conjugate() {
        return this.transpose();
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public double dot(Access1D<?> vector) {
        return this.myUtility.dot(vector);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myUtility.doubleValue(row, col);
    }

    @Override
    public ElementView2D<Double, ?> elements() {
        return this.myUtility.elements();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof Primitive32Store)) {
            return false;
        }
        Primitive32Store other = (Primitive32Store)obj;
        return this.myColDim == other.myColDim && this.myRowDim == other.myRowDim;
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public void fillByMultiplying(Access1D<Double> left, Access1D<Double> right) {
        int complexity = Math.toIntExact(left.count() / this.countRows());
        if (complexity != Math.toIntExact(right.count() / this.countColumns())) {
            ProgrammingError.throwForMultiplicationNotPossible();
        }
        if (left instanceof Primitive32Store) {
            if (right instanceof Primitive32Store) {
                this.multiplyNeither.invoke(this.data, Primitive32Store.cast(left).data, complexity, Primitive32Store.cast(right).data);
            } else {
                this.multiplyRight.invoke(this.data, Primitive32Store.cast(left).data, complexity, right);
            }
        } else if (right instanceof Primitive32Store) {
            this.multiplyLeft.invoke(this.data, left, complexity, Primitive32Store.cast(right).data);
        } else {
            this.multiplyBoth.invoke(this, left, complexity, right);
        }
    }

    @Override
    public void fillColumn(long col, Access1D<Double> values) {
        this.myUtility.fillColumn(col, (Double)((Object)values));
    }

    @Override
    public void fillColumn(long col, Double value) {
        this.myUtility.fillColumn(col, value);
    }

    @Override
    public void fillColumn(long row, long col, Access1D<Double> values) {
        this.myUtility.fillColumn(row, col, (Double)((Object)values));
    }

    @Override
    public void fillColumn(long row, long col, Double value) {
        this.myUtility.fillColumn(row, col, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillColumn(row, col, supplier);
    }

    @Override
    public void fillColumn(long col, NullaryFunction<?> supplier) {
        this.myUtility.fillColumn(col, supplier);
    }

    @Override
    public void fillDiagonal(Access1D<Double> values) {
        this.myUtility.fillDiagonal((Double)((Object)values));
    }

    @Override
    public void fillDiagonal(Double value) {
        this.myUtility.fillDiagonal(value);
    }

    @Override
    public void fillDiagonal(long row, long col, Access1D<Double> values) {
        this.myUtility.fillDiagonal(row, col, (Double)((Object)values));
    }

    @Override
    public void fillDiagonal(long row, long col, Double value) {
        this.myUtility.fillDiagonal(row, col, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillDiagonal(row, col, supplier);
    }

    @Override
    public void fillDiagonal(NullaryFunction<?> supplier) {
        this.myUtility.fillDiagonal(supplier);
    }

    @Override
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        this.myUtility.fillMatching(left, function, right);
    }

    @Override
    public void fillMatching(UnaryFunction<Double> function, Access1D<Double> arguments) {
        this.myUtility.fillMatching(function, arguments);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.myUtility.fillOne(row, col, values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, Double value) {
        this.myUtility.fillOne(row, col, value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillOne(row, col, supplier);
    }

    @Override
    public void fillRow(long row, Access1D<Double> values) {
        this.myUtility.fillRow(row, (Double)((Object)values));
    }

    @Override
    public void fillRow(long row, Double value) {
        this.myUtility.fillRow(row, value);
    }

    @Override
    public void fillRow(long row, long col, Access1D<Double> values) {
        this.myUtility.fillRow(row, col, (Double)((Object)values));
    }

    @Override
    public void fillRow(long row, long col, Double value) {
        this.myUtility.fillRow(row, col, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillRow(row, col, supplier);
    }

    @Override
    public void fillRow(long row, NullaryFunction<?> supplier) {
        this.myUtility.fillRow(row, supplier);
    }

    @Override
    public float floatValue(long row, long col) {
        return this.myUtility.floatValue(row, col);
    }

    @Override
    public Double get(long row, long col) {
        return this.myUtility.get(row, col);
    }

    @Override
    public int getColDim() {
        return this.myColDim;
    }

    @Override
    public int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    @Override
    public int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    @Override
    public int getRowDim() {
        return this.myRowDim;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.myColDim;
        return 31 * result + this.myRowDim;
    }

    @Override
    public int intValue(long row, long col) {
        return this.myUtility.intValue(row, col);
    }

    @Override
    public boolean isAcceptable(Structure2D supplier) {
        return this.myUtility.isAcceptable(supplier);
    }

    @Override
    public boolean isEmpty() {
        return this.myUtility.isEmpty();
    }

    @Override
    public boolean isFat() {
        return this.myUtility.isFat();
    }

    @Override
    public boolean isScalar() {
        return this.myUtility.isScalar();
    }

    @Override
    public boolean isSquare() {
        return this.myUtility.isSquare();
    }

    @Override
    public boolean isTall() {
        return this.myUtility.isTall();
    }

    @Override
    public boolean isVector() {
        return this.myUtility.isVector();
    }

    @Override
    public long longValue(long row, long col) {
        return this.myUtility.longValue(row, col);
    }

    @Override
    public void modifyAll(UnaryFunction<Double> modifier) {
        this.modify(0, this.myRowDim * this.myColDim, 1, modifier);
    }

    @Override
    public void modifyAny(Transformation2D<Double> modifier) {
        this.myUtility.modifyAny(modifier);
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyColumn(row, col, modifier);
    }

    @Override
    public void modifyColumn(long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyColumn(col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyDiagonal(row, col, modifier);
    }

    @Override
    public void modifyDiagonal(UnaryFunction<Double> modifier) {
        this.myUtility.modifyDiagonal(modifier);
    }

    @Override
    public void modifyMatching(Access1D<Double> left, BinaryFunction<Double> function) {
        this.myUtility.modifyMatching(left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<Double> function, Access1D<Double> right) {
        this.myUtility.modifyMatching(function, right);
    }

    @Override
    public void modifyMatchingInColumns(Access1D<Double> left, BinaryFunction<Double> function) {
        this.myUtility.modifyMatchingInColumns(left, function);
    }

    @Override
    public void modifyMatchingInColumns(BinaryFunction<Double> function, Access1D<Double> right) {
        this.myUtility.modifyMatchingInColumns(function, right);
    }

    @Override
    public void modifyMatchingInRows(Access1D<Double> left, BinaryFunction<Double> function) {
        this.myUtility.modifyMatchingInRows(left, function);
    }

    @Override
    public void modifyMatchingInRows(BinaryFunction<Double> function, Access1D<Double> right) {
        this.myUtility.modifyMatchingInRows(function, right);
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyOne(row, col, modifier);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyRow(row, col, modifier);
    }

    @Override
    public void modifyRow(long row, UnaryFunction<Double> modifier) {
        this.myUtility.modifyRow(row, modifier);
    }

    @Override
    public MatrixStore<Double> multiply(MatrixStore<Double> right) {
        Primitive32Store retVal = (Primitive32Store)FACTORY.make((long)this.myRowDim, right.countColumns());
        if (right instanceof Primitive32Store) {
            retVal.multiplyNeither.invoke(retVal.data, this.data, this.myColDim, Primitive32Store.cast(right).data);
        } else {
            retVal.multiplyRight.invoke(retVal.data, this.data, this.myColDim, right);
        }
        return retVal;
    }

    @Override
    public Double multiplyBoth(Access1D<Double> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.make(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.make(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (Double)tmpStep2.get(0L);
    }

    @Override
    public PhysicalStore.Factory<Double, ?> physical() {
        return FACTORY;
    }

    @Override
    public void reduceColumns(Aggregator aggregator, Mutate1D receiver) {
        this.myUtility.reduceColumns(aggregator, receiver);
    }

    @Override
    public void reduceRows(Aggregator aggregator, Mutate1D receiver) {
        this.myUtility.reduceRows(aggregator, receiver);
    }

    @Override
    public TransformableRegion<Double> regionByColumns(int ... columns) {
        return new Subregion2D.ColumnsRegion<Double>(this, this.multiplyBoth, columns);
    }

    @Override
    public TransformableRegion<Double> regionByLimits(int rowLimit, int columnLimit) {
        return new Subregion2D.LimitRegion<Double>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public TransformableRegion<Double> regionByOffsets(int rowOffset, int columnOffset) {
        return new Subregion2D.OffsetRegion<Double>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public TransformableRegion<Double> regionByRows(int ... rows) {
        return new Subregion2D.RowsRegion<Double>(this, this.multiplyBoth, rows);
    }

    @Override
    public TransformableRegion<Double> regionByTransposing() {
        return new Subregion2D.TransposedRegion<Double>(this, this.multiplyBoth);
    }

    @Override
    public Access2D.RowView<Double> rows() {
        return this.myUtility.rows();
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public short shortValue(long row, long col) {
        return this.myUtility.shortValue(row, col);
    }

    @Override
    public Array1D<Double> sliceColumn(long col) {
        return this.myUtility.sliceColumn(col);
    }

    @Override
    public Array1D<Double> sliceColumn(long row, long col) {
        return this.myUtility.sliceColumn(row, col);
    }

    @Override
    public Access1D<Double> sliceDiagonal() {
        return this.myUtility.sliceDiagonal();
    }

    @Override
    public Array1D<Double> sliceDiagonal(long row, long col) {
        return this.myUtility.sliceDiagonal(row, col);
    }

    @Override
    public Array1D<Double> sliceRow(long row) {
        return this.myUtility.sliceRow(row);
    }

    @Override
    public Array1D<Double> sliceRow(long row, long col) {
        return this.myUtility.sliceRow(row, col);
    }

    @Override
    public void substituteBackwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteBackwards.invoke(Primitive32Store.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, hermitian);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, hermitian);
        }
    }

    @Override
    public void substituteForwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteForwards.invoke(Primitive32Store.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, identity);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, identity);
        }
    }

    @Override
    public double[] toRawCopy1D() {
        return this.myUtility.toRawCopy1D();
    }

    @Override
    public double[][] toRawCopy2D() {
        return this.myUtility.toRawCopy2D();
    }

    @Override
    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<Double> transformation, int firstColumn) {
        HouseholderLeft.call(this.data, this.myRowDim, firstColumn, Primitive32Store.cast(transformation));
    }

    @Override
    public void transformLeft(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = Primitive64Store.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateLeft.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, (float)tmpTransf.cos, (float)tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveMath.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveMath.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveMath.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<Double> transformation, int firstRow) {
        HouseholderRight.call(this.data, this.myRowDim, firstRow, Primitive32Store.cast(transformation), this.getWorkerColumn());
    }

    @Override
    public void transformRight(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = Primitive64Store.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateRight.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, (float)tmpTransf.cos, (float)tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveMath.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveMath.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveMath.NEGATE);
        }
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitColumn(row, col, visitor);
    }

    @Override
    public void visitColumn(long col, VoidFunction<Double> visitor) {
        this.myUtility.visitColumn(col, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitDiagonal(row, col, visitor);
    }

    @Override
    public void visitDiagonal(VoidFunction<Double> visitor) {
        this.myUtility.visitDiagonal(visitor);
    }

    @Override
    public void visitOne(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitOne(row, col, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitRow(row, col, visitor);
    }

    @Override
    public void visitRow(long row, VoidFunction<Double> visitor) {
        this.myUtility.visitRow(row, visitor);
    }

    private float[] getWorkerColumn() {
        if (this.myWorkerColumn != null) {
            Arrays.fill(this.myWorkerColumn, 0.0f);
        } else {
            this.myWorkerColumn = new float[this.myRowDim];
        }
        return this.myWorkerColumn;
    }
}

