/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.util.Optional;
import java.util.function.Supplier;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.AbstractSolver;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public interface SolverTask<N extends Comparable<N>>
extends MatrixTask<N> {
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public SolverTask<ComplexNumber> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.COMPLEX.make(templateBody);
                }
                return (SolverTask)LU.COMPLEX.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.COMPLEX.make(templateBody);
            }
            return SingularValue.COMPLEX.make(templateBody);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public SolverTask<Double> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            boolean tmpVectorRHS = templateRHS.countColumns() == 1L;
            long tmpColDim = templateBody.countColumns();
            if (templateBody.isSquare()) {
                if (symmetric) {
                    if (!tmpVectorRHS) {
                        return positiveDefinite ? (SolverTask)Cholesky.PRIMITIVE.make(templateBody) : (SolverTask)LU.PRIMITIVE.make(templateBody);
                    }
                    if (tmpColDim == 1L) {
                        return AbstractSolver.FULL_1X1;
                    }
                    if (tmpColDim == 2L) {
                        return AbstractSolver.SYMMETRIC_2X2;
                    }
                    if (tmpColDim == 3L) {
                        return AbstractSolver.SYMMETRIC_3X3;
                    }
                    if (tmpColDim == 4L) {
                        return AbstractSolver.SYMMETRIC_4X4;
                    }
                    if (tmpColDim == 5L) {
                        return AbstractSolver.SYMMETRIC_5X5;
                    }
                    return positiveDefinite ? (SolverTask)Cholesky.PRIMITIVE.make(templateBody) : (SolverTask)LU.PRIMITIVE.make(templateBody);
                }
                if (!tmpVectorRHS) {
                    return (SolverTask)LU.PRIMITIVE.make(templateBody);
                }
                if (tmpColDim == 1L) {
                    return AbstractSolver.FULL_1X1;
                }
                if (tmpColDim == 2L) {
                    return AbstractSolver.FULL_2X2;
                }
                if (tmpColDim == 3L) {
                    return AbstractSolver.FULL_3X3;
                }
                if (tmpColDim == 4L) {
                    return AbstractSolver.FULL_4X4;
                }
                if (tmpColDim == 5L) {
                    return AbstractSolver.FULL_5X5;
                }
                return (SolverTask)LU.PRIMITIVE.make(templateBody);
            }
            if (!templateBody.isTall()) {
                return SingularValue.PRIMITIVE.make(templateBody);
            }
            if (tmpVectorRHS && tmpColDim <= 5L) {
                return AbstractSolver.LEAST_SQUARES;
            }
            return QR.PRIMITIVE.make(templateBody);
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        public SolverTask<Quaternion> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.QUATERNION.make(templateBody);
                }
                return (SolverTask)LU.QUATERNION.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.QUATERNION.make(templateBody);
            }
            return SingularValue.QUATERNION.make(templateBody);
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        public SolverTask<RationalNumber> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.RATIONAL.make(templateBody);
                }
                return (SolverTask)LU.RATIONAL.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.RATIONAL.make(templateBody);
            }
            return SingularValue.RATIONAL.make(templateBody);
        }
    };

    default public PhysicalStore<N> preallocate(final int numberOfEquations, final int numberOfVariables, final int numberOfSolutions) {
        Structure2D templateBody = new Structure2D(){

            @Override
            public long countColumns() {
                return numberOfVariables;
            }

            @Override
            public long countRows() {
                return numberOfEquations;
            }
        };
        Structure2D templateRHS = new Structure2D(){

            @Override
            public long countColumns() {
                return numberOfSolutions;
            }

            @Override
            public long countRows() {
                return numberOfEquations;
            }
        };
        return this.preallocate(templateBody, templateRHS);
    }

    public PhysicalStore<N> preallocate(Structure2D var1, Structure2D var2);

    default public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    public MatrixStore<N> solve(Access2D<?> var1, Access2D<?> var2, PhysicalStore<N> var3) throws RecoverableCondition;

    default public Provider2D.Solution<Optional<MatrixStore<N>>> toSolutionProvider(ElementsSupplier<N> body, Supplier<MatrixStore<N>> alternativeBodySupplier, Access2D<?> rhs) {
        try {
            MatrixStore solution = this.solve((Access2D)alternativeBodySupplier.get(), rhs);
            return r -> Optional.of(solution);
        }
        catch (RecoverableCondition cause) {
            return r -> Optional.empty();
        }
    }

    public static abstract class Factory<N extends Comparable<N>> {
        public SolverTask<N> make(final int numberOfEquations, final int numberOfVariables, final int numberOfSolutions, boolean symmetric, boolean positiveDefinite) {
            Structure2D templateBody = new Structure2D(){

                @Override
                public long countColumns() {
                    return numberOfVariables;
                }

                @Override
                public long countRows() {
                    return numberOfEquations;
                }
            };
            Structure2D templateRHS = new Structure2D(){

                @Override
                public long countColumns() {
                    return numberOfSolutions;
                }

                @Override
                public long countRows() {
                    return numberOfEquations;
                }
            };
            return this.make(templateBody, templateRHS, symmetric, positiveDefinite);
        }

        public SolverTask<N> make(MatrixStore<N> templateBody, MatrixStore<N> templateRHS) {
            return this.make(templateBody, templateRHS, templateBody.isHermitian(), false);
        }

        public abstract SolverTask<N> make(Structure2D var1, Structure2D var2, boolean var3, boolean var4);

        public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
            return this.make(body, rhs, false, false).solve(body, rhs);
        }
    }
}

