/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.LongFunction;
import org.ojalgo.netio.FromFileReader;
import org.ojalgo.netio.ToFileWriter;
import org.ojalgo.type.format.NumberStyle;
import org.ojalgo.type.keyvalue.EntryPair;

public final class ShardedFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int numberOfShards;
    public final File single;
    private transient File[] myShards = null;

    public static ShardedFile of(File template, int nbShards) {
        return new ShardedFile(template, nbShards);
    }

    public static ShardedFile of(File templateFolder, String templateFile, int nbShards) {
        return new ShardedFile(new File(templateFolder, templateFile), nbShards);
    }

    private static File[] splitToShards(File file, int numberOfShards) {
        File parentDir = file.getParentFile();
        String templateName = file.getName();
        LongFunction<String> converter = NumberStyle.newUniformFormatter(numberOfShards);
        File[] retVal = new File[numberOfShards];
        int indexOfDot = templateName.indexOf(46);
        if (indexOfDot >= 0) {
            String base = templateName.substring(0, indexOfDot);
            String ending = templateName.substring(indexOfDot);
            for (int i = 0; i < numberOfShards; ++i) {
                retVal[i] = new File(parentDir, base + converter.apply(i) + ending);
            }
        } else {
            for (int i = 0; i < numberOfShards; ++i) {
                retVal[i] = new File(parentDir, templateName + converter.apply(i));
            }
        }
        return retVal;
    }

    ShardedFile(File template, int nbShards) {
        this.single = template;
        this.numberOfShards = nbShards;
        ToFileWriter.mkdirs(template.getParentFile());
    }

    public void delete() {
        FromFileReader.delete(this.directory());
    }

    public File directory() {
        return this.single.getParentFile();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShardedFile)) {
            return false;
        }
        ShardedFile other = (ShardedFile)obj;
        if (this.numberOfShards != other.numberOfShards) {
            return false;
        }
        return !(this.single == null ? other.single != null : !this.single.equals(other.single));
    }

    public List<File> files() {
        return Arrays.asList(this.shards());
    }

    public List<EntryPair.KeyedPrimitive<File>> filesWithShardIndex() {
        File[] shards = this.shards();
        ArrayList<EntryPair.KeyedPrimitive<File>> retVal = new ArrayList<EntryPair.KeyedPrimitive<File>>(shards.length);
        for (int s = 0; s < shards.length; ++s) {
            retVal.add(EntryPair.of(shards[s], s));
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.numberOfShards;
        return 31 * result + (this.single == null ? 0 : this.single.hashCode());
    }

    public File shard(int index) {
        File[] shards = this.shards();
        return shards[index];
    }

    public File[] shards() {
        if (this.myShards == null) {
            this.myShards = ShardedFile.splitToShards(this.single, this.numberOfShards);
        }
        return this.myShards;
    }

    public String toString() {
        return this.single.getParent() + "-" + this.numberOfShards + "-" + this.single.getName();
    }
}

