/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class CloseableList<T extends AutoCloseable>
implements List<T>,
AutoCloseable {
    private final List<T> myDelegate;

    public static <T extends AutoCloseable> CloseableList<T> newInstance() {
        return new CloseableList(new ArrayList());
    }

    public static <T extends AutoCloseable> CloseableList<T> newInstance(int capacity) {
        return new CloseableList(new ArrayList(capacity));
    }

    public static <T extends AutoCloseable> CloseableList<T> wrap(List<T> delegate) {
        return new CloseableList<T>(delegate);
    }

    CloseableList(List<T> delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void add(int index, T element) {
        this.myDelegate.add(index, element);
    }

    @Override
    public boolean add(T element) {
        return this.myDelegate.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.myDelegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.myDelegate.addAll(index, c);
    }

    @Override
    public void clear() {
        this.myDelegate.clear();
    }

    @Override
    public void close() {
        this.myDelegate.forEach(e -> {
            try {
                if (e != null) {
                    e.close();
                }
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
        });
    }

    @Override
    public boolean contains(Object o) {
        return this.myDelegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myDelegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.myDelegate.equals(o);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.myDelegate.forEach(action);
    }

    @Override
    public T get(int index) {
        return (T)((AutoCloseable)this.myDelegate.get(index));
    }

    @Override
    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.myDelegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.myDelegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.myDelegate.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myDelegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.myDelegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.myDelegate.listIterator(index);
    }

    @Override
    public Stream<T> parallelStream() {
        return this.myDelegate.parallelStream();
    }

    @Override
    public T remove(int index) {
        return (T)((AutoCloseable)this.myDelegate.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.myDelegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.myDelegate.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.myDelegate.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.myDelegate.replaceAll(operator);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.myDelegate.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return (T)((AutoCloseable)this.myDelegate.set(index, element));
    }

    @Override
    public int size() {
        return this.myDelegate.size();
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.myDelegate.sort(c);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.myDelegate.spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.myDelegate.stream();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.myDelegate.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.myDelegate.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.myDelegate.toArray(a);
    }
}

