/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.keyvalue;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.keyvalue.KeyValue;

public interface EntryPair<K, V>
extends KeyValue<K, V>,
Map<K, V>,
Map.Entry<K, V> {
    public static <K> KeyedPrimitive<K> of(K key, byte value) {
        return new ObjectByte<K>(key, value);
    }

    public static <K> KeyedPrimitive<K> of(K key, double value) {
        return new ObjectDouble<K>(key, value);
    }

    public static <K> KeyedPrimitive<K> of(K key, float value) {
        return new ObjectFloat<K>(key, value);
    }

    public static <K> KeyedPrimitive<K> of(K key, int value) {
        return new ObjectInt<K>(key, value);
    }

    public static <K> KeyedPrimitive<KeyValue.Dual<K>> of(K key1, K key2, byte value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K> KeyedPrimitive<KeyValue.Dual<K>> of(K key1, K key2, double value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K> KeyedPrimitive<KeyValue.Dual<K>> of(K key1, K key2, float value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K> KeyedPrimitive<KeyValue.Dual<K>> of(K key1, K key2, int value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K> KeyedPrimitive<KeyValue.Dual<K>> of(K key1, K key2, long value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K> KeyedPrimitive<KeyValue.Dual<K>> of(K key1, K key2, short value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K, V> EntryPair<KeyValue.Dual<K>, V> of(K key1, K key2, V value) {
        return EntryPair.of(new KeyValue.Dual<K>(key1, key2), value);
    }

    public static <K> KeyedPrimitive<K> of(K key, long value) {
        return new ObjectLong<K>(key, value);
    }

    public static <K> KeyedPrimitive<K> of(K key, short value) {
        return new ObjectShort<K>(key, value);
    }

    public static <K, V> EntryPair<K, V> of(K key, V value) {
        return new ObjectObject<K, V>(key, value);
    }

    default public KeyedPrimitive<EntryPair<K, V>> asKeyTo(byte value) {
        return EntryPair.of(this, value);
    }

    default public KeyedPrimitive<EntryPair<K, V>> asKeyTo(double value) {
        return EntryPair.of(this, value);
    }

    default public KeyedPrimitive<EntryPair<K, V>> asKeyTo(float value) {
        return EntryPair.of(this, value);
    }

    default public KeyedPrimitive<EntryPair<K, V>> asKeyTo(int value) {
        return EntryPair.of(this, value);
    }

    default public KeyedPrimitive<EntryPair<K, V>> asKeyTo(long value) {
        return EntryPair.of(this, value);
    }

    default public KeyedPrimitive<EntryPair<K, V>> asKeyTo(short value) {
        return EntryPair.of(this, value);
    }

    default public <T> EntryPair<EntryPair<K, V>, T> asKeyTo(T value) {
        return EntryPair.of(this, value);
    }

    default public <T> EntryPair<T, EntryPair<K, V>> asValueTo(T key) {
        return EntryPair.of(key, this);
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Set<Map.Entry<K, V>> entrySet() {
        return Collections.singleton(this);
    }

    @Override
    default public boolean isEmpty() {
        return false;
    }

    @Override
    default public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public int size() {
        return 1;
    }

    public static final class ObjectShort<K>
    implements KeyedPrimitive<K> {
        private final K myKey;
        private final short myValue;

        ObjectShort(K key, short value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Short.compare(this.myValue, other.shortValue());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof Comparable) {
                return NumberDefinition.shortValue((Comparable)value) == this.myValue;
            }
            return false;
        }

        @Override
        public double doubleValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectInt)) {
                return false;
            }
            ObjectInt other = (ObjectInt)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return this.myValue == other.myValue;
        }

        @Override
        public PrimitiveNumber get(Object key) {
            if (this.myKey.equals(key)) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            return 31 * result + this.myValue;
        }

        @Override
        public int intValue() {
            return this.myValue;
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        @Override
        public long longValue() {
            return this.myValue;
        }

        @Override
        public short shortValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }
    }

    public static final class ObjectObject<K, V>
    implements EntryPair<K, V> {
        private final K myKey;
        private final V myValue;

        ObjectObject(K key, V value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = Objects.requireNonNull(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.myValue.equals(value);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectObject)) {
                return false;
            }
            ObjectObject other = (ObjectObject)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
        }

        @Override
        public V get(Object key) {
            if (this.myKey.equals(key)) {
                return this.myValue;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public V getValue() {
            return this.myValue;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            return 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }

        @Override
        public Collection<V> values() {
            return Collections.singleton(this.myValue);
        }
    }

    public static final class ObjectLong<K>
    implements KeyedPrimitive<K> {
        private final K myKey;
        private final long myValue;

        ObjectLong(K key, long value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Long.compare(this.myValue, other.longValue());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof Comparable) {
                return NumberDefinition.longValue((Comparable)value) == this.myValue;
            }
            return false;
        }

        @Override
        public double doubleValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectLong)) {
                return false;
            }
            ObjectLong other = (ObjectLong)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return this.myValue == other.myValue;
        }

        @Override
        public PrimitiveNumber get(Object key) {
            if (this.myKey.equals(key)) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            return 31 * result + (int)(this.myValue ^ this.myValue >>> 32);
        }

        @Override
        public int intValue() {
            return Math.toIntExact(this.myValue);
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        @Override
        public long longValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }
    }

    public static final class ObjectInt<K>
    implements KeyedPrimitive<K> {
        private final K myKey;
        private final int myValue;

        ObjectInt(K key, int value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Integer.compare(this.myValue, other.intValue());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof Comparable) {
                return NumberDefinition.intValue((Comparable)value) == this.myValue;
            }
            return false;
        }

        @Override
        public double doubleValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectInt)) {
                return false;
            }
            ObjectInt other = (ObjectInt)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return this.myValue == other.myValue;
        }

        @Override
        public PrimitiveNumber get(Object key) {
            if (this.myKey.equals(key)) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            return 31 * result + this.myValue;
        }

        @Override
        public int intValue() {
            return this.myValue;
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        @Override
        public long longValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }
    }

    public static final class ObjectFloat<K>
    implements KeyedPrimitive<K> {
        private final K myKey;
        private final float myValue;

        ObjectFloat(K key, float value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Float.compare(this.myValue, other.floatValue());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof Comparable) {
                return NumberDefinition.floatValue((Comparable)value) == this.myValue;
            }
            return false;
        }

        @Override
        public double doubleValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectFloat)) {
                return false;
            }
            ObjectFloat other = (ObjectFloat)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return Float.floatToIntBits(this.myValue) == Float.floatToIntBits(other.myValue);
        }

        @Override
        public float floatValue() {
            return this.myValue;
        }

        @Override
        public PrimitiveNumber get(Object key) {
            if (this.myKey.equals(key)) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            return 31 * result + Float.floatToIntBits(this.myValue);
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }
    }

    public static final class ObjectDouble<K>
    implements KeyedPrimitive<K> {
        private final K myKey;
        private final double myValue;

        ObjectDouble(K key, double value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Double.compare(this.myValue, other.doubleValue());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof Comparable) {
                return NumberDefinition.doubleValue((Comparable)value) == this.myValue;
            }
            return false;
        }

        @Override
        public double doubleValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectDouble)) {
                return false;
            }
            ObjectDouble other = (ObjectDouble)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return Double.doubleToLongBits(this.myValue) == Double.doubleToLongBits(other.myValue);
        }

        @Override
        public PrimitiveNumber get(Object key) {
            if (this.myKey.equals(key)) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            long temp = Double.doubleToLongBits(this.myValue);
            return 31 * result + (int)(temp ^ temp >>> 32);
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }
    }

    public static final class ObjectByte<K>
    implements KeyedPrimitive<K> {
        private final K myKey;
        private final byte myValue;

        ObjectByte(K key, byte value) {
            this.myKey = Objects.requireNonNull(key);
            this.myValue = value;
        }

        @Override
        public byte byteValue() {
            return this.myValue;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Byte.compare(this.myValue, other.byteValue());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myKey.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (value instanceof Comparable) {
                return NumberDefinition.byteValue((Comparable)value) == this.myValue;
            }
            return false;
        }

        @Override
        public double doubleValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectInt)) {
                return false;
            }
            ObjectInt other = (ObjectInt)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return this.myValue == other.myValue;
        }

        @Override
        public PrimitiveNumber get(Object key) {
            if (this.myKey.equals(key)) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            return this.myKey;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            return 31 * result + this.myValue;
        }

        @Override
        public int intValue() {
            return this.myValue;
        }

        @Override
        public Set<K> keySet() {
            return Collections.singleton(this.myKey);
        }

        @Override
        public long longValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myKey + "=" + this.myValue;
        }
    }

    public static interface KeyedPrimitive<K>
    extends EntryPair<K, PrimitiveNumber>,
    PrimitiveNumber {
        @Override
        default public PrimitiveNumber getValue() {
            return this;
        }

        @Override
        default public Collection<PrimitiveNumber> values() {
            return Collections.singleton(this);
        }
    }
}

