/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.graphic.Triangle3D;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriMeshGraphic
extends GraphicCollection3D {
    protected Logger logger = LoggerFactory.getLogger((String)"TriMeshGraphic");
    protected float[] vertexPosition;
    protected float[] vertexValue;
    protected float[] vertexColor;
    protected float[] vertexNormal;
    protected int[] vertexIndices;
    protected boolean faceInterp = true;
    protected boolean edgeInterp = false;
    protected boolean mesh = false;
    protected boolean normalLoaded = false;
    protected Extent extent;
    protected LegendScheme legendScheme;
    protected boolean singleLegend = true;
    protected ColorBreak legendBreak;

    public float[] getVertexPosition() {
        return this.vertexPosition;
    }

    public float[] getVertexPosition(Transform transform) {
        int n = this.vertexPosition.length;
        float[] vData = new float[n];
        for (int i = 0; i < n; i += 3) {
            vData[i] = transform.transform_x(this.vertexPosition[i]);
            vData[i + 1] = transform.transform_y(this.vertexPosition[i + 1]);
            vData[i + 2] = transform.transform_z(this.vertexPosition[i + 2]);
        }
        return vData;
    }

    public void setVertexPosition(float[] value) {
        this.vertexPosition = value;
        this.updateExtent();
    }

    public float[] getVertexValue() {
        return this.vertexValue;
    }

    public void setVertexValue(float[] value) {
        this.vertexValue = value;
    }

    public int[] getVertexIndices() {
        return this.vertexIndices;
    }

    public void setVertexIndices(int[] value) {
        this.vertexIndices = value;
    }

    public float[] getVertexColor() {
        return this.vertexColor;
    }

    public float[] getVertexNormal() {
        return this.vertexNormal;
    }

    public void setVertexNormal(float[] value) {
        this.vertexNormal = value;
    }

    public boolean isFaceInterp() {
        return this.faceInterp;
    }

    public void setFaceInterp(boolean value) {
        this.faceInterp = value;
    }

    public boolean isEdgeInterp() {
        return this.edgeInterp;
    }

    public void setEdgeInterp(boolean value) {
        this.edgeInterp = value;
    }

    public boolean isMesh() {
        return this.mesh;
    }

    public void setMesh(boolean value) {
        this.mesh = value;
    }

    public Vector3f getVertex(float[] vData, int idx) {
        return new Vector3f(vData[idx * 3], vData[idx * 3 + 1], vData[idx * 3 + 2]);
    }

    public Vector3f getVertex(int idx) {
        return this.getVertex(this.vertexPosition, idx);
    }

    public void setTriangles(float[] vertexes) {
        Vector3f vector3f;
        LinkedHashMap<Vector3f, Integer> map = new LinkedHashMap<Vector3f, Integer>();
        int n = vertexes.length / 3;
        this.vertexIndices = new int[n];
        int idx = 0;
        int vertexIdx = 0;
        int triangleIdx = 0;
        ArrayList idxList = new ArrayList();
        for (int i = 0; i < n / 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int ii = i * 9 + j * 3;
                vector3f = new Vector3f(vertexes[ii], vertexes[ii + 1], vertexes[ii + 2]);
                if (map.containsKey(vector3f)) {
                    int index;
                    this.vertexIndices[vertexIdx] = index = ((Integer)map.get(vector3f)).intValue();
                } else {
                    this.vertexIndices[vertexIdx] = idx;
                    map.put(vector3f, idx++);
                }
                ++vertexIdx;
            }
            ++triangleIdx;
        }
        this.vertexPosition = new float[map.size() * 3];
        idx = 0;
        for (Map.Entry entry : map.entrySet()) {
            vector3f = (Vector3f)entry.getKey();
            this.vertexPosition[idx++] = vector3f.x;
            this.vertexPosition[idx++] = vector3f.y;
            this.vertexPosition[idx++] = vector3f.z;
        }
        this.updateExtent();
    }

    public void setTriangles(List<Triangle3D> triangles) {
        Vector3f vector3f;
        LinkedHashMap<Vector3f, Integer> map = new LinkedHashMap<Vector3f, Integer>();
        int n = triangles.size();
        this.vertexIndices = new int[n];
        int idx = 0;
        int vertexIdx = 0;
        int triangleIdx = 0;
        ArrayList idxList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Triangle3D triangle = triangles.get(i);
            for (int j = 0; j < 3; ++j) {
                vector3f = new Vector3f((Vector3fc)triangle.getPoint(j));
                if (map.containsKey(vector3f)) {
                    int index;
                    this.vertexIndices[vertexIdx] = index = ((Integer)map.get(vector3f)).intValue();
                } else {
                    this.vertexIndices[vertexIdx] = idx;
                    map.put(vector3f, idx++);
                }
                ++vertexIdx;
            }
            ++triangleIdx;
        }
        this.vertexPosition = new float[map.size() * 3];
        idx = 0;
        for (Map.Entry entry : map.entrySet()) {
            vector3f = (Vector3f)entry.getKey();
            this.vertexPosition[idx++] = vector3f.x;
            this.vertexPosition[idx++] = vector3f.y;
            this.vertexPosition[idx++] = vector3f.z;
        }
        this.updateExtent();
    }

    public void setTriangles(Array vertexes, Array faceIndices) {
        vertexes = vertexes.copyIfView();
        faceIndices = faceIndices.copyIfView();
        this.vertexIndices = (int[])faceIndices.getStorage();
        this.vertexPosition = (float[])vertexes.getStorage();
        this.updateExtent();
    }

    public void setTriangles(Array faceIndices, Array x, Array y, Array z) {
        this.logger.info("Start set triangles...");
        x = x.copyIfView();
        y = y.copyIfView();
        z = z.copyIfView();
        faceIndices = faceIndices.copyIfView();
        this.vertexIndices = (int[])faceIndices.getStorage();
        int n = x.getShape()[0];
        this.vertexPosition = new float[n * 3];
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            this.vertexPosition[idx] = x.getFloat(i);
            this.vertexPosition[idx + 1] = y.getFloat(i);
            this.vertexPosition[idx + 2] = z.getFloat(i);
            idx += 3;
        }
        this.updateExtent();
        this.logger.info("Set triangles finished!");
    }

    public void setTriangles(Array faceIndices, Array x, Array y, Array z, Array normal) {
        this.logger.info("Start set triangles...");
        x = x.copyIfView();
        y = y.copyIfView();
        z = z.copyIfView();
        normal = normal.copyIfView();
        faceIndices = faceIndices.copyIfView();
        boolean vertexIdx = false;
        int nFace = faceIndices.getShape()[0];
        this.vertexIndices = (int[])faceIndices.getStorage();
        this.logger.info("Set vertex position and normal...");
        int n = x.getShape()[0];
        this.vertexPosition = new float[n * 3];
        this.vertexNormal = (float[])normal.getStorage();
        int idx = 0;
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = minX;
        float maxY = maxX;
        float minZ = minX;
        float maxZ = maxX;
        for (int i = 0; i < n; ++i) {
            float xx = x.getFloat(i);
            float yy = y.getFloat(i);
            float zz = z.getFloat(i);
            this.vertexPosition[idx] = xx;
            this.vertexPosition[idx + 1] = yy;
            this.vertexPosition[idx + 2] = zz;
            idx += 3;
            if (minX > xx) {
                minX = xx;
            }
            if (maxX < xx) {
                maxX = xx;
            }
            if (minY > yy) {
                minY = yy;
            }
            if (maxY < yy) {
                maxY = yy;
            }
            if (minZ > zz) {
                minZ = zz;
            }
            if (!(maxZ < zz)) continue;
            maxZ = zz;
        }
        this.extent = new Extent3D((double)minX, (double)maxX, (double)minY, (double)maxY, (double)minZ, (double)maxZ);
        this.normalLoaded = true;
        this.logger.info("Set triangles finished!");
    }

    public void setTriangles(float[] vertexes, Array cData, Array xa, Array ya, Array za) {
        Vector3f vector3f;
        LinkedHashMap<Vector3f, Integer> map = new LinkedHashMap<Vector3f, Integer>();
        int n = vertexes.length / 3;
        this.vertexIndices = new int[n];
        int idx = 0;
        int vertexIdx = 0;
        int triangleIdx = 0;
        ArrayList idxList = new ArrayList();
        for (int i = 0; i < n / 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int ii = i * 9 + j * 3;
                vector3f = new Vector3f(vertexes[ii], vertexes[ii + 1], vertexes[ii + 2]);
                if (map.containsKey(vector3f)) {
                    int index;
                    this.vertexIndices[vertexIdx] = index = ((Integer)map.get(vector3f)).intValue();
                } else {
                    this.vertexIndices[vertexIdx] = idx;
                    map.put(vector3f, idx++);
                }
                ++vertexIdx;
            }
            ++triangleIdx;
        }
        this.vertexPosition = new float[map.size() * 3];
        this.vertexValue = new float[map.size()];
        Index cIndex = cData.getIndex();
        idx = 0;
        for (Map.Entry entry : map.entrySet()) {
            vector3f = (Vector3f)entry.getKey();
            this.vertexPosition[idx * 3] = vector3f.x;
            this.vertexPosition[idx * 3 + 1] = vector3f.y;
            this.vertexPosition[idx * 3 + 2] = vector3f.z;
            int xi = ArrayUtil.searchSorted((Array)xa, (Number)Float.valueOf(vector3f.x), (boolean)true);
            int yi = ArrayUtil.searchSorted((Array)ya, (Number)Float.valueOf(vector3f.y), (boolean)true);
            int zi = ArrayUtil.searchSorted((Array)za, (Number)Float.valueOf(vector3f.z), (boolean)true);
            cIndex.set(zi, yi, xi);
            this.vertexValue[idx] = cData.getFloat(cIndex);
            ++idx;
        }
        this.updateExtent();
    }

    public void setVertexValue(Array cData, Array xa, Array ya, Array za) {
        int n = this.getVertexNumber();
        this.vertexValue = new float[n];
        Index cIndex = cData.getIndex();
        for (int i = 0; i < n; ++i) {
            float x = this.vertexPosition[i * 3];
            float y = this.vertexPosition[i * 3 + 1];
            float z = this.vertexPosition[i * 3 + 2];
            int xi = ArrayUtil.searchSorted((Array)xa, (Number)Float.valueOf(x), (boolean)true);
            int yi = ArrayUtil.searchSorted((Array)ya, (Number)Float.valueOf(y), (boolean)true);
            int zi = ArrayUtil.searchSorted((Array)za, (Number)Float.valueOf(z), (boolean)true);
            cIndex.set(zi, yi, xi);
            this.vertexValue[i] = cData.getFloat(cIndex);
        }
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent value) {
        this.extent = value;
    }

    public LegendScheme getLegendScheme() {
        return this.legendScheme;
    }

    public void setLegendScheme(LegendScheme ls) {
        this.legendScheme = ls;
        this.updateVertexColor();
    }

    public boolean isSingleLegend() {
        return this.singleLegend;
    }

    public void setSingleLegend(boolean value) {
        this.singleLegend = value;
    }

    public ColorBreak getLegendBreak() {
        return this.legendBreak;
    }

    public void setLegendBreak(ColorBreak value) {
        this.legendBreak = value;
    }

    public void setTransferFunction(TransferFunction transferFunction) {
        LegendScheme ls;
        if (this.vertexValue != null) {
            this.vertexColor = new float[this.getVertexNumber() * 4];
            for (int i = 0; i < this.vertexValue.length; ++i) {
                float[] color = transferFunction.getColor((double)this.vertexValue[i]).getRGBComponents(null);
                System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
            }
        }
        this.legendScheme = ls = LegendManage.createLegendScheme((TransferFunction)transferFunction);
        this.setSingleLegend(false);
    }

    public void updateVertexColor() {
        block4: {
            if (this.legendScheme == null) break block4;
            int n = this.getVertexNumber();
            this.vertexColor = new float[n * 4];
            if (this.vertexValue != null) {
                for (int i = 0; i < n; ++i) {
                    float[] color = this.legendScheme.findLegendBreak((Number)Float.valueOf(this.vertexValue[i])).getColor().getRGBComponents(null);
                    System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                }
            } else {
                float[] color = this.legendScheme.getLegendBreak(0).getColor().getRGBComponents(null);
                for (int i = 0; i < n; ++i) {
                    System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                }
            }
        }
    }

    public int getVertexNumber() {
        return this.vertexPosition.length / 3;
    }

    public int getTriangleNumber() {
        return this.vertexIndices.length / 3;
    }

    public Color getColor() {
        return this.legendScheme.getLegendBreak(0).getColor();
    }

    public void setColor(Color color) {
        this.legendScheme.getLegendBreak(0).setColor(color);
        this.updateVertexColor();
    }

    public void updateExtent() {
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = minX;
        float maxY = maxX;
        float minZ = minX;
        float maxZ = maxX;
        for (int i = 0; i < this.vertexPosition.length; i += 3) {
            float x = this.vertexPosition[i];
            float y = this.vertexPosition[i + 1];
            float z = this.vertexPosition[i + 2];
            if (minX > x) {
                minX = x;
            }
            if (maxX < x) {
                maxX = x;
            }
            if (minY > y) {
                minY = y;
            }
            if (maxY < y) {
                maxY = y;
            }
            if (minZ > z) {
                minZ = z;
            }
            if (!(maxZ < z)) continue;
            maxZ = z;
        }
        this.extent = new Extent3D((double)minX, (double)maxX, (double)minY, (double)maxY, (double)minZ, (double)maxZ);
    }

    public Triangle3D getTriangle(float[] vData, int idx) {
        Vector3f a = this.getVertex(vData, this.vertexIndices[idx * 3]);
        Vector3f b = this.getVertex(vData, this.vertexIndices[idx * 3 + 1]);
        Vector3f c = this.getVertex(vData, this.vertexIndices[idx * 3 + 2]);
        return new Triangle3D(a, b, c);
    }

    public Triangle3D getTriangle(int idx) {
        return this.getTriangle(this.vertexPosition, idx);
    }

    public List<Triangle3D> getTriangles(float[] vData) {
        int n = this.getTriangleNumber();
        ArrayList<Triangle3D> triangles = new ArrayList<Triangle3D>();
        for (int i = 0; i < n; ++i) {
            triangles.add(this.getTriangle(i));
        }
        return triangles;
    }

    public List<Triangle3D> getTriangles() {
        return this.getTriangles(this.vertexPosition);
    }

    public void calculateNormalVectors(float[] vData) {
        Vector3f normal;
        Vector3f vertex;
        if (this.vertexNormal != null) {
            return;
        }
        List<Triangle3D> triangles = this.getTriangles(vData);
        int nVertex = this.getVertexNumber();
        this.vertexNormal = new float[vData.length];
        LinkedHashMap<Vector3f, Vector3f> normalMap = new LinkedHashMap<Vector3f, Vector3f>();
        for (Triangle3D triangle : triangles) {
            List<Vector3f> points = triangle.getPoints();
            List<Vector3f> normals = triangle.getNormals();
            for (int i = 0; i < 3; ++i) {
                vertex = points.get(i);
                normal = normals.get(i);
                if (normalMap.containsKey(vertex)) {
                    normalMap.put(vertex, ((Vector3f)((HashMap)normalMap).get(vertex)).add((Vector3fc)normal));
                    continue;
                }
                normalMap.put(vertex, normal);
            }
        }
        for (int i = 0; i < nVertex; ++i) {
            vertex = this.getVertex(i);
            normal = (Vector3f)((HashMap)normalMap).get(vertex);
            normal.normalize();
            normal.negate();
            this.vertexNormal[i * 3] = normal.x;
            this.vertexNormal[i * 3 + 1] = normal.y;
            this.vertexNormal[i * 3 + 2] = normal.z;
        }
    }
}

