/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Triangle3D {
    private Vector3f pointA;
    private Vector3f pointB;
    private Vector3f pointC;
    private Vector3f normalA;
    private Vector3f normalB;
    private Vector3f normalC;

    public Triangle3D(Vector3f a, Vector3f b, Vector3f c) {
        this.pointA = a;
        this.pointB = b;
        this.pointC = c;
    }

    public Vector3f getPoint(int index) {
        switch (index) {
            case 0: {
                return this.pointA;
            }
            case 1: {
                return this.pointB;
            }
            case 2: {
                return this.pointC;
            }
        }
        return null;
    }

    public Vector3f getPointA() {
        return this.pointA;
    }

    public void setPointA(Vector3f a) {
        this.pointA = a;
    }

    public Vector3f getPointB() {
        return this.pointB;
    }

    public void setPointB(Vector3f b) {
        this.pointB = b;
    }

    public Vector3f getPointC() {
        return this.pointC;
    }

    public void setPointC(Vector3f c) {
        this.pointC = c;
    }

    public Vector3f getNormalA() {
        if (this.normalA == null) {
            this.normalA = this.pointC.sub((Vector3fc)this.pointA, new Vector3f()).cross((Vector3fc)this.pointB.sub((Vector3fc)this.pointA, new Vector3f()));
        }
        return this.normalA;
    }

    public Vector3f getNormalB() {
        if (this.normalB == null) {
            this.normalB = this.pointA.sub((Vector3fc)this.pointB, new Vector3f()).cross((Vector3fc)this.pointC.sub((Vector3fc)this.pointB, new Vector3f()));
        }
        return this.normalB;
    }

    public Vector3f getNormalC() {
        if (this.normalC == null) {
            this.normalC = this.pointB.sub((Vector3fc)this.pointC, new Vector3f()).cross((Vector3fc)this.pointA.sub((Vector3fc)this.pointC, new Vector3f()));
        }
        return this.normalC;
    }

    public Vector3f getNormal(Vector3f point) {
        if (point.equals((Object)this.pointA)) {
            return this.getNormalA();
        }
        if (point.equals((Object)this.pointB)) {
            return this.getNormalB();
        }
        if (point.equals((Object)this.pointC)) {
            return this.getNormalC();
        }
        return null;
    }

    public List<Vector3f> getPoints() {
        return new ArrayList<Vector3f>(Arrays.asList(this.pointA, this.pointB, this.pointC));
    }

    public List<Vector3f> getNormals() {
        return new ArrayList<Vector3f>(Arrays.asList(this.getNormalA(), this.getNormalB(), this.getNormalC()));
    }
}

