/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import org.meteoinfo.common.Extent;
import org.meteoinfo.data.mapdata.webmap.DefaultTileFactory;
import org.meteoinfo.data.mapdata.webmap.GeoPosition;
import org.meteoinfo.data.mapdata.webmap.Tile;
import org.meteoinfo.data.mapdata.webmap.TileFactory;
import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.data.mapdata.webmap.WebMapProvider;
import org.meteoinfo.data.mapdata.webmap.empty.EmptyTileFactory;
import org.meteoinfo.geometry.graphic.Graphic;

public class WebMapImage
extends Graphic {
    private final boolean isNegativeYAllowed = true;
    private int zoom = 11;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private WebMapProvider defaultProvider = WebMapProvider.OpenStreetMap;
    private double webMapScale = 0.0;
    private double width;
    private double height;
    private Extent extent = new Extent(-180.0, 180.0, -90.0, 90.0);

    public WebMapImage() {
        this.factory = new EmptyTileFactory();
    }

    public TileFactory getTileFactory() {
        return this.factory;
    }

    public void setTileFactory(TileFactory factory) {
        this.factory = factory;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    public double getWebMapScale() {
        return this.webMapScale;
    }

    public void setWebMapScale(double value) {
        this.webMapScale = value;
    }

    public void setWebMapProvider(WebMapProvider prov) {
        TileFactoryInfo info = prov.getTileFactoryInfo();
        if (info != null) {
            this.defaultProvider = prov;
            DefaultTileFactory tf = new DefaultTileFactory(info);
            this.setTileFactory((TileFactory)tf);
            this.setAddressLocation(new GeoPosition(51.5, 0.0));
        }
    }

    public WebMapProvider getWebMapProvider() {
        return this.defaultProvider;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoom) {
            return;
        }
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (zoom < info.getMinimumZoomLevel() || zoom > info.getMaximumZoomLevel())) {
            return;
        }
        int oldZoom = this.zoom;
        Point2D oldCenter = this.getCenter();
        Dimension oldMapSize = this.getTileFactory().getMapSize(oldZoom);
        this.zoom = zoom;
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        this.setCenter(new Point2D.Double(oldCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), oldCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())));
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setCenter(Point2D center) {
        this.center = center;
    }

    public void setAddressLocation(GeoPosition pos) {
        this.addressLocation = pos;
        this.setCenter(this.getTileFactory().geoToPixel(this.addressLocation, this.getZoom()));
    }

    public void draw(Graphics2D g, Rectangle2D area, TileLoadListener tileLoadListener) {
        double width = area.getWidth();
        double height = area.getHeight();
        Rectangle2D viewportBounds = this.calculateViewportBounds(g, width, height);
        int size = this.factory.getTileSize(this.zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(this.zoom);
        int numWide = (int)(viewportBounds.getWidth() / (double)size) + 2;
        int numHigh = (int)(viewportBounds.getHeight() / (double)size) + 2;
        TileFactoryInfo info = this.factory.getInfo();
        int tpx = (int)Math.floor(viewportBounds.getX() / (double)info.getTileSize(0));
        int tpy = (int)Math.floor(viewportBounds.getY() / (double)info.getTileSize(0));
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                Tile tile = this.getTileFactory().getTile(itpx, itpy, this.zoom);
                tile.addUniquePropertyChangeListener("loaded", (PropertyChangeListener)tileLoadListener);
                int ox = itpx * this.getTileFactory().getTileSize(this.zoom) - (int)viewportBounds.getX();
                int oy = itpy * this.getTileFactory().getTileSize(this.zoom) - (int)viewportBounds.getY();
                if (!this.isTileOnMap(itpx, itpy, mapSize) || !tile.isLoaded()) continue;
                g.drawImage((Image)tile.getImage(), ox, oy, null);
            }
        }
    }

    public boolean isTileOnMap(int x, int y, Dimension mapSize) {
        return true;
    }

    public Rectangle2D calculateViewportBounds(Graphics2D g, double width, double height) {
        double viewportX = this.center.getX() - width / 2.0;
        double viewportY = this.center.getY() - height / 2.0;
        return new Rectangle2D.Double(viewportX, viewportY, width, height);
    }
}

