/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic.pipe;

import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.graphic.pipe.Line;

public class Plane {
    private Vector3f normal;
    private float d;
    private float normalLength;
    private float distance;

    public Plane() {
        this.normal = new Vector3f(0.0f, 0.0f, 1.0f);
        this.d = 0.0f;
        this.normalLength = 1.0f;
        this.distance = 0.0f;
    }

    public Plane(float a, float b, float c, float d) {
        this.normal.set(a, b, c);
        this.d = d;
        this.normalLength = (float)Math.sqrt(a * a + b * b + c * c);
        this.distance = -d / this.normalLength;
    }

    public Plane(Vector3f normal, Vector3f point) {
        this.normal = normal;
        this.normalLength = normal.length();
        this.d = -normal.dot((Vector3fc)point);
        this.distance = -this.d / this.normalLength;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public float getD() {
        return this.d;
    }

    public float getDistance(Vector3f point) {
        float dot = this.normal.dot((Vector3fc)point);
        return (dot + this.d) / this.normalLength;
    }

    public void normalize() {
        float lengthInv = 1.0f / this.normalLength;
        this.normal = this.normal.mul(lengthInv, new Vector3f());
        this.normalLength = 1.0f;
        this.d *= lengthInv;
        this.distance = -this.d;
    }

    public Vector3f intersect(Line line) {
        Vector3f p = line.getPoint();
        Vector3f v = line.getDirection();
        float dot1 = this.normal.dot((Vector3fc)p);
        float dot2 = this.normal.dot((Vector3fc)v);
        if (dot2 == 0.0f) {
            return new Vector3f(Float.NaN, Float.NaN, Float.NaN);
        }
        float t = -(dot1 + this.d) / dot2;
        if (Math.abs(t) > 2.0f) {
            t = 1.0f;
        }
        return p.add((Vector3fc)v.mul(t, new Vector3f()), new Vector3f());
    }

    public Line intersect(Plane rhs) {
        Vector3f v = this.normal.cross((Vector3fc)rhs.getNormal(), new Vector3f());
        if (v.x == 0.0f && v.y == 0.0f && v.z == 0.0f) {
            return new Line(new Vector3f(Float.NaN, Float.NaN, Float.NaN), new Vector3f(Float.NaN, Float.NaN, Float.NaN));
        }
        float dot = v.dot((Vector3fc)v);
        Vector3f n1 = this.normal.mul(rhs.getD(), new Vector3f());
        Vector3f n2 = rhs.getNormal().mul(-this.d, new Vector3f());
        Vector3f p = n1.add((Vector3fc)n2, new Vector3f()).cross((Vector3fc)v).div(dot);
        return new Line(v, p);
    }

    public boolean isIntersected(Line line) {
        Vector3f v = line.getDirection();
        float dot = this.normal.dot((Vector3fc)v);
        return dot != 0.0f;
    }

    public boolean isIntersected(Plane plane) {
        Vector3f cross = this.normal.cross((Vector3fc)plane.getNormal(), new Vector3f());
        return cross.x != 0.0f || cross.y != 0.0f || cross.z != 0.0f;
    }
}

