/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic.sphere;

import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Sphere {
    private float radius;
    private int sectorCount;
    private int stackCount;
    private boolean smooth;
    private List<Vector3f> vertices;
    private List<Vector3f> normals;
    private List<Integer> indices;
    private List<Integer> lineIndices;
    private List<Vector2f> texCoords;
    private List<Vector3f> interleavedVertices;

    public Sphere(float radius, int sectorCount, int stackCount, boolean smooth) {
        this.radius = radius;
        this.sectorCount = sectorCount;
        this.stackCount = stackCount;
        this.smooth = smooth;
        this.updateVertices();
    }

    public Sphere(float radius, int sectorCount, int stackCount) {
        this(radius, sectorCount, stackCount, true);
    }

    public void updateVertices() {
        if (this.smooth) {
            this.buildVerticesSmooth();
        } else {
            this.buildVerticesFlat();
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float value) {
        if (this.radius != value) {
            this.radius = value;
            this.updateVertices();
        }
    }

    public int getSectorCount() {
        return this.sectorCount;
    }

    public void setSectorCount(int value) {
        if (this.sectorCount != value) {
            this.sectorCount = value;
            this.updateVertices();
        }
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public void setStackCount(int value) {
        if (this.stackCount != value) {
            this.stackCount = value;
            this.updateVertices();
        }
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean value) {
        if (this.smooth != value) {
            this.smooth = value;
            this.updateVertices();
        }
    }

    public List<Vector3f> getVertices() {
        return this.vertices;
    }

    public List<Vector3f> getNormals() {
        return this.normals;
    }

    public List<Vector2f> getTexCoords() {
        return this.texCoords;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public List<Vector3f> getInterleavedVertices() {
        return this.interleavedVertices;
    }

    void clearArrays() {
        this.vertices = new ArrayList<Vector3f>();
        this.normals = new ArrayList<Vector3f>();
        this.indices = new ArrayList<Integer>();
        this.lineIndices = new ArrayList<Integer>();
        this.texCoords = new ArrayList<Vector2f>();
    }

    void addVertex(float x, float y, float z) {
        this.vertices.add(new Vector3f(x, y, z));
    }

    void addNormal(float nx, float ny, float nz) {
        this.normals.add(new Vector3f(nx, ny, nz));
    }

    void addNormal(Vector3f n) {
        this.normals.add(n);
    }

    void addTexCoord(float s, float t) {
        this.texCoords.add(new Vector2f(s, t));
    }

    void addIndices(int i1, int i2, int i3) {
        this.indices.add(i1);
        this.indices.add(i2);
        this.indices.add(i3);
    }

    void buildInterleavedVertices() {
        this.interleavedVertices = new ArrayList<Vector3f>();
        int count = this.vertices.size();
        for (int i = 0; i < count; ++i) {
            this.interleavedVertices.add(this.vertices.get(i));
            this.interleavedVertices.add(this.normals.get(i));
        }
    }

    void buildVerticesSmooth() {
        this.clearArrays();
        float lengthInv = 1.0f / this.radius;
        float sectorStep = (float)Math.PI * 2 / (float)this.sectorCount;
        float stackStep = (float)Math.PI / (float)this.stackCount;
        for (int i = 0; i <= this.stackCount; ++i) {
            float stackAngle = 1.5707964f - (float)i * stackStep;
            float xy = this.radius * (float)Math.cos(stackAngle);
            float z = this.radius * (float)Math.sin(stackAngle);
            for (int j = 0; j <= this.sectorCount; ++j) {
                float sectorAngle = (float)j * sectorStep;
                float x = xy * (float)Math.cos(sectorAngle);
                float y = xy * (float)Math.sin(sectorAngle);
                this.addVertex(x, y, z);
                float nx = x * lengthInv;
                float ny = y * lengthInv;
                float nz = z * lengthInv;
                this.addNormal(nx, ny, nz);
                float s = (float)j / (float)this.sectorCount;
                float t = (float)i / (float)this.stackCount;
                this.addTexCoord(s, t);
            }
        }
        for (int i = 0; i < this.stackCount; ++i) {
            int k1 = i * (this.sectorCount + 1);
            int k2 = k1 + this.sectorCount + 1;
            int j = 0;
            while (j < this.sectorCount) {
                if (i != 0) {
                    this.addIndices(k1, k2, k1 + 1);
                }
                if (i != this.stackCount - 1) {
                    this.addIndices(k1 + 1, k2, k2 + 1);
                }
                this.lineIndices.add(k1);
                this.lineIndices.add(k2);
                if (i != 0) {
                    this.lineIndices.add(k1);
                    this.lineIndices.add(k1 + 1);
                }
                ++j;
                ++k1;
                ++k2;
            }
        }
        this.buildInterleavedVertices();
    }

    void buildVerticesFlat() {
        ArrayList<Vertex> tmpVertices = new ArrayList<Vertex>();
        float sectorStep = (float)Math.PI * 2 / (float)this.sectorCount;
        float stackStep = (float)Math.PI / (float)this.stackCount;
        for (int i = 0; i <= this.stackCount; ++i) {
            float stackAngle = 1.5707964f - (float)i * stackStep;
            float xy = this.radius * (float)Math.cos(stackAngle);
            float z = this.radius * (float)Math.sin(stackAngle);
            for (int j = 0; j <= this.sectorCount; ++j) {
                float sectorAngle = (float)j * sectorStep;
                Vertex vertex = new Vertex();
                vertex.x = xy * (float)Math.cos(sectorAngle);
                vertex.y = xy * (float)Math.sin(sectorAngle);
                vertex.z = z;
                vertex.s = (float)j / (float)this.sectorCount;
                vertex.t = (float)i / (float)this.stackCount;
                tmpVertices.add(vertex);
            }
        }
        this.clearArrays();
        int index = 0;
        for (int i = 0; i < this.stackCount; ++i) {
            int vi1 = i * (this.sectorCount + 1);
            int vi2 = (i + 1) * (this.sectorCount + 1);
            int j = 0;
            while (j < this.sectorCount) {
                int k;
                float[] n;
                Vertex v1 = (Vertex)tmpVertices.get(vi1);
                Vertex v2 = (Vertex)tmpVertices.get(vi2);
                Vertex v3 = (Vertex)tmpVertices.get(vi1 + 1);
                Vertex v4 = (Vertex)tmpVertices.get(vi2 + 1);
                if (i == 0) {
                    this.addVertex(v1.x, v1.y, v1.z);
                    this.addVertex(v2.x, v2.y, v2.z);
                    this.addVertex(v4.x, v4.y, v4.z);
                    this.addTexCoord(v1.s, v1.t);
                    this.addTexCoord(v2.s, v2.t);
                    this.addTexCoord(v4.s, v4.t);
                    n = this.computeFaceNormal(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v4.x, v4.y, v4.z);
                    for (k = 0; k < 3; ++k) {
                        this.addNormal(n[0], n[1], n[2]);
                    }
                    this.addIndices(index, index + 1, index + 2);
                    this.lineIndices.add(index);
                    this.lineIndices.add(index + 1);
                    index += 3;
                } else if (i == this.stackCount - 1) {
                    this.addVertex(v1.x, v1.y, v1.z);
                    this.addVertex(v2.x, v2.y, v2.z);
                    this.addVertex(v3.x, v3.y, v3.z);
                    this.addTexCoord(v1.s, v1.t);
                    this.addTexCoord(v2.s, v2.t);
                    this.addTexCoord(v3.s, v3.t);
                    n = this.computeFaceNormal(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z);
                    for (k = 0; k < 3; ++k) {
                        this.addNormal(n[0], n[1], n[2]);
                    }
                    this.addIndices(index, index + 1, index + 2);
                    this.lineIndices.add(index);
                    this.lineIndices.add(index + 1);
                    this.lineIndices.add(index);
                    this.lineIndices.add(index + 2);
                    index += 3;
                } else {
                    this.addVertex(v1.x, v1.y, v1.z);
                    this.addVertex(v2.x, v2.y, v2.z);
                    this.addVertex(v3.x, v3.y, v3.z);
                    this.addVertex(v4.x, v4.y, v4.z);
                    this.addTexCoord(v1.s, v1.t);
                    this.addTexCoord(v2.s, v2.t);
                    this.addTexCoord(v3.s, v3.t);
                    this.addTexCoord(v4.s, v4.t);
                    n = this.computeFaceNormal(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z);
                    for (k = 0; k < 4; ++k) {
                        this.addNormal(n[0], n[1], n[2]);
                    }
                    this.addIndices(index, index + 1, index + 2);
                    this.addIndices(index + 2, index + 1, index + 3);
                    this.lineIndices.add(index);
                    this.lineIndices.add(index + 1);
                    this.lineIndices.add(index);
                    this.lineIndices.add(index + 2);
                    index += 4;
                }
                ++j;
                ++vi1;
                ++vi2;
            }
        }
        this.buildInterleavedVertices();
    }

    float[] computeFaceNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float EPSILON = 1.0E-6f;
        float[] normal = new float[]{0.0f, 0.0f, 0.0f};
        float ey1 = y2 - y1;
        float ez2 = z3 - z1;
        float ez1 = z2 - z1;
        float ey2 = y3 - y1;
        float nx = ey1 * ez2 - ez1 * ey2;
        float ex2 = x3 - x1;
        float ex1 = x2 - x1;
        float ny = ez1 * ex2 - ex1 * ez2;
        float nz = ex1 * ey2 - ey1 * ex2;
        float length = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (length > EPSILON) {
            float lengthInv = 1.0f / length;
            normal[0] = nx * lengthInv;
            normal[1] = ny * lengthInv;
            normal[2] = nz * lengthInv;
        }
        return normal;
    }

    class Vertex {
        public float x;
        public float y;
        public float z;
        public float s;
        public float t;

        Vertex() {
        }
    }
}

