/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontObjectLoader {
    private Logger logger = LoggerFactory.getLogger((String)"Wavefront Object Loader");
    private ArrayList<float[]> vData = new ArrayList();
    private ArrayList<float[]> vtData = new ArrayList();
    private ArrayList<float[]> vnData = new ArrayList();
    private ArrayList<int[]> fv = new ArrayList();
    private ArrayList<int[]> ft = new ArrayList();
    private ArrayList<int[]> fn = new ArrayList();
    private int polyCount = 0;

    public WavefrontObjectLoader(String objFileName) {
        this.loadObjModel(objFileName);
    }

    private void loadObjModel(String objFileName) {
        try {
            BufferedReader br = null;
            if (objFileName.endsWith(".zip")) {
                this.logger.info("WAVEFRONT MESH IS COMPRESSED! TRY TO EXTRACT FIRST/SINGLE ENTRY!");
                ZipInputStream tZipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(objFileName)));
                ZipEntry tZipEntry = tZipInputStream.getNextEntry();
                String inZipEntryName = tZipEntry.getName();
                if (inZipEntryName == null) {
                    this.logger.error("ERROR! ZIP ENTRY IS NULL!");
                }
                this.logger.info("EXTRACTING: " + inZipEntryName);
                if (!tZipEntry.isDirectory()) {
                    br = new BufferedReader(new InputStreamReader(tZipInputStream));
                } else {
                    this.logger.error("ERROR! ZIP ENTRY IS DIRECTORY! SHOULD BE PLAIN FILE!");
                }
            } else {
                br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(objFileName, new String[0]), new OpenOption[0])));
            }
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.equals("")) continue;
                if (line.startsWith("v ")) {
                    this.vData.add(this.processData(line));
                    continue;
                }
                if (line.startsWith("vt ")) {
                    this.vtData.add(this.processData(line));
                    continue;
                }
                if (line.startsWith("vn ")) {
                    this.vnData.add(this.processData(line));
                    continue;
                }
                if (!line.startsWith("f ")) continue;
                this.processFaceData(line);
            }
            br.close();
            this.logger.info("MODEL " + objFileName + " SUCCESSFULLY LOADED!");
        }
        catch (IOException e) {
            this.logger.error(e.toString());
        }
    }

    private float[] processData(String read) {
        String[] s = read.split("\\s+");
        return this.processFloatData(s);
    }

    private float[] processFloatData(String[] sdata) {
        float[] data = new float[sdata.length - 1];
        for (int loop = 0; loop < data.length; ++loop) {
            data[loop] = Float.parseFloat(sdata[loop + 1]);
        }
        return data;
    }

    private void processFaceData(String fread) {
        ++this.polyCount;
        String[] s = fread.split("\\s+");
        if (fread.contains("//")) {
            for (int loop = 1; loop < s.length; ++loop) {
                s[loop] = s[loop].replaceAll("//", "/0/");
            }
        }
        this.processFaceIntData(s);
    }

    private void processFaceIntData(String[] sdata) {
        int[] vdata = new int[sdata.length - 1];
        int[] vtdata = new int[sdata.length - 1];
        int[] vndata = new int[sdata.length - 1];
        for (int loop = 1; loop < sdata.length; ++loop) {
            String s = sdata[loop];
            String[] temp = s.split("/");
            vdata[loop - 1] = Integer.valueOf(temp[0]) - 1;
            vtdata[loop - 1] = temp.length > 1 ? Integer.valueOf(temp[1]) - 1 : 0;
            vndata[loop - 1] = temp.length > 2 ? Integer.valueOf(temp[2]) - 1 : 0;
        }
        if (vdata.length == 3) {
            this.fv.add(vdata);
            this.ft.add(vtdata);
            this.fn.add(vndata);
        } else {
            this.fv.addAll(this.quad2Triangles(vdata));
            this.ft.addAll(this.quad2Triangles(vtdata));
            this.fn.addAll(this.quad2Triangles(vndata));
        }
    }

    private ArrayList<int[]> quad2Triangles(int[] data) {
        int[] triangle1 = new int[]{data[0], data[1], data[2]};
        int[] triangle2 = new int[]{data[2], data[3], data[0]};
        return new ArrayList<int[]>(Arrays.asList(triangle1, triangle2));
    }

    public ArrayList<float[]> getVertex() {
        return this.vData;
    }

    public ArrayList<float[]> getVertexNormal() {
        return this.vnData;
    }

    public ArrayList<float[]> getVertexTexture() {
        return this.vtData;
    }

    public ArrayList<int[]> getVertexIndices() {
        return this.fv;
    }

    public ArrayList<int[]> getNormalIndices() {
        return this.fn;
    }

    public ArrayList<int[]> getTextureIndices() {
        return this.ft;
    }

    public Array getVertexArray() {
        int n = this.vData.size();
        Array r = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n, 3});
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            float[] v = this.vData.get(i);
            r.setFloat(idx, v[0]);
            r.setFloat(idx + 1, v[1]);
            r.setFloat(idx + 2, v[2]);
            idx += 3;
        }
        return r;
    }

    public Array[] getVertexArrays() {
        int n = this.vData.size();
        Array x = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n});
        Array y = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n});
        Array z = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            float[] v = this.vData.get(i);
            x.setFloat(i, v[0]);
            y.setFloat(i, v[1]);
            z.setFloat(i, v[2]);
        }
        return new Array[]{x, y, z};
    }

    public Array getVertexIndicesArray() {
        int n = this.fv.size();
        Array r = Array.factory((DataType)DataType.INT, (int[])new int[]{n, 3});
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            int[] v = this.fv.get(i);
            r.setInt(idx, v[0]);
            r.setInt(idx + 1, v[1]);
            r.setInt(idx + 2, v[2]);
            idx += 3;
        }
        return r;
    }

    public Array getVertexNormalArray() {
        int n = this.vnData.size();
        if (n == 0) {
            return null;
        }
        Array r = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n, 3});
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            float[] v = this.vnData.get(i);
            r.setFloat(idx, v[0]);
            r.setFloat(idx + 1, v[1]);
            r.setFloat(idx + 2, v[2]);
            idx += 3;
        }
        return r;
    }
}

