/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.meteoinfo.chart.graphic.cylinder.Cylinder;
import org.meteoinfo.chart.graphic.pipe.Pipe;
import org.meteoinfo.chart.graphic.pipe.PipeShape;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.math.Matrix4f;

public class PipeRender
extends JOGLGraphicRender {
    private GraphicCollection3D graphics;
    private IntBuffer vbo;
    private Program program;
    private int vertexNum;
    private int sizePosition;
    private int sizeColor;
    private int sizeNormal;
    private float[] vertexPosition;
    private float[] vertexColor;
    private int[] vertexIndices;
    private List<Integer> linePointNumbers;
    private boolean streamline = false;
    private IntBuffer vboCone;
    private float[] coneVertexPosition;
    private float[] coneVertexNormal;
    private float[] coneVertexColor;
    private int[] coneVertexIndices;
    private int sizeConePosition;
    private int sizeConeNormal;
    private int sizeConeColor;

    public PipeRender(GL2 gl) {
        super(gl);
        if (this.useShader) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initVertexBuffer();
    }

    public PipeRender(GL2 gl, GraphicCollection3D graphics) {
        this(gl);
        this.graphics = graphics;
        this.vertexNum = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            this.vertexNum += ((PipeShape)graphic.getShape()).getVertexCount();
        }
        ColorBreak cb = graphics.getGraphicN(0).getLegend();
        PolylineBreak lineBreak = cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION ? (PolylineBreak)((ColorBreakCollection)cb).get(0) : (PolylineBreak)cb;
        this.streamline = lineBreak instanceof StreamlineBreak;
    }

    void compileShaders() throws Exception {
        String vertexShaderCode = Utils.loadResource("/shaders/surface/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/surface/surface.frag");
        this.program = new Program("surface", vertexShaderCode, fragmentShaderCode);
    }

    private void initVertexBuffer() {
        this.vbo = GLBuffers.newDirectIntBuffer((int)2);
    }

    private void updateVertexColor() {
        this.vertexColor = new float[this.vertexNum * 4];
        int i = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            float[] color;
            PipeShape shape = (PipeShape)graphic.getShape();
            Pipe pipe = shape.getPipe();
            int n = pipe.getContourCount();
            int m = pipe.getContour().size();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                for (int j = 0; j < n; ++j) {
                    ColorBreak lineBreak = ((ColorBreakCollection)cb).get(j);
                    color = lineBreak.getColor().getRGBComponents(null);
                    for (int k = 0; k < m; ++k) {
                        System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                        ++i;
                    }
                }
                continue;
            }
            color = cb.getColor().getRGBComponents(null);
            for (int j = 0; j < n * m; ++j) {
                System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                ++i;
            }
        }
    }

    private void updateVertexPosition() {
        this.vertexPosition = new float[this.vertexNum * 3];
        int i = 0;
        this.linePointNumbers = new ArrayList<Integer>();
        for (Graphic graphic : this.graphics.getGraphics()) {
            PipeShape shape = (PipeShape)graphic.getShape();
            shape.transform(this.transform);
            Pipe pipe = shape.getPipe();
            this.linePointNumbers.add(pipe.getVertexCount());
            for (int j = 0; j < pipe.getContourCount(); ++j) {
                for (Vector3f vector3f : shape.getPipe().getContour(j)) {
                    this.vertexPosition[i] = vector3f.x;
                    this.vertexPosition[i + 1] = vector3f.y;
                    this.vertexPosition[i + 2] = vector3f.z;
                    i += 3;
                }
            }
        }
    }

    private void updateVertexIndices() {
        int idxNum = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PipeShape shape = (PipeShape)graphic.getShape();
            Pipe pipe = shape.getPipe();
            idxNum += (pipe.getContourCount() - 1) * (pipe.getContour().size() - 1) * 6;
        }
        this.vertexIndices = new int[idxNum];
        int i = 0;
        int b = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PipeShape shape = (PipeShape)graphic.getShape();
            Pipe pipe = shape.getPipe();
            int n = pipe.getContour().size();
            for (int j = 0; j < pipe.getContourCount() - 1; ++j) {
                List<Vector3f> c1 = pipe.getContour(j);
                List<Vector3f> c2 = pipe.getContour(j + 1);
                for (int k = 0; k < n - 1; ++k) {
                    this.vertexIndices[i++] = b + j * n + k;
                    this.vertexIndices[i++] = b + j * n + k + 1;
                    this.vertexIndices[i++] = b + (j + 1) * n + k;
                    this.vertexIndices[i++] = b + j * n + k + 1;
                    this.vertexIndices[i++] = b + (j + 1) * n + k + 1;
                    this.vertexIndices[i++] = b + (j + 1) * n + k;
                }
            }
            b += pipe.getVertexCount();
        }
    }

    private float[] getVertexNormal() {
        float[] vertexNormal = new float[this.vertexNum * 3];
        int i = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PipeShape shape = (PipeShape)graphic.getShape();
            Pipe pipe = shape.getPipe();
            for (int j = 0; j < pipe.getContourCount(); ++j) {
                for (Vector3f vector3f : shape.getPipe().getNormal(j)) {
                    vertexNormal[i] = vector3f.x;
                    vertexNormal[i + 1] = vector3f.y;
                    vertexNormal[i + 2] = vector3f.z;
                    i += 3;
                }
            }
        }
        return vertexNormal;
    }

    /*
     * WARNING - void declaration
     */
    private void updateConeVertex() {
        ArrayList<Vector3f> vertexPositionList = new ArrayList<Vector3f>();
        ArrayList<Vector3f> vertexNormalList = new ArrayList<Vector3f>();
        ArrayList<Vector4f> vertexColorList = new ArrayList<Vector4f>();
        ArrayList<Integer> vertexIndices = new ArrayList<Integer>();
        Cylinder cylinder = null;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            int pointNum = shape.getPointNum();
            List ps = shape.getPoints();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                StreamlineBreak slb = (StreamlineBreak)cbc.get(0);
                int interval = slb.getInterval();
                for (int i = 1; i < pointNum; ++i) {
                    if (i % interval != 0) continue;
                    PointZ p2 = (PointZ)ps.get(i);
                    PointZ p1 = (PointZ)ps.get(i - 1);
                    Vector3f v1 = this.transform.transform((float)p1.X, (float)p1.Y, (float)p1.Z);
                    Vector3f v2 = this.transform.transform((float)p2.X, (float)p2.Y, (float)p2.Z);
                    slb = (StreamlineBreak)cbc.get(i);
                    if (cylinder == null) {
                        cylinder = new Cylinder(slb.getArrowHeadWidth() * 0.02f, 0.0f, slb.getArrowHeadLength() * 0.02f, 8, 1, true);
                    }
                    Matrix4f matrix = new Matrix4f();
                    matrix.lookAt(v2.sub((Vector3fc)v1, new Vector3f()));
                    matrix.translate(v2);
                    List<Vector3f> vertices = cylinder.getVertices();
                    int n = vertices.size();
                    int nAdded = vertexPositionList.size();
                    for (Vector3f vector3f : vertices) {
                        vertexPositionList.add(matrix.mul(vector3f));
                    }
                    List<Vector3f> list = cylinder.getNormals();
                    for (Vector3f v4 : list) {
                        vertexNormalList.add(matrix.mul(v4));
                    }
                    float[] fArray = slb.getColor().getRGBComponents(null);
                    for (int j = 0; j < n; ++j) {
                        vertexColorList.add(new Vector4f(fArray));
                    }
                    if (nAdded == 0) {
                        vertexIndices.addAll(cylinder.getIndices());
                        continue;
                    }
                    for (int idx : cylinder.getIndices()) {
                        vertexIndices.add(idx + nAdded);
                    }
                }
                continue;
            }
            StreamlineBreak slb = (StreamlineBreak)cb;
            int interval = slb.getInterval();
            for (int i = 1; i < pointNum; ++i) {
                void var25_45;
                if (i % interval != 0) continue;
                PointZ p2 = (PointZ)ps.get(i);
                PointZ p1 = (PointZ)ps.get(i - 1);
                Vector3f v1 = this.transform.transform((float)p1.X, (float)p1.Y, (float)p1.Z);
                Vector3f v2 = this.transform.transform((float)p2.X, (float)p2.Y, (float)p2.Z);
                if (cylinder == null) {
                    cylinder = new Cylinder(slb.getArrowHeadWidth() * 0.02f, 0.0f, slb.getArrowHeadLength() * 0.02f, 8, 1, true);
                }
                Matrix4f matrix = new Matrix4f();
                matrix.lookAt(v2.sub((Vector3fc)v1, new Vector3f()));
                matrix.translate(v2);
                List<Vector3f> vertices = cylinder.getVertices();
                int n = vertices.size();
                int nAdded = vertexPositionList.size();
                for (Vector3f vector3f : vertices) {
                    vertexPositionList.add(matrix.mul(vector3f));
                }
                List<Vector3f> normals = cylinder.getNormals();
                for (Vector3f vector3f : normals) {
                    vertexNormalList.add(matrix.mul(vector3f));
                }
                float[] fArray = slb.getColor().getRGBComponents(null);
                boolean bl = false;
                while (var25_45 < n) {
                    vertexColorList.add(new Vector4f(fArray));
                    ++var25_45;
                }
                if (nAdded == 0) {
                    vertexIndices.addAll(cylinder.getIndices());
                    continue;
                }
                for (int idx : cylinder.getIndices()) {
                    vertexIndices.add(idx + nAdded);
                }
            }
        }
        int n = vertexPositionList.size();
        this.coneVertexPosition = new float[n * 3];
        this.coneVertexNormal = new float[n * 3];
        this.coneVertexColor = new float[n * 4];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < n) {
            Vector3f v = (Vector3f)vertexPositionList.get(i);
            this.coneVertexPosition[j] = v.x;
            this.coneVertexPosition[j + 1] = v.y;
            this.coneVertexPosition[j + 2] = v.z;
            v = (Vector3f)vertexNormalList.get(i);
            this.coneVertexNormal[j] = v.x;
            this.coneVertexNormal[j + 1] = v.y;
            this.coneVertexNormal[j + 2] = v.z;
            Vector4f v4 = (Vector4f)vertexColorList.get(i);
            this.coneVertexColor[k] = v4.x;
            this.coneVertexColor[k + 1] = v4.y;
            this.coneVertexColor[k + 2] = v4.z;
            this.coneVertexColor[k + 3] = v4.w;
            ++i;
            j += 3;
            k += 4;
        }
        this.coneVertexIndices = vertexIndices.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (updateBuffer) {
            this.updateVertexPosition();
            FloatBuffer vertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexPosition);
            this.sizePosition = vertexBuffer.capacity() * 4;
            float[] vertexNormal = this.getVertexNormal();
            FloatBuffer normalBuffer = GLBuffers.newDirectFloatBuffer((float[])vertexNormal);
            this.sizeNormal = normalBuffer.capacity() * 4;
            if (this.vertexColor == null) {
                this.updateVertexColor();
            }
            FloatBuffer colorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexColor);
            this.sizeColor = colorBuffer.capacity() * 4;
            int totalSize = this.sizePosition + this.sizeNormal + this.sizeColor;
            this.gl.glGenBuffers(2, this.vbo);
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glBufferData(34962, (long)totalSize, null, 35044);
            this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
            this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeNormal, (Buffer)normalBuffer);
            this.gl.glBufferSubData(34962, (long)(this.sizePosition + this.sizeNormal), (long)this.sizeColor, (Buffer)colorBuffer);
            this.gl.glBindBuffer(34962, 0);
            if (this.vertexIndices == null) {
                this.updateVertexIndices();
            }
            IntBuffer indexBuffer = GLBuffers.newDirectIntBuffer((int[])this.vertexIndices);
            this.gl.glBindBuffer(34963, this.vbo.get(1));
            this.gl.glBufferData(34963, (long)(indexBuffer.capacity() * 4), (Buffer)indexBuffer, 35044);
            this.gl.glBindBuffer(34963, 0);
            if (this.streamline) {
                this.updateConeVertex();
                FloatBuffer coneVertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexPosition);
                this.sizeConePosition = coneVertexBuffer.capacity() * 4;
                FloatBuffer coneNormalBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexNormal);
                this.sizeConeNormal = coneNormalBuffer.capacity() * 4;
                FloatBuffer coneColorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexColor);
                this.sizeConeColor = coneColorBuffer.capacity() * 4;
                this.vboCone = GLBuffers.newDirectIntBuffer((int)2);
                this.gl.glGenBuffers(2, this.vboCone);
                this.gl.glBindBuffer(34962, this.vboCone.get(0));
                this.gl.glBufferData(34962, (long)(this.sizeConePosition + this.sizeConeNormal + this.sizeConeColor), null, 35044);
                this.gl.glBufferSubData(34962, 0L, (long)this.sizeConePosition, (Buffer)coneVertexBuffer);
                this.gl.glBufferSubData(34962, (long)this.sizeConePosition, (long)this.sizeConeNormal, (Buffer)coneNormalBuffer);
                this.gl.glBufferSubData(34962, (long)(this.sizeConePosition + this.sizeConeNormal), (long)this.sizeConeColor, (Buffer)coneColorBuffer);
                this.gl.glBindBuffer(34962, 0);
                IntBuffer coneIndexBuffer = GLBuffers.newDirectIntBuffer((int[])this.coneVertexIndices);
                this.gl.glBindBuffer(34963, this.vboCone.get(1));
                this.gl.glBufferData(34963, (long)(coneIndexBuffer.capacity() * 4), (Buffer)coneIndexBuffer, 35044);
                this.gl.glBindBuffer(34963, 0);
            }
        }
    }

    void setUniforms() {
    }

    @Override
    public void draw() {
        this.gl.glPushMatrix();
        FloatBuffer fb = Buffers.newDirectFloatBuffer((int)16);
        this.gl.glLoadMatrixf(this.modelViewMatrixR.get(fb));
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            this.gl.glUseProgram(0);
        } else {
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glBindBuffer(34963, this.vbo.get(1));
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glEnableClientState(32885);
            this.gl.glNormalPointer(5126, 0, (long)this.sizePosition);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 5126, 0, (long)(this.sizePosition + this.sizeNormal));
            this.gl.glDrawElements(4, this.vertexIndices.length, 5125, 0L);
            this.gl.glDisableClientState(32884);
            this.gl.glDisableClientState(32885);
            this.gl.glDisableClientState(32886);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glBindBuffer(34963, 0);
            if (this.streamline) {
                this.gl.glBindBuffer(34962, this.vboCone.get(0));
                this.gl.glBindBuffer(34963, this.vboCone.get(1));
                this.gl.glEnableClientState(32884);
                this.gl.glVertexPointer(3, 5126, 0, 0L);
                this.gl.glEnableClientState(32885);
                this.gl.glNormalPointer(5126, 0, (long)this.sizeConePosition);
                this.gl.glEnableClientState(32886);
                this.gl.glColorPointer(4, 5126, 0, (long)(this.sizeConePosition + this.sizeConeNormal));
                this.gl.glDrawElements(4, this.coneVertexIndices.length, 5125, 0L);
                this.gl.glDisableClientState(32884);
                this.gl.glDisableClientState(32885);
                this.gl.glDisableClientState(32886);
                this.gl.glBindBuffer(34962, 0);
                this.gl.glBindBuffer(34963, 0);
            }
        }
        this.gl.glPopMatrix();
    }
}

