/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.ui;

import java.awt.geom.Point2D;

public class ControlPoint {
    private float ratio;
    private float minRatio = 0.0f;
    private float maxRatio = 1.0f;
    private boolean selected = false;
    private Point2D.Float location = new Point2D.Float();

    public ControlPoint(float value) {
        this.setRatio(value);
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float value) {
        this.ratio = value < this.minRatio ? this.minRatio : (value > this.maxRatio ? this.maxRatio : value);
    }

    public float getMinRatio() {
        return this.minRatio;
    }

    public void setMinRatio(float value) {
        this.minRatio = value;
    }

    public float getMaxRatio() {
        return this.maxRatio;
    }

    public void setMaxRatio(float value) {
        this.maxRatio = value;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        this.selected = value;
    }

    public Point2D.Float getLocation() {
        return this.location;
    }

    public void setLocation(Point2D.Float location) {
        this.location = location;
    }

    public void setLocation(float x, float y) {
        this.location = new Point2D.Float(x, y);
    }

    public double getValue(double min, double max) {
        return min + (max - min) * (double)this.ratio;
    }

    public boolean isInPointExtent(float x, float y, float size) {
        float hSize = size / 2.0f;
        if (x < this.location.x - hSize) {
            return false;
        }
        if (x > this.location.x + hSize) {
            return false;
        }
        if (y < this.location.y - hSize) {
            return false;
        }
        return !(y > this.location.y + hSize);
    }
}

