/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import org.meteoinfo.chart.ui.ControlPoint;
import org.meteoinfo.chart.ui.OpacityControlPoint;
import org.meteoinfo.chart.ui.TransferFunctionChangedEvent;
import org.meteoinfo.chart.ui.TransferFunctionChangedListener;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.colors.OpacityTransferFunction;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.ui.ColorComboBoxModel;
import org.meteoinfo.ui.ColorListCellRender;

public class TransferFunctionPanel
extends JPanel {
    private final EventListenerList listeners = new EventListenerList();
    private ColorMap colorMap;
    private ColorMap[] colorMaps;
    private JComboBox jComboBoxColorMap;
    private Array data;
    private double minData;
    private double maxData;
    private double minValue;
    private double maxValue;
    private Array histogram;
    private List<ControlPoint> colorControlPoints = new ArrayList<ControlPoint>();
    private List<OpacityControlPoint> opacityControlPoints = new ArrayList<OpacityControlPoint>();
    private Color histogramColor;
    private Point mousePressPoint;
    private float xBorderGap;
    private float yBorderGap;
    private float colorMapHeight;
    private float histogramHeight;
    private float cmhistGap;
    private float pointSize;
    private ControlPoint selectedPoint;
    private boolean isDraggingColorCP = false;
    private boolean isDraggingOpacityCP = false;
    private boolean drawColorControlPoints = false;
    private boolean isoValue = false;

    public TransferFunctionPanel(Array data, ColorMap colorMap) {
        this(data, colorMap, null);
    }

    public TransferFunctionPanel(Array data, ColorMap colorMap, ColorMap[] colorMaps) {
        this(data, colorMap, colorMaps, null);
    }

    public TransferFunctionPanel(Array data, ColorMap colorMap, ColorMap[] colorMaps, Float opacity) {
        this(data, colorMap, colorMaps, opacity, 4);
    }

    public TransferFunctionPanel(Array data, ColorMap colorMap, ColorMap[] colorMaps, Float opacity, int opacityCPNumber) {
        this.setPreferredSize(new Dimension(200, 120));
        this.initComponents();
        if (colorMaps != null) {
            this.setColorMaps(colorMaps);
        }
        this.colorMap = colorMap;
        this.colorControlPoints.add(new ControlPoint(0.0f));
        this.colorControlPoints.add(new ControlPoint(1.0f));
        this.updateControlPoints(this.colorControlPoints);
        if (opacity == null) {
            if (opacityCPNumber > 1) {
                for (int i = 0; i < opacityCPNumber; ++i) {
                    this.opacityControlPoints.add(new OpacityControlPoint(1.0f * (float)i / (float)(opacityCPNumber - 1)));
                }
            } else {
                this.opacityControlPoints.add(new OpacityControlPoint(0.5f));
            }
        } else if (opacityCPNumber > 1) {
            for (int i = 0; i < opacityCPNumber; ++i) {
                this.opacityControlPoints.add(new OpacityControlPoint(1.0f * (float)i / (float)(opacityCPNumber - 1), opacity.floatValue()));
            }
        } else {
            this.opacityControlPoints.add(new OpacityControlPoint(0.5f, opacity.floatValue()));
        }
        this.updateControlPoints(this.opacityControlPoints);
        this.histogramColor = new Color(0, 204, 204);
        this.xBorderGap = 4.0f;
        this.yBorderGap = 4.0f;
        this.colorMapHeight = 15.0f;
        this.histogramHeight = 80.0f;
        this.cmhistGap = 10.0f;
        this.pointSize = 8.0f;
        this.setBackground(new Color(40, 40, 40));
        this.setData(data);
        this.minValue = 0.0;
        this.maxValue = 1.0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TransferFunctionPanel.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TransferFunctionPanel.this.mousePressPoint = new Point(e.getX(), e.getY());
                TransferFunctionPanel.this.selectedPoint = TransferFunctionPanel.this.mouseSelectPoint(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TransferFunctionPanel.this.isDraggingColorCP) {
                    TransferFunctionPanel.this.updateControlPoints(TransferFunctionPanel.this.colorControlPoints);
                    TransferFunctionPanel.this.isDraggingColorCP = false;
                    TransferFunctionPanel.this.fileTransferFunctionChangedEvent();
                } else if (TransferFunctionPanel.this.isDraggingOpacityCP) {
                    TransferFunctionPanel.this.updateControlPoints(TransferFunctionPanel.this.opacityControlPoints);
                    TransferFunctionPanel.this.isDraggingOpacityCP = false;
                    TransferFunctionPanel.this.fileTransferFunctionChangedEvent();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TransferFunctionPanel.this.onMouseDragged(e);
            }
        });
    }

    public TransferFunctionPanel(Array data) {
        this(data, 1.0f);
    }

    public TransferFunctionPanel(Array data, float opacity) {
        this.setPreferredSize(new Dimension(200, 120));
        this.initComponents();
        this.isoValue = true;
        this.drawColorControlPoints = true;
        this.colorControlPoints.add(new ControlPoint(0.5f));
        this.updateControlPoints(this.colorControlPoints);
        this.histogramColor = new Color(0, 204, 204);
        this.xBorderGap = 4.0f;
        this.yBorderGap = 4.0f;
        this.colorMapHeight = 15.0f;
        this.histogramHeight = 80.0f;
        this.cmhistGap = 10.0f;
        this.pointSize = 8.0f;
        this.setBackground(new Color(40, 40, 40));
        this.setData(data);
        this.minValue = 0.0;
        this.maxValue = 1.0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TransferFunctionPanel.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TransferFunctionPanel.this.mousePressPoint = new Point(e.getX(), e.getY());
                TransferFunctionPanel.this.selectedPoint = TransferFunctionPanel.this.mouseSelectPoint(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TransferFunctionPanel.this.isDraggingColorCP) {
                    TransferFunctionPanel.this.updateControlPoints(TransferFunctionPanel.this.colorControlPoints);
                    TransferFunctionPanel.this.isDraggingColorCP = false;
                    TransferFunctionPanel.this.fileTransferFunctionChangedEvent();
                } else if (TransferFunctionPanel.this.isDraggingOpacityCP) {
                    TransferFunctionPanel.this.updateControlPoints(TransferFunctionPanel.this.opacityControlPoints);
                    TransferFunctionPanel.this.isDraggingOpacityCP = false;
                    TransferFunctionPanel.this.fileTransferFunctionChangedEvent();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TransferFunctionPanel.this.onMouseDragged(e);
            }
        });
    }

    private void initComponents() {
        this.jComboBoxColorMap = new JComboBox();
        this.add((Component)this.jComboBoxColorMap, "South");
        this.jComboBoxColorMap.setVisible(false);
    }

    public void addTransferFunctionChangedListener(TransferFunctionChangedListener listener) {
        this.listeners.add(TransferFunctionChangedListener.class, listener);
    }

    public void removeTransferFunctionChangedListener(TransferFunctionChangedListener listener) {
        this.listeners.remove(TransferFunctionChangedListener.class, listener);
    }

    public void fileTransferFunctionChangedEvent() {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != TransferFunctionChangedListener.class) continue;
            ((TransferFunctionChangedListener)listeners[i + 1]).transferFunctionChangedEvent(new TransferFunctionChangedEvent(this));
        }
    }

    public void setData(Array data) {
        if (data != null) {
            this.data = data;
            this.minData = ArrayMath.min((Array)data).doubleValue();
            this.maxData = ArrayMath.max((Array)data).doubleValue();
            this.minValue = this.minData;
            this.maxValue = this.maxData;
            this.histogram = (Array)ArrayUtil.histogram((Array)data, (int)256).get(0);
            this.histogram = ArrayUtil.toFloat((Array)this.histogram);
            this.histogram = ArrayMath.div((Array)this.histogram, (Number)ArrayMath.max((Array)this.histogram));
            this.repaint();
        }
    }

    public void setMinValue(double value) {
        this.minValue = value;
        this.repaint();
        this.fileTransferFunctionChangedEvent();
    }

    public void setMaxValue(double value) {
        this.maxValue = value;
        this.repaint();
        this.fileTransferFunctionChangedEvent();
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap value) {
        this.colorMap = value;
    }

    public void setColorMaps(ColorMap[] value) {
        this.colorMaps = value;
        ColorListCellRender render = new ColorListCellRender();
        render.setPreferredSize(new Dimension(62, 21));
        this.jComboBoxColorMap.setModel(new ColorComboBoxModel(this.colorMaps));
        this.jComboBoxColorMap.setRenderer(render);
        this.jComboBoxColorMap.setSelectedItem(this.colorMap);
        this.jComboBoxColorMap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TransferFunctionPanel.this.onColormapChanged(e);
            }
        });
    }

    public ControlPoint getSelectedControlPoint() {
        return this.selectedPoint;
    }

    private void updateControlPoints(List<? extends ControlPoint> cps) {
        if (!this.isoValue) {
            if (cps.size() == 1) {
                ControlPoint cp = cps.get(0);
                cp.setMinRatio(0.0f);
                cp.setMaxRatio(1.0f);
            } else {
                for (int i = 0; i < cps.size(); ++i) {
                    ControlPoint cp = cps.get(i);
                    if (i == 0) {
                        cp.setMaxRatio(cps.get(i + 1).getRatio());
                        continue;
                    }
                    if (i == cps.size() - 1) {
                        cp.setMinRatio(cps.get(i - 1).getRatio());
                        continue;
                    }
                    cp.setMinRatio(cps.get(i - 1).getRatio());
                    cp.setMaxRatio(cps.get(i + 1).getRatio());
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        float y;
        float x;
        float w;
        int n;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        float h = this.colorMapHeight;
        float width = (float)this.getWidth() - this.xBorderGap * 2.0f;
        if (!this.isoValue) {
            n = this.colorMap.getColorCount();
            w = width / (float)n;
            if (w <= 0.0f) {
                w = 1.0f;
            }
            x = this.xBorderGap;
            y = (float)this.getHeight() - h - this.yBorderGap;
            for (i = 0; i < n; ++i) {
                Color c = this.colorMap.getColor(i);
                g2.setColor(c);
                if (i == 0) {
                    g2.fill(new Rectangle2D.Float(x, y, w, h));
                } else {
                    g2.fill(new Rectangle2D.Float(x - 1.0f, y, w + 1.0f, h));
                }
                x += w;
            }
        }
        float height = this.histogramHeight;
        if (this.data != null) {
            n = (int)this.histogram.getSize();
            int si = Math.round((float)((this.minValue - this.minData) / (this.maxData - this.minData) * (double)n));
            int ei = Math.round((float)((this.maxValue - this.minData) / (this.maxData - this.minData) * (double)n));
            x = this.xBorderGap;
            y = (float)this.getHeight() - h - this.yBorderGap;
            y -= this.cmhistGap;
            g2.setColor(this.histogramColor);
            w = width / (float)(ei - si);
            for (int i2 = si; i2 < ei; ++i2) {
                float v = this.histogram.getFloat(i2);
                g2.fill(new Rectangle2D.Float(x, y - (v *= height), w, v));
                x += w;
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        if (this.drawColorControlPoints) {
            y = (float)this.getHeight() - h - this.yBorderGap;
            y += h / 2.0f;
            for (i = 0; i < this.colorControlPoints.size(); ++i) {
                g2.setColor(Color.white);
                ControlPoint cp = this.colorControlPoints.get(i);
                x = this.xBorderGap + cp.getRatio() * width;
                Ellipse2D.Float ellipse = new Ellipse2D.Float(x - this.pointSize / 2.0f, y - this.pointSize / 2.0f, this.pointSize, this.pointSize);
                cp.setLocation(x, y);
                g2.fill(ellipse);
                if (cp.isSelected()) {
                    g2.setColor(Color.black);
                    g2.fill(new Ellipse2D.Float(x - this.pointSize / 4.0f, y - this.pointSize / 4.0f, this.pointSize / 2.0f, this.pointSize / 2.0f));
                }
                if (!this.isoValue) continue;
                g2.setColor(Color.white);
                float ty = (float)this.getHeight() - h - this.yBorderGap - height;
                g2.draw(new Line2D.Float(x, y, x, ty));
            }
        }
        GeneralPath path = new GeneralPath(0, this.opacityControlPoints.size());
        y = (float)this.getHeight() - h - this.yBorderGap;
        y -= this.cmhistGap;
        for (int i3 = 0; i3 < this.opacityControlPoints.size(); ++i3) {
            OpacityControlPoint ocp = this.opacityControlPoints.get(i3);
            x = this.xBorderGap + ocp.getRatio() * width;
            float v = ocp.getOpacity() * height;
            if (i3 == 0) {
                path.moveTo(this.xBorderGap, y - v);
                path.lineTo(x, y - v);
                if (this.opacityControlPoints.size() == 1) {
                    path.lineTo(x, y - v);
                    path.lineTo(this.xBorderGap + width, y - v);
                }
            } else if (i3 == this.opacityControlPoints.size() - 1) {
                path.lineTo(x, y - v);
                path.lineTo(this.xBorderGap + width, y - v);
            } else {
                path.lineTo(x, y - v);
            }
            ocp.setLocation(x, y - v);
        }
        g2.setColor(Color.white);
        g2.draw(path);
        for (OpacityControlPoint ocp : this.opacityControlPoints) {
            Point2D.Float point = ocp.getLocation();
            Ellipse2D.Float ellipse = new Ellipse2D.Float(point.x - this.pointSize / 2.0f, point.y - this.pointSize / 2.0f, this.pointSize, this.pointSize);
            g2.setColor(Color.white);
            g2.fill(ellipse);
            if (!ocp.isSelected()) continue;
            g2.setColor(Color.black);
            g2.fill(new Ellipse2D.Float(point.x - this.pointSize / 4.0f, point.y - this.pointSize / 4.0f, this.pointSize / 2.0f, this.pointSize / 2.0f));
        }
        g2.dispose();
    }

    private Rectangle2D.Float getColorMapExtent() {
        return new Rectangle2D.Float(this.xBorderGap, (float)this.getHeight() - this.yBorderGap - this.colorMapHeight, (float)this.getWidth() - this.xBorderGap * 2.0f, this.colorMapHeight);
    }

    private Rectangle2D.Float getHistogramExtent() {
        return new Rectangle2D.Float(this.xBorderGap, (float)this.getHeight() - this.yBorderGap - this.colorMapHeight - this.cmhistGap - this.histogramHeight, (float)this.getWidth() - this.xBorderGap * 2.0f, this.histogramHeight);
    }

    public boolean mouseInColorMap(MouseEvent e) {
        float y = (float)this.getHeight() - this.yBorderGap;
        return (float)e.getY() <= y && (float)e.getY() >= y - this.colorMapHeight;
    }

    public boolean mouseInHistogram(MouseEvent e) {
        float y = (float)this.getHeight() - this.yBorderGap - this.colorMapHeight - this.cmhistGap;
        return (float)e.getY() <= y && (float)e.getY() >= y - this.histogramHeight;
    }

    private ControlPoint mouseSelectPoint(MouseEvent e) {
        for (ControlPoint cp : this.colorControlPoints) {
            cp.setSelected(false);
        }
        for (OpacityControlPoint ocp : this.opacityControlPoints) {
            ocp.setSelected(false);
        }
        for (ControlPoint cp : this.colorControlPoints) {
            if (!cp.isInPointExtent(e.getX(), e.getY(), this.pointSize + 5.0f)) continue;
            cp.setSelected(true);
            return cp;
        }
        for (OpacityControlPoint ocp : this.opacityControlPoints) {
            if (!ocp.isInPointExtent(e.getX(), e.getY(), this.pointSize + 5.0f)) continue;
            ocp.setSelected(true);
            return ocp;
        }
        return null;
    }

    private void onMouseClicked(final MouseEvent e) {
        this.selectedPoint = this.mouseSelectPoint(e);
        if (e.getButton() == 1) {
            this.repaint();
        } else if (e.getButton() == 3) {
            if (this.mouseInColorMap(e)) {
                if (this.jComboBoxColorMap != null) {
                    this.jComboBoxColorMap.setLocation(this.getX(), this.getY() + this.getHeight() - 20);
                    this.jComboBoxColorMap.setSize(this.getWidth(), 20);
                    this.jComboBoxColorMap.setVisible(true);
                    this.jComboBoxColorMap.showPopup();
                    this.jComboBoxColorMap.setVisible(false);
                }
            } else if (this.mouseInHistogram(e)) {
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem jMenuItemControlPoint = new JMenuItem();
                if (this.selectedPoint == null) {
                    jMenuItemControlPoint.setText("Add control point");
                    jMenuItemControlPoint.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            OpacityControlPoint ocp;
                            Rectangle2D.Float extent = TransferFunctionPanel.this.getHistogramExtent();
                            float ratio = ((float)e.getX() - extent.x) / extent.width;
                            float opacity = 1.0f - ((float)e.getY() - extent.y) / extent.height;
                            OpacityControlPoint newOcp = new OpacityControlPoint(ratio);
                            newOcp.setOpacity(opacity);
                            newOcp.setSelected(true);
                            int i = 0;
                            Iterator iterator = TransferFunctionPanel.this.opacityControlPoints.iterator();
                            while (iterator.hasNext() && !(ratio < (ocp = (OpacityControlPoint)iterator.next()).getRatio())) {
                                ++i;
                            }
                            if (i > 0) {
                                newOcp.setMinRatio(((OpacityControlPoint)TransferFunctionPanel.this.opacityControlPoints.get(i - 1)).getMinRatio());
                            }
                            if (i < TransferFunctionPanel.this.opacityControlPoints.size()) {
                                newOcp.setMaxRatio(((OpacityControlPoint)TransferFunctionPanel.this.opacityControlPoints.get(i)).getMaxRatio());
                            }
                            TransferFunctionPanel.this.opacityControlPoints.add(i, newOcp);
                            TransferFunctionPanel.this.repaint();
                        }
                    });
                } else if (this.opacityControlPoints.size() > 1) {
                    jMenuItemControlPoint.setText("Delete control point");
                    jMenuItemControlPoint.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            TransferFunctionPanel.this.opacityControlPoints.remove(TransferFunctionPanel.this.selectedPoint);
                            TransferFunctionPanel.this.repaint();
                        }
                    });
                }
                popupMenu.add(jMenuItemControlPoint);
                popupMenu.show(this, e.getX(), e.getY());
            }
        }
    }

    private void onMouseDragged(MouseEvent e) {
        if (this.selectedPoint != null) {
            if (this.selectedPoint instanceof OpacityControlPoint) {
                Rectangle2D.Float extent = this.getHistogramExtent();
                this.selectedPoint.setRatio(((float)e.getX() - extent.x) / extent.width);
                ((OpacityControlPoint)this.selectedPoint).setOpacity(1.0f - ((float)e.getY() - extent.y) / extent.height);
                this.isDraggingOpacityCP = true;
            } else {
                Rectangle2D.Float extent = this.getColorMapExtent();
                this.selectedPoint.setRatio(((float)e.getX() - extent.x) / extent.width);
                this.isDraggingColorCP = true;
            }
            this.repaint();
        }
    }

    private void onColormapChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            ColorMap colorMap = (ColorMap)this.jComboBoxColorMap.getSelectedItem();
            this.setColorMap(colorMap);
            this.updateUI();
            this.fileTransferFunctionChangedEvent();
        }
        this.jComboBoxColorMap.hidePopup();
        this.jComboBoxColorMap.setSize(this.jComboBoxColorMap.getWidth(), 0);
    }

    public OpacityControlPoint getSelectedOCP() {
        for (OpacityControlPoint ocp : this.opacityControlPoints) {
            if (!ocp.isSelected()) continue;
            return ocp;
        }
        return null;
    }

    public TransferFunction getTransferFunction() {
        int n = this.opacityControlPoints.size();
        float[] opacityNodes = new float[n];
        float[] opacityLevels = new float[n];
        for (int i = 0; i < n; ++i) {
            OpacityControlPoint opc = this.opacityControlPoints.get(i);
            opacityNodes[i] = (float)((opc.getValue(this.minValue, this.maxValue) - this.minData) / (this.maxData - this.minData));
            opacityLevels[i] = opc.getOpacity();
        }
        OpacityTransferFunction opacityTransferFunction = new OpacityTransferFunction();
        opacityTransferFunction.setOpacityNodes(opacityNodes);
        opacityTransferFunction.setOpacityLevels(opacityLevels);
        Normalize normalize = new Normalize(this.minValue, this.maxValue, true);
        TransferFunction transferFunction = new TransferFunction(opacityTransferFunction, this.colorMap, normalize);
        return transferFunction;
    }
}

