/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.XYDataset;

public class XYArrayDataset
extends XYDataset {
    private final double[][] xValues;
    private final double[][] yValues;
    private final int seriesCount;
    private final int itemCount;
    private String[] seriesKeys;

    public XYArrayDataset(int seriesNum, int itemNum) {
        this.seriesCount = seriesNum;
        this.itemCount = itemNum;
        this.xValues = new double[seriesNum][itemNum];
        this.yValues = new double[seriesNum][itemNum];
        this.seriesKeys = new String[seriesNum];
    }

    public XYArrayDataset(StationData xdata, StationData ydata, String seriesKey) {
        int i;
        ArrayList<double[]> vdata = new ArrayList<double[]>();
        for (i = 0; i < xdata.getStNum(); ++i) {
            double v2;
            double v1 = xdata.getValue(i);
            if (MIMath.doubleEquals((double)v1, (double)xdata.missingValue) || MIMath.doubleEquals((double)(v2 = ydata.getValue(i)), (double)ydata.missingValue)) continue;
            vdata.add(new double[]{v1, v2});
        }
        this.seriesCount = 1;
        this.seriesKeys = new String[this.seriesCount];
        this.seriesKeys[0] = seriesKey;
        this.itemCount = vdata.size();
        this.xValues = new double[this.seriesCount][this.itemCount];
        this.yValues = new double[this.seriesCount][this.itemCount];
        for (i = 0; i < this.seriesCount; ++i) {
            for (int j = 0; j < this.itemCount; ++j) {
                this.xValues[i][j] = ((double[])vdata.get(j))[0];
                this.yValues[i][j] = ((double[])vdata.get(j))[1];
            }
        }
    }

    public XYArrayDataset(List<Number> xdata, List<Number> ydata, String seriesKey) {
        int i;
        ArrayList<Double> nxdata = new ArrayList<Double>();
        ArrayList<Double> nydata = new ArrayList<Double>();
        for (int i2 = 0; i2 < xdata.size(); ++i2) {
            nxdata.add(Double.parseDouble(xdata.get(i2).toString()));
            nydata.add(Double.parseDouble(ydata.get(i2).toString()));
        }
        ArrayList<double[]> vdata = new ArrayList<double[]>();
        for (i = 0; i < xdata.size(); ++i) {
            double v1 = (Double)nxdata.get(i);
            double v2 = (Double)nydata.get(i);
            vdata.add(new double[]{v1, v2});
        }
        this.seriesCount = 1;
        this.seriesKeys = new String[this.seriesCount];
        this.seriesKeys[0] = seriesKey;
        this.itemCount = vdata.size();
        this.xValues = new double[this.seriesCount][this.itemCount];
        this.yValues = new double[this.seriesCount][this.itemCount];
        for (i = 0; i < this.seriesCount; ++i) {
            for (int j = 0; j < this.itemCount; ++j) {
                this.xValues[i][j] = ((double[])vdata.get(j))[0];
                this.yValues[i][j] = ((double[])vdata.get(j))[1];
            }
        }
    }

    @Override
    public int getSeriesCount() {
        return this.seriesCount;
    }

    @Override
    public String getSeriesKey(int seriesIdx) {
        return this.seriesKeys[seriesIdx];
    }

    @Override
    public void setSeriesKey(int seriesIdx, String seriesKey) {
        this.seriesKeys[seriesIdx] = seriesKey;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public int getItemCount(int seriesIdx) {
        return this.itemCount;
    }

    @Override
    public double[] getXValues(int seriesIdx) {
        return this.xValues[seriesIdx];
    }

    @Override
    public double[] getYValues(int seriesIdx) {
        return this.yValues[seriesIdx];
    }

    @Override
    public double getX(int seriesIdx, int itemIdx) {
        return this.xValues[seriesIdx][itemIdx];
    }

    @Override
    public void setX(int seriesIdx, int itemIdx, double value) {
        this.xValues[seriesIdx][itemIdx] = value;
    }

    @Override
    public double getY(int seriesIdx, int itemIdx) {
        return this.yValues[seriesIdx][itemIdx];
    }

    @Override
    public void setY(int seriesIdx, int itemIdx, double value) {
        this.yValues[seriesIdx][itemIdx] = value;
    }

    @Override
    public List<String> getSeriesKeys() {
        return Arrays.asList(this.seriesKeys);
    }

    public void setSeriesKeys(String[] value) {
        this.seriesKeys = value;
    }

    @Override
    public void setSeriesKeys(List<String> value) {
        this.seriesKeys = value.toArray(new String[value.size()]);
    }

    @Override
    public Extent getDataExtent() {
        Extent cET = new Extent();
        int n = 0;
        for (int i = 0; i < this.seriesCount; ++i) {
            for (int j = 0; j < this.itemCount; ++j) {
                double x = this.xValues[i][j];
                double y = this.yValues[i][j];
                if (MIMath.doubleEquals((double)y, (double)this.getMissingValue()) || MIMath.doubleEquals((double)x, (double)this.getMissingValue())) continue;
                if (n == 0) {
                    cET.minX = x;
                    cET.maxX = x;
                    cET.minY = y;
                    cET.maxY = y;
                } else {
                    if (cET.minX > x) {
                        cET.minX = x;
                    } else if (cET.maxX < x) {
                        cET.maxX = x;
                    }
                    if (cET.minY > y) {
                        cET.minY = y;
                    } else if (cET.maxY < y) {
                        cET.maxY = y;
                    }
                }
                ++n;
            }
        }
        return cET;
    }

    @Override
    public List<int[]> selectPoints(Extent extent) {
        ArrayList<int[]> selIdxs = new ArrayList<int[]>();
        for (int i = 0; i < this.seriesCount; ++i) {
            for (int j = 0; j < this.itemCount; ++j) {
                double y;
                double x = this.getX(i, j);
                if (!(x >= extent.minX) || !(x <= extent.maxX) || !((y = this.getY(i, j)) >= extent.minY) || !(y <= extent.maxY)) continue;
                selIdxs.add(new int[]{i, j});
            }
        }
        return selIdxs;
    }

    @Override
    public List<Integer> getMissingValueIndex(int seriesIdx) {
        ArrayList<Integer> mvidx = new ArrayList<Integer>();
        double[] xvs = this.getXValues(seriesIdx);
        double[] yvs = this.getYValues(seriesIdx);
        for (int i = 0; i < this.itemCount; ++i) {
            if (!MIMath.doubleEquals((double)xvs[i], (double)this.getMissingValue()) && !MIMath.doubleEquals((double)yvs[i], (double)this.getMissingValue())) continue;
            mvidx.add(i);
        }
        return mvidx;
    }
}

