/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.XYDataset;
import org.meteoinfo.data.XYSeriesData;
import org.meteoinfo.ndarray.Array;

public class XYListDataset
extends XYDataset {
    private List<XYSeriesData> dataset = new ArrayList<XYSeriesData>();

    public XYListDataset() {
    }

    public XYListDataset(int seriesNum, int itemNum) {
        this();
        for (int i = 0; i < seriesNum; ++i) {
            this.dataset.add(new XYSeriesData());
        }
    }

    public XYListDataset(StationData xdata, StationData ydata, String seriesKey) {
        this();
        ArrayList<double[]> vdata = new ArrayList<double[]>();
        for (int i = 0; i < xdata.getStNum(); ++i) {
            double v2;
            double v1 = xdata.getValue(i);
            if (MIMath.doubleEquals((double)v1, (double)xdata.missingValue) || MIMath.doubleEquals((double)(v2 = ydata.getValue(i)), (double)ydata.missingValue)) continue;
            vdata.add(new double[]{v1, v2});
        }
        int n = vdata.size();
        double[] xvs = new double[n];
        double[] yvs = new double[n];
        for (int i = 0; i < n; ++i) {
            xvs[i] = ((double[])vdata.get(i))[0];
            yvs[i] = ((double[])vdata.get(i))[1];
        }
        XYSeriesData sdata = new XYSeriesData(seriesKey, xvs, yvs);
        this.dataset.add(sdata);
    }

    public XYSeriesData getSeriesData(int seriesIdx) {
        return this.dataset.get(seriesIdx);
    }

    @Override
    public int getSeriesCount() {
        return this.dataset.size();
    }

    @Override
    public String getSeriesKey(int seriesIdx) {
        return this.dataset.get(seriesIdx).getKey();
    }

    @Override
    public void setSeriesKey(int seriesIdx, String seriesKey) {
        this.dataset.get(seriesIdx).setKey(seriesKey);
    }

    @Override
    public List<String> getSeriesKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (XYSeriesData d : this.dataset) {
            keys.add(d.getKey());
        }
        return keys;
    }

    @Override
    public void setSeriesKeys(List<String> value) {
        int i = 0;
        for (XYSeriesData d : this.dataset) {
            d.setKey(value.get(i));
            ++i;
        }
    }

    @Override
    public int getItemCount() {
        int n = this.getItemCount(0);
        if (this.getSeriesCount() > 1) {
            for (int i = 1; i < this.getSeriesCount(); ++i) {
                int nn = this.getItemCount(i);
                if (n >= nn) continue;
                n = nn;
            }
        }
        return n;
    }

    @Override
    public int getItemCount(int seriesIdx) {
        return this.dataset.get(seriesIdx).dataLength();
    }

    @Override
    public double[] getXValues(int seriesIdx) {
        return this.dataset.get(seriesIdx).getXdata();
    }

    @Override
    public double[] getYValues(int seriesIdx) {
        return this.dataset.get(seriesIdx).getYdata();
    }

    @Override
    public double getX(int seriesIdx, int itemIdx) {
        return this.dataset.get(seriesIdx).getXdata()[itemIdx];
    }

    @Override
    public double getY(int seriesIdx, int itemIdx) {
        return this.dataset.get(seriesIdx).getYdata()[itemIdx];
    }

    @Override
    public void setX(int seriesIdx, int itemIdx, double value) {
        this.dataset.get((int)seriesIdx).getXdata()[itemIdx] = value;
    }

    @Override
    public void setY(int seriesIdx, int itemIdx, double value) {
        this.dataset.get((int)seriesIdx).getYdata()[itemIdx] = value;
    }

    public void addSeries(XYSeriesData sdata) {
        this.dataset.add(sdata);
    }

    public void addSeries(String seriesKey, double[] xvs, double[] yvs) {
        XYSeriesData sdata = new XYSeriesData(seriesKey, xvs, yvs);
        this.dataset.add(sdata);
    }

    public void addSeries(String seriesKey, List<Number> xvs, List<Number> yvs) {
        double v;
        int i;
        double[] nxvs = new double[xvs.size()];
        double[] nyvs = new double[yvs.size()];
        for (i = 0; i < xvs.size(); ++i) {
            v = xvs.get(i).doubleValue();
            nxvs[i] = Double.isNaN(v) ? this.getMissingValue() : xvs.get(i).doubleValue();
        }
        for (i = 0; i < yvs.size(); ++i) {
            v = yvs.get(i).doubleValue();
            nyvs[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
        this.addSeries(seriesKey, nxvs, nyvs);
    }

    public void addSeries(String seriesKey, List<Number> xvs, Array yvs) {
        int i;
        int xn = xvs.size();
        int yn = (int)yvs.getSize();
        double[] nxvs = new double[xn];
        double[] nyvs = new double[yn];
        for (i = 0; i < xn; ++i) {
            nxvs[i] = xvs.get(i).doubleValue();
        }
        for (i = 0; i < yn; ++i) {
            double v = yvs.getDouble(i);
            nyvs[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
        this.addSeries(seriesKey, nxvs, nyvs);
    }

    public void addSeries(String seriesKey, Array xvs, Array yvs) {
        int i;
        int xn = (int)xvs.getSize();
        int yn = (int)yvs.getSize();
        double[] nxvs = new double[xn];
        double[] nyvs = new double[yn];
        for (i = 0; i < xn; ++i) {
            nxvs[i] = xvs.getDouble(i);
        }
        for (i = 0; i < yn; ++i) {
            double v = yvs.getDouble(i);
            nyvs[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
        this.addSeries(seriesKey, nxvs, nyvs);
    }

    public void addSeries(String seriesKey, Array xvs, List<Number> yvs) {
        int i;
        int xn = (int)xvs.getSize();
        int yn = yvs.size();
        double[] nxvs = new double[xn];
        double[] nyvs = new double[yn];
        for (i = 0; i < xn; ++i) {
            nxvs[i] = xvs.getDouble(i);
        }
        for (i = 0; i < yn; ++i) {
            double v = yvs.get(i).doubleValue();
            nyvs[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
        this.addSeries(seriesKey, nxvs, nyvs);
    }

    public void removeSeries(int seriesIdx) {
        this.dataset.remove(seriesIdx);
    }

    public void removeSeries(String seriesKey) {
        List<String> keys = this.getSeriesKeys();
        int idx = keys.indexOf(seriesKey);
        if (idx >= 0) {
            this.removeSeries(idx);
        }
    }

    @Override
    public Extent getDataExtent() {
        Extent cET = new Extent();
        int n = 0;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            XYSeriesData sdata = this.dataset.get(i);
            for (int j = 0; j < this.getItemCount(i); ++j) {
                double xmin = sdata.getX_min(j);
                double xmax = sdata.getX_max(j);
                double ymin = sdata.getY_min(j);
                double ymax = sdata.getY_max(j);
                if (Double.isNaN(sdata.getX(j)) || Double.isNaN(sdata.getY(j)) || MIMath.doubleEquals((double)sdata.getX(j), (double)this.getMissingValue()) || MIMath.doubleEquals((double)sdata.getY(j), (double)this.getMissingValue())) continue;
                if (n == 0) {
                    cET.minX = xmin;
                    cET.maxX = xmax;
                    cET.minY = ymin;
                    cET.maxY = ymax;
                } else {
                    if (cET.minX > xmin) {
                        cET.minX = xmin;
                    } else if (cET.maxX < xmax) {
                        cET.maxX = xmax;
                    }
                    if (cET.minY > ymin) {
                        cET.minY = ymin;
                    } else if (cET.maxY < ymax) {
                        cET.maxY = ymax;
                    }
                }
                ++n;
            }
        }
        return cET;
    }

    @Override
    public List<Integer> getMissingValueIndex(int seriesIdx) {
        ArrayList<Integer> mvidx = new ArrayList<Integer>();
        double[] xvs = this.getXValues(seriesIdx);
        double[] yvs = this.getYValues(seriesIdx);
        for (int i = 0; i < yvs.length; ++i) {
            if (!MIMath.doubleEquals((double)xvs[i], (double)this.getMissingValue()) && !MIMath.doubleEquals((double)yvs[i], (double)this.getMissingValue())) continue;
            mvidx.add(i);
        }
        return mvidx;
    }

    @Override
    public List<int[]> selectPoints(Extent extent) {
        ArrayList<int[]> selIdxs = new ArrayList<int[]>();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            for (int j = 0; j < this.getItemCount(i); ++j) {
                double y;
                double x = this.getX(i, j);
                if (!(x >= extent.minX) || !(x <= extent.maxX) || !((y = this.getY(i, j)) >= extent.minY) || !(y <= extent.maxY)) continue;
                selIdxs.add(new int[]{i, j});
            }
        }
        return selIdxs;
    }
}

