/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.geotiff;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.mapdata.geotiff.IFDEntry;
import org.meteoinfo.data.mapdata.geotiff.Tag;
import org.meteoinfo.data.mapdata.geotiff.compression.CompressionDecoder;
import org.meteoinfo.data.mapdata.geotiff.compression.DeflateCompression;
import org.meteoinfo.data.mapdata.geotiff.compression.LZWCompression;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;

public class IFD {
    private List<IFDEntry> tags = new ArrayList<IFDEntry>();
    private FileChannel channel;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public IFD(FileChannel fc, ByteOrder byteOrder) {
        this.channel = fc;
        this.byteOrder = byteOrder;
    }

    public List<IFDEntry> getTags() {
        return this.tags;
    }

    public void setTags(List<IFDEntry> value) {
        this.tags = value;
    }

    IFDEntry findTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        for (IFDEntry ifd : this.tags) {
            if (ifd.tag != tag) continue;
            return ifd;
        }
        return null;
    }

    public void addTag(IFDEntry tag) {
        this.tags.add(tag);
    }

    public void deleteTag(IFDEntry ifd) {
        this.tags.remove(ifd);
    }

    public IFDEntry getTag(int i) {
        return this.tags.get(i);
    }

    public int getTagNum() {
        return this.tags.size();
    }

    public Array readArray() throws IOException {
        Array r;
        block60: {
            CompressionDecoder cDecoder;
            DataType dataType;
            int bitsPerSample;
            int samplesPerPixel;
            int width;
            block59: {
                IFDEntry tileOffsetTag;
                int compression;
                IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
                IFDEntry heightIFD = this.findTag(Tag.ImageLength);
                width = widthIFD.value[0];
                int height = heightIFD.value[0];
                IFDEntry samplesPerPixelTag = this.findTag(Tag.SamplesPerPixel);
                samplesPerPixel = samplesPerPixelTag.value[0];
                IFDEntry bitsPerSampleTag = this.findTag(Tag.BitsPerSample);
                bitsPerSample = bitsPerSampleTag.value[0];
                int[] shape = samplesPerPixel == 1 ? new int[]{height, width} : new int[]{height, width, samplesPerPixel};
                dataType = DataType.INT;
                IFDEntry sampleFormatTag = this.findTag(Tag.SampleFormat);
                int sampleFormat = 0;
                if (sampleFormatTag != null) {
                    sampleFormat = sampleFormatTag.value[0];
                }
                switch (bitsPerSample) {
                    case 32: {
                        switch (sampleFormat) {
                            case 3: {
                                dataType = DataType.FLOAT;
                            }
                        }
                    }
                }
                r = Array.factory((DataType)dataType, (int[])shape);
                IFDEntry compressionTag = this.findTag(Tag.Compression);
                cDecoder = null;
                if (compressionTag != null && (compression = compressionTag.value[0]) > 1) {
                    switch (compression) {
                        case 5: {
                            cDecoder = new LZWCompression();
                            break;
                        }
                        case 8: {
                            cDecoder = new DeflateCompression();
                        }
                    }
                }
                if ((tileOffsetTag = this.findTag(Tag.TileOffsets)) == null) break block59;
                Index index = r.getIndex();
                IFDEntry tileSizeTag = this.findTag(Tag.TileByteCounts);
                IFDEntry tileLengthTag = this.findTag(Tag.TileLength);
                IFDEntry tileWidthTag = this.findTag(Tag.TileWidth);
                int tileWidth = tileWidthTag.value[0];
                int tileHeight = tileLengthTag.value[0];
                int hTileNum = (width + tileWidth - 1) / tileWidth;
                int vTileNum = (height + tileHeight - 1) / tileHeight;
                switch (bitsPerSample) {
                    case 8: {
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                long tileOffset = tileOffsetTag.valueL[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize, cDecoder);
                                block22: for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    for (int w = 0; w < tileWidth; ++w) {
                                        int hIdx = j * tileWidth + w;
                                        if (hIdx == width) {
                                            buffer.get(new byte[tileWidth - w]);
                                            continue block22;
                                        }
                                        index.set0(vIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            if (sampleFormat == 2) {
                                                r.setInt(index, (int)buffer.get());
                                                continue;
                                            }
                                            r.setInt(index, Byte.toUnsignedInt(buffer.get()));
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            if (sampleFormat == 2) {
                                                r.setInt(index, (int)buffer.get());
                                                continue;
                                            }
                                            r.setInt(index, Byte.toUnsignedInt(buffer.get()));
                                        }
                                    }
                                }
                            }
                        }
                        break block60;
                    }
                    case 16: {
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                long tileOffset = tileOffsetTag.valueL[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize, cDecoder);
                                for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    int hIdx;
                                    for (int w = 0; w < tileWidth && (hIdx = j * tileWidth + w) != width; ++w) {
                                        index.set0(vIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            r.setInt(index, (int)buffer.getShort());
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            r.setInt(index, (int)buffer.getShort());
                                        }
                                    }
                                }
                            }
                        }
                        break block60;
                    }
                    case 32: {
                        int size = tileHeight * tileWidth * 4;
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                long tileOffset = tileOffsetTag.valueL[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                if (tileSize == 0) continue;
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize, cDecoder);
                                if (buffer.limit() < size) {
                                    ByteBuffer nbuffer = ByteBuffer.allocate(size);
                                    nbuffer.put(buffer.array());
                                    buffer = nbuffer;
                                    ((Buffer)buffer).position(0);
                                }
                                block32: for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    index.set0(vIdx);
                                    for (int w = 0; w < tileWidth; ++w) {
                                        int hIdx = j * tileWidth + w;
                                        if (hIdx == width) {
                                            buffer.get(new byte[(tileWidth - w) * 4]);
                                            continue block32;
                                        }
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            if (dataType == DataType.FLOAT) {
                                                r.setFloat(index, buffer.getFloat());
                                                continue;
                                            }
                                            r.setInt(index, buffer.getInt());
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            if (dataType == DataType.FLOAT) {
                                                r.setFloat(index, buffer.getFloat());
                                                continue;
                                            }
                                            r.setInt(index, buffer.getInt());
                                        }
                                    }
                                }
                            }
                        }
                        break block60;
                    }
                }
                break block60;
            }
            IFDEntry stripOffsetTag = this.findTag(Tag.StripOffsets);
            if (stripOffsetTag != null) {
                int stripNum = (int)stripOffsetTag.count;
                IFDEntry stripSizeTag = this.findTag(Tag.StripByteCounts);
                int stripSize = stripSizeTag.value[0];
                IFDEntry rowsPerStripTag = this.findTag(Tag.RowsPerStrip);
                int rowNum = rowsPerStripTag.value[0];
                int idx = 0;
                switch (bitsPerSample) {
                    case 8: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize, cDecoder);
                            for (int j = 0; j < width * rowNum; ++j) {
                                for (int k = 0; k < samplesPerPixel; ++k) {
                                    r.setInt(idx, DataConvert.byte2Int((byte)buffer.get()));
                                    ++idx;
                                }
                            }
                        }
                        break;
                    }
                    case 16: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize, cDecoder);
                            for (int j = 0; j < width * rowNum; ++j) {
                                for (int k = 0; k < samplesPerPixel; ++k) {
                                    if (dataType == DataType.FLOAT) {
                                        r.setFloat(idx, (float)buffer.getShort());
                                    } else {
                                        r.setInt(idx, (int)buffer.getShort());
                                    }
                                    ++idx;
                                }
                            }
                        }
                        break;
                    }
                    case 32: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize, cDecoder);
                            for (int j = 0; j < width * rowNum; ++j) {
                                for (int k = 0; k < samplesPerPixel; ++k) {
                                    r.setFloat(idx, buffer.getFloat());
                                    ++idx;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
        r = ArrayMath.flip((Array)r, (int)0);
        return r;
    }

    public Array readArray(Range yRange, Range xRange) throws IOException, InvalidRangeException {
        Array r;
        block72: {
            CompressionDecoder cDecoder;
            DataType dataType;
            int bitsPerSample;
            int samplesPerPixel;
            int height;
            int width;
            block71: {
                IFDEntry tileOffsetTag;
                int compression;
                IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
                IFDEntry heightIFD = this.findTag(Tag.ImageLength);
                width = widthIFD.value[0];
                height = heightIFD.value[0];
                int nx = xRange.length();
                int ny = yRange.length();
                if (width == nx && height == ny) {
                    return this.readArray();
                }
                IFDEntry samplesPerPixelTag = this.findTag(Tag.SamplesPerPixel);
                samplesPerPixel = samplesPerPixelTag.value[0];
                IFDEntry bitsPerSampleTag = this.findTag(Tag.BitsPerSample);
                bitsPerSample = bitsPerSampleTag.value[0];
                int[] shape = samplesPerPixel == 1 ? new int[]{ny, nx} : new int[]{ny, nx, samplesPerPixel};
                dataType = DataType.INT;
                IFDEntry sampleFormatTag = this.findTag(Tag.SampleFormat);
                int sampleFormat = 0;
                if (sampleFormatTag != null) {
                    sampleFormat = sampleFormatTag.value[0];
                }
                switch (bitsPerSample) {
                    case 32: {
                        switch (sampleFormat) {
                            case 3: {
                                dataType = DataType.FLOAT;
                            }
                        }
                    }
                }
                r = Array.factory((DataType)dataType, (int[])shape);
                IFDEntry compressionTag = this.findTag(Tag.Compression);
                cDecoder = null;
                if (compressionTag != null && (compression = compressionTag.value[0]) > 1) {
                    switch (compression) {
                        case 5: {
                            cDecoder = new LZWCompression();
                            break;
                        }
                        case 8: {
                            cDecoder = new DeflateCompression();
                        }
                    }
                }
                if ((tileOffsetTag = this.findTag(Tag.TileOffsets)) == null) break block71;
                Index index = r.getIndex();
                IFDEntry tileSizeTag = this.findTag(Tag.TileByteCounts);
                IFDEntry tileLengthTag = this.findTag(Tag.TileLength);
                IFDEntry tileWidthTag = this.findTag(Tag.TileWidth);
                int tileWidth = tileWidthTag.value[0];
                int tileHeight = tileLengthTag.value[0];
                int hTileNum = (width + tileWidth - 1) / tileWidth;
                int vTileNum = (height + tileHeight - 1) / tileHeight;
                switch (bitsPerSample) {
                    case 8: {
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                long tileOffset = tileOffsetTag.valueL[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize, cDecoder);
                                block22: for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    if (!yRange.contains(vIdx)) {
                                        buffer.position(buffer.position() + tileWidth * samplesPerPixel);
                                        continue;
                                    }
                                    vIdx = yRange.index(vIdx);
                                    index.set0(vIdx);
                                    for (int w = 0; w < tileWidth; ++w) {
                                        int hIdx = j * tileWidth + w;
                                        if (hIdx == width) {
                                            buffer.get(new byte[tileWidth - w]);
                                            continue block22;
                                        }
                                        if (!xRange.contains(hIdx)) {
                                            buffer.position(buffer.position() + samplesPerPixel);
                                            continue;
                                        }
                                        hIdx = xRange.index(hIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            if (sampleFormat == 2) {
                                                r.setInt(index, (int)buffer.get());
                                                continue;
                                            }
                                            r.setInt(index, Byte.toUnsignedInt(buffer.get()));
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            if (sampleFormat == 2) {
                                                r.setInt(index, (int)buffer.get());
                                                continue;
                                            }
                                            r.setInt(index, Byte.toUnsignedInt(buffer.get()));
                                        }
                                    }
                                }
                            }
                        }
                        break block72;
                    }
                    case 16: {
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                long tileOffset = tileOffsetTag.valueL[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize, cDecoder);
                                for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    int hIdx;
                                    if (!yRange.contains(vIdx)) {
                                        buffer.position(buffer.position() + tileWidth * samplesPerPixel * 2);
                                        continue;
                                    }
                                    vIdx = yRange.index(vIdx);
                                    index.set0(vIdx);
                                    for (int w = 0; w < tileWidth && (hIdx = j * tileWidth + w) != width; ++w) {
                                        if (!xRange.contains(hIdx)) {
                                            buffer.position(buffer.position() + samplesPerPixel * 2);
                                            continue;
                                        }
                                        hIdx = xRange.index(hIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            r.setInt(index, (int)buffer.getShort());
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            r.setInt(index, (int)buffer.getShort());
                                        }
                                    }
                                }
                            }
                        }
                        break block72;
                    }
                    case 32: {
                        int size = tileHeight * tileWidth * 4;
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                long tileOffset = tileOffsetTag.valueL[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                if (tileSize == 0) continue;
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize, cDecoder);
                                if (buffer.limit() < size) {
                                    ByteBuffer nbuffer = ByteBuffer.allocate(size);
                                    nbuffer.put(buffer.array());
                                    buffer = nbuffer;
                                    ((Buffer)buffer).position(0);
                                }
                                block32: for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    if (!yRange.contains(vIdx)) {
                                        buffer.position(buffer.position() + tileWidth * samplesPerPixel * 4);
                                        continue;
                                    }
                                    vIdx = yRange.index(vIdx);
                                    index.set0(vIdx);
                                    for (int w = 0; w < tileWidth; ++w) {
                                        int hIdx = j * tileWidth + w;
                                        if (hIdx == width) {
                                            buffer.get(new byte[(tileWidth - w) * 4]);
                                            continue block32;
                                        }
                                        if (!xRange.contains(hIdx)) {
                                            buffer.position(buffer.position() + samplesPerPixel * 40);
                                            continue;
                                        }
                                        hIdx = xRange.index(hIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            if (dataType == DataType.FLOAT) {
                                                r.setFloat(index, buffer.getFloat());
                                                continue;
                                            }
                                            r.setInt(index, buffer.getInt());
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            if (dataType == DataType.FLOAT) {
                                                r.setFloat(index, buffer.getFloat());
                                                continue;
                                            }
                                            r.setInt(index, buffer.getInt());
                                        }
                                    }
                                }
                            }
                        }
                        break block72;
                    }
                }
                break block72;
            }
            IFDEntry stripOffsetTag = this.findTag(Tag.StripOffsets);
            if (stripOffsetTag != null) {
                IndexIterator iter = r.getIndexIterator();
                Index index = Index.factory((int[])new int[]{height, width});
                int stripNum = (int)stripOffsetTag.count;
                IFDEntry stripSizeTag = this.findTag(Tag.StripByteCounts);
                int stripSize = stripSizeTag.value[0];
                IFDEntry rowsPerStripTag = this.findTag(Tag.RowsPerStrip);
                int rowNum = rowsPerStripTag.value[0];
                switch (bitsPerSample) {
                    case 8: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize, cDecoder);
                            for (int j = 0; j < width * rowNum; ++j) {
                                int[] counter = index.getCurrentCounter();
                                if (yRange.contains(counter[0]) && xRange.contains(counter[1])) {
                                    for (int k = 0; k < samplesPerPixel; ++k) {
                                        iter.setIntNext(DataConvert.byte2Int((byte)buffer.get()));
                                    }
                                } else {
                                    buffer.position(buffer.position() + samplesPerPixel);
                                }
                                index.incr();
                            }
                        }
                        break;
                    }
                    case 16: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize, cDecoder);
                            for (int j = 0; j < width * rowNum; ++j) {
                                int[] counter = index.getCurrentCounter();
                                if (yRange.contains(counter[0]) && xRange.contains(counter[1])) {
                                    for (int k = 0; k < samplesPerPixel; ++k) {
                                        if (dataType == DataType.FLOAT) {
                                            iter.setFloatNext((float)buffer.getShort());
                                            continue;
                                        }
                                        iter.setIntNext((int)buffer.getShort());
                                    }
                                } else {
                                    buffer.position(buffer.position() + samplesPerPixel * 2);
                                }
                                index.incr();
                            }
                        }
                        break;
                    }
                    case 32: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize, cDecoder);
                            for (int j = 0; j < width * rowNum; ++j) {
                                int[] counter = index.getCurrentCounter();
                                if (yRange.contains(counter[0]) && xRange.contains(counter[1])) {
                                    for (int k = 0; k < samplesPerPixel; ++k) {
                                        iter.setFloatNext(buffer.getFloat());
                                    }
                                } else {
                                    buffer.position(buffer.position() + samplesPerPixel * 4);
                                }
                                index.incr();
                            }
                        }
                        break;
                    }
                }
            }
        }
        r = ArrayMath.flip((Array)r, (int)0);
        return r;
    }

    private ByteBuffer testReadData(long offset, int size, CompressionDecoder cDecoder) throws IOException {
        this.channel.position(offset);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(this.byteOrder);
        this.channel.read(buffer);
        ((Buffer)buffer).flip();
        if (cDecoder != null) {
            buffer = ByteBuffer.wrap(cDecoder.decode(buffer.array(), this.byteOrder));
            buffer.order(this.byteOrder);
        }
        return buffer;
    }
}

