/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.webmap;

import java.awt.geom.Point2D;
import java.util.Locale;

public class TileFactoryInfo {
    protected int minimumZoomLevel = 0;
    protected int maximumZoomLevel = 18;
    protected int totalMapZoom = 19;
    private int tileSize = 256;
    protected int[] mapWidthInTilesAtZoom;
    protected Point2D[] mapCenterInPixelsAtZoom;
    protected double[] longitudeDegreeWidthInPixels;
    protected double[] longitudeRadianWidthInPixels;
    protected String baseURL;
    private String xparam = "x";
    private String yparam = "y";
    private String zparam = "z";
    private boolean xr2l = true;
    private boolean yt2b = true;
    private int defaultZoomLevel = 1;
    private String name;
    private String language = "en-us";

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int tileSize, String baseURL) {
        this(minimumZoomLevel, maximumZoomLevel, 19, tileSize, true, true, baseURL, "x", "y", "z");
    }

    public TileFactoryInfo(String name, int minimumZoomLevel, int maximumZoomLevel, int tileSize, String baseURL) {
        this(name, minimumZoomLevel, maximumZoomLevel, 19, tileSize, true, true, baseURL, "x", "y", "z");
    }

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL) {
        this(minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, "x", "y", "z");
    }

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this("name not provided", minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, xparam, yparam, zparam);
    }

    public TileFactoryInfo(String name, int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL) {
        this(name, minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, "x", "y", "z");
    }

    public TileFactoryInfo(String name, int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        Locale locale = Locale.getDefault();
        if (locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE)) {
            this.language = "zh-cn";
        }
        this.name = name;
        this.minimumZoomLevel = minimumZoomLevel;
        this.maximumZoomLevel = maximumZoomLevel;
        this.totalMapZoom = totalMapZoom;
        this.baseURL = baseURL;
        this.xparam = xparam;
        this.yparam = yparam;
        this.zparam = zparam;
        this.setXr2l(xr2l);
        this.setYt2b(yt2b);
        this.tileSize = tileSize;
        int tilesize = this.getTileSize(0);
        this.longitudeDegreeWidthInPixels = new double[totalMapZoom + 1];
        this.longitudeRadianWidthInPixels = new double[totalMapZoom + 1];
        this.mapCenterInPixelsAtZoom = new Point2D.Double[totalMapZoom + 1];
        this.mapWidthInTilesAtZoom = new int[totalMapZoom + 1];
        for (int z = totalMapZoom; z >= 0; --z) {
            this.longitudeDegreeWidthInPixels[z] = (double)tilesize / 360.0;
            this.longitudeRadianWidthInPixels[z] = (double)tilesize / (Math.PI * 2);
            int t2 = tilesize / 2;
            this.mapCenterInPixelsAtZoom[z] = new Point2D.Double(t2, t2);
            this.mapWidthInTilesAtZoom[z] = tilesize / this.getTileSize(0);
            tilesize *= 2;
        }
    }

    public int getMinimumZoomLevel() {
        return this.minimumZoomLevel;
    }

    public void setMinimumZoomLevel(int minimumZoomLevel) {
        this.minimumZoomLevel = minimumZoomLevel;
    }

    public int getMaximumZoomLevel() {
        return this.maximumZoomLevel;
    }

    public void setMaximumZoomLevel(int maximumZoomLevel) {
        this.maximumZoomLevel = maximumZoomLevel;
    }

    public int getTotalMapZoom() {
        return this.totalMapZoom;
    }

    public void setTotalMapZoom(int totalMapZoom) {
        this.totalMapZoom = totalMapZoom;
    }

    public int getMapWidthInTilesAtZoom(int zoom) {
        return this.mapWidthInTilesAtZoom[zoom];
    }

    public Point2D getMapCenterInPixelsAtZoom(int zoom) {
        return this.mapCenterInPixelsAtZoom[zoom];
    }

    public String getTileUrl(int x, int y, int zoom) {
        zoom = this.getTotalMapZoom() - zoom;
        String tileUrl = this.baseURL.replace("{x}", String.valueOf(x));
        tileUrl = tileUrl.replace("{y}", String.valueOf(y));
        tileUrl = tileUrl.replace("{z}", String.valueOf(zoom));
        return tileUrl;
    }

    public int getTileSize(int zoom) {
        return this.tileSize;
    }

    protected int getServerNum(int x, int y, int max) {
        return (x + 2 * y) % max;
    }

    public double getLongitudeDegreeWidthInPixels(int zoom) {
        return this.longitudeDegreeWidthInPixels[zoom];
    }

    public double getLongitudeRadianWidthInPixels(int zoom) {
        return this.longitudeRadianWidthInPixels[zoom];
    }

    public boolean isXr2l() {
        return this.xr2l;
    }

    public void setXr2l(boolean xr2l) {
        this.xr2l = xr2l;
    }

    public boolean isYt2b() {
        return this.yt2b;
    }

    public void setYt2b(boolean yt2b) {
        this.yt2b = yt2b;
    }

    public int getDefaultZoomLevel() {
        return this.defaultZoomLevel;
    }

    public void setDefaultZoomLevel(int defaultZoomLevel) {
        this.defaultZoomLevel = defaultZoomLevel;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        this.language = value;
    }
}

