/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.webmap.bmng;

import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;

public class SLMapServerInfo
extends TileFactoryInfo {
    private static final int pyramid_top = 9;
    private static final int midpoint = 5;
    private static final int normal_tile_size = 675;

    public SLMapServerInfo() {
        this("http://maps.joshy.net/tiles/bmng_tiles_3");
    }

    public SLMapServerInfo(String baseURL) {
        super(0, 8, 9, 675, true, false, baseURL, "", "", "");
        this.setDefaultZoomLevel(0);
    }

    public int getMidpoint() {
        return 5;
    }

    @Override
    public int getTileSize(int zoom) {
        int size = super.getTileSize(zoom);
        if (zoom < 5) {
            return size;
        }
        for (int i = 0; i < zoom + 1 - 5; ++i) {
            size /= 2;
        }
        return size;
    }

    @Override
    public int getMapWidthInTilesAtZoom(int zoom) {
        if (zoom < 5) {
            return (int)Math.pow(2.0, 5 - zoom);
        }
        return 1;
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        int ty = y;
        int tx = x;
        int width_in_tiles = this.getMapWidthInTilesAtZoom(zoom);
        if (ty < 0) {
            return null;
        }
        if (zoom < 5 ? ty >= width_in_tiles / 2 : ty != 0) {
            return null;
        }
        String url = this.baseURL + "/" + zoom + "/" + ty + "/" + tx + ".jpg";
        return url;
    }
}

