/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mathparser;

import java.util.Arrays;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.mathparser.ExpressionBase;
import org.meteoinfo.data.mathparser.MathOperators;

public class OperatorExpression
extends ExpressionBase {
    private static final String[] _operatorSymbols = new String[]{"+", "-", "*", "/", "^"};
    private MathOperators _mathOperator;

    public OperatorExpression(String operator) {
        if (operator == null || operator.isEmpty()) {
            throw new IllegalArgumentException("operator");
        }
        if (operator.equals("+")) {
            this._mathOperator = MathOperators.Add;
        } else if (operator.equals("-")) {
            this._mathOperator = MathOperators.Subtract;
        } else if (operator.equals("*")) {
            this._mathOperator = MathOperators.Multiple;
        } else if (operator.equals("/")) {
            this._mathOperator = MathOperators.Divide;
        } else if (operator.equals("^")) {
            this._mathOperator = MathOperators.Power;
        } else {
            throw new IllegalArgumentException("Invalid operator" + operator);
        }
    }

    @Override
    public int getArgumentCount() {
        return 2;
    }

    @Override
    public Object evaluate(Object[] numbers) {
        switch (this._mathOperator) {
            case Add: {
                return this.add(numbers);
            }
            case Subtract: {
                return this.subtract(numbers);
            }
            case Multiple: {
                return this.multiple(numbers);
            }
            case Divide: {
                return this.divide(numbers);
            }
            case Power: {
                return this.power(numbers);
            }
        }
        return null;
    }

    public Object add(Object[] numbers) {
        Object result = DataMath.add(numbers[0], numbers[1]);
        return result;
    }

    public Object subtract(Object[] numbers) {
        Object result = DataMath.sub(numbers[0], numbers[1]);
        return result;
    }

    public Object multiple(Object[] numbers) {
        Object result = DataMath.mul(numbers[0], numbers[1]);
        return result;
    }

    public Object divide(Object[] numbers) {
        Object result = DataMath.div(numbers[0], numbers[1]);
        return result;
    }

    public Object power(Object[] numbers) {
        Object result = DataMath.pow(numbers[0], (Double)numbers[1]);
        return result;
    }

    public static boolean isSymbol(String s) {
        if (s == null || s.length() != 1) {
            return false;
        }
        return Arrays.asList(_operatorSymbols).contains(s);
    }

    public static boolean isSymbol(char c) {
        return OperatorExpression.isSymbol(String.valueOf(c));
    }

    public String toString() {
        return this._mathOperator.toString();
    }
}

