/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.io.RandomAccessFile;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.dimarray.DimArray;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;

public abstract class DataInfo {
    protected String fileName;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Variable> coordinates = new ArrayList<Variable>();
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected Dimension tDim = null;
    protected Dimension xDim = null;
    protected Dimension yDim = null;
    protected Dimension zDim = null;
    protected boolean xReverse = false;
    protected boolean yReverse = false;
    protected boolean isGlobal = false;
    protected double missingValue = -9999.0;
    protected ProjectionInfo projInfo;
    protected MeteoDataType meteoDataType;

    public DataInfo() {
        this.projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> value) {
        this.variables = value;
    }

    public List<Variable> getPlottableVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Variable var : this.variables) {
            if (!var.isPlottable()) continue;
            vars.add(var);
        }
        return vars;
    }

    public List<Variable> getDataVariables() {
        ArrayList<Variable> dataVariables = new ArrayList<Variable>();
        for (Variable variable : this.variables) {
            if (variable.isDimVar()) continue;
            dataVariables.add(variable);
        }
        return dataVariables;
    }

    public List<Variable> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Variable> value) {
        this.coordinates = value;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> dims) {
        this.dimensions = dims;
    }

    public int getVariableNum() {
        return this.variables.size();
    }

    public int getDataVariableNum() {
        int i = 0;
        for (Variable var : this.variables) {
            if (var.isDimVar()) continue;
            ++i;
        }
        return i;
    }

    public int getCoordinateNum() {
        return this.coordinates.size();
    }

    public List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Variable var : this.variables) {
            names.add(var.getName());
        }
        return names;
    }

    public List<String> getCoordinateNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Variable var : this.coordinates) {
            names.add(var.getName());
        }
        return names;
    }

    public Array getTimes() {
        if (this.tDim == null) {
            return null;
        }
        return this.tDim.getDimValue();
    }

    public List<LocalDateTime> getTimeList() {
        if (this.tDim == null) {
            return null;
        }
        ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
        IndexIterator iter = this.tDim.getDimValue().getIndexIterator();
        while (iter.hasNext()) {
            times.add(iter.getDateNext());
        }
        return times;
    }

    public LocalDateTime getTime(int timeIdx) {
        if (this.tDim == null) {
            return null;
        }
        return this.tDim.getDimValue().getDate(timeIdx);
    }

    public double getTimeValue(int timeIdx) {
        if (this.tDim == null) {
            return Double.NaN;
        }
        return JDateUtil.toOADate((LocalDateTime)this.tDim.getDimValue().getDate(timeIdx));
    }

    public static int getTimeValue(LocalDateTime time, LocalDateTime baseDate, String tDelta) {
        int value = 0;
        switch (tDelta.toLowerCase()) {
            case "seconds": {
                value = (int)Duration.between(baseDate, time).getSeconds();
                break;
            }
            case "minutes": {
                value = (int)Duration.between(baseDate, time).toMinutes();
                break;
            }
            case "hours": {
                value = (int)Duration.between(baseDate, time).toHours();
                break;
            }
            case "days": {
                value = Period.between(baseDate.toLocalDate(), time.toLocalDate()).getDays();
            }
        }
        return value;
    }

    public List<Integer> getTimeValues(LocalDateTime baseDate, String tDelta) {
        Array times = this.getTimes();
        ArrayList<Integer> values = new ArrayList<Integer>();
        IndexIterator iter = times.getIndexIterator();
        while (iter.hasNext()) {
            LocalDateTime time = iter.getDateNext();
            if (tDelta.equalsIgnoreCase("hours")) {
                values.add((int)Duration.between(baseDate, time).toHours());
                continue;
            }
            if (!tDelta.equalsIgnoreCase("days")) continue;
            values.add(Period.between(baseDate.toLocalDate(), time.toLocalDate()).getDays());
        }
        return values;
    }

    public void setTimes(List<LocalDateTime> value) {
        Array times = Array.factory((DataType)DataType.DATE, (int[])new int[]{value.size()});
        IndexIterator iter = times.getIndexIterator();
        for (LocalDateTime t : value) {
            iter.setDateNext(t);
        }
        if (this.tDim == null) {
            this.tDim = new Dimension(DimensionType.T);
        }
        this.tDim.setDimValue(times);
    }

    public void setTimes(Array value) {
        this.tDim.setDimValue(value);
    }

    public int getTimeNum() {
        if (this.tDim == null) {
            return 0;
        }
        return this.tDim.getLength();
    }

    public Dimension getTimeDimension() {
        return this.tDim;
    }

    public void setTimeDimension(Dimension tDim) {
        this.tDim = tDim;
    }

    public Dimension getXDimension() {
        return this.xDim;
    }

    public void setXDimension(Dimension xDim) {
        this.xDim = xDim;
    }

    public Dimension getYDimension() {
        return this.yDim;
    }

    public void setYDimension(Dimension yDim) {
        this.yDim = yDim;
    }

    public Dimension getZDimension() {
        return this.zDim;
    }

    public void setZDimension(Dimension zDim) {
        this.zDim = zDim;
    }

    public boolean isXReverse() {
        return this.xReverse;
    }

    public void setXReverse(boolean value) {
        this.xReverse = value;
    }

    public boolean isYReverse() {
        return this.yReverse;
    }

    public void setYReverse(boolean value) {
        this.yReverse = value;
    }

    public String getXCoordVariableName() {
        if (this.projInfo.isLonLat()) {
            return "lon";
        }
        return "x";
    }

    public String getYCoordVariableName() {
        if (this.projInfo.isLonLat()) {
            return "lat";
        }
        return "y";
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean value) {
        this.isGlobal = value;
    }

    public double getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(double value) {
        this.missingValue = value;
    }

    public ProjectionInfo getProjectionInfo() {
        return this.projInfo;
    }

    public void setProjectionInfo(ProjectionInfo value) {
        this.projInfo = value;
    }

    public MeteoDataType getDataType() {
        return this.meteoDataType;
    }

    public void setDataType(MeteoDataType value) {
        this.meteoDataType = value;
    }

    public abstract boolean isValidFile(RandomAccessFile var1);

    public abstract void readDataInfo(String var1);

    public void readDataInfo(String fileName, boolean keepOpen) {
    }

    public String generateInfoText() {
        String dataInfo;
        block10: {
            Dimension dim;
            Dimension ydim;
            dataInfo = "File Name: " + this.getFileName();
            dataInfo = dataInfo + System.getProperty("line.separator") + "Dimensions: " + this.dimensions.size();
            for (Dimension dimension : this.dimensions) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + dimension.getShortName() + " = " + String.valueOf(dimension.getLength()) + ";";
            }
            Dimension xdim = this.getXDimension();
            if (xdim != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "X Dimension: Xmin = " + String.valueOf(xdim.getMinValue()) + "; Xmax = " + String.valueOf(xdim.getMaxValue()) + "; Xsize = " + String.valueOf(xdim.getLength()) + "; Xdelta = " + String.valueOf(xdim.getDeltaValue());
            }
            if ((ydim = this.getYDimension()) != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "Y Dimension: Ymin = " + String.valueOf(ydim.getMinValue()) + "; Ymax = " + String.valueOf(ydim.getMaxValue()) + "; Ysize = " + String.valueOf(ydim.getLength()) + "; Ydelta = " + String.valueOf(ydim.getDeltaValue());
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Global Attributes: ";
            for (Attribute attribute : this.attributes) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t: " + attribute.toString();
            }
            List<Variable> dataVariables = this.getDataVariables();
            dataInfo = dataInfo + System.getProperty("line.separator") + "Data Variables: " + dataVariables.size();
            for (Variable variable : dataVariables) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + variable.getDataType().toString() + " " + variable.getShortName() + "(";
                for (Dimension dim2 : variable.getDimensions()) {
                    dataInfo = dataInfo + dim2.getShortName() + ",";
                }
                dataInfo = dataInfo.substring(0, dataInfo.length() - 1);
                dataInfo = dataInfo + ");";
                List<Attribute> atts = variable.getAttributes();
                for (int j = 0; j < atts.size(); ++j) {
                    Attribute aAttS = atts.get(j);
                    dataInfo = dataInfo + System.getProperty("line.separator") + "\t\t" + variable.getShortName() + ": " + aAttS.toString();
                }
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Coordinates: " + this.coordinates.size();
            for (Variable coord : this.coordinates) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + coord.getDataType().toString() + " " + coord.getShortName() + "(";
                for (Dimension dim3 : coord.getDimensions()) {
                    dataInfo = dataInfo + dim3.getShortName() + ",";
                }
                dataInfo = dataInfo.substring(0, dataInfo.length() - 1);
                dataInfo = dataInfo + ");";
                for (Attribute attr : coord.getAttributes()) {
                    dataInfo = dataInfo + System.getProperty("line.separator") + "\t\t" + coord.getShortName() + ": " + attr.toString();
                }
            }
            Iterator<Object> iterator = this.dimensions.iterator();
            if (!iterator.hasNext() || !(dim = (Dimension)iterator.next()).isUnlimited()) break block10;
            dataInfo = dataInfo + System.getProperty("line.separator") + "Unlimited dimension: " + dim.getShortName();
        }
        return dataInfo;
    }

    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        if (var != null && var.hasCachedData()) {
            return var.cachedData.copy();
        }
        return this.realRead(varName);
    }

    public abstract Array realRead(String var1);

    public DimArray readDimArray(String varName) {
        Variable variable = this.getVariable(varName);
        if (variable == null) {
            System.out.println("The variable is not exist: " + varName);
            return null;
        }
        Array array = this.read(varName);
        return new DimArray(array, variable.getDimensions());
    }

    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        Variable var = this.getVariable(varName);
        if (var == null) {
            System.out.println("The variable is not exist: " + varName);
            return null;
        }
        if (var.hasCachedData()) {
            boolean negStride = false;
            for (int s : stride) {
                if (s >= 0) continue;
                negStride = true;
                break;
            }
            ArrayList<Integer> flips = new ArrayList<Integer>();
            if (negStride) {
                int[] pStride = new int[stride.length];
                for (int i = 0; i < stride.length; ++i) {
                    pStride[i] = Math.abs(stride[i]);
                    if (stride[i] >= 0) continue;
                    flips.add(i);
                }
                stride = pStride;
            }
            Section section = null;
            try {
                section = new Section(origin, size, stride);
                Array r = var.getCachedData().section(section.getRanges()).copy();
                if (negStride) {
                    Iterator s = flips.iterator();
                    while (s.hasNext()) {
                        int i = (Integer)s.next();
                        r = r.flip(i);
                    }
                    Array data = Array.factory((DataType)r.getDataType(), (int[])r.getShape());
                    MAMath.copy((Array)data, (Array)r);
                    return data;
                }
                return r;
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }
        return this.realRead(varName, origin, size, stride);
    }

    public abstract Array realRead(String var1, int[] var2, int[] var3, int[] var4);

    public DimArray readDimArray(String varName, int[] origin, int[] size, int[] stride) {
        Variable variable = this.getVariable(varName);
        if (variable == null) {
            System.out.println("The variable is not exist: " + varName);
            return null;
        }
        Array array = this.read(varName, origin, size, stride).reduce();
        ArrayMath.missingToNaN((Array)array, (Number)this.missingValue);
        try {
            List<Dimension> dimensions = variable.sectionDimensions(origin, size, stride);
            return new DimArray(array, dimensions);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return new DimArray(array);
        }
    }

    public DimArray readDimArray(String varName, List<Range> ranges) {
        int n = ranges.size();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        ArrayMath.rangesToSection(ranges, (int[])origin, (int[])size, (int[])stride);
        return this.readDimArray(varName, origin, size, stride);
    }

    public List<Attribute> getGlobalAttributes() {
        return this.attributes;
    }

    public Variable getVariable(String varName) {
        for (Variable var : this.variables) {
            if (!var.getName().equalsIgnoreCase(varName)) continue;
            return var;
        }
        for (Variable var : this.variables) {
            if (!var.getShortName().equalsIgnoreCase(varName)) continue;
            return var;
        }
        return null;
    }

    public int getVariableIndex(String varName) {
        int varIdx = -1;
        int i = 0;
        for (Variable var : this.variables) {
            if (var.getName().equalsIgnoreCase(varName)) {
                varIdx = i;
                break;
            }
            ++i;
        }
        if (varIdx < 0) {
            i = 0;
            for (Variable var : this.variables) {
                if (var.getShortName().equalsIgnoreCase(varName)) {
                    varIdx = i;
                    break;
                }
                ++i;
            }
        }
        return varIdx;
    }

    public void addVariable(Variable var) {
        this.variables.add(var);
    }

    public void addCoordinate(Variable var) {
        this.coordinates.add(var);
        this.variables.add(var);
    }

    public void addDimension(Dimension dim) {
        this.dimensions.add(dim);
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }

    public Attribute findGlobalAttribute(String attName) {
        for (Attribute att : this.attributes) {
            if (!att.getShortName().equalsIgnoreCase(attName)) continue;
            return att;
        }
        return null;
    }

    public boolean isRadial() {
        String va;
        Attribute ra = this.findGlobalAttribute("featureType");
        return ra != null && (va = ra.getStringValue()).equalsIgnoreCase("RADIAL");
    }
}

