/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.mm5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.mm5.BigHeader;
import org.meteoinfo.data.meteodata.mm5.MM5IMDataInfo;
import org.meteoinfo.data.meteodata.mm5.SubHeader;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.Reproject;

public class MM5DataInfo
extends DataInfo
implements IGridDataInfo {
    private ByteOrder _byteOrder = ByteOrder.BIG_ENDIAN;
    private BigHeader _bigHeader = new BigHeader();
    List<SubHeader> _subHeaders = new ArrayList<SubHeader>();

    public MM5DataInfo() {
        this.setDataType(MeteoDataType.MM5);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    @Override
    public void readDataInfo(String fileName) {
        BigHeader bh = null;
        this.readDataInfo(fileName, bh);
    }

    public void readDataInfo(String fileName, String bigHeaderFile) {
        this.setFileName(fileName);
        try {
            RandomAccessFile br = new RandomAccessFile(bigHeaderFile, "r");
            br.skipBytes(4);
            int flag = br.readInt();
            br.skipBytes(4);
            BigHeader bh = null;
            if (flag == 0) {
                bh = this.readBigHeader(br);
            }
            br.close();
            this.readDataInfo(fileName, bh);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void readDataInfo(String fileName, BigHeader ebh) {
        this.setFileName(fileName);
        try {
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            int xn = 0;
            int yn = 0;
            int zn = 0;
            ArrayList<Variable> variables = new ArrayList<Variable>();
            int tn = 0;
            Dimension xdim = new Dimension(DimensionType.X);
            xdim.setShortName("x");
            Dimension ydim = new Dimension(DimensionType.Y);
            ydim.setShortName("y");
            Dimension zdim = new Dimension(DimensionType.Z);
            zdim.setShortName("level");
            if (ebh != null) {
                this._bigHeader = ebh;
                xn = ebh.getXNum();
                yn = ebh.getYNum();
                zn = ebh.getZNum();
                float[] values = new float[zn];
                for (int i = 0; i < zn; ++i) {
                    values[i] = i + 1;
                }
                zdim.setValues(values);
                String projStr = this.getProjectionInfo().toProj4String();
                int mapProj = ebh.getMapProj();
                switch (mapProj) {
                    case 1: {
                        projStr = "+proj=lcc +lat_1=" + String.valueOf(ebh.getTrueLatSouth()) + " +lat_2=" + String.valueOf(ebh.getTrueLatNorth()) + " +lat_0=" + String.valueOf(ebh.getXLATC()) + " +lon_0=" + String.valueOf(ebh.getXLONC());
                        break;
                    }
                    case 2: {
                        projStr = "+proj=stere+lat_0=" + String.valueOf(ebh.getXLATC()) + "+lon_0=" + String.valueOf(ebh.getXLONC());
                        break;
                    }
                    case 3: {
                        projStr = "+proj=tmerc+lat_0=" + String.valueOf(ebh.getXLATC()) + "+lon_0=" + String.valueOf(ebh.getXLONC());
                    }
                }
                this.setProjectionInfo(ProjectionInfo.factory((String)projStr));
                double[] X = new double[xn];
                double[] Y = new double[yn];
                float centeri = (float)xn / 2.0f;
                float centerj = (float)yn / 2.0f;
                this.getProjectedXY(this.getProjectionInfo(), ebh.getDeltaX(), centeri, centerj, ebh.getXLONC(), ebh.getXLATC(), X, Y);
                xdim.setValues(X);
                ydim.setValues(Y);
                this.setXDimension(xdim);
                this.setYDimension(ydim);
                this.setZDimension(zdim);
                this.addDimension(xdim);
                this.addDimension(ydim);
                this.addDimension(zdim);
            }
            ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
            while (br.getFilePointer() < br.length() - 100L) {
                br.skipBytes(4);
                int flag = br.readInt();
                br.skipBytes(4);
                if (flag == 0) {
                    BigHeader bh = this.readBigHeader(br);
                    if (ebh != null) continue;
                    this._bigHeader = bh;
                    xn = bh.getXNum();
                    yn = bh.getYNum();
                    zn = bh.getZNum();
                    float[] values = new float[zn];
                    for (int i = 0; i < zn; ++i) {
                        values[i] = i + 1;
                    }
                    zdim.setValues(values);
                    this.setZDimension(zdim);
                    String projStr = this.getProjectionInfo().toProj4String();
                    int mapProj = bh.getMapProj();
                    switch (mapProj) {
                        case 1: {
                            projStr = "+proj=lcc +lat_1=" + String.valueOf(bh.getTrueLatSouth()) + " +lat_2=" + String.valueOf(bh.getTrueLatNorth()) + " +lat_0=" + String.valueOf(bh.getXLATC()) + " +lon_0=" + String.valueOf(bh.getXLONC());
                            break;
                        }
                        case 2: {
                            projStr = "+proj=stere+lat_0=" + String.valueOf(bh.getXLATC()) + "+lon_0=" + String.valueOf(bh.getXLONC());
                            break;
                        }
                        case 3: {
                            projStr = "+proj=tmerc+lat_0=" + String.valueOf(bh.getXLATC()) + "+lon_0=" + String.valueOf(bh.getXLONC());
                        }
                    }
                    this.setProjectionInfo(ProjectionInfo.factory((String)projStr));
                    double[] X = new double[xn];
                    double[] Y = new double[yn];
                    float centeri = (float)xn / 2.0f;
                    float centerj = (float)yn / 2.0f;
                    this.getProjectedXY(this.getProjectionInfo(), bh.getDeltaX(), centeri, centerj, bh.getXLONC(), bh.getXLATC(), X, Y);
                    xdim.setValues(X);
                    ydim.setValues(Y);
                    this.setXDimension(xdim);
                    this.setYDimension(ydim);
                    this.addDimension(xdim);
                    this.addDimension(ydim);
                    this.addDimension(zdim);
                    continue;
                }
                if (flag == 1) {
                    long pos = br.getFilePointer();
                    SubHeader sh = this.readSubHeader(br);
                    sh.timeIndex = tn;
                    sh.position = pos;
                    sh.length = (int)(br.getFilePointer() - pos);
                    this._subHeaders.add(sh);
                    if (sh.ordering.equals("YXS") || sh.ordering.equals("YXP")) {
                        br.skipBytes(xn * yn * zn * 4 + 8);
                    } else if (sh.ordering.equals("YXW")) {
                        br.skipBytes(xn * yn * (zn + 1) * 4 + 8);
                    } else if (sh.ordering.equals("YX")) {
                        br.skipBytes(xn * yn * 4 + 8);
                    } else if (sh.ordering.equals("CA")) {
                        br.skipBytes(sh.end_index[0] * sh.end_index[1] * 4 + 8);
                    } else if (sh.ordering.equals("XSB")) {
                        br.skipBytes(yn * zn * 5 * 4 + 8);
                    } else if (sh.ordering.equals("YSB")) {
                        br.skipBytes(xn * zn * 5 * 4 + 8);
                    } else if (sh.ordering.equals("XWB")) {
                        br.skipBytes(yn * (zn + 1) * 5 * 4 + 8);
                    } else if (sh.ordering.equals("YWB")) {
                        br.skipBytes(xn * (zn + 1) * 5 * 4 + 8);
                    } else if (sh.ordering.equals("S")) {
                        br.skipBytes(zn * 4 + 8);
                    } else if (sh.ordering.equals("P")) {
                        br.skipBytes(zn * 4 + 8);
                    }
                    LocalDateTime ct = sh.current_date.length() == 24 ? LocalDateTime.parse(sh.current_date.substring(0, 19), format) : LocalDateTime.parse(sh.current_date, format);
                    if (times.contains(ct)) {
                        sh.timeIndex = times.indexOf(ct);
                        continue;
                    }
                    times.add(ct);
                    sh.timeIndex = times.size() - 1;
                    continue;
                }
                if (flag != 2) continue;
                ++tn;
            }
            Array tArray = Array.factory((DataType)DataType.DATE, (int[])new int[]{times.size()});
            IndexIterator iter = tArray.getIndexIterator();
            for (LocalDateTime t : times) {
                iter.setDateNext(t);
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setShortName("time");
            tDim.setDimValue(tArray);
            this.setTimeDimension(tDim);
            this.addDimension(tDim);
            ArrayList<SubHeader> shs = new ArrayList<SubHeader>();
            ArrayList<String> varNames = new ArrayList<String>();
            boolean nameDup = false;
            for (SubHeader sh : this._subHeaders) {
                if (sh.timeIndex != 0) continue;
                if (varNames.contains(sh.name)) {
                    sh.name = sh.name + String.valueOf(varNames.size());
                    nameDup = true;
                }
                varNames.add(sh.name);
                shs.add(sh);
            }
            if (nameDup) {
                for (int i = 1; i < times.size(); ++i) {
                    varNames = new ArrayList();
                    for (SubHeader sh : this._subHeaders) {
                        if (sh.timeIndex != i) continue;
                        if (varNames.contains(sh.name)) {
                            sh.name = sh.name + String.valueOf(varNames.size());
                            nameDup = true;
                        }
                        varNames.add(sh.name);
                    }
                }
            }
            for (SubHeader sh : shs) {
                Variable var = new Variable();
                var.setName(sh.name);
                var.setDataType(DataType.FLOAT);
                var.setUnits(sh.unit);
                var.setDescription(sh.description);
                if (sh.ordering.equals("YXS") || sh.ordering.equals("YXP") || sh.ordering.equals("YXW") || sh.ordering.equals("YX")) {
                    var.addDimension(xdim);
                    var.addDimension(0, ydim);
                }
                if (sh.ordering.equals("YXS") || sh.ordering.equals("YXP") || sh.ordering.equals("YXW") || sh.ordering.equals("S") || sh.ordering.equals("P")) {
                    var.addDimension(0, zdim);
                }
                variables.add(var);
            }
            for (Variable var : variables) {
                var.addDimension(0, tDim);
            }
            this.setVariables(variables);
            for (Dimension dim : this.dimensions) {
                switch (dim.getDimType()) {
                    case X: 
                    case Y: 
                    case Z: 
                    case T: {
                        Variable variable = new Variable(dim.getName());
                        variable.setDimVar(true);
                        variable.setCachedData(dim.getDimValue());
                        variable.addDimension(dim);
                        this.addCoordinate(variable);
                    }
                }
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public BigHeader readBigHeader(RandomAccessFile br) throws IOException {
        return this.readBigHeader(br, true);
    }

    public BigHeader readBigHeader(RandomAccessFile br, boolean isSequential) throws IOException {
        int j;
        int i;
        BigHeader bh = new BigHeader();
        if (isSequential) {
            br.skipBytes(4);
        }
        byte[] bytes = new byte[80];
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 50; ++j) {
                bh.bhi[j][i] = br.readInt();
            }
        }
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 20; ++j) {
                bh.bhr[j][i] = br.readFloat();
            }
        }
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 50; ++j) {
                br.read(bytes);
                bh.bhic[j][i] = new String(bytes).trim();
            }
        }
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 20; ++j) {
                br.read(bytes);
                bh.bhrc[j][i] = new String(bytes).trim();
            }
        }
        if (isSequential) {
            br.skipBytes(4);
        }
        return bh;
    }

    public SubHeader readSubHeader(RandomAccessFile br) throws IOException {
        return this.readSubHeader(br, true);
    }

    public SubHeader readSubHeader(RandomAccessFile br, boolean isSequential) throws IOException {
        int i;
        SubHeader sh = new SubHeader();
        byte[] bytes = new byte[4];
        if (isSequential) {
            br.skipBytes(4);
        }
        sh.ndim = br.readInt();
        for (i = 0; i < 4; ++i) {
            sh.start_index[i] = br.readInt();
        }
        for (i = 0; i < 4; ++i) {
            sh.end_index[i] = br.readInt();
        }
        sh.xtime = br.readFloat();
        br.read(bytes);
        sh.staggering = new String(bytes).trim();
        br.read(bytes);
        sh.ordering = new String(bytes).trim();
        bytes = new byte[24];
        br.read(bytes);
        sh.current_date = new String(bytes).trim();
        bytes = new byte[9];
        br.read(bytes);
        sh.name = new String(bytes).trim();
        bytes = new byte[25];
        br.read(bytes);
        sh.unit = new String(bytes).trim();
        bytes = new byte[46];
        br.read(bytes);
        sh.description = new String(bytes).trim();
        if (isSequential) {
            br.skipBytes(4);
        }
        return sh;
    }

    private void getProjectedXY(ProjectionInfo projInfo, float size, float sync_XP, float sync_YP, float sync_Lon, float sync_Lat, double[] X, double[] Y) {
        int i;
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[][]{{sync_Lon, sync_Lat}};
        Reproject.reprojectPoints((double[][])points, (ProjectionInfo)fromProj, (ProjectionInfo)projInfo, (int)0, (int)1);
        double sync_X = points[0][0];
        double sync_Y = points[0][1];
        int i_XP = (int)sync_XP;
        double i_X = sync_XP == (float)i_XP ? sync_X : sync_X - (double)((sync_XP - (float)i_XP) * size);
        int i_YP = (int)sync_YP;
        double i_Y = sync_YP == (float)i_YP ? sync_Y : sync_Y - (double)((sync_YP - (float)i_YP) * size);
        int nx = X.length;
        int ny = Y.length;
        double xlb = i_X - (double)((float)(i_XP - 1) * size);
        double ylb = i_Y - (double)((float)(i_YP - 1) * size);
        for (i = 0; i < nx; ++i) {
            X[i] = xlb + (double)((float)i * size);
        }
        for (i = 0; i < ny; ++i) {
            Y[i] = ylb + (double)((float)i * size);
        }
    }

    private SubHeader findSubHeader(String varName, int tIdx) {
        for (SubHeader sh : this._subHeaders) {
            if (sh.timeIndex != tIdx || !sh.name.equals(varName)) continue;
            return sh;
        }
        return this._subHeaders.get(0);
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    public String generateInfoText_bak() {
        int j;
        int i;
        String dataInfo = "File Name: " + this.getFileName();
        for (i = 0; i < 50; ++i) {
            for (j = 0; j < 20; ++j) {
                dataInfo = dataInfo + System.getProperty("line.separator") + String.format("[%d][%d]", i + 1, j + 1) + " " + this._bigHeader.bhic[i][j] + ": " + String.valueOf(this._bigHeader.bhi[i][j]);
            }
        }
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 20; ++j) {
                dataInfo = dataInfo + System.getProperty("line.separator") + String.format("[%d][%d]", i + 1, j + 1) + " " + this._bigHeader.bhrc[i][j] + ": " + String.valueOf(this._bigHeader.bhr[i][j]);
            }
        }
        return dataInfo;
    }

    @Override
    public Array realRead(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.realRead(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            int rangeIdx = 0;
            Range timeRange = var.getTDimension() != null ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range levRange = var.getLevelNum() > 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range yRange = var.getYDimension() != null ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range xRange = var.getXDimension() != null ? section.getRange(rangeIdx) : new Range(0, 0);
            IndexIterator ii = dataArray.getIndexIterator();
            for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    this.readXY(varName, timeIdx, levelIdx, yRange, xRange, ii);
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(String varName, int timeIdx, int levelIdx, Range yRange, Range xRange, IndexIterator ii) {
        try {
            int varIdx = this.getVariableNames().indexOf(varName);
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            Variable var = this.getVariables().get(varIdx);
            Dimension xdim = var.getXDimension();
            Dimension ydim = var.getYDimension();
            int xn = xdim != null ? xdim.getLength() : 1;
            int yn = ydim != null ? ydim.getLength() : 1;
            SubHeader sh = this.findSubHeader(var.getName(), timeIdx);
            br.seek(sh.position + (long)sh.length);
            int n = xn * yn;
            br.skipBytes(4);
            br.skipBytes(n * 4 * levelIdx);
            byte[] dataBytes = new byte[n * 4];
            br.read(dataBytes);
            br.close();
            float[] data = new float[n];
            int start = 0;
            byte[] bytes = new byte[4];
            for (int i = 0; i < xn; ++i) {
                for (int j = 0; j < yn; ++j) {
                    System.arraycopy(dataBytes, start, bytes, 0, 4);
                    data[j * xn + i] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
                    start += 4;
                }
            }
            br.close();
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xn + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        try {
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            Variable var = this.getVariable(varName);
            Dimension xdim = var.getXDimension();
            Dimension ydim = var.getYDimension();
            int xn = xdim.getLength();
            int yn = ydim.getLength();
            SubHeader sh = this.findSubHeader(var.getName(), timeIdx);
            br.seek(sh.position + (long)sh.length);
            int n = xn * yn;
            br.skipBytes(4);
            br.skipBytes(n * 4 * levelIdx);
            byte[] dataBytes = new byte[n * 4];
            br.read(dataBytes);
            br.close();
            double[][] theData = new double[yn][xn];
            int start = 0;
            byte[] bytes = new byte[4];
            for (int i = 0; i < xn; ++i) {
                for (int j = 0; j < yn; ++j) {
                    System.arraycopy(dataBytes, start, bytes, 0, 4);
                    theData[j][i] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
                    start += 4;
                }
            }
            return new GridData(theData, xdim.getValues(), ydim.getValues(), this.missingValue);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(MM5IMDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public GridData getGridData(RandomAccessFile raf, Dimension xdim, Dimension ydim) throws IOException {
        int xn = xdim.getLength();
        int yn = ydim.getLength();
        int n = xn * yn;
        byte[] dataBytes = new byte[n * 4];
        raf.read(dataBytes);
        double[][] theData = new double[yn][xn];
        int start = 0;
        byte[] bytes = new byte[4];
        for (int i = 0; i < xn; ++i) {
            for (int j = 0; j < yn; ++j) {
                System.arraycopy(dataBytes, start, bytes, 0, 4);
                theData[j][i] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
                start += 4;
            }
        }
        return new GridData(theData, xdim.getValues(), ydim.getValues(), this.missingValue);
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        try {
            Variable var = this.getVariable(varName);
            Dimension xdim = var.getXDimension();
            Dimension ydim = var.getYDimension();
            int xNum = xdim.getLength();
            int yNum = ydim.getLength();
            int tNum = this.getTimeNum();
            double[][] theData = new double[tNum][yNum];
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            for (int t = 0; t < tNum; ++t) {
                SubHeader sh = this.findSubHeader(var.getName(), t);
                br.seek(sh.position + (long)sh.length);
                int n = xNum * yNum;
                br.skipBytes(4);
                br.skipBytes(n * 4 * levelIdx);
                byte[] dataBytes = new byte[n * 4];
                br.read(dataBytes);
                int start = lonIdx * yNum * 4;
                byte[] bytes = new byte[4];
                for (int j = 0; j < yNum; ++j) {
                    System.arraycopy(dataBytes, start, bytes, 0, 4);
                    theData[t][j] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
                    start += 4;
                }
            }
            br.close();
            double[] yArray = new double[tNum];
            for (int i = 0; i < tNum; ++i) {
                yArray[i] = JDateUtil.toOADate((LocalDateTime)this.getTimes().getDate(i));
            }
            return new GridData(theData, ydim.getValues(), yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        try {
            int i;
            Variable var = this.getVariable(varName);
            Dimension xdim = var.getXDimension();
            Dimension ydim = var.getYDimension();
            int xNum = xdim.getLength();
            int yNum = ydim.getLength();
            int tNum = this.getTimeNum();
            double[][] theData = new double[tNum][xNum];
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            for (int t = 0; t < tNum; ++t) {
                SubHeader sh = this.findSubHeader(var.getName(), t);
                br.seek(sh.position + (long)sh.length);
                int n = xNum * yNum;
                br.skipBytes(4);
                br.skipBytes(n * 4 * levelIdx);
                byte[] dataBytes = new byte[n * 4];
                br.read(dataBytes);
                int start = 0;
                byte[] bytes = new byte[4];
                for (i = 0; i < xNum; ++i) {
                    for (int j = 0; j < yNum; ++j) {
                        if (j == latIdx) {
                            System.arraycopy(dataBytes, start, bytes, 0, 4);
                            theData[t][i] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)this._byteOrder);
                        }
                        start += 4;
                    }
                }
            }
            br.close();
            double[] yArray = new double[tNum];
            for (i = 0; i < tNum; ++i) {
                yArray[i] = JDateUtil.toOADate((LocalDateTime)this.getTimes().getDate(i));
            }
            return new GridData(theData, xdim.getValues(), yArray, this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(MM5DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void addBigHeader(String fileName, String newFileName, String refFileName) throws FileNotFoundException, IOException {
        int numBytes;
        DataInputStream dis = new DataInputStream(new FileInputStream(fileName));
        DataInputStream rdis = new DataInputStream(new FileInputStream(refFileName));
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(newFileName));
        dos.writeInt(4);
        dos.writeInt(0);
        dos.writeInt(4);
        int n = 117600;
        byte[] bytes = new byte[n];
        dos.writeInt(n);
        rdis.read(new byte[12]);
        rdis.readInt();
        rdis.read(bytes);
        dos.write(bytes);
        dos.writeInt(n);
        bytes = new byte[32768];
        while ((numBytes = dis.read(bytes)) != -1) {
            dos.write(bytes, 0, numBytes);
        }
        dis.close();
        rdis.close();
        dos.close();
    }
}

