/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.radar.BaseRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.GenericHeader;
import org.meteoinfo.data.meteodata.radar.IRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.MomentHeader;
import org.meteoinfo.data.meteodata.radar.RadarDataType;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class PARadarDataInfo
extends BaseRadarDataInfo
implements IRadarDataInfo {
    private GenericHeader genericHeader;
    private SiteConfig siteConfig;
    private TaskConfig taskConfig;
    private List<BeamConfig> beamConfigs;
    private List<CutConfig> cutConfigs;
    private List<RadialHeader> radialHeaders;

    public PARadarDataInfo() {
        this.meteoDataType = MeteoDataType.RADAR;
    }

    @Override
    public RadarDataType getRadarDataType() {
        return RadarDataType.PA;
    }

    public GenericHeader getGenericHeader() {
        return this.genericHeader;
    }

    public SiteConfig getSiteConfig() {
        return this.siteConfig;
    }

    public TaskConfig getTaskConfig() {
        return this.taskConfig;
    }

    public List<CutConfig> getCutConfigs() {
        return this.cutConfigs;
    }

    public List<RadialHeader> getRadialHeaders() {
        return this.radialHeaders;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            byte[] bytes = new byte[4];
            raf.read(bytes);
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean canOpen(String fileName) {
        try {
            byte[] bytes = new byte[4];
            if (fileName.endsWith("bz2")) {
                BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
                inputStream.read(bytes);
                inputStream.close();
            } else {
                RandomAccessFile raf = new RandomAccessFile(fileName, "r");
                raf.seek(0L);
                raf.read(bytes);
                raf.close();
            }
            int magic = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            return magic == 1297371986;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    void readDataInfo(InputStream raf) {
        try {
            this.genericHeader = new GenericHeader(raf);
            this.siteConfig = new SiteConfig(raf);
            this.antennaHeight = this.siteConfig.antennaHeight;
            this.addAttribute(new Attribute("StationCode", this.siteConfig.siteCode));
            this.addAttribute(new Attribute("StationName", this.siteConfig.siteName));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(this.siteConfig.latitude)));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(this.siteConfig.longitude)));
            this.addAttribute(new Attribute("AntennaHeight", this.siteConfig.antennaHeight));
            this.addAttribute(new Attribute("GroundHeight", this.siteConfig.groundHeight));
            this.addAttribute(new Attribute("RadarType", this.siteConfig.getRadarType()));
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            this.addAttribute(new Attribute("RadarDataType", "PA"));
            this.taskConfig = new TaskConfig(raf);
            this.addAttribute(new Attribute("TaskName", this.taskConfig.taskName));
            this.addAttribute(new Attribute("TaskDescription", this.taskConfig.taskDescription));
            this.beamConfigs = new ArrayList<BeamConfig>();
            for (int i = 0; i < this.taskConfig.beamNumber; ++i) {
                BeamConfig beamConfig = new BeamConfig(raf);
                this.beamConfigs.add(beamConfig);
                if (i != 0) continue;
                this.beamWidthVert = beamConfig.txBeamWidthV;
            }
            this.cutConfigs = new ArrayList<CutConfig>();
            for (int i = 0; i < this.taskConfig.cutNumber; ++i) {
                CutConfig cutConfig = new CutConfig(raf);
                this.cutConfigs.add(cutConfig);
                if (i != 0) continue;
                this.logResolution = cutConfig.logResolution;
                this.dopplerResolution = cutConfig.dopplerResolution;
            }
            this.radialHeaders = new ArrayList<RadialHeader>();
            byte[] rhBytes = new byte[RadialHeader.length];
            while (raf.read(rhBytes) != -1) {
                RadialHeader radialHeader = new RadialHeader(rhBytes);
                int scanIdx = radialHeader.elevationNumber - 1;
                for (int i = 0; i < radialHeader.momentNumber; ++i) {
                    RadialRecord record;
                    MomentHeader momentHeader = new MomentHeader(raf);
                    String product = (String)this.productMap.get(momentHeader.dataType);
                    if (this.recordMap.containsKey(product)) {
                        record = (RadialRecord)this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(momentHeader.binLength);
                        record.scale = 1.0f / (float)momentHeader.scale;
                        record.offset = (float)(-momentHeader.offset) / (float)momentHeader.scale;
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.fixedElevation.add(Float.valueOf(this.cutConfigs.get((int)scanIdx).elevation));
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.azimuthMinIndex.add(0);
                        if (this.isVelocityGroup(record)) {
                            record.disResolution.add(Float.valueOf(this.cutConfigs.get((int)scanIdx).dopplerResolution));
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)Float.valueOf(this.cutConfigs.get((int)scanIdx).dopplerResolution)));
                        } else {
                            record.disResolution.add(Float.valueOf(this.cutConfigs.get((int)scanIdx).logResolution));
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)(momentHeader.dataLength / momentHeader.binLength), (Number)Float.valueOf(this.cutConfigs.get((int)scanIdx).logResolution)));
                        }
                        record.newScanData();
                    }
                    record.elevation.get(scanIdx).add(Float.valueOf(radialHeader.elevation));
                    record.addAzimuth(scanIdx, radialHeader.azimuth);
                    byte[] bytes = new byte[momentHeader.dataLength];
                    raf.read(bytes);
                    record.addDataBytes(scanIdx, bytes);
                }
                this.radialHeaders.add(radialHeader);
            }
            raf.close();
            RadialRecord radialRecord = (RadialRecord)this.recordMap.get("dBZ");
            this.radialDim = new Dimension();
            this.radialDim.setName("radial");
            this.radialDim.setLength(radialRecord.getMaxRadials());
            this.addDimension(this.radialDim);
            this.scanDim = new Dimension();
            this.scanDim.setName("scan");
            this.scanDim.setLength(radialRecord.getScanNumber());
            this.addDimension(this.scanDim);
            this.gateDim = new Dimension();
            this.gateDim.setName("gate");
            this.gateDim.setLength(radialRecord.getGateNumber(0));
            this.addDimension(this.gateDim);
            this.makeAllVariables(radialRecord);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Float> getElevations() {
        ArrayList<Float> elevations = new ArrayList<Float>();
        for (CutConfig cutConfig : this.cutConfigs) {
            if (elevations.contains(Float.valueOf(cutConfig.elevation))) continue;
            elevations.add(Float.valueOf(cutConfig.elevation));
        }
        return elevations;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.attributes;
    }

    static class RadialHeader {
        public static int length = 128;
        public int radialState;
        public int spotBlank;
        public int sequenceNumber;
        public int radialNumber;
        public int elevationNumber;
        public float azimuth;
        public float elevation;
        public long seconds;
        public int microSeconds;
        public int lengthOfData;
        public int momentNumber;
        public short scanBeamIndex;
        public short horizontalEstimatedNoise;
        public short verticalEstimatedNoise;
        public int PRFFLAG;
        public byte[] reserved04;

        public RadialHeader(byte[] bytes) {
            ByteBuffer bf = ByteBuffer.wrap(bytes);
            bf.order(ByteOrder.LITTLE_ENDIAN);
            this.radialState = bf.getInt();
            this.spotBlank = bf.getInt();
            this.sequenceNumber = bf.getInt();
            this.radialNumber = bf.getInt();
            this.elevationNumber = bf.getInt();
            this.azimuth = bf.getFloat();
            this.elevation = bf.getFloat();
            this.seconds = bf.getLong();
            this.microSeconds = bf.getInt();
            this.lengthOfData = bf.getInt();
            this.momentNumber = bf.getInt();
            this.scanBeamIndex = bf.getShort();
            this.horizontalEstimatedNoise = bf.getShort();
            this.verticalEstimatedNoise = bf.getShort();
            this.PRFFLAG = bf.getInt();
        }
    }

    static class CutConfig {
        public static int length = 256;
        public short cutIndex;
        public short txBeamIndex;
        public float elevation;
        public float txBeamGain;
        public float rxBeamWidthH;
        public float rxBeamWidthV;
        public float rxBeamGain;
        public int processMode;
        public int waveForm;
        public float N1_PRF_1;
        public float N1_PRF_2;
        public float N2_PRF_1;
        public float N2_PRF_2;
        public int unfoldMode;
        public float azimuth;
        public float startAngle;
        public float endAngle;
        public float angleResolution;
        public float scanSpeed;
        public float logResolution;
        public float dopplerResolution;
        public int maximumRange;
        public int maximumRange2;
        public int startRange;
        public int sample_1;
        public int sample_2;
        public int phaseMode;
        public float atmosphericLoss;
        public float nyquistSpeed;
        public long momentsMask;
        public long momentsSizeMask;
        public int miscFilterMask;
        public float SQIThreshold;
        public float SIGThreshold;
        public float CSRThreshold;
        public float LOGThreshold;
        public float CPAThreshold;
        public float PMIThreshold;
        public float DPLOGThreshold;
        public byte[] thresholdsReserved;
        public int dBTMask;
        public int dBZMask;
        public int velocity;
        public int spectrumWidthMask;
        public int ZDRMask;
        public byte[] maskReserved;
        public int scanSync;
        public int direction;
        public short groundClutterClassifierType;
        public short groundClutterFilterType;
        public short groundClutterFilterNotchWidth;
        public short groundClutterFilterWindow;
        public byte[] reserved;

        public CutConfig(InputStream inputStream) throws IOException {
            byte[] bytes = new byte[length];
            inputStream.read(bytes);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.cutIndex = byteBuffer.getShort();
            this.txBeamIndex = byteBuffer.getShort();
            this.elevation = byteBuffer.getFloat();
            this.txBeamGain = byteBuffer.getFloat();
            this.rxBeamWidthH = byteBuffer.getFloat();
            this.rxBeamWidthV = byteBuffer.getFloat();
            this.rxBeamGain = byteBuffer.getFloat();
            this.processMode = byteBuffer.getInt();
            this.waveForm = byteBuffer.getInt();
            this.N1_PRF_1 = byteBuffer.getFloat();
            this.N1_PRF_2 = byteBuffer.getFloat();
            this.N2_PRF_1 = byteBuffer.getFloat();
            this.N2_PRF_2 = byteBuffer.getFloat();
            this.unfoldMode = byteBuffer.getInt();
            this.azimuth = byteBuffer.getFloat();
            this.startAngle = byteBuffer.getFloat();
            this.endAngle = byteBuffer.getFloat();
            this.angleResolution = byteBuffer.getFloat();
            this.scanSpeed = byteBuffer.getFloat();
            this.logResolution = byteBuffer.getFloat();
            this.dopplerResolution = byteBuffer.getFloat();
            this.maximumRange = byteBuffer.getInt();
            this.maximumRange2 = byteBuffer.getInt();
            this.startRange = byteBuffer.getInt();
            this.sample_1 = byteBuffer.getInt();
            this.sample_2 = byteBuffer.getInt();
            this.phaseMode = byteBuffer.getInt();
            this.atmosphericLoss = byteBuffer.getFloat();
            this.nyquistSpeed = byteBuffer.getFloat();
            this.momentsMask = byteBuffer.getLong();
            this.momentsSizeMask = byteBuffer.getLong();
            this.miscFilterMask = byteBuffer.getInt();
            this.SQIThreshold = byteBuffer.getFloat();
            this.SIGThreshold = byteBuffer.getFloat();
            this.CSRThreshold = byteBuffer.getFloat();
            this.LOGThreshold = byteBuffer.getFloat();
            this.CPAThreshold = byteBuffer.getFloat();
            this.PMIThreshold = byteBuffer.getFloat();
            this.DPLOGThreshold = byteBuffer.getFloat();
            byteBuffer.getInt();
            this.dBTMask = byteBuffer.getInt();
            this.dBZMask = byteBuffer.getInt();
            this.velocity = byteBuffer.getInt();
            this.spectrumWidthMask = byteBuffer.getInt();
            this.ZDRMask = byteBuffer.getInt();
            byteBuffer.position(byteBuffer.position() + 12);
            this.scanSync = byteBuffer.getInt();
            this.direction = byteBuffer.getInt();
            this.groundClutterClassifierType = byteBuffer.getShort();
            this.groundClutterFilterType = byteBuffer.getShort();
            this.groundClutterFilterNotchWidth = byteBuffer.getShort();
            this.groundClutterFilterWindow = byteBuffer.getShort();
        }
    }

    static class BeamConfig {
        public static int length = 640;
        public int beamIndex;
        public int beamType;
        public int subPulseNumber;
        public float txBeamDirection;
        public float txBeamWidthH;
        public float txBeamWidthV;
        public float txBeamGain;
        public byte[] reserves1;
        public int subPulseStrategy;
        public int subPulseModulation;
        public float subPulseFrequency;
        public float subPulseBandWidth;
        public int subPulseWidth;
        public byte[] reserves2;

        public BeamConfig(InputStream inputStream) throws IOException {
            byte[] inBytes = new byte[length];
            inputStream.read(inBytes);
            ByteBuffer byteBuffer = ByteBuffer.wrap(inBytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.beamIndex = byteBuffer.getInt();
            this.beamType = byteBuffer.getInt();
            this.subPulseNumber = byteBuffer.getInt();
            this.txBeamDirection = byteBuffer.getFloat();
            this.txBeamWidthH = byteBuffer.getFloat();
            this.txBeamWidthV = byteBuffer.getFloat();
            this.txBeamGain = byteBuffer.getFloat();
            byteBuffer.position(byteBuffer.position() + 100);
            this.subPulseStrategy = byteBuffer.getInt();
            this.subPulseModulation = byteBuffer.getInt();
            this.subPulseFrequency = byteBuffer.getFloat();
            this.subPulseBandWidth = byteBuffer.getFloat();
            this.subPulseWidth = byteBuffer.getInt();
        }
    }

    static class TaskConfig {
        public static int length = 256;
        public String taskName;
        public String taskDescription;
        public int polarizationType;
        public int scanType;
        public int beamNumber;
        public int cutNumber;
        public int rayOrder;
        public LocalDateTime scanStartTime;
        public byte[] reserves;

        public TaskConfig(InputStream raf) throws IOException {
            byte[] bytes = new byte[32];
            raf.read(bytes);
            this.taskName = new String(bytes).trim();
            bytes = new byte[128];
            raf.read(bytes);
            this.taskDescription = new String(bytes, "GB2312").trim();
            bytes = new byte[4];
            raf.read(bytes);
            this.polarizationType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.scanType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.beamNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.cutNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.rayOrder = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            bytes = new byte[8];
            raf.read(bytes);
            long seconds = DataConvert.bytes2Long((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            LocalDateTime dt = LocalDateTime.of(1970, 1, 1, 0, 0);
            this.scanStartTime = dt.plusSeconds(seconds);
            this.reserves = new byte[68];
            raf.read(this.reserves);
        }
    }

    static class SiteConfig {
        public static int length = 128;
        public String siteCode;
        public String siteName;
        public float latitude;
        public float longitude;
        public int antennaHeight;
        public int groundHeight;
        public float frequency;
        public int antennaType;
        public int TRNumber;
        public int RADVersion;
        public short radarType;
        public byte[] reserved;

        public SiteConfig(InputStream raf) throws IOException {
            byte[] bytes = new byte[8];
            raf.read(bytes);
            this.siteCode = new String(bytes).trim();
            bytes = new byte[32];
            raf.read(bytes);
            this.siteName = new String(bytes).trim();
            bytes = new byte[4];
            raf.read(bytes);
            this.latitude = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.longitude = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.antennaHeight = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.groundHeight = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.frequency = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.antennaType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.TRNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            raf.read(bytes);
            this.RADVersion = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            bytes = new byte[2];
            raf.read(bytes);
            this.radarType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            this.reserved = new byte[54];
            raf.read(this.reserved);
        }

        public String getRadarType() {
            switch (this.radarType) {
                case 7: {
                    return "SPAR";
                }
                case 8: {
                    return "SPARD";
                }
                case 43: {
                    return "CPAR";
                }
                case 44: {
                    return "CPARD";
                }
                case 69: {
                    return "XPAR";
                }
                case 70: {
                    return "XPARD";
                }
            }
            return "UNDEFINE";
        }
    }
}

