/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.internal;

import java.text.ParsePosition;
import org.apache.commons.geometry.core.internal.DoubleFunction1N;
import org.apache.commons.geometry.core.internal.DoubleFunction2N;
import org.apache.commons.geometry.core.internal.DoubleFunction3N;

public class SimpleTupleFormat {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String SPACE = " ";
    private static final SimpleTupleFormat DEFAULT_INSTANCE = new SimpleTupleFormat(",", "(", ")");
    private final String separator;
    private final String prefix;
    private final String suffix;

    public SimpleTupleFormat(String prefix, String suffix) {
        this(DEFAULT_SEPARATOR, prefix, suffix);
    }

    protected SimpleTupleFormat(String separator, String prefix, String suffix) {
        this.separator = separator;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String format(double a) {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append(a);
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public String format(double a1, double a2) {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append(a1).append(this.separator).append(SPACE).append(a2);
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public String format(double a1, double a2, double a3) {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append(a1).append(this.separator).append(SPACE).append(a2).append(this.separator).append(SPACE).append(a3);
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public String format(double a1, double a2, double a3, double a4) {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append(a1).append(this.separator).append(SPACE).append(a2).append(this.separator).append(SPACE).append(a3).append(this.separator).append(SPACE).append(a4);
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public <T> T parse(String str, DoubleFunction1N<T> fn) {
        ParsePosition pos = new ParsePosition(0);
        this.readPrefix(str, pos);
        double v = this.readTupleValue(str, pos);
        this.readSuffix(str, pos);
        this.endParse(str, pos);
        return fn.apply(v);
    }

    public <T> T parse(String str, DoubleFunction2N<T> fn) {
        ParsePosition pos = new ParsePosition(0);
        this.readPrefix(str, pos);
        double v1 = this.readTupleValue(str, pos);
        double v2 = this.readTupleValue(str, pos);
        this.readSuffix(str, pos);
        this.endParse(str, pos);
        return fn.apply(v1, v2);
    }

    public <T> T parse(String str, DoubleFunction3N<T> fn) {
        ParsePosition pos = new ParsePosition(0);
        this.readPrefix(str, pos);
        double v1 = this.readTupleValue(str, pos);
        double v2 = this.readTupleValue(str, pos);
        double v3 = this.readTupleValue(str, pos);
        this.readSuffix(str, pos);
        this.endParse(str, pos);
        return fn.apply(v1, v2, v3);
    }

    private void readPrefix(String str, ParsePosition pos) {
        if (this.prefix != null) {
            this.consumeWhitespace(str, pos);
            this.readSequence(str, this.prefix, pos);
        }
    }

    private double readTupleValue(String str, ParsePosition pos) {
        int startIdx = pos.getIndex();
        int endIdx = str.indexOf(this.separator, startIdx);
        if (endIdx < 0) {
            if (this.suffix != null) {
                endIdx = str.indexOf(this.suffix, startIdx);
            }
            if (endIdx < 0) {
                endIdx = str.length();
            }
        }
        String substr = str.substring(startIdx, endIdx);
        try {
            double value = Double.parseDouble(substr);
            pos.setIndex(endIdx);
            this.matchSequence(str, this.separator, pos);
            return value;
        }
        catch (NumberFormatException exc) {
            throw SimpleTupleFormat.parseFailure(String.format("unable to parse number from string \"%s\"", substr), str, pos, exc);
        }
    }

    private void readSuffix(String str, ParsePosition pos) {
        if (this.suffix != null) {
            this.consumeWhitespace(str, pos);
            this.readSequence(str, this.suffix, pos);
        }
    }

    private void endParse(String str, ParsePosition pos) {
        this.consumeWhitespace(str, pos);
        if (pos.getIndex() != str.length()) {
            throw SimpleTupleFormat.parseFailure("unexpected content", str, pos);
        }
    }

    private void consumeWhitespace(String str, ParsePosition pos) {
        int idx;
        int len = str.length();
        for (idx = pos.getIndex(); idx < len && Character.isWhitespace(str.codePointAt(idx)); ++idx) {
        }
        pos.setIndex(idx);
    }

    private boolean matchSequence(String str, String seq, ParsePosition pos) {
        int s;
        int idx = pos.getIndex();
        int inputLength = str.length();
        int seqLength = seq.length();
        int i = idx;
        for (s = 0; i < inputLength && s < seqLength && str.codePointAt(i) == seq.codePointAt(s); ++i, ++s) {
        }
        if (i <= inputLength && s == seqLength) {
            pos.setIndex(idx + seqLength);
            return true;
        }
        return false;
    }

    private void readSequence(String str, String seq, ParsePosition pos) {
        if (!this.matchSequence(str, seq, pos)) {
            int idx = pos.getIndex();
            String actualSeq = str.substring(idx, Math.min(str.length(), idx + seq.length()));
            throw SimpleTupleFormat.parseFailure(String.format("expected \"%s\" but found \"%s\"", seq, actualSeq), str, pos);
        }
    }

    public static SimpleTupleFormat getDefault() {
        return DEFAULT_INSTANCE;
    }

    private static IllegalArgumentException parseFailure(String msg, String str, ParsePosition pos) {
        return SimpleTupleFormat.parseFailure(msg, str, pos, null);
    }

    private static IllegalArgumentException parseFailure(String msg, String str, ParsePosition pos, Throwable cause) {
        String fullMsg = String.format("Failed to parse string \"%s\" at index %d: %s", str, pos.getIndex(), msg);
        return new TupleParseException(fullMsg, cause);
    }

    private static class TupleParseException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 20180629L;

        TupleParseException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

