/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.io.npy.NpyDataType;
import org.meteoinfo.ndarray.io.npy.NpyFormatException;
import org.meteoinfo.ndarray.io.npy.NpyUtil;
import org.meteoinfo.ndarray.io.npy.ToFloatFunction;
import org.meteoinfo.ndarray.io.npy.ToShortFunction;
import org.meteoinfo.ndarray.io.npy.dict.NpyHeaderDict;

abstract class ArrayReader {
    protected final NpyHeaderDict dict;
    protected final int elementCount;
    private final int elementSize;
    private int pos;

    private ArrayReader(NpyHeaderDict dict) {
        this.dict = dict;
        NpyDataType type = dict.dataType();
        int n = this.elementCount = type == NpyDataType.S || type == NpyDataType.U ? dict.typeSize() : dict.numberOfElements();
        this.elementSize = type == NpyDataType.S ? 1 : (type == NpyDataType.U ? 4 : type.size());
        this.pos = 0;
    }

    static ArrayReader of(NpyHeaderDict dict) throws NpyFormatException {
        switch (dict.dataType()) {
            case bool: {
                return new BooleanBuilder(dict);
            }
            case f2: {
                return new FloatBuilder(dict, NpyUtil::f2ToFloat);
            }
            case f4: {
                return new FloatBuilder(dict, ByteBuffer::getFloat);
            }
            case f8: {
                return new DoubleBuilder(dict);
            }
            case i1: {
                return new ByteBuilder(dict);
            }
            case i2: {
                return new ShortBuilder(dict, ByteBuffer::getShort);
            }
            case i4: {
                return new IntBuilder(dict, ByteBuffer::getInt);
            }
            case i8: {
                return new LongBuilder(dict, ByteBuffer::getLong);
            }
            case u1: {
                return new ShortBuilder(dict, NpyUtil::u1ToShort);
            }
            case u2: {
                return new IntBuilder(dict, NpyUtil::u2ToInt);
            }
            case u4: {
                return new LongBuilder(dict, NpyUtil::u4ToLong);
            }
            case u8: {
                return new BigIntBuilder(dict);
            }
            case S: {
                return new AsciiBuilder(dict);
            }
            case U: {
                return new UnicodeBuilder(dict);
            }
        }
        throw new NpyFormatException("unsupported data type: " + (Object)((Object)dict.dataType()));
    }

    final void readAllFrom(ByteBuffer buffer) {
        while (this.pos != this.elementCount && buffer.remaining() >= this.elementSize) {
            this.nextInto(buffer, this.pos);
            ++this.pos;
        }
    }

    final void readNextFrom(ByteBuffer buffer) {
        this.nextInto(buffer, this.pos);
        ++this.pos;
    }

    abstract void nextInto(ByteBuffer var1, int var2);

    abstract Object getData();

    Array finish() {
        return Array.factory(NpyUtil.toMIDataType(this.dict.dataType()), this.dict.shape(), this.getData());
    }

    private static final class UnicodeBuilder
    extends ArrayReader {
        private final int[] data;

        private UnicodeBuilder(NpyHeaderDict dict) {
            super(dict);
            this.data = new int[this.elementCount];
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = buffer.getInt();
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class AsciiBuilder
    extends ArrayReader {
        private final CharBuffer chars = CharBuffer.allocate(this.elementCount);
        private char[] data;
        private boolean terminated = false;

        private AsciiBuilder(NpyHeaderDict dict) {
            super(dict);
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            if (this.terminated) {
                return;
            }
            char next = (char)buffer.get();
            if (next == '\u0000') {
                this.terminated = true;
                return;
            }
            this.chars.put(next);
        }

        @Override
        Object getData() {
            if (this.chars.remaining() == 0) {
                this.data = this.chars.array();
            } else {
                this.chars.flip();
                this.data = new char[this.chars.limit()];
                this.chars.get(this.data, 0, this.chars.limit());
            }
            return this.data;
        }
    }

    private static final class BigIntBuilder
    extends ArrayReader {
        private final BigInteger[] data;

        private BigIntBuilder(NpyHeaderDict dict) {
            super(dict);
            this.data = new BigInteger[this.elementCount];
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = NpyUtil.u8ToBigInteger(buffer);
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class LongBuilder
    extends ArrayReader {
        private final long[] data;
        private final ToLongFunction<ByteBuffer> fn;

        private LongBuilder(NpyHeaderDict dict, ToLongFunction<ByteBuffer> fn) {
            super(dict);
            this.data = new long[this.elementCount];
            this.fn = fn;
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = this.fn.applyAsLong(buffer);
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class ShortBuilder
    extends ArrayReader {
        private final short[] data;
        private final ToShortFunction<ByteBuffer> fn;

        private ShortBuilder(NpyHeaderDict dict, ToShortFunction<ByteBuffer> fn) {
            super(dict);
            this.data = new short[this.elementCount];
            this.fn = fn;
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = this.fn.applyAsShort(buffer);
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class IntBuilder
    extends ArrayReader {
        private final int[] data;
        private final ToIntFunction<ByteBuffer> fn;

        private IntBuilder(NpyHeaderDict dict, ToIntFunction<ByteBuffer> fn) {
            super(dict);
            this.data = new int[this.elementCount];
            this.fn = fn;
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = this.fn.applyAsInt(buffer);
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class FloatBuilder
    extends ArrayReader {
        private final float[] data;
        private final ToFloatFunction<ByteBuffer> fn;

        private FloatBuilder(NpyHeaderDict dict, ToFloatFunction<ByteBuffer> fn) {
            super(dict);
            this.data = new float[this.elementCount];
            this.fn = fn;
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = this.fn.applyAsFloat(buffer);
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class DoubleBuilder
    extends ArrayReader {
        private final double[] data;

        private DoubleBuilder(NpyHeaderDict dict) {
            super(dict);
            this.data = new double[this.elementCount];
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = buffer.getDouble();
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class ByteBuilder
    extends ArrayReader {
        private final byte[] data;

        private ByteBuilder(NpyHeaderDict dict) {
            super(dict);
            this.data = new byte[this.elementCount];
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = buffer.get();
        }

        @Override
        Object getData() {
            return this.data;
        }
    }

    private static final class BooleanBuilder
    extends ArrayReader {
        private final boolean[] data;

        private BooleanBuilder(NpyHeaderDict dict) {
            super(dict);
            this.data = new boolean[this.elementCount];
        }

        @Override
        void nextInto(ByteBuffer buffer, int pos) {
            this.data[pos] = buffer.get() != 0;
        }

        @Override
        Object getData() {
            return this.data;
        }
    }
}

