/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.math;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.io.EndianDataOutputStream;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayChar;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ListIndexComparator;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import org.meteoinfo.ndarray.util.DataTypeUtil;

public class ArrayUtil {
    public static Array readASCIIFile(String fileName, String delimiter, int headerLines, String dataType, List<Integer> shape, boolean readFirstCol) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        DataType dt = DataType.DOUBLE;
        if (dataType != null) {
            if (dataType.contains("%")) {
                dataType = dataType.split("%")[1];
            }
            dt = ArrayUtil.toDataType(dataType);
        }
        return ArrayUtil.readASCIIFile(fileName, delimiter, headerLines, dt, shape, readFirstCol);
    }

    public static Array readASCIIFile(String fileName, String delimiter, int headerLines, DataType dataType, List<Integer> shape, boolean readFirstCol) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        int i;
        BufferedReader sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        if (headerLines > 0) {
            for (i = 0; i < headerLines; ++i) {
                sr.readLine();
            }
        }
        int[] ss = new int[shape.size()];
        for (i = 0; i < shape.size(); ++i) {
            ss[i] = shape.get(i);
        }
        Array a = Array.factory(dataType, ss);
        i = 0;
        String line = sr.readLine();
        int sCol = 0;
        if (!readFirstCol) {
            sCol = 1;
        }
        delimiter = delimiter == null || delimiter.equals(" ") ? "\\s+" : Pattern.quote(delimiter);
        while (line != null) {
            if ((line = line.trim()).isEmpty()) {
                line = sr.readLine();
                continue;
            }
            String[] dataArray = line.split(delimiter);
            for (int j = sCol; j < dataArray.length; ++j) {
                a.setDouble(i, Double.parseDouble(dataArray[j]));
                if ((long)(++i) >= a.getSize()) break;
            }
            if ((long)i >= a.getSize()) break;
            line = sr.readLine();
        }
        sr.close();
        return a;
    }

    public static Array readASCIIFile(String fileName, DataType dataType, int count, String delimiter) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        delimiter = delimiter == null || delimiter.equals(" ") ? "\\s+" : Pattern.quote(delimiter);
        List<String> dataList = new ArrayList<String>();
        BufferedReader sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        String line = sr.readLine();
        while (line != null) {
            if ((line = line.trim()).isEmpty()) {
                line = sr.readLine();
                continue;
            }
            String[] dataArray = line.split(delimiter);
            dataList.addAll(Arrays.asList(dataArray));
            if (count > 0 && dataList.size() >= count) {
                if (dataList.size() <= count) break;
                dataList = dataList.subList(0, count);
                break;
            }
            line = sr.readLine();
        }
        sr.close();
        count = count > 0 ? count : dataList.size();
        Array r = Array.factory(dataType, new int[]{count});
        for (int i = 0; i < dataList.size(); ++i) {
            r.setString(i, (String)dataList.get(i));
        }
        return r;
    }

    public static int numASCIIRow(String fileName) throws FileNotFoundException {
        int lineNumber;
        File f = new File(fileName);
        try (Scanner fileScanner = new Scanner(f);){
            lineNumber = 0;
            while (fileScanner.hasNextLine()) {
                String line = fileScanner.nextLine();
                if (line.isEmpty()) continue;
                ++lineNumber;
            }
        }
        return lineNumber;
    }

    public static int numASCIICol(String fileName, String delimiter, int headerLines) throws FileNotFoundException, IOException {
        String[] dataArray;
        delimiter = delimiter == null ? "\\s+" : Pattern.quote(delimiter);
        try (BufferedReader sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));){
            if (headerLines > 0) {
                for (int i = 0; i < headerLines; ++i) {
                    sr.readLine();
                }
            }
            String line = sr.readLine().trim();
            dataArray = line.split(delimiter);
        }
        return dataArray.length;
    }

    public static EndianDataOutputStream createBinFile(String fn) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(fn)));
        EndianDataOutputStream outs = new EndianDataOutputStream((OutputStream)out);
        return outs;
    }

    public static void writeBinFile(EndianDataOutputStream outs, Array a, String byteOrder, boolean sequential) {
        try {
            ByteBuffer bb = a.getDataAsByteBuffer();
            int n = (int)a.getSize();
            ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
            if (byteOrder.equalsIgnoreCase("big_endian")) {
                bOrder = ByteOrder.BIG_ENDIAN;
            }
            if (sequential) {
                if (bOrder == ByteOrder.BIG_ENDIAN) {
                    outs.writeIntBE(n * 4);
                } else {
                    outs.writeIntLE(n * 4);
                }
            }
            if (bOrder == ByteOrder.BIG_ENDIAN) {
                outs.write(bb.array());
            } else if (a.getDataType() == DataType.BYTE) {
                outs.write(bb.array());
            } else {
                ByteBuffer nbb = ByteBuffer.allocate(bb.array().length);
                nbb.order(bOrder);
                switch (a.getDataType()) {
                    case INT: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putInt(i * 4, bb.getInt());
                            ++i;
                        }
                        break;
                    }
                    case FLOAT: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putFloat(i * 4, bb.getFloat());
                            ++i;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putDouble(i * 8, bb.getDouble());
                            ++i;
                        }
                        break;
                    }
                    default: {
                        nbb.put(bb);
                    }
                }
                outs.write(nbb.array());
            }
            if (sequential) {
                if (bOrder == ByteOrder.BIG_ENDIAN) {
                    outs.writeIntBE(n * 4);
                } else {
                    outs.writeIntLE(n * 4);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void saveBinFile(String fn, Array a, String byteOrder, boolean append, boolean sequential) {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(fn), append));){
            EndianDataOutputStream outs = new EndianDataOutputStream((OutputStream)out);
            ByteBuffer bb = a.getDataAsByteBuffer();
            int n = (int)a.getSize();
            ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
            if (byteOrder.equalsIgnoreCase("big_endian")) {
                bOrder = ByteOrder.BIG_ENDIAN;
            }
            if (sequential) {
                if (bOrder == ByteOrder.BIG_ENDIAN) {
                    outs.writeIntBE(n * 4);
                } else {
                    outs.writeIntLE(n * 4);
                }
            }
            if (bOrder == ByteOrder.BIG_ENDIAN) {
                outs.write(bb.array());
            } else if (a.getDataType() == DataType.BYTE) {
                outs.write(bb.array());
            } else {
                ByteBuffer nbb = ByteBuffer.allocate(bb.array().length);
                nbb.order(bOrder);
                switch (a.getDataType()) {
                    case INT: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putInt(i * 4, bb.getInt());
                            ++i;
                        }
                        break;
                    }
                    case FLOAT: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putFloat(i * 4, bb.getFloat());
                            ++i;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putDouble(i * 8, bb.getDouble());
                            ++i;
                        }
                        break;
                    }
                    default: {
                        nbb.put(bb);
                    }
                }
                outs.write(nbb.array());
            }
            if (sequential) {
                if (bOrder == ByteOrder.BIG_ENDIAN) {
                    outs.writeIntBE(n * 4);
                } else {
                    outs.writeIntLE(n * 4);
                }
            }
            outs.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void saveASCIIFile(String fn, Array a, int colNum, String format, String delimiter) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fn)));
        String line = "";
        int j = 0;
        IndexIterator iter = a.getIndexIterator();
        int i = 0;
        while ((long)i < a.getSize()) {
            Object o = iter.getObjectNext();
            line = format == null ? line + o.toString() : line + String.format(format, o);
            if (++j < colNum && (long)i < a.getSize() - 1L) {
                line = delimiter == null ? line + " " : line + delimiter;
            } else {
                sw.write(line);
                sw.newLine();
                line = "";
                j = 0;
            }
            ++i;
        }
        sw.flush();
        sw.close();
    }

    public static Array readBinFile(String fn, List<Integer> dims, String dataType, int skip, String byteOrder) {
        DataType dt = DataType.DOUBLE;
        if (dataType != null) {
            if (dataType.contains("%")) {
                dataType = dataType.split("%")[1];
            }
            dt = ArrayUtil.toDataType(dataType);
        }
        DataType ndt = dt;
        if (dt == DataType.BYTE) {
            ndt = DataType.INT;
        }
        ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
        if (byteOrder.equalsIgnoreCase("big_endian")) {
            bOrder = ByteOrder.BIG_ENDIAN;
        }
        int[] shape = new int[dims.size()];
        for (int i = 0; i < dims.size(); ++i) {
            shape[i] = dims.get(i);
        }
        Array r = Array.factory(ndt, shape);
        IndexIterator iter = r.getIndexIterator();
        try {
            DataInputStream ins = new DataInputStream(new FileInputStream(fn));
            ins.skip(skip);
            int start = 0;
            switch (dt) {
                case BYTE: {
                    byte[] bytes = new byte[(int)r.getSize()];
                    ins.read(bytes);
                    int i = 0;
                    while ((long)i < r.getSize()) {
                        r.setInt(i, DataTypeUtil.byte2Int(bytes[i]));
                        ++i;
                    }
                    break;
                }
                case SHORT: {
                    byte[] bytes = new byte[(int)r.getSize() * 2];
                    byte[] db = new byte[2];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 2);
                        iter.setShortNext(DataTypeUtil.bytes2Short(db, bOrder));
                        start += 2;
                    }
                    break;
                }
                case INT: {
                    byte[] bytes = new byte[(int)r.getSize() * 4];
                    byte[] db = new byte[4];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 4);
                        iter.setIntNext(DataTypeUtil.bytes2Int(db, bOrder));
                        start += 4;
                    }
                    break;
                }
                case FLOAT: {
                    byte[] bytes = new byte[(int)r.getSize() * 4];
                    byte[] db = new byte[4];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 4);
                        iter.setFloatNext(DataTypeUtil.bytes2Float(db, bOrder));
                        start += 4;
                    }
                    break;
                }
                case DOUBLE: {
                    byte[] bytes = new byte[(int)r.getSize() * 8];
                    byte[] db = new byte[8];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 8);
                        iter.setDoubleNext(DataTypeUtil.bytes2Double(db, bOrder));
                        start += 8;
                    }
                    break;
                }
            }
            ins.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return r;
    }

    public static Array readBinFile(String fn, DataType dataType, int count, int offset) throws IOException {
        return ArrayUtil.readBinFile(fn, dataType, count, offset, "little_endian");
    }

    public static Array readBinFile(String fn, DataType dataType, int count, int offset, String byteOrder) throws IOException {
        ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
        if (byteOrder.equalsIgnoreCase("big_endian")) {
            bOrder = ByteOrder.BIG_ENDIAN;
        }
        if (count < 0) {
            long size = Files.size(Paths.get(fn, new String[0]));
            count = (int)((size - (long)offset) / (long)dataType.getSize());
        }
        Array r = Array.factory(dataType, new int[]{count});
        IndexIterator iter = r.getIndexIterator();
        try {
            DataInputStream ins = new DataInputStream(new FileInputStream(fn));
            ins.skip(offset);
            int start = 0;
            byte[] bytes = new byte[(int)r.getSize() * dataType.getSize()];
            ins.read(bytes);
            switch (dataType) {
                case BYTE: {
                    int i = 0;
                    while ((long)i < r.getSize()) {
                        r.setByte(i, bytes[i]);
                        ++i;
                    }
                    break;
                }
                case SHORT: {
                    byte[] db = new byte[2];
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 2);
                        iter.setShortNext(DataTypeUtil.bytes2Short(db, bOrder));
                        start += 2;
                    }
                    break;
                }
                case INT: {
                    byte[] db = new byte[4];
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 4);
                        iter.setIntNext(DataTypeUtil.bytes2Int(db, bOrder));
                        start += 4;
                    }
                    break;
                }
                case FLOAT: {
                    byte[] db = new byte[4];
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 4);
                        iter.setFloatNext(DataTypeUtil.bytes2Float(db, bOrder));
                        start += 4;
                    }
                    break;
                }
                case DOUBLE: {
                    byte[] db = new byte[8];
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 8);
                        iter.setDoubleNext(DataTypeUtil.bytes2Double(db, bOrder));
                        start += 8;
                    }
                    break;
                }
            }
            ins.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return r;
    }

    public static Array fromBuffer(byte[] buffer, DataType dataType, int count, int offset) {
        return ArrayUtil.fromBuffer(buffer, dataType, count, offset, "little_endian");
    }

    public static Array fromBuffer(byte[] buffer, DataType dataType, int count, int offset, String byteOrder) {
        ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
        if (byteOrder.equalsIgnoreCase("big_endian")) {
            bOrder = ByteOrder.BIG_ENDIAN;
        }
        if (count < 0) {
            long size = buffer.length;
            count = (int)((size - (long)offset) / (long)dataType.getSize());
        }
        Array r = Array.factory(dataType, new int[]{count});
        IndexIterator iter = r.getIndexIterator();
        int idx = offset;
        int start = 0;
        int n = (int)r.getSize() * dataType.getSize();
        byte[] bytes = Arrays.copyOfRange(buffer, idx, idx + n);
        switch (dataType) {
            case BYTE: {
                int i = 0;
                while ((long)i < r.getSize()) {
                    r.setByte(i, bytes[i]);
                    ++i;
                }
                break;
            }
            case SHORT: {
                byte[] db = new byte[2];
                while (iter.hasNext()) {
                    System.arraycopy(bytes, start, db, 0, 2);
                    iter.setShortNext(DataTypeUtil.bytes2Short(db, bOrder));
                    start += 2;
                }
                break;
            }
            case INT: {
                byte[] db = new byte[4];
                while (iter.hasNext()) {
                    System.arraycopy(bytes, start, db, 0, 4);
                    iter.setIntNext(DataTypeUtil.bytes2Int(db, bOrder));
                    start += 4;
                }
                break;
            }
            case FLOAT: {
                byte[] db = new byte[4];
                while (iter.hasNext()) {
                    System.arraycopy(bytes, start, db, 0, 4);
                    iter.setFloatNext(DataTypeUtil.bytes2Float(db, bOrder));
                    start += 4;
                }
                break;
            }
            case DOUBLE: {
                byte[] db = new byte[8];
                while (iter.hasNext()) {
                    System.arraycopy(bytes, start, db, 0, 8);
                    iter.setDoubleNext(DataTypeUtil.bytes2Double(db, bOrder));
                    start += 8;
                }
                break;
            }
        }
        return r;
    }

    public static Array array(Object data) {
        return ArrayUtil.array(data, null);
    }

    public static Array array(Object data, DataType dt) {
        if (data == null) {
            Array a = Array.factory(DataType.OBJECT, new int[0]);
            a.setObject(0, null);
            return a;
        }
        if (data instanceof Array) {
            return (Array)data;
        }
        if (data instanceof List) {
            return ArrayUtil.array_list((List)data, dt);
        }
        if (data.getClass().isArray()) {
            return Array.factory(data);
        }
        if (dt == null) {
            dt = ArrayMath.getDataType(data);
        }
        Array a = Array.factory(dt, new int[0]);
        if (data instanceof String) {
            a.setString(0, (String)data);
        } else {
            a.setObject(0, data);
        }
        return a;
    }

    public static Array arrayComplex(double[] real, double[] image) {
        int n = real.length;
        Array r = Array.factory(DataType.COMPLEX, new int[]{n});
        for (int i = 0; i < n; ++i) {
            r.setComplex(i, new Complex(real[i], image[i]));
        }
        return r;
    }

    public static Array array_list(List data, DataType dt) {
        if (data.isEmpty()) {
            if (dt == null) {
                dt = DataType.DOUBLE;
            }
            return Array.factory(dt, new int[]{0});
        }
        Object d0 = data.get(0);
        if (d0 instanceof Number) {
            if (dt == null) {
                dt = ArrayUtil.objectsToType(data);
            }
            Array a = Array.factory(dt, new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                a.setObject(i, data.get(i));
            }
            return a;
        }
        if (d0 instanceof String) {
            if (dt == null) {
                dt = DataType.STRING;
            }
            if (dt == DataType.CHAR) {
                int strLen = 1;
                for (int i = 0; i < data.size(); ++i) {
                    int len = ((String)data.get(i)).length();
                    if (len <= strLen) continue;
                    strLen = len;
                }
                if (strLen == 1) {
                    Array a = Array.factory(dt, new int[]{data.size()});
                    for (int i = 0; i < data.size(); ++i) {
                        a.setChar(i, ((String)data.get(i)).charAt(0));
                    }
                    return a;
                }
                Array a = Array.factory(dt, new int[]{data.size(), strLen});
                for (int i = 0; i < data.size(); ++i) {
                    a.setString(i, (String)data.get(i));
                }
                return a;
            }
            Array a = Array.factory(dt, new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                a.setString(i, (String)data.get(i));
            }
            return a;
        }
        if (d0 instanceof Boolean) {
            Array a = Array.factory(DataType.BOOLEAN, new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                a.setObject(i, data.get(i));
            }
            return a;
        }
        if (d0 instanceof Complex) {
            Array a = Array.factory(DataType.COMPLEX, new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                Complex d = (Complex)data.get(i);
                a.setObject(i, (Object)d);
            }
            return a;
        }
        if (d0 instanceof LocalDateTime) {
            Array a = Array.factory(DataType.DATE, new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                LocalDateTime d = (LocalDateTime)data.get(i);
                a.setDate(i, d);
            }
            return a;
        }
        if (d0 instanceof List) {
            ArrayList<Integer> dims = new ArrayList<Integer>();
            dims.add(data.size());
            dims.add(((List)d0).size());
            Object v = ((List)d0).get(0);
            if (v instanceof List) {
                d0 = v;
            }
            while (v instanceof List) {
                dims.add(((List)v).size());
                v = ((List)v).get(0);
                if (!(v instanceof List)) break;
                d0 = v;
            }
            if (dt == null) {
                dt = ArrayUtil.objectsToType(data);
            }
            int ndim = dims.size();
            int[] shape = dims.stream().mapToInt(Integer::valueOf).toArray();
            Array a = Array.factory(dt, shape);
            Index index = a.getIndex();
            int i = 0;
            while ((long)i < a.getSize()) {
                int[] counter = index.getCurrentCounter();
                List vList = (List)data.get(counter[0]);
                if (ndim > 2) {
                    for (int j = 1; j < ndim - 1; ++j) {
                        vList = (List)vList.get(counter[j]);
                    }
                }
                a.setObject(index, vList.get(counter[ndim - 1]));
                index.incr();
                ++i;
            }
            return a;
        }
        Array a = Array.factory(DataType.OBJECT, new int[]{data.size()});
        for (int i = 0; i < data.size(); ++i) {
            a.setObject(i, data.get(i));
        }
        return a;
    }

    public static Array view(Array a) {
        return Array.factory(a.getElementType(), a.getIndex(), a.getStorage());
    }

    public static Array arrayRange_bak(Number start, Number stop, Number step) {
        double startv;
        if (stop == null) {
            stop = start;
            start = 0;
        }
        DataType dataType = ArrayUtil.objectsToType(new Object[]{start, stop, step});
        double stopv = stop.doubleValue();
        double stepv = step.doubleValue();
        ArrayList<Double> data = new ArrayList<Double>();
        if (dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            while (startv < stopv) {
                data.add(startv);
                startv = BigDecimalUtil.add(startv, stepv);
            }
        } else {
            for (startv = start.doubleValue(); startv < stopv; startv += stepv) {
                data.add(startv);
            }
        }
        int length = data.size();
        Array a = Array.factory(dataType, new int[]{length});
        for (int i = 0; i < length; ++i) {
            a.setObject(i, data.get(i));
        }
        return a;
    }

    public static Array arrayRange(Number start, Number stop, Number step) {
        if (stop == null) {
            stop = start;
            start = 0;
        }
        DataType dataType = ArrayUtil.objectsToType(new Object[]{start, stop, step});
        double startv = start.doubleValue();
        double stopv = stop.doubleValue();
        double stepv = step.doubleValue();
        int length = Math.max(0, (int)Math.ceil((stopv - startv) / stepv));
        Array a = Array.factory(dataType, new int[]{length});
        if (dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)BigDecimalUtil.add(BigDecimalUtil.mul((double)i, stepv), startv));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)((double)i * stepv + startv));
            }
        }
        return a;
    }

    public static Array arrayRange1(Number start, int length, Number step) {
        DataType dataType = ArrayUtil.objectsToType(new Object[]{start, step});
        double startv = start.doubleValue();
        double stepv = step.doubleValue();
        Array a = Array.factory(dataType, new int[]{length});
        if (dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)BigDecimalUtil.add(BigDecimalUtil.mul((double)i, stepv), startv));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)((double)i * stepv + startv));
            }
        }
        return a;
    }

    public static Array lineSpace(Number start, Number stop, int n) {
        return ArrayUtil.lineSpace(start, stop, n, true);
    }

    public static Array lineSpace(Number start, Number stop, int n, boolean endpoint) {
        if (stop == null) {
            stop = start;
            start = 0;
        }
        double startv = start.doubleValue();
        double stopv = stop.doubleValue();
        int div = endpoint ? n - 1 : n;
        double stepv = (stopv - startv) / (double)div;
        Array a = Array.factory(DataType.DOUBLE, new int[]{n});
        double v = startv;
        for (int i = 0; i < n; ++i) {
            a.setDouble(i, v);
            v += stepv;
        }
        if (endpoint && a.getDouble(n - 1) != stopv) {
            a.setDouble(n - 1, stopv);
        }
        return a;
    }

    public static Array lineSpace_bak(Number start, Number stop, int n, boolean endpoint) {
        if (stop == null) {
            stop = start;
            start = 0;
        }
        double startv = start.doubleValue();
        double stopv = stop.doubleValue();
        double stepv = (stopv - startv) / (double)(n - 1);
        double endv = (double)n * stepv + startv;
        int nn = n;
        if (endpoint) {
            if (endv < stopv) {
                // empty if block
            }
        } else if (endv >= stopv) {
            --nn;
        }
        Array a = Array.factory(DataType.FLOAT, new int[]{++nn});
        for (int i = 0; i < nn; ++i) {
            a.setObject(i, (Object)BigDecimalUtil.add(BigDecimalUtil.mul((double)i, stepv), startv));
        }
        return a;
    }

    public static Array zeros(int n) {
        Array a = Array.factory(DataType.FLOAT, new int[]{n});
        for (int i = 0; i < n; ++i) {
            a.setFloat(i, 0.0f);
        }
        return a;
    }

    public static Array zeros(List<Integer> shape, String dtype) {
        DataType dt = ArrayUtil.toDataType(dtype);
        return ArrayUtil.zeros(shape, dt);
    }

    public static Array zeros(List<Integer> shape, DataType dtype) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(dtype, ashape);
        return a;
    }

    public static Array zeros(int[] shape, DataType dtype) {
        Array a = Array.factory(dtype, shape);
        return a;
    }

    public static Array empty(List<Integer> shape, DataType dtype) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(dtype, ashape);
        return a;
    }

    public static Array full(int[] shape, Object fillValue, DataType dtype) {
        if (dtype == null) {
            dtype = ArrayMath.getDataType(fillValue);
        }
        Array a = Array.factory(dtype, shape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setObject(i, fillValue);
            ++i;
        }
        return a;
    }

    public static Array full(List<Integer> shape, Object fillValue, DataType dtype) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        return ArrayUtil.full(ashape, fillValue, dtype);
    }

    public static Array full(List<Integer> shape, Array fillValue, DataType dtype) {
        fillValue = fillValue.copyIfView();
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        if (dtype == null) {
            dtype = fillValue.getDataType();
        }
        Array a = Array.factory(dtype, ashape);
        int idx = 0;
        int len = (int)fillValue.getSize();
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setObject(i, fillValue.getObject(idx));
            if (++idx == len) {
                idx = 0;
            }
            ++i;
        }
        return a;
    }

    public static Array ones(int n) {
        Array a = Array.factory(DataType.FLOAT, new int[]{n});
        for (int i = 0; i < n; ++i) {
            a.setFloat(i, 1.0f);
        }
        return a;
    }

    public static Array ones(List<Integer> shape, DataType dtype) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(dtype, ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setObject(i, (Object)1);
            ++i;
        }
        return a;
    }

    public static Array identity(int n, DataType dtype) {
        int[] shape = new int[]{n, n};
        Array a = Array.factory(dtype, shape);
        IndexIterator index = a.getIndexIterator();
        while (index.hasNext()) {
            index.next();
            int[] current = index.getCurrentCounter();
            if (current[0] == current[1]) {
                index.setObjectCurrent(1);
                continue;
            }
            index.setObjectCurrent(0);
        }
        return a;
    }

    public static Array eye(int n, int m, int k, DataType dtype) {
        int[] shape = new int[]{n, m};
        Array a = Array.factory(dtype, shape);
        IndexIterator index = a.getIndexIterator();
        while (index.hasNext()) {
            index.next();
            int[] current = index.getCurrentCounter();
            int i = current[0];
            int j = current[1] - k;
            if (i == j) {
                index.setObjectCurrent(1);
                continue;
            }
            index.setObjectCurrent(0);
        }
        return a;
    }

    public static Array diag(Array a, int k) {
        if (a.getRank() == 2) {
            int m = a.getShape()[0];
            int n = a.getShape()[1];
            int len = Math.min(m, n) - Math.abs(k);
            Array r = Array.factory(a.getDataType(), new int[]{len});
            IndexIterator index = a.getIndexIterator();
            int idx = 0;
            while (index.hasNext()) {
                int j;
                index.next();
                int[] current = index.getCurrentCounter();
                int i = current[0];
                if (i != (j = current[1] - k)) continue;
                r.setObject(idx, index.getObjectCurrent());
                if (++idx != len) continue;
            }
            return r;
        }
        int m = a.getShape()[0];
        Array r = Array.factory(a.getDataType(), new int[]{m, m});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                if (i == j - k) {
                    r.setObject(i * m + j, a.getObject(i));
                    continue;
                }
                r.setObject(i * m + j, (Object)0);
            }
        }
        return r;
    }

    public static Array magic(int n) {
        int[] M = new int[n * n];
        if (n % 2 == 1) {
            int a = (n + 1) / 2;
            int b = n + 1;
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < n; ++i) {
                    M[i * n + j] = n * ((i + j + a) % n) + (i + 2 * j + b) % n + 1;
                }
            }
        } else if (n % 4 == 0) {
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < n; ++i) {
                    M[i * n + j] = (i + 1) / 2 % 2 == (j + 1) / 2 % 2 ? n * n - n * i - j : n * i + j + 1;
                }
            }
        } else {
            int p = n / 2;
            int k = (n - 2) / 4;
            Array A = ArrayUtil.magic(p);
            for (int j = 0; j < p; ++j) {
                for (int i = 0; i < p; ++i) {
                    int aij;
                    M[i * n + j] = aij = A.getInt(i * p + j);
                    M[i * n + j + p] = aij + 2 * p * p;
                    M[(i + p) * n + j] = aij + 3 * p * p;
                    M[(i + p) * n + j + p] = aij + p * p;
                }
            }
            for (int i = 0; i < p; ++i) {
                int t;
                int j;
                for (j = 0; j < k; ++j) {
                    t = M[i * n + j];
                    M[i * n + j] = M[(i + p) * n + j];
                    M[(i + p) * n + j] = t;
                }
                for (j = n - k + 1; j < n; ++j) {
                    t = M[i * n + j];
                    M[i * n + j] = M[(i + p) * n + j];
                    M[(i + p) * n + j] = t;
                }
            }
            int t = M[k * n];
            M[k * n] = M[(k + p) * n];
            M[(k + p) * n] = t;
            t = M[k * n + k];
            M[k * n + k] = M[(k + p) * n + k];
            M[(k + p) * n + k] = t;
        }
        return Array.factory(DataType.INT, new int[]{n, n}, (Object)M);
    }

    public static Array toeplitz(Array col, Array row) {
        int nx = (int)row.getSize();
        int ny = (int)col.getSize();
        DataType dataType = ArrayMath.commonType(col.getDataType(), row.getDataType());
        Array r = Array.factory(dataType, new int[]{ny, nx});
        for (int i = 0; i < ny; ++i) {
            int j;
            for (j = 0; j < i; ++j) {
                r.setObject(i * nx + j, col.getObject(i - j));
            }
            for (j = i; j < nx; ++j) {
                r.setObject(i * nx + j, row.getObject(j - i));
            }
        }
        return r;
    }

    public static Array repeat(Number v, int n) {
        DataType dt = ArrayMath.getDataType(v);
        Array r = Array.factory(dt, new int[]{n});
        for (int i = 0; i < n; ++i) {
            r.setObject(i, (Object)v);
        }
        return r;
    }

    public static Array repeat(Array a, List<Integer> repeats) {
        Array r;
        IndexIterator iterA = a.getIndexIterator();
        if (repeats.size() == 1) {
            int n = repeats.get(0);
            r = Array.factory(a.getDataType(), new int[]{(int)a.getSize() * n});
            int i = 0;
            while (iterA.hasNext()) {
                Object o = iterA.getObjectNext();
                for (int j = 0; j < n; ++j) {
                    r.setObject(i * n + j, o);
                }
                ++i;
            }
        } else {
            int n = 0;
            for (int i = 0; i < repeats.size(); ++i) {
                n += repeats.get(i).intValue();
            }
            r = Array.factory(a.getDataType(), new int[]{n});
            int idx = 0;
            int i = 0;
            while (iterA.hasNext()) {
                Object o = iterA.getObjectNext();
                for (int j = 0; j < repeats.get(i); ++j) {
                    r.setObject(idx, o);
                    ++idx;
                }
                ++i;
            }
        }
        return r;
    }

    public static Array repeat(Array a, List<Integer> repeats, int axis) {
        Array r;
        if (repeats.size() == 1) {
            int n = repeats.get(0);
            int[] shape = a.getShape();
            shape[axis] = shape[axis] * n;
            r = Array.factory(a.getDataType(), shape);
            Index aindex = a.getIndex();
            Index index = r.getIndex();
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = index.getCurrentCounter();
                current[axis] = current[axis] / n;
                aindex.set(current);
                r.setObject(index, a.getObject(aindex));
                index.incr();
                ++i;
            }
        } else {
            int n = 0;
            int[] rsum = new int[repeats.size()];
            for (int i = 0; i < repeats.size(); ++i) {
                rsum[i] = n;
                n += repeats.get(i).intValue();
            }
            int[] shape = a.getShape();
            shape[axis] = n;
            r = Array.factory(a.getDataType(), shape);
            Index aindex = a.getIndex();
            Index index = r.getIndex();
            int i = 0;
            while ((long)i < a.getSize()) {
                int[] current = aindex.getCurrentCounter();
                int idx = current[axis];
                for (int j = 0; j < repeats.get(idx); ++j) {
                    current[axis] = rsum[idx] + j;
                    index.set(current);
                    r.setObject(index, a.getObject(aindex));
                }
                aindex.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array repeat(Array a, Array repeats) {
        Array r;
        repeats = repeats.copyIfView();
        IndexIterator iterA = a.getIndexIterator();
        if (repeats.getSize() == 1L) {
            int n = repeats.getInt(0);
            r = Array.factory(a.getDataType(), new int[]{(int)a.getSize() * n});
            int i = 0;
            while (iterA.hasNext()) {
                Object o = iterA.getObjectNext();
                for (int j = 0; j < n; ++j) {
                    r.setObject(i * n + j, o);
                }
                ++i;
            }
        } else {
            int n = 0;
            int i = 0;
            while ((long)i < repeats.getSize()) {
                n += repeats.getInt(i);
                ++i;
            }
            r = Array.factory(a.getDataType(), new int[]{n});
            int idx = 0;
            int i2 = 0;
            while (iterA.hasNext()) {
                Object o = iterA.getObjectNext();
                for (int j = 0; j < repeats.getInt(i2); ++j) {
                    r.setObject(idx, o);
                    ++idx;
                }
                ++i2;
            }
        }
        return r;
    }

    public static Array repeat(Array a, Array repeats, int axis) {
        Array r;
        if ((repeats = repeats.copyIfView()).getSize() == 1L) {
            int n = repeats.getInt(0);
            int[] shape = a.getShape();
            shape[axis] = shape[axis] * n;
            r = Array.factory(a.getDataType(), shape);
            Index aindex = a.getIndex();
            Index index = r.getIndex();
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = index.getCurrentCounter();
                current[axis] = current[axis] / n;
                aindex.set(current);
                r.setObject(index, a.getObject(aindex));
                index.incr();
                ++i;
            }
        } else {
            int n = 0;
            int[] rsum = new int[(int)repeats.getSize()];
            int i = 0;
            while ((long)i < repeats.getSize()) {
                rsum[i] = n;
                n += repeats.getInt(i);
                ++i;
            }
            int[] shape = a.getShape();
            shape[axis] = n;
            r = Array.factory(a.getDataType(), shape);
            Index aindex = a.getIndex();
            Index index = r.getIndex();
            int i2 = 0;
            while ((long)i2 < a.getSize()) {
                int[] current = aindex.getCurrentCounter();
                int idx = current[axis];
                for (int j = 0; j < repeats.getInt(idx); ++j) {
                    current[axis] = rsum[idx] + j;
                    index.set(current);
                    r.setObject(index, a.getObject(aindex));
                }
                aindex.incr();
                ++i2;
            }
        }
        return r;
    }

    public static Array tile(Number v, int n) {
        DataType dt = ArrayMath.getDataType(v);
        Array r = Array.factory(dt, new int[]{n});
        for (int i = 0; i < n; ++i) {
            r.setObject(i, (Object)v);
        }
        return r;
    }

    public static Array tile(Number v, List<Integer> repeats) {
        int[] shape = new int[repeats.size()];
        for (int i = 0; i < repeats.size(); ++i) {
            shape[i] = repeats.get(i);
        }
        DataType dt = ArrayMath.getDataType(v);
        Array r = Array.factory(dt, shape);
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setObject(i, (Object)v);
            ++i;
        }
        return r;
    }

    public static Array tile(Array a, List<Integer> repeats) {
        if (a.getRank() > repeats.size()) {
            int n = a.getRank() - repeats.size();
            for (int i = 0; i < n; ++i) {
                repeats.add(0, 1);
            }
        } else if (a.getRank() < repeats.size()) {
            int[] shape = a.getShape();
            int[] nshape = new int[repeats.size()];
            int n = repeats.size() - shape.length;
            for (int i = 0; i < nshape.length; ++i) {
                nshape[i] = i < n ? 1 : shape[i - n];
            }
            a = a.reshape(nshape);
        }
        int[] ashape = a.getShape();
        int[] shape = a.getShape();
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = shape[i] * repeats.get(i);
        }
        Array r = Array.factory(a.getDataType(), shape);
        Index index = r.getIndex();
        Index aindex = a.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = index.getCurrentCounter();
            for (int j = 0; j < repeats.size(); ++j) {
                int idx = current[j];
                current[j] = idx %= ashape[j];
            }
            aindex.set(current);
            r.setObject(index, a.getObject(aindex));
            index.incr();
            ++i;
        }
        return r;
    }

    public static double rand() {
        Random r = new Random();
        return r.nextDouble();
    }

    public static Array rand(int n) {
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        Random rd = new Random();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, rd.nextDouble());
            ++i;
        }
        return r;
    }

    public static Array rand(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(DataType.DOUBLE, ashape);
        Random rd = new Random();
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, rd.nextDouble());
            ++i;
        }
        return a;
    }

    private static DataType objectsToType(Object[] objects) {
        if (objects.length == 0) {
            return DataType.INT;
        }
        short sz = -1;
        DataType dataType = DataType.INT;
        for (Object o : objects) {
            DataType _type = ArrayMath.getDataType(o);
            short new_sz = ArrayMath.typeToNBytes(_type);
            if (new_sz <= sz) continue;
            dataType = _type;
            sz = new_sz;
        }
        return dataType;
    }

    private static DataType objectsToType(List<Object> objects) {
        if (objects.isEmpty()) {
            return DataType.INT;
        }
        short sz = -1;
        DataType dataType = DataType.INT;
        for (Object o : objects) {
            DataType dType = o instanceof List ? ArrayUtil.objectsToType((List)o) : ArrayMath.getDataType(o);
            short new_sz = ArrayMath.typeToNBytes(dType);
            if (new_sz <= sz) continue;
            dataType = dType;
            sz = new_sz;
        }
        return dataType;
    }

    public static DataType mergeDataType(DataType dt1, DataType dt2) {
        if (dt1 == DataType.OBJECT || dt2 == DataType.OBJECT) {
            return DataType.OBJECT;
        }
        if (dt1 == DataType.STRING || dt2 == DataType.STRING) {
            return DataType.STRING;
        }
        if (dt1 == DataType.DOUBLE || dt2 == DataType.DOUBLE) {
            return DataType.DOUBLE;
        }
        if (dt1 == DataType.FLOAT || dt2 == DataType.FLOAT) {
            return DataType.FLOAT;
        }
        return dt1;
    }

    public static String convertToString(Array a) {
        if (a.getDataType() == DataType.STRUCTURE) {
            return a.toString();
        }
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("array(");
        int ndim = a.getRank();
        if (ndim == 0) {
            sbuff.append(a.getObject(0));
            sbuff.append(")");
            return sbuff.toString();
        }
        if (ndim > 1) {
            for (int i = 0; i < ndim - 1; ++i) {
                sbuff.append("[");
            }
        }
        IndexIterator ii = a.getIndexIterator();
        int shapeIdx = ndim - 1;
        if (shapeIdx < 0) {
            sbuff.append("[");
            sbuff.append(ii.getObjectNext());
            sbuff.append("])");
            return sbuff.toString();
        }
        int[] shape = a.getShape();
        int[] dims = new int[shape.length];
        for (int i = dims.length - 1; i >= 0; --i) {
            dims[i] = i == dims.length - 1 ? shape[i] : dims[i + 1] * shape[i];
        }
        int len = a.getShape()[shapeIdx];
        int i = 0;
        int n = 1;
        int nn = 0;
        while (ii.hasNext()) {
            int j;
            if (i == 0) {
                if (n > 1) {
                    sbuff.append("\n      ");
                }
                sbuff.append("[");
                if (nn > 0) {
                    for (j = 0; j < nn; ++j) {
                        sbuff.append("[");
                    }
                }
            }
            String dstr = ii.getStringNext();
            if (a.getDataType().isBoolean()) {
                dstr = GlobalUtil.capitalize((String)dstr);
            }
            if (a.getDataType().isString()) {
                sbuff.append("'");
                sbuff.append(dstr);
                sbuff.append("'");
            } else {
                sbuff.append(dstr);
            }
            if (++i == len) {
                sbuff.append("]");
                i = 0;
                if (ndim > 1 && (long)n < a.getSize()) {
                    nn = 0;
                    for (j = ndim - 2; j >= 0; --j) {
                        if (n % dims[j] != 0) continue;
                        sbuff.append("]");
                        ++nn;
                    }
                    for (j = 0; j < nn; ++j) {
                        sbuff.append("\n");
                    }
                }
            } else {
                sbuff.append(", ");
            }
            if (++n <= 200 || !ii.hasNext()) continue;
            sbuff.append("...]");
            break;
        }
        if (ndim > 1) {
            for (i = 0; i < ndim - 1; ++i) {
                sbuff.append("]");
            }
        }
        sbuff.append(")");
        return sbuff.toString();
    }

    public static String toString_old(Array a) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("array(");
        int ndim = a.getRank();
        if (ndim > 1) {
            sbuff.append("[");
        }
        int i = 0;
        int shapeIdx = ndim - 1;
        int len = a.getShape()[shapeIdx];
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            if (i == 0) {
                sbuff.append("[");
            }
            Object data = ii.getObjectNext();
            sbuff.append(data);
            if (++i == len) {
                sbuff.append("]");
                len = a.getShape()[shapeIdx];
                i = 0;
                continue;
            }
            sbuff.append(", ");
        }
        if (ndim > 1) {
            sbuff.append("]");
        }
        return sbuff.toString();
    }

    public static String dataTypeString(DataType dt) {
        String str = "string";
        switch (dt) {
            case BYTE: {
                str = "byte";
                break;
            }
            case SHORT: {
                str = "short";
                break;
            }
            case INT: {
                str = "int";
                break;
            }
            case FLOAT: {
                str = "float";
                break;
            }
            case DOUBLE: {
                str = "double";
            }
        }
        return str;
    }

    public static DataType toDataType(String dt) {
        if (dt.contains("%")) {
            dt = dt.split("%")[1];
        }
        switch (dt.toLowerCase()) {
            case "c": 
            case "s": 
            case "string": {
                return DataType.STRING;
            }
            case "b": 
            case "byte": {
                return DataType.BYTE;
            }
            case "short": {
                return DataType.SHORT;
            }
            case "i": 
            case "int": {
                return DataType.INT;
            }
            case "f": 
            case "float": {
                return DataType.FLOAT;
            }
            case "d": 
            case "double": {
                return DataType.DOUBLE;
            }
            case "bool": 
            case "boolean": {
                return DataType.BOOLEAN;
            }
        }
        return DataType.OBJECT;
    }

    public static Array convertToDataType(Array a, DataType dataType) {
        if (a.getDataType() == dataType) {
            return a;
        }
        Array r = Array.factory(dataType, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        switch (dataType) {
            case BYTE: {
                while (iterR.hasNext()) {
                    iterR.setByteNext(iterA.getByteNext());
                }
                break;
            }
            case BOOLEAN: {
                while (iterR.hasNext()) {
                    iterR.setBooleanNext(iterA.getBooleanNext());
                }
                break;
            }
            case SHORT: {
                while (iterR.hasNext()) {
                    iterR.setShortNext(iterA.getShortNext());
                }
                break;
            }
            case INT: {
                while (iterR.hasNext()) {
                    iterR.setIntNext(iterA.getIntNext());
                }
                break;
            }
            case LONG: {
                while (iterR.hasNext()) {
                    iterR.setLongNext(iterA.getLongNext());
                }
                break;
            }
            case FLOAT: {
                while (iterR.hasNext()) {
                    iterR.setFloatNext(iterA.getFloatNext());
                }
                break;
            }
            case DOUBLE: {
                while (iterR.hasNext()) {
                    iterR.setDoubleNext(iterA.getDoubleNext());
                }
                break;
            }
            case COMPLEX: {
                while (iterR.hasNext()) {
                    iterR.setComplexNext(iterA.getComplexNext());
                }
                break;
            }
            case STRING: {
                while (iterR.hasNext()) {
                    iterR.setStringNext(iterA.getStringNext());
                }
                break;
            }
            case DATE: {
                while (iterR.hasNext()) {
                    iterR.setDateNext(iterA.getDateNext());
                }
                break;
            }
        }
        return r;
    }

    public static Array toInteger(Array a) {
        Array r = Array.factory(DataType.INT, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        if (a.getDataType().isNumeric()) {
            while (iterA.hasNext()) {
                iterR.setIntNext(iterA.getIntNext());
            }
        } else if (a.getDataType() == DataType.BOOLEAN) {
            while (iterA.hasNext()) {
                iterR.setIntNext(iterA.getBooleanNext() ? 1 : 0);
            }
        } else {
            while (iterA.hasNext()) {
                iterR.setIntNext(Integer.valueOf(iterA.getObjectNext().toString().trim()));
            }
        }
        return r;
    }

    public static Array toFloat(Array a) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        if (a.getDataType().isNumeric()) {
            while (iterA.hasNext()) {
                iterR.setFloatNext(iterA.getFloatNext());
            }
        } else {
            while (iterA.hasNext()) {
                iterR.setFloatNext(Float.valueOf(iterA.getObjectNext().toString()).floatValue());
            }
        }
        return r;
    }

    public static Array toDouble(Array a) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        if (a.getDataType().isNumeric()) {
            while (iterA.hasNext()) {
                iterR.setDoubleNext(iterA.getDoubleNext());
            }
        } else if (a.getDataType() == DataType.DATE) {
            while (iterA.hasNext()) {
                iterR.setDoubleNext(JDateUtil.toOADate((LocalDateTime)iterA.getDateNext()));
            }
        } else {
            while (iterA.hasNext()) {
                iterR.setDoubleNext(Double.valueOf(iterA.getObjectNext().toString()));
            }
        }
        return r;
    }

    public static Array toBoolean(Array a) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setBooleanNext(iterA.getDoubleNext() != 0.0);
        }
        return r;
    }

    public static Array toDate(Array a) {
        Array r = Array.factory(DataType.DATE, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        while (iterA.hasNext()) {
            iterR.setDateNext(JDateUtil.fromOADate((double)iterA.getDoubleNext()));
        }
        return r;
    }

    public static Array stringToDateArray(Array s, String format) {
        Array r = Array.factory(DataType.DATE, s.getShape());
        IndexIterator iterS = s.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        while (iterS.hasNext()) {
            iterR.setDateNext(LocalDateTime.parse(iterS.getStringNext(), formatter));
        }
        return r;
    }

    public static Array convertEncoding(ArrayChar a, String encoding) {
        if (encoding.toUpperCase().equals("UTF-8")) {
            return a.copy();
        }
        char[] data = (char[])a.getStorage();
        Charset cs = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.allocate(data.length);
        cb.put(data);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        cs = Charset.forName(encoding);
        cb = cs.decode(bb);
        Array r = Array.factory(DataType.CHAR, a.getIndex(), (Object)cb.array());
        return r;
    }

    public static String getString(ArrayChar a, String encoding) {
        a = (ArrayChar)a.copyIfView();
        char[] data = (char[])a.getStorage();
        if (!encoding.toUpperCase().equals("UTF-8")) {
            try {
                byte[] bytes = String.valueOf(data).getBytes("UTF-8");
                return new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(data);
    }

    public static Array concatenate(List<Array> arrays, Integer axis) throws InvalidRangeException {
        int ndim = arrays.get(0).getRank();
        if (axis == -1) {
            axis = ndim - 1;
        }
        int len = 0;
        int[] lens = new int[arrays.size()];
        int i = 0;
        ArrayList<Index> indexList = new ArrayList<Index>();
        for (Array a : arrays) {
            lens[i] = len += a.getShape()[axis];
            indexList.add(a.getIndex());
            ++i;
        }
        int[] shape = arrays.get(0).getShape();
        shape[axis.intValue()] = len;
        DataType dataType = ArrayMath.commonTypeArrays(arrays);
        Array r = Array.factory(dataType, shape);
        IndexIterator ii = r.getIndexIterator();
        int idx = 0;
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            for (i = 0; i < lens.length; ++i) {
                if (current[axis] >= lens[i]) continue;
                idx = i;
                break;
            }
            if (idx > 0) {
                current[axis.intValue()] = current[axis] - lens[idx - 1];
            }
            Index index = (Index)indexList.get(idx);
            index.set(current);
            ii.setObjectCurrent(arrays.get(idx).getObject(index));
        }
        return r;
    }

    public static Array concatenate(Array a, Array b, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == -1) {
            axis = n - 1;
        }
        int nn = shape[axis];
        int[] bshape = b.getShape();
        int[] nshape = new int[n];
        for (int i = 0; i < n; ++i) {
            nshape[i] = i == axis ? shape[i] + bshape[i] : shape[i];
        }
        DataType dataType = ArrayMath.commonType(a.getDataType(), b.getDataType());
        Array r = Array.factory(dataType, nshape);
        Index indexr = r.getIndex();
        Index indexa = a.getIndex();
        Index indexb = b.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            if (current[axis] < nn) {
                indexa.set(current);
                r.setObject(indexr, a.getObject(indexa));
            } else {
                current[axis.intValue()] = current[axis] - nn;
                indexb.set(current);
                r.setObject(indexr, b.getObject(indexb));
            }
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static List<Array> arraySplit(Array a, int sections, int axis) {
        int[] shape = a.getShape();
        if (axis == -1) {
            axis = a.getRank() - 1;
        }
        int n = shape[axis];
        int sn = n / sections;
        ArrayList<Array> arrays = new ArrayList<Array>();
        return arrays;
    }

    public static Array unPack(Array a, double missingValue, double scaleFactor, double addOffset) {
        if (!Double.isNaN(missingValue) && ArrayMath.contains(a, missingValue)) {
            a = ArrayUtil.convertToDataType(a, DataType.DOUBLE);
            ArrayMath.replaceValue(a, missingValue, Double.NaN);
        }
        if (scaleFactor != 1.0) {
            a = ArrayMath.mul(a, scaleFactor);
        }
        if (addOffset != 0.0) {
            a = ArrayMath.add(a, addOffset);
        }
        return a;
    }

    public static Array sort(Array a, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == null) {
            int[] nshape = new int[]{(int)a.getSize()};
            Array r = Array.factory(a.getDataType(), nshape);
            ArrayList<Object> tlist = new ArrayList<Object>();
            IndexIterator ii = a.getIndexIterator();
            while (ii.hasNext()) {
                tlist.add(ii.getObjectNext());
            }
            Collections.sort(tlist);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setObject(i, tlist.get(i));
                ++i;
            }
            return r;
        }
        if (axis == -1) {
            axis = n - 1;
        }
        int nn = shape[axis];
        Array r = Array.factory(a.getDataType(), shape);
        Index indexr = r.getIndex();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < n; ++i) {
            if (i == axis) {
                ranges.add(new Range(0, 0, 1));
                continue;
            }
            ranges.add(new Range(0, shape[i] - 1, 1));
        }
        IndexIterator rii = r.sectionNoReduce(ranges).getIndexIterator();
        while (rii.hasNext()) {
            rii.next();
            int[] current = rii.getCurrentCounter();
            ranges = new ArrayList();
            for (int j = 0; j < n; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, shape[j] - 1, 1));
                    continue;
                }
                ranges.add(new Range(current[j], current[j], 1));
            }
            ArrayList<Object> tlist = new ArrayList<Object>();
            IndexIterator ii = a.getRangeIterator(ranges);
            while (ii.hasNext()) {
                tlist.add(ii.getObjectNext());
            }
            Collections.sort(tlist);
            for (int j = 0; j < nn; ++j) {
                indexr.set(current);
                r.setObject(indexr, tlist.get(j));
                current[axis.intValue()] = current[axis] + 1;
            }
        }
        return r;
    }

    public static Array argSort(Array a, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == null) {
            int[] nshape = new int[]{(int)a.getSize()};
            Array r = Array.factory(DataType.INT, nshape);
            ArrayList<Object> stlist = new ArrayList<Object>();
            IndexIterator ii = a.getIndexIterator();
            while (ii.hasNext()) {
                Object v = ii.getObjectNext();
                stlist.add(v);
            }
            ListIndexComparator comparator = new ListIndexComparator(stlist);
            Integer[] indexes = comparator.createIndexArray();
            Arrays.sort(indexes, comparator);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setInt(i, (int)indexes[i]);
                ++i;
            }
            return r;
        }
        if (axis == -1) {
            axis = n - 1;
        }
        int nn = shape[axis];
        Array r = Array.factory(DataType.INT, shape);
        Index indexr = r.getIndex();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < n; ++i) {
            if (i == axis) {
                ranges.add(new Range(0, 0, 1));
                continue;
            }
            ranges.add(new Range(0, shape[i] - 1, 1));
        }
        IndexIterator rii = r.sectionNoReduce(ranges).getIndexIterator();
        while (rii.hasNext()) {
            rii.next();
            int[] current = rii.getCurrentCounter();
            ranges = new ArrayList();
            for (int j = 0; j < n; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, shape[j] - 1, 1));
                    continue;
                }
                ranges.add(new Range(current[j], current[j], 1));
            }
            ArrayList<Object> stlist = new ArrayList<Object>();
            IndexIterator ii = a.getRangeIterator(ranges);
            while (ii.hasNext()) {
                Object v = ii.getObjectNext();
                stlist.add(v);
            }
            ListIndexComparator comparator = new ListIndexComparator(stlist);
            Integer[] indexes = comparator.createIndexArray();
            Arrays.sort(indexes, comparator);
            for (int j = 0; j < nn; ++j) {
                indexr.set(current);
                r.setObject(indexr, (Object)indexes[j]);
                current[axis.intValue()] = current[axis] + 1;
            }
        }
        return r;
    }

    public static int searchSorted(Array a, Number v, boolean left) {
        int idx = -1;
        switch (a.getDataType()) {
            case BYTE: {
                idx = Arrays.binarySearch((byte[])a.getStorage(), v.byteValue());
                break;
            }
            case INT: {
                idx = Arrays.binarySearch((int[])a.getStorage(), v.intValue());
                break;
            }
            case SHORT: {
                idx = Arrays.binarySearch((short[])a.getStorage(), v.shortValue());
                break;
            }
            case LONG: {
                idx = Arrays.binarySearch((long[])a.getStorage(), v.longValue());
                break;
            }
            case FLOAT: {
                idx = Arrays.binarySearch((float[])a.getStorage(), v.floatValue());
                break;
            }
            case DOUBLE: {
                idx = Arrays.binarySearch((double[])a.getStorage(), v.doubleValue());
            }
        }
        if (idx < 0) {
            idx = idx == -1 ? 0 : -idx - 1;
            if (!left) {
                ++idx;
            }
        }
        return idx;
    }

    public static Array searchSorted(Array a, Array v, boolean left) {
        a = a.copyIfView();
        v = v.copyIfView();
        Array idx = Array.factory(DataType.INT, v.getShape());
        int i = 0;
        while ((long)i < idx.getSize()) {
            idx.setInt(i, ArrayUtil.searchSorted(a, v.getDouble(i), left));
            ++i;
        }
        return idx;
    }

    public static Array[] unique(Array a, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == null) {
            ArrayList<Object> tList = new ArrayList<Object>();
            IndexIterator ii = a.getIndexIterator();
            while (ii.hasNext()) {
                Object o = ii.getObjectNext();
                if (tList.contains(o)) continue;
                tList.add(o);
            }
            Collections.sort(tList);
            int[] nShape = new int[]{tList.size()};
            Array r = Array.factory(a.getDataType(), nShape);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setObject(i, tList.get(i));
                ++i;
            }
            return new Array[]{r};
        }
        if (axis == -1) {
            axis = n - 1;
        }
        ArrayList<Array> tList = new ArrayList<Array>();
        int nn = shape[axis];
        shape[axis.intValue()] = 1;
        int[] origin = new int[shape.length];
        for (int i = 0; i < nn; ++i) {
            origin[axis.intValue()] = i;
            Array ta = a.section(origin, shape);
            if (tList.contains(ta)) continue;
            tList.add(ta);
        }
        shape[axis.intValue()] = tList.size();
        Array r = Array.factory(a.getDataType(), shape);
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            ranges.add(new Range(0, shape[i] - 1, 1));
        }
        Range range = (Range)ranges.get(axis);
        for (int i = 0; i < tList.size(); ++i) {
            range = new Range(i, i, 1);
            ranges.set(axis, range);
            ArrayMath.setSection(r, ranges, (Array)tList.get(i));
        }
        return new Array[]{r};
    }

    public static boolean isUnique(Array a, int limit) {
        IndexIterator iter = a.getIndexIterator();
        ArrayList<Object> values = new ArrayList<Object>();
        boolean n = false;
        while (iter.hasNext()) {
            Object v = iter.getObjectNext();
            if (!values.contains(v)) {
                values.add(v);
            }
            if (values.size() <= limit) continue;
            return false;
        }
        return true;
    }

    public static Array[] unique(Array a, Integer axis, boolean returnIndex, boolean returnInverse, boolean returnCounts) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        ArrayList<Array> result = new ArrayList<Array>();
        if (axis == null) {
            int i;
            Object o;
            ArrayList<Object> tList = new ArrayList<Object>();
            ArrayList<Integer> idxList = new ArrayList<Integer>();
            ArrayList<Integer> countList = new ArrayList<Integer>();
            IndexIterator ii = a.getIndexIterator();
            int idx = 0;
            if (returnCounts) {
                while (ii.hasNext()) {
                    o = ii.getObjectNext();
                    int i2 = tList.indexOf(o);
                    if (i2 < 0) {
                        tList.add(o);
                        idxList.add(idx);
                        countList.add(1);
                    } else {
                        countList.set(i2, (Integer)countList.get(i2) + 1);
                    }
                    ++idx;
                }
            } else {
                while (ii.hasNext()) {
                    o = ii.getObjectNext();
                    if (!tList.contains(o)) {
                        tList.add(o);
                        idxList.add(idx);
                    }
                    ++idx;
                }
            }
            List sortIndex = MIMath.sort(tList);
            int nv = tList.size();
            int[] nShape = new int[]{nv};
            Array r = Array.factory(a.getDataType(), nShape);
            for (int i3 = 0; i3 < nv; ++i3) {
                r.setObject(i3, tList.get(i3));
            }
            result.add(r);
            if (returnIndex) {
                Array index = Array.factory(DataType.INT, nShape);
                for (i = 0; i < nv; ++i) {
                    index.setInt(i, (int)((Integer)idxList.get((Integer)sortIndex.get(i))));
                }
                result.add(index);
            }
            if (returnInverse) {
                int na = (int)a.getSize();
                Array inverse = Array.factory(DataType.INT, new int[]{na});
                ii = a.getIndexIterator();
                IndexIterator iterInverse = inverse.getIndexIterator();
                while (ii.hasNext()) {
                    o = ii.getObjectNext();
                    iterInverse.setObjectNext(tList.indexOf(o));
                }
                result.add(inverse);
            }
            if (returnCounts) {
                Array counts = Array.factory(DataType.INT, nShape);
                for (i = 0; i < nv; ++i) {
                    counts.setInt(i, (int)((Integer)countList.get((Integer)sortIndex.get(i))));
                }
                result.add(counts);
            }
        } else {
            int nv;
            Array ta;
            int i;
            if (axis == -1) {
                axis = n - 1;
            }
            ArrayList<Array> tList = new ArrayList<Array>();
            ArrayList<Integer> idxList = new ArrayList<Integer>();
            ArrayList<Integer> countList = new ArrayList<Integer>();
            int nn = shape[axis];
            shape[axis.intValue()] = 1;
            int[] origin = new int[shape.length];
            if (returnCounts) {
                for (i = 0; i < nn; ++i) {
                    origin[axis.intValue()] = i;
                    ta = a.section(origin, shape);
                    int idx = tList.indexOf(ta);
                    if (idx < 0) {
                        tList.add(ta);
                        idxList.add(i);
                        countList.add(1);
                        continue;
                    }
                    countList.set(idx, (Integer)countList.get(idx) + 1);
                }
            } else {
                for (i = 0; i < nn; ++i) {
                    origin[axis.intValue()] = i;
                    ta = a.section(origin, shape);
                    if (tList.contains(ta)) continue;
                    tList.add(ta);
                    idxList.add(i);
                }
            }
            shape[axis.intValue()] = nv = tList.size();
            Array r = Array.factory(a.getDataType(), shape);
            Array index = Array.factory(DataType.INT, new int[]{nv});
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i4 = 0; i4 < shape.length; ++i4) {
                ranges.add(new Range(0, shape[i4] - 1, 1));
            }
            Range range = (Range)ranges.get(axis);
            Iterator iter = tList.iterator();
            int i5 = 0;
            while (iter.hasNext()) {
                Array arr = (Array)iter.next();
                range = new Range(i5, i5, 1);
                ranges.set(axis, range);
                ArrayMath.setSection(r, ranges, arr);
                index.setInt(i5, (int)((Integer)idxList.get(i5)));
                ++i5;
            }
            result.add(r);
            if (returnIndex) {
                result.add(index);
            }
            if (returnInverse) {
                int na = (int)a.getSize();
                Array inverse = Array.factory(DataType.INT, new int[]{na});
                IndexIterator ii = a.getIndexIterator();
                IndexIterator iterInverse = inverse.getIndexIterator();
                while (ii.hasNext()) {
                    Object o = ii.getObjectNext();
                    iterInverse.setObjectNext(tList.indexOf(o));
                }
                result.add(inverse);
            }
            if (returnCounts) {
                Array counts = Array.factory(DataType.INT, shape);
                for (i5 = 0; i5 < nv; ++i5) {
                    counts.setInt(i5, (int)((Integer)countList.get(i5)));
                }
                result.add(counts);
            }
        }
        return (Array[])result.stream().toArray(Array[]::new);
    }

    public static Object copyToNDJavaArray(Array a, String dtype) {
        if (dtype == null) {
            return ArrayUtil.copyToNDJavaArray(a);
        }
        switch (dtype.toLowerCase()) {
            case "double": {
                return ArrayUtil.copyToNDJavaArray_Double(a);
            }
            case "long": {
                return ArrayUtil.copyToNDJavaArray_Long(a);
            }
        }
        return ArrayUtil.copyToNDJavaArray(a);
    }

    public static Object copyToNDJavaArray(Array a) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(a.getDataType().getPrimitiveClassType(), a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter);
        return javaArray;
    }

    public static Object copyToNDJavaArray_Long(Array a) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(Long.TYPE, a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter);
        return javaArray;
    }

    public static Object copyToNDJavaArray_Double(Array a) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(Double.TYPE, a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter);
        return javaArray;
    }

    public static Object copyToNDJavaArray_Double(Array a, double missingValue) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(Double.TYPE, a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter, missingValue);
        return javaArray;
    }

    private static void reflectArrayCopyOut(Object jArray, Array aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (!cType.isArray()) {
            if (cType == Long.TYPE) {
                ArrayUtil.copyTo1DJavaArray_Long(aaIter, jArray);
            } else if (cType == Double.TYPE) {
                ArrayUtil.copyTo1DJavaArray_Double(aaIter, jArray);
            } else {
                ArrayUtil.copyTo1DJavaArray(aaIter, jArray);
            }
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                ArrayUtil.reflectArrayCopyOut(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    private static void reflectArrayCopyOut(Object jArray, Array aa, IndexIterator aaIter, double missingValue) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (!cType.isArray()) {
            if (cType == Long.TYPE) {
                ArrayUtil.copyTo1DJavaArray_Long(aaIter, jArray);
            } else if (cType == Double.TYPE) {
                ArrayUtil.copyTo1DJavaArray_Double(aaIter, jArray, missingValue);
            } else {
                ArrayUtil.copyTo1DJavaArray(aaIter, jArray, missingValue);
            }
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                ArrayUtil.reflectArrayCopyOut(java.lang.reflect.Array.get(jArray, i), aa, aaIter, missingValue);
            }
        }
    }

    protected static void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        for (int i = 0; i < java.lang.reflect.Array.getLength(javaArray); ++i) {
            java.lang.reflect.Array.set(javaArray, i, iter.getObjectNext());
        }
    }

    protected static void copyTo1DJavaArray(IndexIterator iter, Object javaArray, double missingValue) {
        for (int i = 0; i < java.lang.reflect.Array.getLength(javaArray); ++i) {
            double v = iter.getDoubleNext();
            if (Double.isNaN(v)) {
                java.lang.reflect.Array.set(javaArray, i, missingValue);
                continue;
            }
            java.lang.reflect.Array.set(javaArray, i, v);
        }
    }

    protected static void copyTo1DJavaArray_Long(IndexIterator iter, Object javaArray) {
        long[] ja = (long[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getLongNext();
        }
    }

    protected static void copyTo1DJavaArray_Double(IndexIterator iter, Object javaArray) {
        double[] ja = (double[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getDoubleNext();
        }
    }

    protected static void copyTo1DJavaArray_Double(IndexIterator iter, Object javaArray, double missingValue) {
        double[] ja = (double[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            double v = iter.getDoubleNext();
            if (Double.isNaN(v)) {
                v = missingValue;
            }
            ja[i] = v;
        }
    }

    public static Array delete(Array a, int idx, int axis) {
        int[] shape = a.getShape();
        int n = shape.length;
        int[] nshape = new int[n];
        for (int i = 0; i < n; ++i) {
            nshape[i] = i == axis ? shape[i] - 1 : shape[i];
        }
        Array r = Array.factory(a.getDataType(), nshape);
        IndexIterator ii = a.getIndexIterator();
        int i = 0;
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            if (current[axis] == idx) continue;
            r.setObject(i, ii.getObjectCurrent());
            ++i;
        }
        return r;
    }

    public static Array delete(Array a, List<Integer> idx, int axis) {
        int[] shape = a.getShape();
        int n = shape.length;
        int[] nshape = new int[n];
        for (int i = 0; i < n; ++i) {
            nshape[i] = i == axis ? shape[i] - idx.size() : shape[i];
        }
        Array r = Array.factory(a.getDataType(), nshape);
        IndexIterator ii = a.getIndexIterator();
        int i = 0;
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            if (idx.contains(current[axis])) continue;
            r.setObject(i, ii.getObjectCurrent());
            ++i;
        }
        return r;
    }

    public static List<Array> nonzero(Array a) {
        ArrayList r = new ArrayList();
        int ndim = a.getRank();
        for (int i = 0; i < ndim; ++i) {
            r.add(new ArrayList());
        }
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            if (Double.isNaN(v) || v == 0.0) continue;
            int[] counter = iterA.getCurrentCounter();
            for (int j = 0; j < ndim; ++j) {
                ((List)r.get(j)).add(counter[j]);
            }
        }
        if (((List)r.get(0)).isEmpty()) {
            return null;
        }
        ArrayList<Array> ra = new ArrayList<Array>();
        for (int i = 0; i < ndim; ++i) {
            ra.add(ArrayUtil.array(r.get(i), null));
        }
        return ra;
    }

    public static Array flatNonZero(Array a) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        IndexIterator iterA = a.getIndexIterator();
        int i = 0;
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            if (!Double.isNaN(v) && v != 0.0) {
                r.add(i);
            }
            ++i;
        }
        return ArrayUtil.array(r, DataType.INT);
    }

    public static Array where(Array a, Array x, Array y) {
        DataType dataType = ArrayMath.commonType(x.getDataType(), y.getDataType());
        Array r = Array.factory(dataType, a.getShape());
        IndexIterator iterA = a.getIndexIterator();
        IndexIterator iterX = x.getIndexIterator();
        IndexIterator iterY = y.getIndexIterator();
        IndexIterator iterR = r.getIndexIterator();
        while (iterR.hasNext()) {
            double v = iterA.getDoubleNext();
            if (!Double.isNaN(v) && v != 0.0) {
                iterR.setObjectNext(iterX.getObjectNext());
                iterY.next();
                continue;
            }
            iterR.setObjectNext(iterY.getObjectNext());
            iterX.next();
        }
        return r;
    }

    public static List<Array> histogram(Array a, int nbins) {
        double min = ArrayMath.getMinimum(a);
        double max = ArrayMath.getMaximum(a);
        double interval = BigDecimalUtil.div(BigDecimalUtil.sub(max, min), nbins);
        double[] bins = new double[nbins + 1];
        for (int i = 0; i < nbins + 1; ++i) {
            bins[i] = min;
            min = BigDecimalUtil.add(min, interval);
        }
        Array ba = Array.factory(DataType.DOUBLE, new int[]{bins.length}, (Object)bins);
        return ArrayUtil.histogram(a, ba);
    }

    public static List<Array> histogram(Array a, Array bins) {
        int n = (int)bins.getSize();
        Array hist = Array.factory(DataType.INT, new int[]{n - 1});
        IndexIterator iterA = a.getIndexIterator();
        block0: while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            for (int j = 0; j < n - 1; ++j) {
                if (j == n - 2) {
                    if (!(v >= bins.getDouble(j)) || !(v <= bins.getDouble(j + 1))) continue;
                    hist.setInt(j, hist.getInt(j) + 1);
                    continue block0;
                }
                if (!(v >= bins.getDouble(j)) || !(v < bins.getDouble(j + 1))) continue;
                hist.setInt(j, hist.getInt(j) + 1);
                continue block0;
            }
        }
        ArrayList<Array> r = new ArrayList<Array>();
        r.add(hist);
        r.add(bins);
        return r;
    }

    public static List<Array> histogram(Array a, double[] bins) {
        int n = bins.length;
        double delta = bins[1] - bins[0];
        int[] count = new int[n + 1];
        IndexIterator iterA = a.getIndexIterator();
        block0: while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            if (v < bins[0]) {
                count[0] = count[0] + 1;
                continue;
            }
            if (v > bins[n - 1]) {
                int n2 = n;
                count[n2] = count[n2] + 1;
                continue;
            }
            for (int j = 0; j < n - 1; ++j) {
                if (!(v > bins[j]) || !(v < bins[j + 1])) continue;
                int n3 = j + 1;
                count[n3] = count[n3] + 1;
                continue block0;
            }
        }
        Array x = Array.factory(DataType.DOUBLE, new int[]{count.length + 1});
        Array y = Array.factory(DataType.INT, new int[]{count.length});
        for (int i = 0; i < count.length; ++i) {
            y.setInt(i, count[i]);
            if (i == 0) {
                x.setDouble(0, bins[0] - delta);
                x.setDouble(1, bins[0]);
                continue;
            }
            if (i == count.length - 1) {
                x.setDouble(i + 1, bins[i - 1] + delta);
                continue;
            }
            x.setDouble(i + 1, bins[i]);
        }
        ArrayList<Array> r = new ArrayList<Array>();
        r.add(y);
        r.add(x);
        return r;
    }

    public static int[] broadcastShapes(List<List<Integer>> shapes) {
        int ndim = 0;
        for (List<Integer> shape : shapes) {
            if (ndim >= shape.size()) continue;
            ndim = shape.size();
        }
        int[] newShape = new int[ndim];
        for (List<Integer> shape : shapes) {
            int nn = shape.size();
            for (int n : shape) {
                if (newShape[ndim - nn] < n) {
                    newShape[ndim - nn] = n;
                }
                --nn;
            }
        }
        return newShape;
    }

    public static Array broadcast(Array a, int[] shape) {
        int i;
        int[] bshape = a.getShape();
        if (bshape.length > shape.length) {
            return null;
        }
        if (bshape.length < shape.length) {
            int miss = shape.length - a.getRank();
            bshape = new int[shape.length];
            for (i = 0; i < shape.length; ++i) {
                bshape[i] = i < miss ? 1 : a.getShape()[i - miss];
            }
            a = a.reshape(bshape);
        }
        boolean pass = true;
        for (i = 0; i < shape.length; ++i) {
            if (shape[i] == bshape[i] || bshape[i] == 1) continue;
            pass = false;
            break;
        }
        if (!pass) {
            return null;
        }
        Index aindex = a.getIndex();
        Array r = Array.factory(a.getDataType(), shape);
        Index index = r.getIndex();
        int i2 = 0;
        while ((long)i2 < r.getSize()) {
            int[] current = index.getCurrentCounter();
            for (int j = 0; j < shape.length; ++j) {
                if (bshape[j] == 1) {
                    aindex.setDim(j, 0);
                    continue;
                }
                aindex.setDim(j, current[j]);
            }
            r.setObject(index, a.getObject(aindex));
            index.incr();
            ++i2;
        }
        return r;
    }

    public static Array broadcast(Array a, List<Integer> shape) {
        int[] nshape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            nshape[i] = shape.get(i);
        }
        return ArrayUtil.broadcast(a, nshape);
    }

    public static Array[] meshgrid(Array x, Array y) {
        int xn = (int)x.getSize();
        int yn = (int)y.getSize();
        int[] shape = new int[]{yn, xn};
        Array rx = Array.factory(x.getDataType(), shape);
        Array ry = Array.factory(y.getDataType(), shape);
        IndexIterator iterY = y.getIndexIterator();
        for (int i = 0; i < yn; ++i) {
            Object yv = iterY.getObjectNext();
            IndexIterator iterX = x.getIndexIterator();
            for (int j = 0; j < xn; ++j) {
                Object xv = iterX.getObjectNext();
                rx.setObject(i * xn + j, xv);
                ry.setObject(i * xn + j, yv);
            }
        }
        return new Array[]{rx, ry};
    }

    public static Array[] meshgrid(Array x) {
        return ArrayUtil.meshgrid(new Array[]{x, x});
    }

    public static Array[] meshgrid(Array ... xs) {
        Array x;
        int n = xs.length;
        if (n == 1) {
            xs = new Array[]{xs[0], xs[0]};
            n = 2;
        }
        int[] shape = new int[n];
        int i = 0;
        for (i = 0; i < n; ++i) {
            x = xs[i];
            shape[n - i - 1] = (int)x.getSize();
        }
        Array[] rs = new Array[n];
        for (int s = 0; s < n; ++s) {
            x = xs[s];
            Array r = Array.factory(xs[s].getDataType(), shape);
            Index index = r.getIndex();
            Index xIndex = x.getIndex();
            i = 0;
            while ((long)i < r.getSize()) {
                int idx = index.getCurrentCounter()[n - s - 1];
                r.setObject(index, x.getObject(xIndex.set0(idx)));
                index.incr();
                ++i;
            }
            rs[s] = r;
        }
        return rs;
    }

    public static Array smooth5(Array a, int rowNum, int colNum, double unDefData) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        double s = 0.5;
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        if (Double.isNaN(unDefData)) {
            for (int i = 0; i < rowNum; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    if (i == 0 || i == rowNum - 1 || j == 0 || j == colNum - 1) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    if (Double.isNaN(a.getDouble(i * colNum + j)) || Double.isNaN(a.getDouble((i + 1) * colNum + j)) || Double.isNaN(a.getDouble((i - 1) * colNum + j)) || Double.isNaN(a.getDouble(i * colNum + j + 1)) || Double.isNaN(a.getDouble(i * colNum + j - 1))) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    r.setDouble(i * colNum + j, a.getDouble(i * colNum + j) + s / 4.0 * (a.getDouble((i + 1) * colNum + j) + a.getDouble((i - 1) * colNum + j) + a.getDouble(i * colNum + j + 1) + a.getDouble(i * colNum + j - 1) - 4.0 * a.getDouble(i * colNum + j)));
                }
            }
        } else {
            for (int i = 0; i < rowNum; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    if (i == 0 || i == rowNum - 1 || j == 0 || j == colNum - 1) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    if (a.getDouble(i * colNum + j) == unDefData || a.getDouble((i + 1) * colNum + j) == unDefData || a.getDouble((i - 1) * colNum + j) == unDefData || a.getDouble(i * colNum + j + 1) == unDefData || a.getDouble(i * colNum + j - 1) == unDefData) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    r.setDouble(i * colNum + j, a.getDouble(i * colNum + j) + s / 4.0 * (a.getDouble((i + 1) * colNum + j) + a.getDouble((i - 1) * colNum + j) + a.getDouble(i * colNum + j + 1) + a.getDouble(i * colNum + j - 1) - 4.0 * a.getDouble(i * colNum + j)));
                }
            }
        }
        return r;
    }

    public static Array smooth5(Array a) {
        int[] shape = a.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        Array r = Array.factory(a.getDataType(), shape);
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        Index2D index = new Index2D(shape);
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                double sum = 0.0;
                double wsum = 0.0;
                for (int ii = i - 1; ii <= i + 1; ++ii) {
                    if (ii < 0 || ii >= rowNum) continue;
                    for (int jj = j - 1; jj <= j + 1; ++jj) {
                        double v;
                        if (jj < 0 || jj >= colNum || (ii == i - 1 || ii == i + 1) && jj != j || Double.isNaN(v = a.getDouble(index.set(ii, jj)))) continue;
                        double w = ii == i && jj == j ? 1.0 : 0.5;
                        sum += v * w;
                        wsum += w;
                    }
                }
                index.set(i, j);
                if (wsum > 0.0) {
                    r.setDouble(index, sum / wsum);
                    continue;
                }
                r.setDouble(index, Double.NaN);
            }
        }
        return r;
    }

    public static Array smooth9(Array a) {
        int[] shape = a.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        Array r = Array.factory(a.getDataType(), shape);
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        Index2D index = new Index2D(shape);
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                double sum = 0.0;
                double wsum = 0.0;
                for (int ii = i - 1; ii <= i + 1; ++ii) {
                    if (ii < 0 || ii >= rowNum) continue;
                    for (int jj = j - 1; jj <= j + 1; ++jj) {
                        double v;
                        if (jj < 0 || jj >= colNum || Double.isNaN(v = a.getDouble(index.set(ii, jj)))) continue;
                        double w = ii == i && jj == j ? 1.0 : (ii == i || jj == j ? 0.5 : 0.3);
                        sum += v * w;
                        wsum += w;
                    }
                }
                index.set(i, j);
                if (wsum > 0.0) {
                    r.setDouble(index, sum / wsum);
                    continue;
                }
                r.setDouble(index, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_Nearest_1(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, double radius, double fill_value) {
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array rdata = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        int rr = (int)Math.ceil(radius);
        List<int[]> pIJ = ArrayUtil.getPointsIJ(x_s, y_s, X, Y);
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        for (int i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                rdata.setDouble(i * colNum + j, fill_value);
                double gx = X.get(j).doubleValue();
                double minr = Double.MAX_VALUE;
                List<Integer> pIdx = ArrayUtil.getPointsIdx(pIJ, i, j, rr);
                for (int p : pIdx) {
                    double y;
                    double x;
                    double r;
                    double v = a.getDouble(p);
                    if (MIMath.doubleEquals((double)v, (double)fill_value) || !((r = Math.sqrt((gx - (x = x_s.get(p).doubleValue())) * (gx - x) + (gy - (y = y_s.get(p).doubleValue())) * (gy - y))) < minr)) continue;
                    rdata.setDouble(i * colNum + j, v);
                    minr = r;
                }
            }
        }
        return rdata;
    }

    public static Array interpolation_Nearest_bak(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, double radius) {
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array rdata = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        for (int i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                rdata.setDouble(i * colNum + j, Double.NaN);
                double gx = X.get(j).doubleValue();
                double minr = Double.MAX_VALUE;
                for (int p = 0; p < pNum; ++p) {
                    double r;
                    double v = a.getDouble(p);
                    if (Double.isNaN(v)) continue;
                    double x = x_s.get(p).doubleValue();
                    double y = y_s.get(p).doubleValue();
                    if (Math.abs(gx - x) > radius || Math.abs(gy - y) > radius || !((r = Math.sqrt((gx - x) * (gx - x) + (gy - y) * (gy - y))) < radius) || !(r < minr)) continue;
                    rdata.setDouble(i * colNum + j, v);
                    minr = r;
                }
            }
        }
        return rdata;
    }

    public static Array[] extendHalfCell(Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        double dX = x.getDouble(1) - x.getDouble(0);
        double dY = y.getDouble(1) - y.getDouble(0);
        int nx = (int)x.getSize() + 1;
        int ny = (int)y.getSize() + 1;
        Array rx = Array.factory(DataType.DOUBLE, new int[]{nx});
        Array ry = Array.factory(DataType.DOUBLE, new int[]{ny});
        int i = 0;
        while ((long)i < rx.getSize()) {
            if ((long)i == rx.getSize() - 1L) {
                rx.setDouble(i, x.getDouble(i - 1) + dX * 0.5);
            } else {
                rx.setDouble(i, x.getDouble(i) - dX * 0.5);
            }
            ++i;
        }
        i = 0;
        while ((long)i < ry.getSize()) {
            if ((long)i == ry.getSize() - 1L) {
                ry.setDouble(i, y.getDouble(i - 1) + dY * 0.5);
            } else {
                ry.setDouble(i, y.getDouble(i) - dY * 0.5);
            }
            ++i;
        }
        return new Array[]{rx, ry};
    }

    public static Array interpolation_Inside(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y) {
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        a = a.copyIfView();
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] == 0) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * colNum + j, r.getDouble(i * colNum + j) / (double)pNums[i][j]);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Mean(Array x_s, Array y_s, Array a, Array X, Array Y, boolean center) {
        int j;
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        if (center) {
            Array[] xy = ArrayUtil.extendHalfCell(X, Y);
            X = xy[0];
            Y = xy[1];
        }
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        if (center) {
            // empty if block
        }
        int pNum = (int)x_s.getSize();
        Array r = Array.factory(DataType.DOUBLE, new int[]{--rowNum, --colNum});
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        int[][] pNums = new int[rowNum][colNum];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.getDouble(p);
            double y = y_s.getDouble(p);
            if (x < X.getDouble(0) || x > X.getDouble(colNum - 1) || y < Y.getDouble(0) || y > Y.getDouble(rowNum - 1)) continue;
            j = (int)((x - X.getDouble(0)) / dX);
            int i2 = (int)((y - Y.getDouble(0)) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] == 0) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * colNum + j, r.getDouble(i * colNum + j) / (double)pNums[i][j]);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Max(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y) {
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double min = Double.NEGATIVE_INFINITY;
        a = a.copyIfView();
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, min);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.max(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && !Double.isInfinite(r.getDouble(i * colNum + j))) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Min(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y) {
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double max = Double.MAX_VALUE;
        a = a.copyIfView();
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, max);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.min(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && r.getDouble(i * colNum + j) != Double.MAX_VALUE) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Object interpolation_Inside_Count(List<Number> x_s, List<Number> y_s, List<Number> X, List<Number> Y, boolean pointDensity, boolean centerPoint) {
        double y;
        double x;
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.INT, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
            }
        }
        for (int p = 0; p < pNum; ++p) {
            x = x_s.get(p).doubleValue();
            y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                r.setInt(i * colNum + j, pNums[i][j]);
            }
        }
        if (pointDensity) {
            Array pds = Array.factory(DataType.INT, new int[]{pNum});
            for (int p = 0; p < pNum; ++p) {
                x = x_s.get(p).doubleValue();
                y = y_s.get(p).doubleValue();
                if (x < sx || x > ex || y < sy || y > ey) continue;
                int j2 = (int)((x - sx) / dX);
                int i3 = (int)((y - sy) / dY);
                pds.setInt(p, pNums[i3][j2]);
            }
            return new Array[]{r, pds};
        }
        return r;
    }

    private static List<int[]> getPointsIJ(List<Number> x_s, List<Number> y_s, List<Number> X, List<Number> Y) {
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        ArrayList<int[]> pIndices = new ArrayList<int[]>();
        for (int p = 0; p < pNum; ++p) {
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            int j = (int)((x - X.get(0).doubleValue()) / dX);
            int i = (int)((y - Y.get(0).doubleValue()) / dY);
            pIndices.add(new int[]{i, j});
        }
        return pIndices;
    }

    private static List<Integer> getPointsIdx(List<int[]> pIJ, int ii, int jj, int radius) {
        ArrayList<Integer> pIdx = new ArrayList<Integer>();
        for (int p = 0; p < pIJ.size(); ++p) {
            int[] ij = pIJ.get(p);
            int i = ij[0];
            int j = ij[1];
            if (Math.abs(i - ii) > radius || Math.abs(j - jj) > radius) continue;
            pIdx.add(p);
        }
        return pIdx;
    }

    public static Array cressman(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double syi;
        double sxi;
        double sy;
        double sx;
        double val;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double xMax = X.get(xNum - 1).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double yMax = Y.get(yNum - 1).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int stNum = 0;
        double[][] stationData = new double[pNum][3];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = (x - xMin) / xDelt;
            stationData[i][1] = (y - yMin) / yDelt;
            stationData[i][2] = v_s.getDouble(i);
            if (Double.isNaN(stationData[i][2])) continue;
            ++stNum;
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            yMin = y - rad;
            yMax = y + rad;
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                xMin = x - rad;
                xMax = x + rad;
                stNum = 0;
                sum = 0.0;
                for (int s = 0; s < pNum; ++s) {
                    double dis;
                    val = stationData[s][2];
                    sx = x_s.get(s).doubleValue();
                    sy = y_s.get(s).doubleValue();
                    sxi = stationData[s][0];
                    syi = stationData[s][1];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                yMin = y - rad;
                yMax = y + rad;
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    xMin = x - rad;
                    xMax = x + rad;
                    sum = 0.0;
                    double wSum = 0.0;
                    for (int s = 0; s < pNum; ++s) {
                        double calVal;
                        double dis;
                        val = stationData[s][2];
                        sx = x_s.get(s).doubleValue();
                        sy = y_s.get(s).doubleValue();
                        sxi = stationData[s][0];
                        syi = stationData[s][1];
                        if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array cressman_bak(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double sum;
        double xMax;
        double yMax;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int stNum = 0;
        double[][] stationData = new double[pNum][3];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = (x - xMin) / xDelt;
            stationData[i][1] = (y - yMin) / yDelt;
            stationData[i][2] = v_s.getDouble(i);
            if (Double.isNaN(stationData[i][2])) continue;
            ++stNum;
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = i;
            yMin = y - rad;
            yMax = y + rad;
            for (j = 0; j < xNum; ++j) {
                x = j;
                xMin = x - rad;
                xMax = x + rad;
                stNum = 0;
                sum = 0.0;
                for (int s = 0; s < pNum; ++s) {
                    double dis;
                    double val = stationData[s][2];
                    double sx = stationData[s][0];
                    double sy = stationData[s][1];
                    if (sx < 0.0 || sx >= (double)(xNum - 1) || sy < 0.0 || sy >= (double)(yNum - 1) || Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = i;
                yMin = y - rad;
                yMax = y + rad;
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = j;
                    xMin = x - rad;
                    xMax = x + rad;
                    sum = 0.0;
                    double wSum = 0.0;
                    for (int s = 0; s < pNum; ++s) {
                        double calVal;
                        double dis;
                        double val = stationData[s][2];
                        double sx = stationData[s][0];
                        double sy = stationData[s][1];
                        if (sx < 0.0 || sx >= (double)(xNum - 1) || sy < 0.0 || sy >= (double)(yNum - 1) || Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                        int i1 = (int)sy;
                        int j1 = (int)sx;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (sy - (double)i1);
                            double x2val = b + (d - b) * (sy - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sx - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (wSum < 1.0E-6) {
                        r.setDouble(i * xNum + j, Double.NaN);
                        continue;
                    }
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array linint2(Array a, Array X, Array Y, Array newX, Array newY) {
        int xn = (int)newX.getSize();
        int yn = (int)newY.getSize();
        int[] shape = a.getShape();
        int n = shape.length;
        shape[n - 1] = xn;
        shape[n - 2] = yn;
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index index = r.getIndex();
        int k = 0;
        while ((long)k < r.getSize()) {
            int[] counter = index.getCurrentCounter();
            int yi = counter[n - 2];
            int xi = counter[n - 1];
            double y = newY.getDouble(yi);
            double x = newX.getDouble(xi);
            double v = ArrayUtil.bilinear(a, index, X, Y, x, y);
            r.setDouble(index, v);
            index.incr();
            ++k;
        }
        return r;
    }

    public static Array slice(Array a, int axis, int idx) throws InvalidRangeException {
        a = a.copyIfView();
        int ndim = a.getRank();
        int[] dShape = a.getShape();
        if (idx < 0 || idx >= dShape[axis]) {
            return null;
        }
        int[] origin = new int[ndim];
        int[] shape = new int[ndim];
        for (int i = 0; i < ndim; ++i) {
            if (i == axis) {
                origin[i] = idx;
                shape[i] = 1;
                continue;
            }
            origin[i] = 0;
            shape[i] = dShape[i];
        }
        Array r = a.section(origin, shape);
        return r;
    }

    public static Array slice(Array a, int axis, Array dim, double v) throws InvalidRangeException {
        a = a.copyIfView();
        dim = dim.copyIfView();
        int ndim = a.getRank();
        int[] dShape = a.getShape();
        int n = (int)dim.getSize();
        int idx = ArrayUtil.getDimIndex(dim, v);
        if (idx == -1 || idx == -(n + 1)) {
            return null;
        }
        if (idx >= 0) {
            int[] origin = new int[ndim];
            int[] shape = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                if (i == axis) {
                    origin[i] = idx;
                    shape[i] = 1;
                    continue;
                }
                origin[i] = 0;
                shape[i] = dShape[i];
            }
            Array r = a.section(origin, shape);
            return r;
        }
        int[] origin = new int[ndim];
        int[] shape = new int[ndim];
        int si = -idx - 2;
        int ei = si + 1;
        for (int i = 0; i < ndim; ++i) {
            if (i == axis) {
                origin[i] = si;
                shape[i] = 1;
                continue;
            }
            origin[i] = 0;
            shape[i] = dShape[i];
        }
        Array rs = a.section(origin, shape);
        origin[axis] = ei;
        Array re = a.section(origin, shape);
        double sv = dim.getDouble(si);
        double ev = dim.getDouble(ei);
        double ratio = (v - sv) / (ev - sv);
        Array r = Array.factory(a.getDataType(), rs.getShape());
        IndexIterator rIter = r.getIndexIterator();
        IndexIterator sIter = rs.getIndexIterator();
        IndexIterator eIter = re.getIndexIterator();
        while (rIter.hasNext()) {
            sv = sIter.getDoubleNext();
            ev = eIter.getDoubleNext();
            rIter.setDoubleNext(sv + (ev - sv) * ratio);
        }
        return r;
    }

    public static Array resample_Bilinear(Array a, List<Number> X, List<Number> Y, List<Number> newX, List<Number> newY) {
        int xn = newX.size();
        int yn = newY.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yn, xn});
        if (!a.getIndexPrivate().isFastIterator()) {
            a = a.copy();
        }
        for (int i = 0; i < yn; ++i) {
            double y = newY.get(i).doubleValue();
            for (int j = 0; j < xn; ++j) {
                double x = newX.get(j).doubleValue();
                if (x < X.get(0).doubleValue() || x > X.get(X.size() - 1).doubleValue()) {
                    r.setDouble(i * xn + j, Double.NaN);
                    continue;
                }
                if (y < Y.get(0).doubleValue() || y > Y.get(Y.size() - 1).doubleValue()) {
                    r.setDouble(i * xn + j, Double.NaN);
                    continue;
                }
                double v = ArrayUtil.toStation(a, X, Y, x, y);
                r.setDouble(i * xn + j, v);
            }
        }
        return r;
    }

    public static Array resample_Bilinear(Array a, Array X, Array Y, Array newX, Array newY) {
        int n = (int)newX.getSize();
        Array r = Array.factory(DataType.DOUBLE, newX.getShape());
        for (int i = 0; i < n; ++i) {
            double x = newX.getDouble(i);
            double y = newY.getDouble(i);
            if (x < X.getDouble(0) || x > X.getDouble((int)X.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            if (y < Y.getDouble(0) || y > Y.getDouble((int)Y.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            double v = ArrayUtil.toStation(a, X, Y, x, y);
            r.setDouble(i, v);
        }
        return r;
    }

    public static Array resample_Neighbor(Array a, Array X, Array Y, Array newX, Array newY) {
        int n = (int)newX.getSize();
        Array r = Array.factory(DataType.DOUBLE, newX.getShape());
        for (int i = 0; i < n; ++i) {
            double x = newX.getDouble(i);
            double y = newY.getDouble(i);
            if (x < X.getDouble(0) || x > X.getDouble((int)X.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            if (y < Y.getDouble(0) || y > Y.getDouble((int)Y.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            double v = ArrayUtil.toStation_Neighbor(a, X, Y, x, y);
            r.setDouble(i, v);
        }
        return r;
    }

    public Array interpolate(Array a, List<Number> X, List<Number> Y) {
        int i;
        int nxNum = X.size() * 2 - 1;
        int nyNum = Y.size() * 2 - 1;
        ArrayList<Number> newX = new ArrayList<Number>();
        ArrayList<Number> newY = new ArrayList<Number>();
        for (i = 0; i < nxNum; ++i) {
            if (i % 2 == 0) {
                newX.add(X.get(i / 2).doubleValue());
                continue;
            }
            newX.add((X.get((i - 1) / 2).doubleValue() + X.get((i - 1) / 2 + 1).doubleValue()) / 2.0);
        }
        for (i = 0; i < nyNum; ++i) {
            if (i % 2 == 0) {
                newY.add(Y.get(i / 2).doubleValue());
                continue;
            }
            newY.add((Y.get((i - 1) / 2).doubleValue() + Y.get((i - 1) / 2 + 1).doubleValue()) / 2.0);
        }
        return ArrayUtil.resample_Bilinear(a, X, Y, newX, newY);
    }

    public static double interpn_s(List<List<Number>> points, Array values, List<Number> xi) {
        Object[] r = ArrayUtil.findIndices(points, xi);
        boolean outBounds = (Boolean)r[2];
        if (outBounds) {
            return Double.NaN;
        }
        Index index = values.getIndex();
        int[] indices = (int[])r[0];
        double[] distances = (double[])r[1];
        double v = 0.0;
        ArrayList<Index> ii = new ArrayList<Index>();
        ArrayUtil.iterIndex(ii, index, indices, 0);
        int n = indices.length;
        for (Index idx : ii) {
            double weight = 1.0;
            for (int i = 0; i < n; ++i) {
                weight *= idx.getCurrentCounter()[i] == indices[i] ? 1.0 - distances[i] : distances[i];
            }
            v += values.getDouble(idx) * weight;
        }
        return v;
    }

    public static double interpn_s(List<Array> points, Array values, Array xi) {
        Object[] r = ArrayUtil.findIndices(points, xi);
        boolean outBounds = (Boolean)r[2];
        if (outBounds) {
            return Double.NaN;
        }
        Index index = values.getIndex();
        int[] indices = (int[])r[0];
        double[] distances = (double[])r[1];
        double v = 0.0;
        ArrayList<Index> ii = new ArrayList<Index>();
        ArrayUtil.iterIndex(ii, index, indices, 0);
        int n = indices.length;
        for (Index idx : ii) {
            double weight = 1.0;
            for (int i = 0; i < n; ++i) {
                weight *= idx.getCurrentCounter()[i] == indices[i] ? 1.0 - distances[i] : distances[i];
            }
            v += values.getDouble(idx) * weight;
        }
        return v;
    }

    public static Array interpn(List<Array> points, Array values, List<Array> xi) {
        int n = xi.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        for (int i = 0; i < n; ++i) {
            Array x = xi.get(i);
            r.setDouble(i, ArrayUtil.interpn_s(points, values, x));
        }
        return r;
    }

    public static Object interpn(List<Array> points, Array values, Array xi) throws InvalidRangeException {
        if (xi.getRank() == 1) {
            return ArrayUtil.interpn_s(points, values, xi);
        }
        int n = xi.getShape()[0];
        int m = xi.getShape()[1];
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        for (int i = 0; i < n; ++i) {
            Array x = xi.section(new int[]{i, 0}, new int[]{1, m});
            r.setDouble(i, ArrayUtil.interpn_s(points, values, x));
        }
        return r;
    }

    private static void iterIndex(List<Index> ii, Index index, int[] indices, int idx) {
        int n = indices.length;
        if (idx < n - 1) {
            index.setDim(idx, indices[idx]);
            ArrayUtil.iterIndex(ii, index, indices, idx + 1);
            if (indices[idx] < index.getShape(idx) - 1) {
                index.setDim(idx, indices[idx] + 1);
                ArrayUtil.iterIndex(ii, index, indices, idx + 1);
            }
        } else {
            index.setDim(idx, indices[idx]);
            ii.add((Index)index.clone());
            if (indices[idx] < index.getShape(idx) - 1) {
                index.setDim(idx, indices[idx] + 1);
            }
            ii.add((Index)index.clone());
        }
    }

    public static Object[] findIndices(List<List<Number>> points, List<Number> xi) {
        int n = points.size();
        int[] indices = new int[n];
        double[] distances = new double[n];
        boolean outBounds = false;
        for (int i = 0; i < n; ++i) {
            double x = xi.get(i).doubleValue();
            List<Number> a = points.get(i);
            int idx = ArrayUtil.searchSorted(a, x);
            if (idx < 0) {
                outBounds = true;
                idx = 0;
            }
            indices[i] = idx;
            distances[i] = (x - a.get(idx).doubleValue()) / (a.get(idx + 1).doubleValue() - a.get(idx).doubleValue());
        }
        return new Object[]{indices, distances, outBounds};
    }

    public static Object[] findIndices(List<Array> points, Array xi) {
        int n = points.size();
        int[] indices = new int[n];
        double[] distances = new double[n];
        boolean outBounds = false;
        for (int i = 0; i < n; ++i) {
            double x = xi.getDouble(i);
            Array a = points.get(i);
            int idx = ArrayUtil.searchSorted(a, x);
            if (idx < 0) {
                outBounds = true;
                idx = 0;
            }
            indices[i] = idx;
            distances[i] = (long)idx == a.getSize() - 1L ? 0.0 : (x - a.getDouble(idx)) / (a.getDouble(idx + 1) - a.getDouble(idx));
        }
        return new Object[]{indices, distances, outBounds};
    }

    public static int searchSorted(List<Number> a, double v) {
        int idx = -1;
        int n = a.size();
        if (a.get(1).doubleValue() > a.get(0).doubleValue()) {
            if (v < a.get(0).doubleValue()) {
                return idx;
            }
            if (v > a.get(n - 1).doubleValue()) {
                return idx;
            }
            for (int i = 1; i < n; ++i) {
                if (!(v < a.get(i).doubleValue())) continue;
                idx = i - 1;
                break;
            }
        } else {
            if (v > a.get(0).doubleValue()) {
                return idx;
            }
            if (v < a.get(n - 1).doubleValue()) {
                return idx;
            }
            for (int i = 1; i < n; ++i) {
                if (!(v > a.get(i).doubleValue())) continue;
                idx = i - 1;
                break;
            }
        }
        return idx;
    }

    public static int searchSorted(Array a, double v) {
        a = a.copyIfView();
        int idx = -1;
        int n = (int)a.getSize();
        if (a.getDouble(1) > a.getDouble(0)) {
            if (v < a.getDouble(0)) {
                return idx;
            }
            if (v > a.getDouble(n - 1)) {
                return idx;
            }
            idx = n - 1;
            for (int i = 1; i < n; ++i) {
                if (!(v < a.getDouble(i))) continue;
                idx = i - 1;
                break;
            }
        } else {
            if (v > a.getDouble(0)) {
                return idx;
            }
            if (v < a.getDouble(n - 1)) {
                return idx;
            }
            idx = n - 1;
            for (int i = 1; i < n; ++i) {
                if (!(v > a.getDouble(i))) continue;
                idx = i - 1;
                break;
            }
        }
        return idx;
    }

    public static int[] searchSorted1(Array a, double v) {
        a = a.copyIfView();
        int n = (int)a.getSize();
        int[] idx = null;
        for (int i = 1; i < n; ++i) {
            double v1 = a.getDouble(i - 1);
            double v2 = a.getDouble(i);
            if (v < v2 && v >= v1) {
                idx = new int[]{i - 1, i};
                break;
            }
            if (!(v < v1) || !(v >= v2)) continue;
            idx = new int[]{i, i - 1};
            break;
        }
        return idx;
    }

    public static Array interpolate_1d(double x, Array xp, Array a, int axis) throws InvalidRangeException {
        int[] dataShape = xp.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            if (i < axis) {
                shape[i] = dataShape[i];
                continue;
            }
            if (i <= axis) continue;
            shape[i - 1] = dataShape[i];
        }
        Array r = Array.factory(a.getDataType(), shape);
        Index indexr = r.getIndex();
        Index indexa = a.getIndex();
        int[] dcurrent = new int[dataShape.length];
        int i = 0;
        while ((long)i < r.getSize()) {
            int idx;
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
                dcurrent[j] = current[idx];
            }
            Array tArray = ArrayMath.section(xp, ranges);
            idx = ArrayUtil.searchSorted(tArray, x);
            if (idx < 0) {
                r.setDouble(i, Double.NaN);
            } else if (idx == dataShape[axis] - 1) {
                dcurrent[axis] = idx;
                r.setObject(i, a.getObject(indexa.set(dcurrent)));
            } else {
                dcurrent[axis] = idx;
                indexa.set(dcurrent);
                double belowp = xp.getDouble(indexa);
                double belowa = a.getDouble(indexa);
                dcurrent[axis] = idx + 1;
                indexa.set(dcurrent);
                double abovep = xp.getDouble(indexa);
                double abovea = a.getDouble(indexa);
                r.setDouble(i, (x - belowp) / (abovep - belowp) * (abovea - belowa) + belowa);
            }
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array interpolate_1d(Array xa, Array xp, Array a, int axis) throws InvalidRangeException {
        int[] dataShape = xp.getShape();
        int[] shape = new int[dataShape.length];
        int[] tshape = new int[shape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            if (i == axis) {
                shape[i] = xa.getShape()[0];
                continue;
            }
            shape[i] = dataShape[i];
            if (i < axis) {
                tshape[i] = dataShape[i];
                continue;
            }
            tshape[i - 1] = dataShape[i];
        }
        Array r = Array.factory(a.getDataType(), shape);
        Array rr = Array.factory(DataType.BYTE, tshape);
        Index indexrr = rr.getIndex();
        Index indexr = r.getIndex();
        Index indexa = a.getIndex();
        int[] currenta = new int[dataShape.length];
        int[] currentr = new int[shape.length];
        int i = 0;
        while ((long)i < rr.getSize()) {
            int idx;
            int j;
            int[] currentrr = indexrr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(currentrr[idx], currentrr[idx], 1));
                currenta[j] = currentrr[idx];
                currentr[j] = currentrr[idx];
            }
            Array tArray = ArrayMath.section(xp, ranges).copy();
            j = 0;
            while ((long)j < xa.getSize()) {
                double x = xa.getDouble(j);
                idx = ArrayUtil.searchSorted(tArray, x);
                currentr[axis] = j;
                indexr.set(currentr);
                if (idx < 0) {
                    r.setDouble(indexr, Double.NaN);
                } else if (idx == dataShape[axis] - 1) {
                    currenta[axis] = idx;
                    r.setObject(indexr, a.getObject(indexa.set(currenta)));
                } else {
                    currenta[axis] = idx;
                    indexa.set(currenta);
                    double belowp = xp.getDouble(indexa);
                    double belowa = a.getDouble(indexa);
                    currenta[axis] = idx + 1;
                    indexa.set(currenta);
                    double abovep = xp.getDouble(indexa);
                    double abovea = a.getDouble(indexa);
                    r.setDouble(indexr, (x - belowp) / (abovep - belowp) * (abovea - belowa) + belowa);
                }
                ++j;
            }
            indexrr.incr();
            ++i;
        }
        return r;
    }

    public static double toStation(Array data, List<Number> xArray, List<Number> yArray, double x, double y, double missingValue) {
        int i;
        double iValue = Double.NaN;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a) && !MIMath.doubleEquals((double)a, (double)missingValue)) {
            dList.add(a);
        }
        if (!Double.isNaN(b) && !MIMath.doubleEquals((double)b, (double)missingValue)) {
            dList.add(b);
        }
        if (!Double.isNaN(c) && !MIMath.doubleEquals((double)c, (double)missingValue)) {
            dList.add(c);
        }
        if (!Double.isNaN(d) && !MIMath.doubleEquals((double)d, (double)missingValue)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xArray.get(xIdx + 1).doubleValue() - xArray.get(xIdx).doubleValue();
            double dy = yArray.get(yIdx + 1).doubleValue() - yArray.get(yIdx).doubleValue();
            double x1val = a + (c - a) * (y - yArray.get(i1).doubleValue()) / dy;
            double x2val = b + (d - b) * (y - yArray.get(i1).doubleValue()) / dy;
            iValue = x1val + (x2val - x1val) * (x - xArray.get(j1).doubleValue()) / dx;
        }
        return iValue;
    }

    public static double toStation(Array data, List<Number> xArray, List<Number> yArray, double x, double y) {
        int i;
        double iValue = Double.NaN;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xArray.get(xIdx + 1).doubleValue() - xArray.get(xIdx).doubleValue();
            double dy = yArray.get(yIdx + 1).doubleValue() - yArray.get(yIdx).doubleValue();
            double x1val = a + (c - a) * (y - yArray.get(i1).doubleValue()) / dy;
            double x2val = b + (d - b) * (y - yArray.get(i1).doubleValue()) / dy;
            iValue = x1val + (x2val - x1val) * (x - xArray.get(j1).doubleValue()) / dx;
        }
        return iValue;
    }

    public static int getDimIndex(Array dim, Number v) {
        dim = dim.copyIfView();
        switch (dim.getDataType()) {
            case BYTE: {
                return Arrays.binarySearch((byte[])dim.getStorage(), v.byteValue());
            }
            case INT: {
                return Arrays.binarySearch((int[])dim.getStorage(), v.intValue());
            }
            case SHORT: {
                return Arrays.binarySearch((short[])dim.getStorage(), v.shortValue());
            }
            case LONG: {
                return Arrays.binarySearch((long[])dim.getStorage(), v.longValue());
            }
            case FLOAT: {
                return Arrays.binarySearch((float[])dim.getStorage(), v.floatValue());
            }
            case DOUBLE: {
                return Arrays.binarySearch((double[])dim.getStorage(), v.doubleValue());
            }
        }
        int n = (int)dim.getSize();
        if (v.doubleValue() < dim.getDouble(0) || v.doubleValue() > dim.getDouble(n - 1)) {
            return -1;
        }
        int idx = n - 1;
        for (int i = 1; i < n; ++i) {
            if (!(v.doubleValue() < dim.getDouble(i))) continue;
            idx = i - 1;
            break;
        }
        return idx;
    }

    public static int[] gridIndex(Array xdim, Array ydim, double x, double y) {
        if (xdim.getRank() == 1) {
            int yIdx;
            int xn = (int)xdim.getSize();
            int yn = (int)ydim.getSize();
            int xIdx = ArrayUtil.getDimIndex(xdim, x);
            if (xIdx == -1 || xIdx == -(xn + 1)) {
                return null;
            }
            if (xIdx < 0) {
                xIdx = -xIdx - 2;
            }
            if ((yIdx = ArrayUtil.getDimIndex(ydim, y)) == -1 || yIdx == -(yn + 1)) {
                return null;
            }
            if (yIdx < 0) {
                yIdx = -yIdx - 2;
            }
            if (xIdx == xn - 1) {
                xIdx = xn - 2;
            }
            if (yIdx == yn - 1) {
                yIdx = yn - 2;
            }
            return new int[]{yIdx, xIdx};
        }
        int xIdx = -1;
        int yIdx = -1;
        int[] shape = xdim.getShape();
        int yn = shape[0];
        int xn = shape[1];
        Index index = new Index2D(shape);
        for (int i = 0; i < yn - 1; ++i) {
            for (int j = 0; j < xn - 1; ++j) {
                index = index.set(i, j);
                double y1 = ydim.getDouble(index);
                index = index.set(i + 1, j);
                double y2 = ydim.getDouble(index);
                if (!(y >= y1) || !(y < y2)) continue;
                index = index.set(i, j);
                double x1 = xdim.getDouble(index);
                index = index.set(i, j + 1);
                double x2 = xdim.getDouble(index);
                if (!(x >= x1) || !(x < x2)) continue;
                yIdx = i;
                xIdx = j;
            }
        }
        if (yIdx >= 0 && xIdx >= 0) {
            return new int[]{yIdx, xIdx};
        }
        return null;
    }

    public static int[] gridIndex(double[][] xdim, double[][] ydim, double x, double y) {
        int xIdx = -1;
        int yIdx = -1;
        int yn = xdim.length;
        int xn = xdim[0].length;
        for (int i = 0; i < yn - 1; ++i) {
            for (int j = 0; j < xn - 1; ++j) {
                if (!(y >= ydim[i][j]) || !(y < ydim[i + 1][j]) || !(x >= xdim[i][j]) || !(x < xdim[i][j + 1])) continue;
                yIdx = i;
                xIdx = j;
            }
        }
        if (yIdx >= 0 && xIdx >= 0) {
            return new int[]{yIdx, xIdx};
        }
        return null;
    }

    private static double bilinear(Array data, Index dindex, Array xdim, Array ydim, double x, double y) {
        xdim = xdim.copyIfView();
        ydim = ydim.copyIfView();
        double iValue = Double.NaN;
        int[] xyIdx = ArrayUtil.gridIndex(xdim, ydim, x, y);
        if (xyIdx == null) {
            return iValue;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        int n = index.getRank();
        for (int i = 0; i < n - 2; ++i) {
            index.setDim(i, dindex.getCurrentCounter()[i]);
        }
        index.setDim(n - 2, i1);
        index.setDim(n - 1, j1);
        double a = data.getDouble(index);
        index.setDim(n - 1, j2);
        double b = data.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j1);
        double c = data.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j2);
        double d = data.getDouble(index);
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xdim.getDouble(j1 + 1) - xdim.getDouble(j1);
            double dy = ydim.getDouble(i1 + 1) - ydim.getDouble(i1);
            double x1val = a + (c - a) * (y - ydim.getDouble(i1)) / dy;
            double x2val = b + (d - b) * (y - ydim.getDouble(i1)) / dy;
            iValue = x1val + (x2val - x1val) * (x - xdim.getDouble(j1)) / dx;
        }
        return iValue;
    }

    public static double toStation(Array data, Array xArray, Array yArray, double x, double y) {
        int i;
        xArray = xArray.copyIfView();
        yArray = yArray.copyIfView();
        double iValue = Double.NaN;
        int nx = (int)xArray.getSize();
        int ny = (int)yArray.getSize();
        if (x < xArray.getDouble(0) || x > xArray.getDouble(nx - 1) || y < yArray.getDouble(0) || y > yArray.getDouble(ny - 1)) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.getDouble(i))) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.getDouble(i))) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xArray.getDouble(xIdx + 1) - xArray.getDouble(xIdx);
            double dy = yArray.getDouble(yIdx + 1) - yArray.getDouble(yIdx);
            double x1val = a + (c - a) * (y - yArray.getDouble(i1)) / dy;
            double x2val = b + (d - b) * (y - yArray.getDouble(i1)) / dy;
            iValue = x1val + (x2val - x1val) * (x - xArray.getDouble(j1)) / dx;
        }
        return iValue;
    }

    public static double toStation_Neighbor(Array data, List<Number> xArray, List<Number> yArray, double x, double y, double missingValue) {
        int i;
        double iValue = Double.NaN;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        iValue = Math.abs(x - xArray.get(j1).doubleValue()) < Math.abs(xArray.get(j2).doubleValue() - x) ? (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? a : c) : (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? b : d);
        return iValue;
    }

    public static double toStation_Neighbor(Array data, List<Number> xArray, List<Number> yArray, double x, double y) {
        int i;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return Double.NaN;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        double iValue = Math.abs(x - xArray.get(j1).doubleValue()) < Math.abs(xArray.get(j2).doubleValue() - x) ? (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? a : c) : (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? b : d);
        return iValue;
    }

    public static double toStation_Neighbor(Array data, Array xArray, Array yArray, double x, double y) {
        int i;
        xArray = xArray.copyIfView();
        yArray = yArray.copyIfView();
        int nx = (int)xArray.getSize();
        int ny = (int)yArray.getSize();
        if (x < xArray.getDouble(0) || x > xArray.getDouble(nx - 1) || y < yArray.getDouble(0) || y > yArray.getDouble(ny - 1)) {
            return Double.NaN;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.getDouble(i))) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.getDouble(i))) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        double iValue = Math.abs(x - xArray.getDouble(j1)) < Math.abs(xArray.getDouble(j2) - x) ? (Math.abs(y - yArray.getDouble(i1)) < Math.abs(yArray.getDouble(i2) - y) ? a : c) : (Math.abs(y - yArray.getDouble(i1)) < Math.abs(yArray.getDouble(i2) - y) ? b : d);
        return iValue;
    }
}

