/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core;

import java.util.Arrays;
import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;

public abstract class BaseProvider
implements RestorableUniformRandomProvider {
    private static final long GOLDEN_RATIO_64 = -7046029254386353131L;
    private static final int GOLDEN_RATIO_32 = -1640531527;

    public RandomProviderState saveState() {
        return new RandomProviderDefaultState(this.getStateInternal());
    }

    public void restoreState(RandomProviderState state) {
        if (!(state instanceof RandomProviderDefaultState)) {
            throw new IllegalArgumentException("Foreign instance");
        }
        this.setStateInternal(((RandomProviderDefaultState)state).getState());
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected byte[] composeStateInternal(byte[] state, byte[] parentState) {
        int len = parentState.length + state.length;
        byte[] c = new byte[len];
        System.arraycopy(state, 0, c, 0, state.length);
        System.arraycopy(parentState, 0, c, state.length, parentState.length);
        return c;
    }

    protected byte[][] splitStateInternal(byte[] state, int localStateLength) {
        this.checkStateSize(state, localStateLength);
        byte[] local = new byte[localStateLength];
        System.arraycopy(state, 0, local, 0, localStateLength);
        int parentLength = state.length - localStateLength;
        byte[] parent = new byte[parentLength];
        System.arraycopy(state, localStateLength, parent, 0, parentLength);
        return new byte[][]{local, parent};
    }

    protected byte[] getStateInternal() {
        return new byte[0];
    }

    protected void setStateInternal(byte[] state) {
        if (state.length != 0) {
            throw new IllegalStateException("State not fully recovered by subclasses");
        }
    }

    protected void fillState(int[] state, int[] seed) {
        int stateSize = state.length;
        int seedSize = seed.length;
        System.arraycopy(seed, 0, state, 0, Math.min(seedSize, stateSize));
        if (seedSize < stateSize) {
            for (int i = seedSize; i < stateSize; ++i) {
                state[i] = (int)(BaseProvider.scrambleWell(state[i - seed.length], i) & 0xFFFFFFFFL);
            }
        }
    }

    protected void fillState(long[] state, long[] seed) {
        int stateSize = state.length;
        int seedSize = seed.length;
        System.arraycopy(seed, 0, state, 0, Math.min(seedSize, stateSize));
        if (seedSize < stateSize) {
            for (int i = seedSize; i < stateSize; ++i) {
                state[i] = BaseProvider.scrambleWell(state[i - seed.length], i);
            }
        }
    }

    @Deprecated
    protected void checkStateSize(byte[] state, int expected) {
        if (state.length < expected) {
            throw new IllegalStateException("State size must be larger than " + expected + " but was " + state.length);
        }
    }

    protected void checkIndex(int min, int max, int index) {
        if (index < min || index > max) {
            throw new IndexOutOfBoundsException(index + " is out of interval [" + min + ", " + max + "]");
        }
    }

    private static long scramble(long n, long mult, int shift, int add) {
        return mult * (n ^ n >> shift) + (long)add;
    }

    private static long scrambleWell(long n, int add) {
        return BaseProvider.scramble(n, 1812433253L, 30, add);
    }

    protected static long[] extendSeed(long[] seed, int length) {
        if (seed.length < length) {
            long[] s = Arrays.copyOf(seed, length);
            long x = s[0];
            for (int i = seed.length; i < length; ++i) {
                s[i] = BaseProvider.stafford13(x += -7046029254386353131L);
            }
            return s;
        }
        return seed;
    }

    protected static int[] extendSeed(int[] seed, int length) {
        if (seed.length < length) {
            int[] s = Arrays.copyOf(seed, length);
            int x = s[0];
            for (int i = seed.length; i < length; ++i) {
                s[i] = BaseProvider.murmur3(x -= 1640531527);
            }
            return s;
        }
        return seed;
    }

    private static long stafford13(long x) {
        x = (x ^ x >>> 30) * -4658895280553007687L;
        x = (x ^ x >>> 27) * -7723592293110705685L;
        return x ^ x >>> 31;
    }

    private static int murmur3(int x) {
        x = (x ^ x >>> 16) * -2048144789;
        x = (x ^ x >>> 13) * -1028477387;
        return x ^ x >>> 16;
    }
}

