/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.analysis;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.GridDataSetting;
import org.meteoinfo.geo.analysis.InterpolationMethods;

public class InterpolationSetting {
    private GridDataSetting _gridDataPara = new GridDataSetting();
    private InterpolationMethods _gridInterMethod;
    private int _minPointNum;
    private double _radius;
    private double _missingValue = -9999.0;
    private List<Double> _radList;
    private double beta = 1.5;

    public InterpolationSetting() {
        double[] values;
        this._gridDataPara.xNum = 50;
        this._gridDataPara.yNum = 50;
        this._gridInterMethod = InterpolationMethods.IDW_RADIUS;
        this._minPointNum = 1;
        this._radius = 1.0;
        this._radList = new ArrayList<Double>();
        for (double v : values = new double[]{10.0, 7.0, 4.0, 2.0, 1.0}) {
            this._radList.add(v);
        }
    }

    public InterpolationSetting(double minX, double maxX, double minY, double maxY, int xNum, int yNum, String aInterMethod, float radius, int minNum) {
        double[] values;
        GridDataSetting aGDP = new GridDataSetting();
        aGDP.dataExtent.minX = minX;
        aGDP.dataExtent.maxX = maxX;
        aGDP.dataExtent.minY = minY;
        aGDP.dataExtent.maxY = maxY;
        aGDP.xNum = xNum;
        aGDP.yNum = yNum;
        this._gridDataPara = aGDP;
        this._gridInterMethod = InterpolationMethods.valueOf(aInterMethod);
        this._radius = radius;
        this._minPointNum = minNum;
        this._radList = new ArrayList<Double>();
        for (double v : values = new double[]{10.0, 7.0, 4.0, 2.0, 1.0}) {
            this._radList.add(v);
        }
    }

    public InterpolationSetting(double minX, double maxX, double minY, double maxY, int xNum, int yNum, String aInterMethod, List<Double> radList) {
        GridDataSetting aGDP = new GridDataSetting();
        aGDP.dataExtent.minX = minX;
        aGDP.dataExtent.maxX = maxX;
        aGDP.dataExtent.minY = minY;
        aGDP.dataExtent.maxY = maxY;
        aGDP.xNum = xNum;
        aGDP.yNum = yNum;
        this._gridDataPara = aGDP;
        this._gridInterMethod = InterpolationMethods.valueOf(aInterMethod);
        this._radList = radList;
        this._minPointNum = 1;
    }

    public GridDataSetting getGridDataSetting() {
        return this._gridDataPara;
    }

    public void setGridDataSetting(GridDataSetting value) {
        this._gridDataPara = value;
    }

    public InterpolationMethods getInterpolationMethod() {
        return this._gridInterMethod;
    }

    public void setInterpolationMethod(InterpolationMethods value) {
        this._gridInterMethod = value;
    }

    public int getMinPointNum() {
        return this._minPointNum;
    }

    public void setMinPointNum(int value) {
        this._minPointNum = value;
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double value) {
        this._radius = value;
    }

    public double getMissingValue() {
        return this._missingValue;
    }

    public void setMissingValue(double value) {
        this._missingValue = value;
    }

    public List<Double> getRadiusList() {
        return this._radList;
    }

    public void setRadiusList(List<Double> value) {
        this._radList = value;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double value) {
        this.beta = value;
    }
}

