/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.geo.layout.MapLayout;
import org.meteoinfo.geo.legend.LegendView;
import org.meteoinfo.geo.legend.SymbolControl;
import org.meteoinfo.geo.mapview.MapView;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ui.event.ISelectedCellChangedListener;
import org.meteoinfo.ui.event.SelectedCellChangedEvent;

public class FrmPolylineSymbolSet
extends JDialog {
    private Object _parent = null;
    private PolylineBreak _polylineBreak = null;
    private boolean isLoading = false;
    private JButton jButton_Apply;
    private JButton jButton_OK;
    private JCheckBox jCheckBox_DrawFill;
    private JCheckBox jCheckBox_DrawPointSymbol;
    private JCheckBox jCheckBox_DrawShape;
    private JComboBox jComboBox_SymbolStyle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel_Color;
    private JLabel jLabel_FillColor;
    private JLabel jLabel_SymbolColor;
    private JPanel jPanel1;
    private JSpinner jSpinner_Size;
    private JSpinner jSpinner_SymbolInterval;
    private JSpinner jSpinner_SymbolSize;
    private SymbolControl symbolControl1;

    public FrmPolylineSymbolSet(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Polyline Symbol Set");
    }

    public FrmPolylineSymbolSet(Dialog parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Polyline Symbol Set");
        if (tparent.getClass() == LegendView.class) {
            this.jButton_Apply.setVisible(false);
            this.jButton_OK.setVisible(false);
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
        }
        this.symbolControl1.addSelectedCellChangedListener(new ISelectedCellChangedListener(){

            public void selectedCellChangedEvent(SelectedCellChangedEvent event) {
                FrmPolylineSymbolSet.this.onSelectedCellChanged(event);
            }
        });
        this._parent = tparent;
    }

    public FrmPolylineSymbolSet(Frame parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Polyline Symbol Set");
        if (tparent.getClass() == LegendView.class) {
            this.jButton_Apply.setVisible(false);
            this.jButton_OK.setVisible(false);
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
        }
        this.symbolControl1.addSelectedCellChangedListener(new ISelectedCellChangedListener(){

            public void selectedCellChangedEvent(SelectedCellChangedEvent event) {
                FrmPolylineSymbolSet.this.onSelectedCellChanged(event);
            }
        });
        this._parent = tparent;
    }

    private void onSelectedCellChanged(SelectedCellChangedEvent event) {
        if (this.isLoading) {
            return;
        }
        this._polylineBreak.setStyle(LineStyles.values()[this.symbolControl1.getSelectedCell()]);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_PolylineStyle(this._polylineBreak.getStyle());
        }
    }

    private void initComponents() {
        this.symbolControl1 = new SymbolControl();
        this.jLabel1 = new JLabel();
        this.jSpinner_Size = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel_Color = new JLabel();
        this.jCheckBox_DrawShape = new JCheckBox();
        this.jCheckBox_DrawPointSymbol = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinner_SymbolSize = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel_SymbolColor = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSpinner_SymbolInterval = new JSpinner();
        this.jComboBox_SymbolStyle = new JComboBox();
        this.jCheckBox_DrawFill = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel_FillColor = new JLabel();
        this.jButton_Apply = new JButton();
        this.jButton_OK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.symbolControl1.setCellSize(new Dimension(50, 40));
        this.symbolControl1.setPreferredSize(new Dimension(200, 50));
        this.symbolControl1.setShapeType(ShapeTypes.POLYLINE);
        this.jLabel1.setText("Size:");
        this.jSpinner_Size.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(100.0f), Float.valueOf(0.5f)));
        this.jSpinner_Size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPolylineSymbolSet.this.jSpinner_SizeStateChanged(evt);
            }
        });
        this.jLabel2.setText("Color:");
        this.jLabel_Color.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_Color.setOpaque(true);
        this.jLabel_Color.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPolylineSymbolSet.this.jLabel_ColorMouseClicked(evt);
            }
        });
        this.jCheckBox_DrawShape.setText("Draw Shape");
        this.jCheckBox_DrawShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolylineSymbolSet.this.jCheckBox_DrawShapeActionPerformed(evt);
            }
        });
        this.jCheckBox_DrawPointSymbol.setText("Draw Point Symbol");
        this.jCheckBox_DrawPointSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolylineSymbolSet.this.jCheckBox_DrawPointSymbolActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Point Symbol"));
        this.jPanel1.setToolTipText("Outline");
        this.jPanel1.setName("Outline");
        this.jLabel3.setText("Size:");
        this.jSpinner_SymbolSize.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(100.0f), Float.valueOf(0.5f)));
        this.jSpinner_SymbolSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPolylineSymbolSet.this.jSpinner_SymbolSizeStateChanged(evt);
            }
        });
        this.jLabel4.setText("Outline Color:");
        this.jLabel_SymbolColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_SymbolColor.setOpaque(true);
        this.jLabel_SymbolColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPolylineSymbolSet.this.jLabel_SymbolColorMouseClicked(evt);
            }
        });
        this.jLabel5.setText("Interval:");
        this.jSpinner_SymbolInterval.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.jSpinner_SymbolInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPolylineSymbolSet.this.jSpinner_SymbolIntervalStateChanged(evt);
            }
        });
        this.jComboBox_SymbolStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_SymbolStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolylineSymbolSet.this.jComboBox_SymbolStyleActionPerformed(evt);
            }
        });
        this.jCheckBox_DrawFill.setText("Draw Fill");
        this.jCheckBox_DrawFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolylineSymbolSet.this.jCheckBox_DrawFillActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Fill Color:");
        this.jLabel_FillColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_FillColor.setOpaque(true);
        this.jLabel_FillColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPolylineSymbolSet.this.jLabel_FillColorMouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_SymbolStyle, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_SymbolSize, -2, 62, -2)))).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCheckBox_DrawFill))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_SymbolInterval, -2, 60, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_SymbolColor, -2, 59, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_FillColor, -2, 59, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_SymbolColor, -2, 19, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinner_SymbolSize, -2, -1, -2).addComponent(this.jLabel4))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_DrawFill).addComponent(this.jLabel6)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel_FillColor, -2, 19, -2).addGap(2, 2, 2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner_SymbolInterval, -2, -1, -2).addComponent(this.jComboBox_SymbolStyle, -2, -1, -2)).addContainerGap()));
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolylineSymbolSet.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolylineSymbolSet.this.jButton_OKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.symbolControl1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_Size, -2, 60, -2)).addComponent(this.jCheckBox_DrawShape)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Color, -2, 59, -2)).addComponent(this.jCheckBox_DrawPointSymbol)))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton_OK, -2, 71, -2).addGap(58, 58, 58).addComponent(this.jButton_Apply, -2, 82, -2).addGap(52, 52, 52)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.symbolControl1, -2, 92, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinner_Size, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_DrawShape)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel_Color, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_DrawPointSymbol))).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Apply).addComponent(this.jButton_OK, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jSpinner_SizeStateChanged(ChangeEvent evt) {
        float size = Float.parseFloat(this.jSpinner_Size.getValue().toString());
        this._polylineBreak.setWidth(size);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Size(size);
        }
    }

    private void jLabel_ColorMouseClicked(MouseEvent evt) {
        Color aColor = JColorChooser.showDialog(this.rootPane, null, this.jLabel_Color.getBackground());
        this.jLabel_Color.setBackground(aColor);
        this._polylineBreak.setColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Color(aColor);
        }
    }

    private void jCheckBox_DrawShapeActionPerformed(ActionEvent evt) {
        this._polylineBreak.setDrawShape(this.jCheckBox_DrawShape.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawShape(this.jCheckBox_DrawShape.isSelected());
        }
    }

    private void jCheckBox_DrawPointSymbolActionPerformed(ActionEvent evt) {
        this._polylineBreak.setDrawSymbol(this.jCheckBox_DrawPointSymbol.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawSymbol(this.jCheckBox_DrawPointSymbol.isSelected());
        }
    }

    private void jSpinner_SymbolSizeStateChanged(ChangeEvent evt) {
        float size = Float.parseFloat(this.jSpinner_SymbolSize.getValue().toString());
        this._polylineBreak.setSymbolSize(size);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_SymbolSize(size);
        }
    }

    private void jLabel_SymbolColorMouseClicked(MouseEvent evt) {
        Color aColor = JColorChooser.showDialog(this.rootPane, null, this.jLabel_SymbolColor.getBackground());
        this.jLabel_SymbolColor.setBackground(aColor);
        this._polylineBreak.setSymbolColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_SymbolColor(aColor);
        }
    }

    private void jSpinner_SymbolIntervalStateChanged(ChangeEvent evt) {
        int interval = Integer.parseInt(this.jSpinner_SymbolInterval.getValue().toString());
        this._polylineBreak.setSymbolInterval(interval);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_SymbolInterval(interval);
        }
    }

    private void jComboBox_SymbolStyleActionPerformed(ActionEvent evt) {
        if (this.isLoading) {
            return;
        }
        this._polylineBreak.setSymbolStyle(PointStyle.valueOf((String)this.jComboBox_SymbolStyle.getSelectedItem().toString()));
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_SymbolStyle(this._polylineBreak.getSymbolStyle());
        }
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        if (this._parent.getClass() == MapView.class) {
            ((MapView)this._parent).paintLayers();
        } else if (this._parent.getClass() == MapLayout.class) {
            ((MapLayout)this._parent).paintGraphics();
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        if (this._parent.getClass() == MapView.class) {
            ((MapView)this._parent).setDefPolylineBreak(this._polylineBreak);
            ((MapView)this._parent).paintLayers();
        } else if (this._parent.getClass() == MapLayout.class) {
            ((MapLayout)this._parent).setDefPolylineBreak(this._polylineBreak);
            ((MapLayout)this._parent).paintGraphics();
        }
        this.dispose();
    }

    private void jCheckBox_DrawFillActionPerformed(ActionEvent evt) {
        this._polylineBreak.setFillSymbol(this.jCheckBox_DrawFill.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).repaint();
        }
    }

    private void jLabel_FillColorMouseClicked(MouseEvent evt) {
        Color c = JColorChooser.showDialog(this.rootPane, null, this.jLabel_FillColor.getBackground());
        if (c == null) {
            return;
        }
        Color aColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        this.jLabel_FillColor.setBackground(aColor);
        this._polylineBreak.setSymbolFillColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).repaint();
        }
    }

    public void setPolylineBreak(PolylineBreak plb) {
        this._polylineBreak = plb;
        this.updateProperties();
    }

    private void updateProperties() {
        this.isLoading = true;
        this.jLabel_Color.setBackground(this._polylineBreak.getColor());
        this.jSpinner_Size.setValue(Float.valueOf(this._polylineBreak.getWidth()));
        this.jCheckBox_DrawShape.setSelected(this._polylineBreak.isDrawShape());
        this.jCheckBox_DrawPointSymbol.setSelected(this._polylineBreak.isDrawSymbol());
        this.jSpinner_SymbolSize.setValue(Float.valueOf(this._polylineBreak.getSymbolSize()));
        this.jLabel_SymbolColor.setBackground(this._polylineBreak.getSymbolColor());
        this.jSpinner_SymbolInterval.setValue(this._polylineBreak.getSymbolInterval());
        this.jComboBox_SymbolStyle.removeAllItems();
        for (PointStyle sName : PointStyle.values()) {
            this.jComboBox_SymbolStyle.addItem(sName);
        }
        this.jComboBox_SymbolStyle.setSelectedItem(this._polylineBreak.getSymbolStyle());
        this.jCheckBox_DrawFill.setSelected(this._polylineBreak.isFillSymbol());
        this.jLabel_FillColor.setBackground(this._polylineBreak.getSymbolFillColor());
        if (this._parent.getClass() == LegendView.class) {
            this.symbolControl1.setSymbolNumber(5);
        } else {
            this.symbolControl1.setSymbolNumber(LineStyles.values().length);
        }
        this.symbolControl1.setSelectedCell(Arrays.asList(LineStyles.values()).indexOf(this._polylineBreak.getStyle()));
        this.isLoading = false;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmPolylineSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmPolylineSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmPolylineSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmPolylineSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmPolylineSymbolSet dialog = new FrmPolylineSymbolSet((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

