/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.mapview;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.undo.UndoableEdit;
import org.apache.commons.imaging.ImageFormats;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Direction;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.data.mapdata.webmap.GeoPosition;
import org.meteoinfo.data.mapdata.webmap.GeoUtil;
import org.meteoinfo.data.mapdata.webmap.IWebMapPanel;
import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.data.mapdata.webmap.WebMapProvider;
import org.meteoinfo.geo.analysis.GeoComputation;
import org.meteoinfo.geo.gui.FrmMeasurement;
import org.meteoinfo.geo.layer.ChartSet;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geo.layer.LabelSet;
import org.meteoinfo.geo.layer.LayerCollection;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.RasterLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.layer.VisibleScale;
import org.meteoinfo.geo.layer.WebMapLayer;
import org.meteoinfo.geo.layout.Edge;
import org.meteoinfo.geo.legend.FrmLabelSymbolSet;
import org.meteoinfo.geo.legend.FrmPointSymbolSet;
import org.meteoinfo.geo.legend.FrmPolygonSymbolSet;
import org.meteoinfo.geo.legend.FrmPolylineSymbolSet;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geo.mapdata.MapDataManage;
import org.meteoinfo.geo.mapview.FrmIdentifer;
import org.meteoinfo.geo.mapview.FrmIdentiferGrid;
import org.meteoinfo.geo.mapview.FrmVerticeEdit;
import org.meteoinfo.geo.mapview.MapViewUndoRedo;
import org.meteoinfo.geo.mapview.MaskOut;
import org.meteoinfo.geo.mapview.MouseTools;
import org.meteoinfo.geo.mapview.ProjectionSet;
import org.meteoinfo.geo.util.GeoProjectionUtil;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.ChartGraphic;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.AlignType;
import org.meteoinfo.geometry.legend.ArrowBreak;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ChartBreak;
import org.meteoinfo.geometry.legend.ChartTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.HatchStyle;
import org.meteoinfo.geometry.legend.LabelBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.CurveLineShape;
import org.meteoinfo.geometry.shape.CurvePolygonShape;
import org.meteoinfo.geometry.shape.EllipseShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.Polygon;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.RectangleShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.StationModelShape;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindBarb;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.render.java2d.Draw;
import org.meteoinfo.table.Field;
import org.meteoinfo.ui.event.GraphicSelectedEvent;
import org.meteoinfo.ui.event.IGraphicSelectedListener;
import org.meteoinfo.ui.event.ILayersUpdatedListener;
import org.meteoinfo.ui.event.IProjectionChangedListener;
import org.meteoinfo.ui.event.IShapeSelectedListener;
import org.meteoinfo.ui.event.IUndoEditListener;
import org.meteoinfo.ui.event.IViewExtentChangedListener;
import org.meteoinfo.ui.event.LayersUpdatedEvent;
import org.meteoinfo.ui.event.ProjectionChangedEvent;
import org.meteoinfo.ui.event.ShapeSelectedEvent;
import org.meteoinfo.ui.event.UndoEditEvent;
import org.meteoinfo.ui.event.ViewExtentChangedEvent;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wcontour.Contour;

public class MapView
extends JPanel
implements IWebMapPanel {
    private final EventListenerList _listeners = new EventListenerList();
    private TileLoadListener tileLoadListener = new TileLoadListener((IWebMapPanel)this);
    public FrmIdentifer frmIdentifer = null;
    public FrmIdentiferGrid _frmIdentiferGrid = null;
    private FrmMeasurement _frmMeasure = null;
    private BufferedImage _mapBitmap = new BufferedImage(10, 10, 2);
    private boolean newPaint = false;
    private boolean doubleBuffer = true;
    private boolean _antiAlias = false;
    private boolean _pointAntiAlias = true;
    private boolean _highSpeedWheelZoom = true;
    private boolean _lockViewUpdate = false;
    private LayerCollection layers = new LayerCollection();
    private int _selectedLayer;
    private Extent _extent = new Extent();
    private Extent _viewExtent = new Extent();
    private Extent _drawExtent = new Extent();
    private double _scaleX = 1.0;
    private double _scaleY = 1.0;
    private boolean fixMapScale = false;
    private int zoomLevel = 1;
    private double _XYScaleFactor = 1.0;
    private Color _selectColor = Color.yellow;
    private boolean _isGeoMap = true;
    private boolean _isLayoutMap = false;
    private final ProjectionSet _projection = new ProjectionSet();
    private MouseTools _mouseTool = MouseTools.NONE;
    private VectorLayer _lonLatLayer = null;
    private GraphicCollection _graphicCollection = new GraphicCollection();
    private final GraphicCollection _selectedGraphics = new GraphicCollection();
    private GraphicCollection _visibleGraphics = new GraphicCollection();
    private java.awt.Rectangle _selectedRectangle = new java.awt.Rectangle();
    private Edge _resizeSelectedEdge = Edge.NONE;
    private java.awt.Rectangle _resizeRectangle = new java.awt.Rectangle();
    public boolean _drawIdentiferShape = false;
    private boolean _mouseDoubleClicked = false;
    Point _mouseDownPoint = new Point(0, 0);
    Point _mouseLastPos = new Point(0, 0);
    Point _mousePos = new Point(0, 0);
    private int _xShift = 0;
    private int _yShift = 0;
    private double _paintScale = 1.0;
    private MaskOut _maskOut;
    private GeneralPath _maskOutGraphicsPath = new GeneralPath();
    private FrmPointSymbolSet _frmPointSymbolSet = null;
    private FrmPolylineSymbolSet _frmPolylineSymbolSet = null;
    private FrmPolygonSymbolSet _frmPolygonSymbolSet = null;
    private FrmLabelSymbolSet _frmLabelSymbolSet = null;
    private boolean _startNewGraphic = true;
    private List<PointF> _graphicPoints = new ArrayList<PointF>();
    private PointBreak _defPointBreak = new PointBreak();
    private LabelBreak _defLabelBreak = new LabelBreak();
    private PolylineBreak _defPolylineBreak = new PolylineBreak();
    private PolygonBreak _defPolygonBreak = new PolygonBreak();
    private final List<PointD> _editingVertices = new ArrayList<PointD>();
    private int _editingVerticeIndex;
    private boolean _dragMode = false;
    private boolean _multiGlobalDraw = true;
    private List<String> _xGridStrs = new ArrayList<String>();
    private List<String> _yGridStrs = new ArrayList<String>();
    private final List<Object[]> _xGridPosLabel = new ArrayList<Object[]>();
    private final List<Object[]> _yGridPosLabel = new ArrayList<Object[]>();
    private boolean _drawGridTickLine = false;
    private Color _gridLineColor = Color.gray;
    private float _gridLineSize = 1.0f;
    private LineStyles _gridLineStyle = LineStyles.DASH;
    private boolean _drawGridLine = false;
    private double _gridXDelt = 10.0;
    private double _gridYDelt = 10.0;
    private float _gridXOrigin = -180.0f;
    private float _gridYOrigin = -90.0f;
    private boolean _gridDeltChanged = false;
    private List<GridLabel> _gridLabels = new ArrayList<GridLabel>();
    private LocalDateTime _lastMouseWheelTime;
    private Timer _mouseWheelDetctionTimer;

    public MapView() {
        this.setSize(200, 200);
        this.setDoubleBuffered(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapView.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapView.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MapView.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MapView.this.onMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MapView.this.onMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                MapView.this.onMouseDragged(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                MapView.this.onMouseWheelMoved(e);
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                MapView.this.onKeyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                MapView.this.onKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MapView.this.onKeyReleased(e);
            }
        });
        this._mouseWheelDetctionTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalDateTime now = LocalDateTime.now();
                if (Duration.between(MapView.this._lastMouseWheelTime, now).toMillis() > 200L) {
                    MapView.this._xShift = 0;
                    MapView.this._yShift = 0;
                    MapView.this._paintScale = 1.0;
                    MapView.this.repaintNew();
                    MapView.this._mouseWheelDetctionTimer.stop();
                }
            }
        });
        this.setBackground(new Color(255, 255, 255, 0));
        this._maskOut = new MaskOut(this);
        this._mouseTool = MouseTools.NONE;
        this._viewExtent.minX = -180.0;
        this._viewExtent.maxX = 180.0;
        this._viewExtent.minY = -90.0;
        this._viewExtent.maxY = 90.0;
        this._drawExtent = (Extent)this._viewExtent.clone();
        this._scaleX = 1.0;
        this._scaleY = 1.0;
        this._selectColor = Color.yellow;
        this._defPointBreak.setSize(10.0f);
        this._defLabelBreak.setText("Text");
        this._defLabelBreak.setFont(new Font(GlobalUtil.getDefaultFontName(), 0, 12));
        this._defPolylineBreak.setColor(Color.red);
        this._defPolylineBreak.setWidth(2.0f);
        this._defPolygonBreak.setColor(new Color(104, 255, 104, 125));
    }

    public MapView(ProjectionInfo proj) {
        this();
        this._projection.setProjInfo(proj);
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffer(boolean value) {
        this.doubleBuffer = value;
    }

    public void setTileLoadListener(TileLoadListener value) {
        this.tileLoadListener = value;
    }

    public LayerCollection getLayers() {
        return this.layers;
    }

    public void setLayers(LayerCollection layers) {
        this.layers = layers;
    }

    public int getLayerNum() {
        return this.layers.size();
    }

    public int getSelectedLayerHandle() {
        return this._selectedLayer;
    }

    public void setSelectedLayerHandle(int handle) {
        this._selectedLayer = handle;
    }

    public MapLayer getLastAddedLayer() {
        int hnd = 0;
        for (MapLayer layer : this.layers) {
            if (layer.getHandle() <= hnd) continue;
            hnd = layer.getHandle();
        }
        return this.getLayerByHandle(hnd);
    }

    public boolean isLayoutMap() {
        return this._isLayoutMap;
    }

    public void setIsLayoutMap(boolean istrue) {
        this._isLayoutMap = istrue;
    }

    public boolean isGeoMap() {
        return this._isGeoMap;
    }

    public void setGeoMap(boolean value) {
        this._isGeoMap = value;
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(Extent extent) {
        this._extent = extent;
    }

    public Extent getViewExtent() {
        return this._viewExtent;
    }

    public void setViewExtent(Extent extent) {
        this._viewExtent = (Extent)extent.clone();
        this._drawExtent = (Extent)this._viewExtent.clone();
        if (this._isGeoMap) {
            this.setCoordinateGeoMap(extent, this.getWidth(), this.getHeight());
        } else {
            this.setCoordinateMap(extent, this.getWidth(), this.getHeight());
        }
    }

    public Color getSelectColor() {
        return this._selectColor;
    }

    public void setSelectColor(Color color) {
        this._selectColor = color;
    }

    public boolean isMultiGlobalDraw() {
        return this._multiGlobalDraw;
    }

    public void setMultiGlobalDraw(boolean istrue) {
        this._multiGlobalDraw = istrue;
    }

    public double getXScale() {
        return this._scaleX;
    }

    public double getYScale() {
        return this._scaleY;
    }

    public boolean isFixMapScale() {
        return this.fixMapScale;
    }

    public void setFixMapScale(boolean value) {
        this.fixMapScale = value;
    }

    public double getXYScaleFactor() {
        return this._XYScaleFactor;
    }

    public void setXYScaleFactor(double value) {
        this._XYScaleFactor = value;
        if (this._XYScaleFactor < 0.5 || this._XYScaleFactor > 2.0) {
            this._XYScaleFactor = 1.0;
        }
        this.zoomToExtent(this._drawExtent);
    }

    public MouseTools getMouseTool() {
        return this._mouseTool;
    }

    public void setMouseTool(MouseTools mt) {
        this._mouseTool = mt;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor customCursor = Cursor.getPredefinedCursor(0);
        switch (mt) {
            case ZOOM_IN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case ZOOM_OUT: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom Out");
                break;
            }
            case PAN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Pan");
                break;
            }
            case IDENTIFIER: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/identifer_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
                break;
            }
            case SELECT_FEATURES_RECTANGLE: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case EDIT_TOOL: 
            case EDIT_FEATURE_VERTICES: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Edit_tool.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(2, 2), "Edit Tool");
                break;
            }
            case NEW_LABEL: 
            case NEW_POINT: 
            case NEW_POLYGON: 
            case NEW_POLYLINE: 
            case NEW_RECTANGLE: 
            case NEW_CIRCLE: 
            case NEW_CURVE: 
            case NEW_CURVE_POLYGON: 
            case NEW_ELLIPSE: 
            case NEW_FREEHAND: 
            case EDIT_NEW_FEATURE: 
            case EDIT_ADD_RING: 
            case EDIT_FILL_RING: 
            case EDIT_REFORM_FEATURE: 
            case EDIT_SPLIT_FEATURE: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case MEASUREMENT: {
                customCursor = Cursor.getPredefinedCursor(1);
            }
        }
        this.setCursor(customCursor);
    }

    public ProjectionSet getProjection() {
        return this._projection;
    }

    public boolean isLockViewUpdate() {
        return this._lockViewUpdate;
    }

    public void setLockViewUpdate(boolean istrue) {
        this._lockViewUpdate = istrue;
    }

    public boolean isAntiAlias() {
        return this._antiAlias;
    }

    public void setAntiAlias(boolean istrue) {
        this._antiAlias = istrue;
        if (this._antiAlias) {
            this._pointAntiAlias = true;
        }
    }

    public boolean isPointAntiAlias() {
        return this._pointAntiAlias;
    }

    public void setPointAntiAlias(boolean value) {
        this._pointAntiAlias = value;
    }

    public boolean isHighSpeedWheelZoom() {
        return this._highSpeedWheelZoom;
    }

    public void setHighSpeedWheelZoom(boolean value) {
        this._highSpeedWheelZoom = value;
    }

    public GraphicCollection getSelectedGraphics() {
        return this._selectedGraphics;
    }

    public PointBreak getDefPointBreak() {
        return this._defPointBreak;
    }

    public void setDefPointBreak(PointBreak pb) {
        this._defPointBreak = pb;
    }

    public LabelBreak getDefLabelBreak() {
        return this._defLabelBreak;
    }

    public void setDefLabelBreak(LabelBreak lb) {
        this._defLabelBreak = lb;
    }

    public PolylineBreak getDefPolylineBreak() {
        return this._defPolylineBreak;
    }

    public void setDefPolylineBreak(PolylineBreak pb) {
        this._defPolylineBreak = pb;
    }

    public PolygonBreak getDefPolygonBreak() {
        return this._defPolygonBreak;
    }

    public void setDefPolygonBreak(PolygonBreak pb) {
        this._defPolygonBreak = pb;
    }

    public boolean isDrawIdentiferShape() {
        return this._drawIdentiferShape;
    }

    public void setDrawIdentiferShape(boolean istrue) {
        this._drawIdentiferShape = istrue;
    }

    public boolean isDrawGridTickLine() {
        return this._drawGridTickLine;
    }

    public void setDrawGridTickLine(boolean istrue) {
        this._drawGridTickLine = istrue;
    }

    public List<GridLabel> getGridLabels() {
        return this._gridLabels;
    }

    public Color getGridLineColor() {
        return this._gridLineColor;
    }

    public void setGridLineColor(Color color) {
        this._gridLineColor = color;
    }

    public float getGridLineSize() {
        return this._gridLineSize;
    }

    public void setGridLineSize(float size) {
        this._gridLineSize = size;
    }

    public LineStyles getGridLineStyle() {
        return this._gridLineStyle;
    }

    public void setGridLineStyle(LineStyles style) {
        this._gridLineStyle = style;
    }

    public boolean isDrawGridLine() {
        return this._drawGridLine;
    }

    public void setDrawGridLine(boolean istrue) {
        this._drawGridLine = istrue;
    }

    public double getGridXDelt() {
        return this._gridXDelt;
    }

    public void setGridXDelt(double delt) {
        this._gridXDelt = delt;
        this._gridDeltChanged = true;
    }

    public double getGridYDelt() {
        return this._gridYDelt;
    }

    public void setGridYDelt(double delt) {
        this._gridYDelt = delt;
        this._gridDeltChanged = true;
    }

    public float getGridXOrigin() {
        return this._gridXOrigin;
    }

    public void setGridXOrigin(float origin) {
        this._gridXOrigin = origin;
        this._gridDeltChanged = true;
    }

    public float getGridYOrigin() {
        return this._gridYOrigin;
    }

    public void setGridYOrigin(float origin) {
        this._gridYOrigin = origin;
        this._gridDeltChanged = true;
    }

    public List<String> getXGridStrs() {
        return this._xGridStrs;
    }

    public void setXGridStrs(List<String> value) {
        this._xGridStrs = value;
    }

    public List<String> getYGridStrs() {
        return this._yGridStrs;
    }

    public void setYGridStrs(List<String> value) {
        this._yGridStrs = value;
    }

    public GraphicCollection getGraphicCollection() {
        return this._graphicCollection;
    }

    public void setGraphicCollection(GraphicCollection aGCollection) {
        this._graphicCollection = aGCollection;
    }

    public VectorLayer getLonLatLayer() {
        return this._lonLatLayer;
    }

    public void setLonLatLayer(VectorLayer layer) {
        this._lonLatLayer = layer;
    }

    public FrmMeasurement getMeasurementForm() {
        return this._frmMeasure;
    }

    public void setMeasurementForm(FrmMeasurement form) {
        this._frmMeasure = form;
    }

    public MaskOut getMaskOut() {
        return this._maskOut;
    }

    public void setMaskOut(MaskOut value) {
        this._maskOut = value;
    }

    public BufferedImage getViewImage() {
        return this._mapBitmap;
    }

    public void addViewExtentChangedListener(IViewExtentChangedListener listener) {
        this._listeners.add(IViewExtentChangedListener.class, listener);
    }

    public void removeViewExtentChangedListener(IViewExtentChangedListener listener) {
        this._listeners.remove(IViewExtentChangedListener.class, listener);
    }

    public void fireViewExtentChangedEvent() {
        this.fireViewExtentChangedEvent(new ViewExtentChangedEvent((Object)this));
    }

    private void fireViewExtentChangedEvent(ViewExtentChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IViewExtentChangedListener.class) continue;
            ((IViewExtentChangedListener)listeners[i + 1]).viewExtentChangedEvent(event);
        }
    }

    public void addUndoEditListener(IUndoEditListener listener) {
        this._listeners.add(IUndoEditListener.class, listener);
    }

    public void removeUndoEditListener(IUndoEditListener listener) {
        this._listeners.remove(IUndoEditListener.class, listener);
    }

    public void fireUndoEditEvent(UndoableEdit undoEdit) {
        this.fireUndoEditEvent(new UndoEditEvent((Object)this), undoEdit);
    }

    private void fireUndoEditEvent(UndoEditEvent event, UndoableEdit undoEdit) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IUndoEditListener.class) continue;
            ((IUndoEditListener)listeners[i + 1]).undoEditEvent(event, undoEdit);
        }
    }

    public void addLayersUpdatedListener(ILayersUpdatedListener listener) {
        this._listeners.add(ILayersUpdatedListener.class, listener);
    }

    public void removeLayersUpdatedListener(ILayersUpdatedListener listener) {
        this._listeners.remove(ILayersUpdatedListener.class, listener);
    }

    public void fireLayersUpdatedEvent() {
        this.fireLayersUpdatedEvent(new LayersUpdatedEvent((Object)this));
    }

    private void fireLayersUpdatedEvent(LayersUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ILayersUpdatedListener.class) continue;
            ((ILayersUpdatedListener)listeners[i + 1]).layersUpdatedEvent(event);
        }
    }

    public void addGraphicSelectedListener(IGraphicSelectedListener listener) {
        this._listeners.add(IGraphicSelectedListener.class, listener);
    }

    public void removeGraphicSelectedListener(IGraphicSelectedListener listener) {
        this._listeners.remove(IGraphicSelectedListener.class, listener);
    }

    public void fireGraphicSelectedEvent() {
        this.fireGraphicSelectedEvent(new GraphicSelectedEvent((Object)this));
    }

    private void fireGraphicSelectedEvent(GraphicSelectedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IGraphicSelectedListener.class) continue;
            ((IGraphicSelectedListener)listeners[i + 1]).graphicSelectedEvent(event);
        }
    }

    public void addShapeSelectedListener(IShapeSelectedListener listener) {
        this._listeners.add(IShapeSelectedListener.class, listener);
    }

    public void removeShapeSelectedListener(IShapeSelectedListener listener) {
        this._listeners.remove(IShapeSelectedListener.class, listener);
    }

    public void fireShapeSelectedEvent() {
        this.repaintNew();
        this.fireShapeSelectedEvent(new ShapeSelectedEvent((Object)this));
    }

    private void fireShapeSelectedEvent(ShapeSelectedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IShapeSelectedListener.class) continue;
            ((IShapeSelectedListener)listeners[i + 1]).shapeSelectedEvent(event);
        }
    }

    public void addProjectionChangedListener(IProjectionChangedListener listener) {
        this._listeners.add(IProjectionChangedListener.class, listener);
    }

    public void removeViewExtentChangedListener(IProjectionChangedListener listener) {
        this._listeners.remove(IProjectionChangedListener.class, listener);
    }

    public void fireProjectionChangedEvent() {
        this.fireProjectionChangedEvent(new ProjectionChangedEvent((Object)this));
    }

    private void fireProjectionChangedEvent(ProjectionChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IProjectionChangedListener.class) continue;
            ((IProjectionChangedListener)listeners[i + 1]).projectionChangedEvent(event);
        }
    }

    void onComponentResized(ComponentEvent e) {
        this.zoomToExtent(this.getViewExtent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onMousePressed(MouseEvent e) {
        block47: {
            block48: {
                if (e.getButton() != 1) break block48;
                Graphics2D g = (Graphics2D)this.getGraphics();
                switch (this._mouseTool) {
                    case ZOOM_IN: {
                        break;
                    }
                    case PAN: {
                        break;
                    }
                    case EDIT_TOOL: {
                        VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                        List<Shape> selShapes = layer.getSelectedShapes();
                        if (selShapes.size() <= 0) break;
                        float burf = 2.5f;
                        Rectangle2D.Float selExtent = new Rectangle2D.Float((float)e.getX() - burf, (float)e.getY() - burf, burf * 2.0f, burf * 2.0f);
                        List<Integer> idxs = this.selectShapes(layer, selShapes, selExtent, true, false);
                        if (idxs.size() > 0) {
                            Rectangle2D.Double dRect = this.projToScreen(layer.getShapes().get(idxs.get(0)).getExtent(), 0.0);
                            this._selectedRectangle = dRect.width > 5.0 ? new java.awt.Rectangle((int)dRect.x, (int)dRect.y, (int)dRect.width, (int)dRect.height) : new java.awt.Rectangle((int)dRect.x - 5, (int)dRect.y - 5, (int)dRect.width + 10, (int)dRect.height + 10);
                            this._mouseTool = MouseTools.EDIT_MOVE_SELECTION;
                            break;
                        }
                        break block47;
                    }
                    case SELECT_ELEMENTS: {
                        PointF mousePoint = new PointF();
                        mousePoint.X = e.getX();
                        mousePoint.Y = e.getY();
                        double lonShift = 0.0;
                        GraphicCollection tempGraphics = new GraphicCollection();
                        if (this.selectGraphics(mousePoint, this._selectedGraphics, tempGraphics, lonShift, 3)) {
                            this._resizeRectangle = this._selectedRectangle = this.getGraphicRectangle(g, this._selectedGraphics.get(0), lonShift);
                            if (this._resizeSelectedEdge == Edge.NONE) {
                                this._mouseTool = MouseTools.MOVE_SELECTION;
                                break;
                            }
                            this._mouseTool = MouseTools.RESIZE_SELECTION;
                            break;
                        }
                        this._mouseTool = MouseTools.CREATE_SELECTION;
                        break;
                    }
                    case NEW_POINT: {
                        PointShape aPS = new PointShape();
                        float[] pXY = this.screenToProj(e.getX(), e.getY());
                        aPS.setPoint(new PointD((double)pXY[0], (double)pXY[1]));
                        Graphic aGraphic = new Graphic();
                        aGraphic.setShape((Shape)aPS);
                        aGraphic.setLegend((ColorBreak)((PointBreak)this._defPointBreak.clone()));
                        this._graphicCollection.add(aGraphic);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        this.drawGraphic(g, aGraphic, 0.0);
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    case NEW_LABEL: {
                        float[] pXY = this.screenToProj(e.getX(), e.getY());
                        PointShape aPS = new PointShape();
                        aPS.setPoint(new PointD((double)pXY[0], (double)pXY[1]));
                        Graphic aGraphic = new Graphic((Shape)aPS, (ColorBreak)((LabelBreak)this._defLabelBreak.clone()));
                        this._graphicCollection.add(aGraphic);
                        this.drawGraphic(g, aGraphic, 0.0);
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    case EDIT_NEW_FEATURE: {
                        MapLayer selLayer = this.getSelectedLayer();
                        if (selLayer == null || selLayer.getLayerType() != LayerTypes.VECTOR_LAYER) break;
                        VectorLayer layer = (VectorLayer)selLayer;
                        if (layer.getShapeType().isPoint()) {
                            float[] pXY = this.screenToProj(e.getX(), e.getY());
                            PointShape aPS = new PointShape();
                            switch (layer.getShapeType()) {
                                case POINT: {
                                    aPS.setPoint(new PointD((double)pXY[0], (double)pXY[1]));
                                    break;
                                }
                                case POINT_Z: {
                                    aPS = new PointZShape();
                                    aPS.setPoint((PointD)new PointZ((double)pXY[0], (double)pXY[1], 0.0, 0.0));
                                    break;
                                }
                            }
                            try {
                                layer.editAddShape((Shape)aPS);
                                this.repaintNew();
                                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                Objects.requireNonNull(mapViewUndoRedo);
                                MapViewUndoRedo.AddFeatureEdit edit = new MapViewUndoRedo.AddFeatureEdit(mapViewUndoRedo, this, layer, (Shape)aPS);
                                layer.getUndoManager().addEdit(edit);
                                this.fireUndoEditEvent(edit);
                            }
                            catch (Exception ex) {
                                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break block47;
                        } else {
                            PointD snapP;
                            if (this._startNewGraphic) {
                                this._graphicPoints = new ArrayList<PointF>();
                                this._startNewGraphic = false;
                            }
                            if ((snapP = this.selectSnapVertice(this._mouseLastPos, layer, 10)) != null) {
                                double[] screenP = this.projToScreen(snapP.X, snapP.Y);
                                this._graphicPoints.add(new PointF((float)screenP[0], (float)screenP[1]));
                                break;
                            }
                            this._graphicPoints.add(new PointF((float)e.getX(), (float)e.getY()));
                            break;
                        }
                    }
                    case NEW_POLYGON: 
                    case NEW_POLYLINE: 
                    case NEW_CURVE: 
                    case NEW_CURVE_POLYGON: 
                    case NEW_FREEHAND: 
                    case EDIT_ADD_RING: 
                    case EDIT_FILL_RING: 
                    case EDIT_REFORM_FEATURE: 
                    case EDIT_SPLIT_FEATURE: 
                    case SELECT_FEATURES_POLYGON: 
                    case SELECT_FEATURES_LASSO: {
                        if (this._startNewGraphic) {
                            this._graphicPoints = new ArrayList<PointF>();
                            this._startNewGraphic = false;
                        }
                        this._graphicPoints.add(new PointF((float)e.getX(), (float)e.getY()));
                        break;
                    }
                    case EDIT_FEATURE_VERTICES: {
                        VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                        Shape eShape = layer.getEditingShape();
                        if (eShape == null || !eShape.isEditing()) break;
                        this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                        if (this._editingVerticeIndex < 0) break;
                        this._mouseTool = MouseTools.EDIT_IN_EDITING_VERTICES;
                        break;
                    }
                    case EDIT_VERTICES: {
                        if (this._selectedGraphics.size() <= 0) break;
                        this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), this._selectedGraphics.get(0).getShape(), this._editingVertices);
                        if (this._editingVerticeIndex < 0) break;
                        this._mouseTool = MouseTools.IN_EDITING_VERTICES;
                        break;
                    }
                    case MEASUREMENT: {
                        if (this._frmMeasure == null || !this._frmMeasure.isVisible()) break;
                        switch (this._frmMeasure.getMeasureType()) {
                            case Length: 
                            case Area: {
                                if (this._startNewGraphic) {
                                    this._graphicPoints = new ArrayList<PointF>();
                                    this._startNewGraphic = false;
                                }
                                this._frmMeasure.setPreviousValue(this._frmMeasure.getTotalValue());
                                this._graphicPoints.add(new PointF((float)e.getX(), (float)e.getY()));
                                break;
                            }
                            case Feature: {
                                PointF aPoint;
                                List<Integer> selectedShapes;
                                VectorLayer aLayer;
                                MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                                if (aMLayer == null || aMLayer.getLayerType() != LayerTypes.VECTOR_LAYER || (aLayer = (VectorLayer)aMLayer).getShapeType() == ShapeTypes.POINT || (selectedShapes = this.selectShapes(aLayer, aPoint = new PointF((float)e.getX(), (float)e.getY()))).size() <= 0) break;
                                Shape aShape = aLayer.getShapes().get(selectedShapes.get(0));
                                aLayer.setIdentiferShape(selectedShapes.get(0));
                                this._drawIdentiferShape = true;
                                this.repaintOld();
                                double value = 0.0;
                                switch (aShape.getShapeType()) {
                                    case POLYLINE: 
                                    case POLYLINE_Z: {
                                        this._frmMeasure.setArea(false);
                                        double areaValue = 0.0;
                                        if (this._projection.isLonLatMap()) {
                                            value = GeoComputation.getDistance((List)((PolylineShape)aShape).getPoints(), (boolean)true);
                                            if (((PolylineShape)aShape).isClosed()) {
                                                areaValue = GeoComputation.sphericalPolygonArea((List)aShape.getPoints());
                                            }
                                        } else {
                                            value = ((PolylineShape)aShape).getLength();
                                            value *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                                            if (((PolylineShape)aShape).isClosed()) {
                                                areaValue = GeoComputation.getArea((List)aShape.getPoints());
                                            }
                                        }
                                        if (!((PolylineShape)aShape).isClosed()) break;
                                        this._frmMeasure.setAreaValue(areaValue *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres());
                                        break;
                                    }
                                    case POLYGON: 
                                    case POLYGON_M: 
                                    case POLYGON_Z: {
                                        this._frmMeasure.setArea(true);
                                        value = this._projection.isLonLatMap() ? ((PolygonShape)aShape).getSphericalArea() : ((PolygonShape)aShape).getArea();
                                        value *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                                        break;
                                    }
                                }
                                this._frmMeasure.setCurrentValue(value);
                            }
                        }
                        break block47;
                    }
                }
                break block47;
            }
            if (e.getButton() == 3) {
                switch (this._mouseTool) {
                    case MEASUREMENT: {
                        if (!this._frmMeasure.isVisible()) break;
                        switch (this._frmMeasure.getMeasureType()) {
                            case Length: 
                            case Area: {
                                this._startNewGraphic = true;
                                this._frmMeasure.setTotalValue(0.0);
                            }
                        }
                        break;
                    }
                }
            }
        }
        this._mouseDownPoint.x = e.getX();
        this._mouseDownPoint.y = e.getY();
        this._mouseLastPos = (Point)this._mouseDownPoint.clone();
    }

    void onMouseDragged(MouseEvent e) {
        this._dragMode = true;
        int deltaX = e.getX() - this._mouseLastPos.x;
        int deltaY = e.getY() - this._mouseLastPos.y;
        this._mouseLastPos.x = e.getX();
        this._mouseLastPos.y = e.getY();
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(this.getForeground());
        switch (this._mouseTool) {
            case ZOOM_IN: {
                this.repaintOld();
                break;
            }
            case PAN: {
                this._xShift = e.getX() - this._mouseDownPoint.x;
                this._yShift = e.getY() - this._mouseDownPoint.y;
                this.repaintOld();
                break;
            }
            case SELECT_FEATURES_RECTANGLE: 
            case EDIT_TOOL: 
            case CREATE_SELECTION: {
                this.repaintOld();
                break;
            }
            case MOVE_SELECTION: 
            case EDIT_MOVE_SELECTION: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                this.repaintOld();
                break;
            }
            case RESIZE_SELECTION: {
                Graphic aGraphic = this._selectedGraphics.get(0);
                if (this._selectedRectangle.width > 2 && this._selectedRectangle.height > 2) {
                    block10 : switch (aGraphic.getResizeAbility()) {
                        case SAME_WIDTH_HEIGHT: {
                            switch (this._resizeSelectedEdge) {
                                case TOP_LEFT: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.y += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height -= deltaX;
                                    break block10;
                                }
                                case BOTTOM_RIGHT: {
                                    this._resizeRectangle.width += deltaX;
                                    this._resizeRectangle.height += deltaX;
                                    break block10;
                                }
                                case TOP_RIGHT: {
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.width -= deltaY;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BOTTOM_LEFT: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height -= deltaX;
                                }
                            }
                            break;
                        }
                        case RESIZE_ALL: {
                            switch (this._resizeSelectedEdge) {
                                case TOP_LEFT: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BOTTOM_RIGHT: {
                                    this._resizeRectangle.width += deltaX;
                                    this._resizeRectangle.height += deltaY;
                                    break block10;
                                }
                                case TOP: {
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BOTTOM: {
                                    this._resizeRectangle.height += deltaY;
                                    break block10;
                                }
                                case TOP_RIGHT: {
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.width += deltaX;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BOTTOM_LEFT: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height += deltaY;
                                    break block10;
                                }
                                case LEFT: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    break block10;
                                }
                                case RIGHT: {
                                    this._resizeRectangle.width += deltaX;
                                }
                            }
                        }
                    }
                } else {
                    this._resizeRectangle.width = 3;
                    this._resizeRectangle.height = 3;
                }
                this.repaintOld();
                break;
            }
            case NEW_RECTANGLE: 
            case NEW_CIRCLE: 
            case NEW_ELLIPSE: 
            case NEW_FREEHAND: 
            case SELECT_FEATURES_LASSO: 
            case SELECT_FEATURES_CIRCLE: {
                this.repaintOld();
                break;
            }
            case IN_EDITING_VERTICES: {
                this.repaintOld();
                break;
            }
            case EDIT_IN_EDITING_VERTICES: {
                VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                PointD snapP = this.selectSnapVertice(this._mouseLastPos, layer, 10);
                if (snapP != null) {
                    double[] screenP = this.projToScreen(snapP.X, snapP.Y);
                    this._mouseLastPos.x = (int)screenP[0];
                    this._mouseLastPos.y = (int)screenP[1];
                }
                this.repaintOld();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onMouseMoved(MouseEvent e) {
        this._mouseLastPos.x = e.getX();
        this._mouseLastPos.y = e.getY();
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(this.getForeground());
        block0 : switch (this._mouseTool) {
            case EDIT_TOOL: {
                VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                List<Shape> selShapes = layer.getSelectedShapes();
                boolean isMove = false;
                if (selShapes.size() > 0) {
                    float burf = 2.5f;
                    Rectangle2D.Float selExtent = new Rectangle2D.Float((float)e.getX() - burf, (float)e.getY() - burf, burf * 2.0f, burf * 2.0f);
                    List<Integer> idxs = this.selectShapes(layer, selShapes, selExtent, true, false);
                    if (idxs.size() > 0) {
                        isMove = true;
                    }
                }
                if (isMove) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                    return;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(this.getClass().getResource("/images/Edit_tool.png"));
                this.setCursor(toolkit.createCustomCursor(image, new Point(2, 2), "Edit Tool"));
                return;
            }
            case SELECT_ELEMENTS: {
                if (this._selectedGraphics.size() > 0) {
                    GraphicCollection tempGraphics = new GraphicCollection();
                    double lonShift = 0.0;
                    if (this.selectGraphics(new PointF((float)e.getX(), (float)e.getY()), this._selectedGraphics, tempGraphics, lonShift, 3)) {
                        java.awt.Rectangle aRect = this.getGraphicRectangle(g, this._selectedGraphics.get(0), lonShift);
                        this._resizeSelectedEdge = MapView.intersectElementEdge(aRect, new PointF((float)e.getX(), (float)e.getY()), 3.0f);
                        switch (this._selectedGraphics.get(0).getResizeAbility()) {
                            case SAME_WIDTH_HEIGHT: {
                                switch (this._resizeSelectedEdge) {
                                    case TOP_LEFT: 
                                    case BOTTOM_RIGHT: {
                                        this.setCursor(Cursor.getPredefinedCursor(6));
                                        return;
                                    }
                                    case TOP_RIGHT: 
                                    case BOTTOM_LEFT: {
                                        this.setCursor(Cursor.getPredefinedCursor(7));
                                        return;
                                    }
                                }
                                this.setCursor(Cursor.getPredefinedCursor(13));
                                return;
                            }
                            case RESIZE_ALL: {
                                switch (this._resizeSelectedEdge) {
                                    case TOP_LEFT: 
                                    case BOTTOM_RIGHT: {
                                        this.setCursor(Cursor.getPredefinedCursor(6));
                                        return;
                                    }
                                    case TOP: 
                                    case BOTTOM: {
                                        this.setCursor(Cursor.getPredefinedCursor(8));
                                        return;
                                    }
                                    case TOP_RIGHT: 
                                    case BOTTOM_LEFT: {
                                        this.setCursor(Cursor.getPredefinedCursor(7));
                                        return;
                                    }
                                    case LEFT: 
                                    case RIGHT: {
                                        this.setCursor(Cursor.getPredefinedCursor(11));
                                        return;
                                    }
                                    case NONE: {
                                        this.setCursor(Cursor.getPredefinedCursor(13));
                                    }
                                }
                                return;
                            }
                        }
                        this.setCursor(Cursor.getPredefinedCursor(13));
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            case EDIT_NEW_FEATURE: 
            case EDIT_ADD_RING: 
            case EDIT_FILL_RING: 
            case EDIT_REFORM_FEATURE: 
            case EDIT_SPLIT_FEATURE: {
                VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                if (selLayer == null) {
                    return;
                }
                if (selLayer.getShapeType().isPoint()) return;
                switch (this._mouseTool) {
                    case EDIT_NEW_FEATURE: {
                        PointD snapP = this.selectSnapVertice(this._mouseLastPos, selLayer, 10);
                        if (snapP != null) {
                            double[] screenP = this.projToScreen(snapP.X, snapP.Y);
                            this._mouseLastPos.x = (int)screenP[0];
                            this._mouseLastPos.y = (int)screenP[1];
                            this.repaintOld();
                            return;
                        }
                        if (this._startNewGraphic) return;
                        this.repaintOld();
                        return;
                    }
                }
                if (this._startNewGraphic) return;
                this.repaintOld();
                return;
            }
            case NEW_POLYGON: 
            case NEW_POLYLINE: 
            case NEW_CURVE: 
            case NEW_CURVE_POLYGON: 
            case NEW_FREEHAND: 
            case SELECT_FEATURES_POLYGON: {
                if (this._startNewGraphic) return;
                this.repaintOld();
                return;
            }
            case EDIT_FEATURE_VERTICES: {
                VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                if (selLayer == null) {
                    return;
                }
                Shape eShape = selLayer.getEditingShape();
                if (eShape == null || !eShape.isEditing()) return;
                this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (this._editingVerticeIndex >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/VertexEdit_32x32x32.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Vertices edit"));
                    return;
                }
                if (this.isOnRing(new Point(e.getX(), e.getY()), eShape) >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/insert_vertice.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Insert Vertice"));
                    return;
                }
                Image image = toolkit.getImage(this.getClass().getResource("/images/Edit_tool.png"));
                this.setCursor(toolkit.createCustomCursor(image, new Point(2, 2), "Edit Tool"));
                return;
            }
            case EDIT_VERTICES: {
                if (this._selectedGraphics.size() <= 0) return;
                Shape eShape = this._selectedGraphics.get(0).getShape();
                this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (this._editingVerticeIndex >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/VertexEdit_32x32x32.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Vertices edit"));
                    return;
                }
                if (this.isOnRing(new Point(e.getX(), e.getY()), eShape) >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/insert_vertice.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Insert Vertice"));
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            case MEASUREMENT: {
                if (this._frmMeasure == null || !this._frmMeasure.isVisible()) return;
                switch (this._frmMeasure.getMeasureType()) {
                    case Length: 
                    case Area: {
                        if (this._startNewGraphic) return;
                        this.repaintOld();
                        PointF[] fpoints = this._graphicPoints.toArray(new PointF[this._graphicPoints.size()]);
                        PointF[] points = new PointF[fpoints.length + 1];
                        System.arraycopy(fpoints, 0, points, 0, fpoints.length);
                        points[this._graphicPoints.size()] = new PointF((float)e.getX(), (float)e.getY());
                        float[] pXY = this.screenToProj(e.getX(), e.getY());
                        if (this._frmMeasure.getMeasureType() == FrmMeasurement.MeasureTypes.Length) {
                            double dist;
                            float[] ppXY = this.screenToProj(this._mouseDownPoint.x, this._mouseDownPoint.y);
                            double dx = Math.abs(pXY[0] - ppXY[0]);
                            double dy = Math.abs(pXY[1] - ppXY[1]);
                            if (this._projection.isLonLatMap()) {
                                double y = (pXY[1] + ppXY[1]) / 2.0f;
                                double factor = Math.cos(y * Math.PI / 180.0);
                                dist = Math.sqrt((dx *= factor) * dx + dy * dy);
                                dist *= 111319.5;
                            } else {
                                dist = Math.sqrt(dx * dx + dy * dy);
                                dist *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                            }
                            this._frmMeasure.setCurrentValue(dist);
                            break block0;
                        }
                        ArrayList<PointD> mPoints = new ArrayList<PointD>();
                        for (PointF point : points) {
                            pXY = this.screenToProj(point.X, point.Y);
                            mPoints.add(new PointD((double)pXY[0], (double)pXY[1]));
                        }
                        double area = GeoComputation.getArea(mPoints);
                        area = this._projection.isLonLatMap() ? area * 111319.5 * 111319.5 : (area *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres());
                        this._frmMeasure.setCurrentValue(area);
                    }
                }
            }
        }
    }

    void onMouseReleased(MouseEvent e) {
        this._dragMode = false;
        double lonRan = this._drawExtent.maxX - this._drawExtent.minX;
        double latRan = this._drawExtent.maxY - this._drawExtent.minY;
        double mouseLon = this._drawExtent.minX + (double)e.getX() / this._scaleX;
        double mouseLat = this._drawExtent.maxY - (double)e.getY() / this._scaleY;
        this._mousePos.x = e.getX();
        this._mousePos.y = e.getY();
        switch (this._mouseTool) {
            case ZOOM_IN: {
                double MaxY;
                double MinY;
                double MaxX;
                double MinX;
                if (Math.abs(this._mousePos.x - this._mouseDownPoint.x) > 5) {
                    double ZoomF = (double)Math.abs(this._mousePos.x - this._mouseDownPoint.x) / (double)this.getWidth();
                    double ZoomFY = (double)Math.abs(this._mousePos.y - this._mouseDownPoint.y) / (double)this.getHeight();
                    if (this._isGeoMap) {
                        if (ZoomF < ZoomFY) {
                            ZoomF = ZoomFY;
                        } else {
                            ZoomFY = ZoomF;
                        }
                    }
                    mouseLon = this._drawExtent.minX + (double)(this._mouseDownPoint.x + (this._mousePos.x - this._mouseDownPoint.x) / 2) / this._scaleX;
                    mouseLat = this._drawExtent.maxY - (double)(this._mouseDownPoint.y + (this._mousePos.y - this._mouseDownPoint.y) / 2) / this._scaleY;
                    MinX = mouseLon - lonRan / 2.0 * ZoomF;
                    MaxX = mouseLon + lonRan / 2.0 * ZoomF;
                    MinY = mouseLat - latRan / 2.0 * ZoomFY;
                    MaxY = mouseLat + latRan / 2.0 * ZoomFY;
                } else {
                    double ZoomF = e.getButton() == 1 ? 0.75 : 1.5;
                    MinX = mouseLon - lonRan / 2.0 * ZoomF;
                    MaxX = mouseLon + lonRan / 2.0 * ZoomF;
                    MinY = mouseLat - latRan / 2.0 * ZoomF;
                    MaxY = mouseLat + latRan / 2.0 * ZoomF;
                }
                if (!(MaxX - MinX > 0.001)) break;
                this.zoomToExtent(MinX, MaxX, MinY, MaxY);
                break;
            }
            case ZOOM_OUT: {
                double ZoomF = e.getButton() == 1 ? 1.5 : 0.75;
                double MinX = mouseLon - lonRan / 2.0 * ZoomF;
                double MaxX = mouseLon + lonRan / 2.0 * ZoomF;
                double MinY = mouseLat - latRan / 2.0 * ZoomF;
                double MaxY = mouseLat + latRan / 2.0 * ZoomF;
                this.zoomToExtent(MinX, MaxX, MinY, MaxY);
                break;
            }
            case PAN: {
                if (e.getButton() != 1) break;
                this._xShift = 0;
                this._yShift = 0;
                double lon = this._drawExtent.minX + (double)this._mouseDownPoint.x / this._scaleX;
                double lat = this._drawExtent.maxY - (double)this._mouseDownPoint.y / this._scaleY;
                double MinX = this._drawExtent.minX - (mouseLon - lon);
                double MaxX = this._drawExtent.maxX - (mouseLon - lon);
                double MinY = this._drawExtent.minY - (mouseLat - lat);
                double MaxY = this._drawExtent.maxY - (mouseLat - lat);
                this.zoomToExtent(MinX, MaxX, MinY, MaxY);
                break;
            }
            case SELECT_FEATURES_RECTANGLE: 
            case EDIT_TOOL: {
                Rectangle2D.Float rect;
                if (e.getButton() != 1) break;
                if (this._selectedLayer < 0) {
                    return;
                }
                MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                if (aMLayer == null) {
                    return;
                }
                if (aMLayer.getLayerType() != LayerTypes.VECTOR_LAYER) {
                    return;
                }
                VectorLayer aLayer = (VectorLayer)aMLayer;
                boolean isPointSel = false;
                if (Math.abs(e.getX() - this._mouseDownPoint.x) > 5 || Math.abs(e.getY() - this._mouseDownPoint.y) > 5) {
                    int minx = Math.min(this._mouseDownPoint.x, e.getX());
                    int miny = Math.min(this._mouseDownPoint.y, e.getY());
                    int width = Math.abs(e.getX() - this._mouseDownPoint.x);
                    int height = Math.abs(e.getY() - this._mouseDownPoint.y);
                    rect = new Rectangle2D.Float(minx, miny, width, height);
                } else {
                    float b = 2.5f;
                    float minx = (float)e.getX() - b;
                    float miny = (float)e.getY() - b;
                    float width = b * 2.0f;
                    float height = b * 2.0f;
                    rect = new Rectangle2D.Float(minx, miny, width, height);
                    isPointSel = true;
                }
                List<Integer> selectedShapes = this.selectShapes(aLayer, rect);
                if (!e.isControlDown() && !e.isShiftDown()) {
                    aLayer.clearSelectedShapes();
                }
                if (selectedShapes.size() > 0) {
                    if (isPointSel) {
                        Shape shape;
                        shape.setSelected(!(shape = aLayer.getShapes().get(selectedShapes.get(selectedShapes.size() - 1))).isSelected());
                    } else {
                        for (int shapeIdx : selectedShapes) {
                            Shape shape;
                            shape.setSelected(!(shape = aLayer.getShapes().get(shapeIdx)).isSelected());
                        }
                    }
                } else {
                    this.repaintNew();
                }
                this.fireShapeSelectedEvent();
                break;
            }
            case CREATE_SELECTION: {
                if (e.getButton() == 1) {
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        for (Graphic aGraphic : this._selectedGraphics.getGraphics()) {
                            aGraphic.getShape().setSelected(false);
                        }
                        this._selectedGraphics.clear();
                    }
                    if (Math.abs(e.getX() - this._mouseDownPoint.x) > 5 || Math.abs(e.getY() - this._mouseDownPoint.y) > 5) {
                        double lonShift;
                        GraphicCollection tempGraphics;
                        int height;
                        int width;
                        int miny;
                        int minx = Math.min(this._mouseDownPoint.x, e.getX());
                        java.awt.Rectangle rect = new java.awt.Rectangle(minx, miny = Math.min(this._mouseDownPoint.y, e.getY()), width = Math.abs(e.getX() - this._mouseDownPoint.x), height = Math.abs(e.getY() - this._mouseDownPoint.y));
                        if (this.selectGraphics(rect, tempGraphics = new GraphicCollection(), lonShift = 0.0)) {
                            if (!e.isControlDown() && !e.isShiftDown()) {
                                for (Graphic aGraphic : tempGraphics.getGraphics()) {
                                    aGraphic.getShape().setSelected(true);
                                    this._selectedGraphics.add(aGraphic);
                                }
                            } else {
                                for (Graphic aGraphic : tempGraphics.getGraphics()) {
                                    aGraphic.getShape().setSelected(!aGraphic.getShape().isSelected());
                                    if (aGraphic.getShape().isSelected()) {
                                        this._selectedGraphics.add(aGraphic);
                                        continue;
                                    }
                                    this._selectedGraphics.remove(aGraphic);
                                }
                            }
                        }
                        this.repaintNew();
                        return;
                    }
                    PointF mousePoint = new PointF((float)this._mouseDownPoint.x, (float)this._mouseDownPoint.y);
                    GraphicCollection tempGraphics = new GraphicCollection();
                    double lonShift = 0.0;
                    if (this.selectGraphics(mousePoint, tempGraphics, lonShift)) {
                        Graphic aGraphic = tempGraphics.get(0);
                        if (!e.isControlDown() && !e.isShiftDown()) {
                            aGraphic.getShape().setSelected(true);
                            this._selectedGraphics.add(aGraphic);
                        } else {
                            aGraphic.getShape().setSelected(!aGraphic.getShape().isSelected());
                            if (aGraphic.getShape().isSelected()) {
                                this._selectedGraphics.add(aGraphic);
                            } else {
                                this._selectedGraphics.remove(aGraphic);
                            }
                        }
                        switch (aGraphic.getLegend().getBreakType()) {
                            case POINT_BREAK: {
                                if (this._frmPointSymbolSet == null || !this._frmPointSymbolSet.isVisible()) break;
                                this._frmPointSymbolSet.setPointBreak((PointBreak)aGraphic.getLegend());
                                break;
                            }
                            case LABEL_BREAK: {
                                if (this._frmLabelSymbolSet == null || !this._frmLabelSymbolSet.isVisible()) break;
                                this._frmLabelSymbolSet.setLabelBreak((LabelBreak)aGraphic.getLegend());
                                break;
                            }
                            case POLYLINE_BREAK: {
                                if (this._frmPolylineSymbolSet == null || !this._frmPolylineSymbolSet.isVisible()) break;
                                this._frmPolylineSymbolSet.setPolylineBreak((PolylineBreak)aGraphic.getLegend());
                                break;
                            }
                            case POLYGON_BREAK: {
                                if (this._frmPolygonSymbolSet == null || !this._frmPolygonSymbolSet.isVisible()) break;
                                this._frmPolygonSymbolSet.setPolygonBreak((PolygonBreak)aGraphic.getLegend());
                            }
                        }
                    }
                    this.fireGraphicSelectedEvent();
                    this.repaintNew();
                }
                this._mouseTool = MouseTools.SELECT_ELEMENTS;
                break;
            }
            case EDIT_MOVE_SELECTION: {
                VectorLayer slayer = (VectorLayer)this.getSelectedLayer();
                List<Shape> selShapes = slayer.getSelectedShapes();
                if (selShapes.size() > 0) {
                    for (Shape shape : selShapes) {
                        this.moveShapeOnScreen(shape, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                    }
                    slayer.updateExtent();
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.MoveFeaturesEdit edit = new MapViewUndoRedo.MoveFeaturesEdit(mapViewUndoRedo, this, selShapes, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                    slayer.getUndoManager().addEdit(edit);
                    this.fireUndoEditEvent(edit);
                }
                this._mouseTool = MouseTools.EDIT_TOOL;
                break;
            }
            case MOVE_SELECTION: {
                if (this._mouseDoubleClicked) {
                    this._mouseDoubleClicked = false;
                } else if (this._selectedGraphics.size() > 0) {
                    if (Math.abs(e.getX() - this._mouseDownPoint.x) < 2 && Math.abs(e.getY() - this._mouseDownPoint.y) < 2) {
                        Graphic aGraphic = this._selectedGraphics.get(0);
                        PointF mousePoint = new PointF((float)this._mouseDownPoint.x, (float)this._mouseDownPoint.y);
                        double lonShift = 0.0;
                        GraphicCollection tempGraphics = new GraphicCollection();
                        this.selectGraphics(mousePoint, tempGraphics, lonShift);
                        if (e.isControlDown() || e.isShiftDown()) {
                            if (tempGraphics.size() > 0) {
                                aGraphic = tempGraphics.get(0);
                                aGraphic.getShape().setSelected(!aGraphic.getShape().isSelected());
                                if (aGraphic.getShape().isSelected()) {
                                    this._selectedGraphics.add(aGraphic);
                                } else {
                                    this._selectedGraphics.remove(aGraphic);
                                }
                            }
                        } else {
                            if (tempGraphics.size() > 1) {
                                aGraphic.getShape().setSelected(false);
                                int idx = tempGraphics.indexOf(aGraphic);
                                idx = idx == 0 ? tempGraphics.size() - 1 : --idx;
                                aGraphic = tempGraphics.get(idx);
                                this._selectedGraphics.clear();
                                this._selectedGraphics.add(aGraphic);
                                this._selectedGraphics.get(0).getShape().setSelected(true);
                                switch (aGraphic.getLegend().getBreakType()) {
                                    case POINT_BREAK: {
                                        if (this._frmPointSymbolSet == null || !this._frmPointSymbolSet.isVisible()) break;
                                        this._frmPointSymbolSet.setPointBreak((PointBreak)aGraphic.getLegend());
                                        break;
                                    }
                                    case LABEL_BREAK: {
                                        if (this._frmLabelSymbolSet == null || !this._frmLabelSymbolSet.isVisible()) break;
                                        this._frmLabelSymbolSet.setLabelBreak((LabelBreak)aGraphic.getLegend());
                                        break;
                                    }
                                    case POLYLINE_BREAK: {
                                        if (this._frmPolylineSymbolSet == null || !this._frmPolylineSymbolSet.isVisible()) break;
                                        this._frmPolylineSymbolSet.setPolylineBreak((PolylineBreak)aGraphic.getLegend());
                                        break;
                                    }
                                    case POLYGON_BREAK: {
                                        if (this._frmPolygonSymbolSet == null || !this._frmPolygonSymbolSet.isVisible()) break;
                                        this._frmPolygonSymbolSet.setPolygonBreak((PolygonBreak)aGraphic.getLegend());
                                    }
                                }
                            }
                            this.fireGraphicSelectedEvent();
                        }
                    } else {
                        Graphic aGraphic = this._selectedGraphics.get(0);
                        Shape aShape = aGraphic.getShape();
                        this.moveShapeOnScreen(aShape, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.MoveGraphicEdit edit = new MapViewUndoRedo.MoveGraphicEdit(mapViewUndoRedo, this, aGraphic, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                        this.fireUndoEditEvent(edit);
                        this._selectedGraphics.remove(aGraphic);
                        this._selectedGraphics.add(0, aGraphic);
                    }
                    this.repaintNew();
                }
                this._mouseTool = MouseTools.SELECT_ELEMENTS;
                break;
            }
            case RESIZE_SELECTION: {
                Graphic aG = this._selectedGraphics.get(0);
                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                Objects.requireNonNull(mapViewUndoRedo);
                MapViewUndoRedo.ResizeGraphicEdit edit = new MapViewUndoRedo.ResizeGraphicEdit(mapViewUndoRedo, this, aG, this._resizeRectangle);
                this.fireUndoEditEvent(edit);
                Shape shape = aG.getShape();
                this.resizeShapeOnScreen(shape, aG.getLegend(), this._resizeRectangle);
                this._selectedGraphics.remove(aG);
                this._selectedGraphics.add(0, aG);
                this.repaintNew();
                this._mouseTool = MouseTools.SELECT_ELEMENTS;
                break;
            }
            case NEW_RECTANGLE: 
            case NEW_ELLIPSE: {
                if (e.getButton() != 1) break;
                if (Math.abs(e.getX() - this._mouseDownPoint.x) < 2 || Math.abs(e.getY() - this._mouseDownPoint.y) < 2) {
                    return;
                }
                this._startNewGraphic = true;
                this._graphicPoints = new ArrayList<PointF>();
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x, (float)this._mouseDownPoint.y));
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x, (float)e.getY()));
                this._graphicPoints.add(new PointF((float)e.getX(), (float)e.getY()));
                this._graphicPoints.add(new PointF((float)e.getX(), (float)this._mouseDownPoint.y));
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointF aPoint : this._graphicPoints) {
                    double[] pXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
                    points.add(new PointD(pXY[0], pXY[1]));
                }
                Graphic aGraphic = null;
                switch (this._mouseTool) {
                    case NEW_RECTANGLE: {
                        RectangleShape aPGS = new RectangleShape();
                        points.add((PointD)((PointD)points.get(0)).clone());
                        aPGS.setPoints(points);
                        aGraphic = new Graphic((Shape)aPGS, (ColorBreak)((PolygonBreak)this._defPolygonBreak.clone()));
                        break;
                    }
                    case NEW_ELLIPSE: {
                        EllipseShape aES = new EllipseShape();
                        aES.setPoints(points);
                        aGraphic = new Graphic((Shape)aES, (ColorBreak)((PolygonBreak)this._defPolygonBreak.clone()));
                    }
                }
                if (aGraphic != null) {
                    this._graphicCollection.add(aGraphic);
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                this.repaintOld();
                break;
            }
            case NEW_FREEHAND: 
            case SELECT_FEATURES_LASSO: {
                if (e.getButton() != 1) break;
                this._startNewGraphic = true;
                if (this._graphicPoints.size() < 2) break;
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointF aPoint : this._graphicPoints) {
                    float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                    points.add(new PointD((double)pXY[0], (double)pXY[1]));
                }
                if (this._mouseTool == MouseTools.NEW_FREEHAND) {
                    PolylineShape aPLS = new PolylineShape();
                    aPLS.setPoints(points);
                    Graphic aGraphic = new Graphic((Shape)aPLS, (ColorBreak)((PolylineBreak)this._defPolylineBreak.clone()));
                    this._graphicCollection.add(aGraphic);
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                if (aMLayer == null) {
                    return;
                }
                if (aMLayer.getLayerType() != LayerTypes.VECTOR_LAYER) {
                    return;
                }
                PolygonShape aPGS = new PolygonShape();
                points.add((PointD)((PointD)points.get(0)).clone());
                aPGS.setPoints(points);
                VectorLayer aLayer = (VectorLayer)aMLayer;
                if (!e.isControlDown() && !e.isShiftDown()) {
                    aLayer.clearSelectedShapes();
                }
                aLayer.selectShapes(aPGS);
                this.fireShapeSelectedEvent();
                break;
            }
            case NEW_CIRCLE: 
            case SELECT_FEATURES_CIRCLE: {
                if (e.getButton() != 1) break;
                if (e.getX() - this._mouseDownPoint.x < 2 || e.getY() - this._mouseDownPoint.y < 2) {
                    return;
                }
                float radius = (float)Math.sqrt(Math.pow(e.getX() - this._mouseDownPoint.x, 2.0) + Math.pow(e.getY() - this._mouseDownPoint.y, 2.0));
                this._startNewGraphic = true;
                this._graphicPoints = new ArrayList<PointF>();
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x - radius, (float)this._mouseDownPoint.y));
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x, (float)this._mouseDownPoint.y - radius));
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x + radius, (float)this._mouseDownPoint.y));
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x, (float)this._mouseDownPoint.y + radius));
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointF aPoint : this._graphicPoints) {
                    float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                    points.add(new PointD((double)pXY[0], (double)pXY[1]));
                }
                CircleShape aPGS = new CircleShape();
                aPGS.setPoints(points);
                if (this._mouseTool == MouseTools.NEW_CIRCLE) {
                    Graphic aGraphic = new Graphic((Shape)aPGS, (ColorBreak)((PolygonBreak)this._defPolygonBreak.clone()));
                    this._graphicCollection.add(aGraphic);
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                MapLayer layer = this.getLayerByHandle(this._selectedLayer);
                if (layer == null) {
                    return;
                }
                if (layer.getLayerType() != LayerTypes.VECTOR_LAYER) {
                    return;
                }
                VectorLayer aLayer = (VectorLayer)layer;
                if (!e.isControlDown() && !e.isShiftDown()) {
                    aLayer.clearSelectedShapes();
                }
                aLayer.selectShapes((PolygonShape)aPGS);
                this.fireShapeSelectedEvent();
                break;
            }
            case IN_EDITING_VERTICES: {
                Graphic graphic = this._selectedGraphics.get(0);
                double[] pXY = this.screenToProj((double)e.getX(), (double)e.getY());
                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                Objects.requireNonNull(mapViewUndoRedo);
                MapViewUndoRedo.MoveGraphicVerticeEdit edit = new MapViewUndoRedo.MoveGraphicVerticeEdit(mapViewUndoRedo, this, graphic, this._editingVerticeIndex, pXY[0], pXY[1]);
                this.fireUndoEditEvent(edit);
                graphic.verticeMoveUpdate(this._editingVerticeIndex, pXY[0], pXY[1]);
                this._mouseTool = MouseTools.EDIT_VERTICES;
                this.repaintNew();
                break;
            }
            case EDIT_IN_EDITING_VERTICES: {
                VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                Shape eShape = layer.getEditingShape();
                if (eShape != null && eShape.isEditing()) {
                    double[] pXY = this.screenToProj((double)e.getX(), (double)e.getY());
                    PointD snapP = this.selectSnapVertice(new Point(e.getX(), e.getY()), layer, 10);
                    if (snapP != null) {
                        pXY[0] = snapP.X;
                        pXY[1] = snapP.Y;
                    }
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.MoveFeatureVerticeEdit edit = new MapViewUndoRedo.MoveFeatureVerticeEdit(mapViewUndoRedo, this, eShape, this._editingVerticeIndex, pXY[0], pXY[1]);
                    layer.getUndoManager().addEdit(edit);
                    this.fireUndoEditEvent(edit);
                    eShape.moveVertice(this._editingVerticeIndex, pXY[0], pXY[1]);
                    this.repaintNew();
                }
                this._mouseTool = MouseTools.EDIT_FEATURE_VERTICES;
            }
        }
    }

    private void showSymbolSetForm(ColorBreak aCB) {
        switch (aCB.getBreakType()) {
            case POINT_BREAK: {
                PointBreak aPB = (PointBreak)aCB;
                if (this._frmPointSymbolSet == null) {
                    this._frmPointSymbolSet = new FrmPointSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPointSymbolSet.setLocationRelativeTo(this);
                    this._frmPointSymbolSet.setVisible(true);
                }
                this._frmPointSymbolSet.setPointBreak(aPB);
                this._frmPointSymbolSet.setVisible(true);
                break;
            }
            case LABEL_BREAK: {
                LabelBreak aLB = (LabelBreak)aCB;
                if (this._frmLabelSymbolSet == null) {
                    this._frmLabelSymbolSet = new FrmLabelSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this);
                    this._frmLabelSymbolSet.setLocationRelativeTo(this);
                    this._frmLabelSymbolSet.setVisible(true);
                }
                this._frmLabelSymbolSet.setLabelBreak(aLB);
                this._frmLabelSymbolSet.setVisible(true);
                break;
            }
            case POLYLINE_BREAK: {
                PolylineBreak aPLB = (PolylineBreak)aCB;
                if (this._frmPolylineSymbolSet == null) {
                    this._frmPolylineSymbolSet = new FrmPolylineSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolylineSymbolSet.setLocationRelativeTo(this);
                    this._frmPolylineSymbolSet.setVisible(true);
                }
                this._frmPolylineSymbolSet.setPolylineBreak(aPLB);
                this._frmPolylineSymbolSet.setVisible(true);
                break;
            }
            case POLYGON_BREAK: {
                PolygonBreak aPGB = (PolygonBreak)aCB;
                if (this._frmPolygonSymbolSet == null) {
                    this._frmPolygonSymbolSet = new FrmPolygonSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolygonSymbolSet.setLocationRelativeTo(this);
                    this._frmPolygonSymbolSet.setVisible(true);
                }
                this._frmPolygonSymbolSet.setPolygonBreak(aPGB);
                this._frmPolygonSymbolSet.setVisible(true);
            }
        }
    }

    void onMouseClicked(MouseEvent e) {
        block84: {
            int clickTimes;
            block82: {
                block83: {
                    clickTimes = e.getClickCount();
                    if (clickTimes != 1) break block82;
                    if (e.getButton() != 1) break block83;
                    switch (this._mouseTool) {
                        case IDENTIFIER: {
                            if (this._selectedLayer < 0) {
                                return;
                            }
                            MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                            if (aMLayer == null) {
                                return;
                            }
                            if (aMLayer.getLayerType() == LayerTypes.IMAGE_LAYER) {
                                return;
                            }
                            PointF aPoint = new PointF((float)e.getX(), (float)e.getY());
                            if (aMLayer.getLayerType() == LayerTypes.VECTOR_LAYER) {
                                VectorLayer aLayer = (VectorLayer)aMLayer;
                                List<Integer> selectedShapes = this.selectShapes(aLayer, aPoint, true, false);
                                if (selectedShapes.size() > 0) {
                                    if (this.frmIdentifer == null) {
                                        this.frmIdentifer = new FrmIdentifer((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this);
                                        this.frmIdentifer.addWindowListener(new WindowAdapter(){

                                            @Override
                                            public void windowClosed(WindowEvent e) {
                                                MapView.this._drawIdentiferShape = false;
                                                MapView.this.repaintOld();
                                            }
                                        });
                                    }
                                    Object[] colNames = new String[]{"Field", "Value"};
                                    int shapeIdx = selectedShapes.get(0);
                                    aLayer.setIdentiferShape(shapeIdx);
                                    this._drawIdentiferShape = true;
                                    Object[][] tData = new Object[aLayer.getFieldNumber() + 1][2];
                                    String fieldStr = "Index";
                                    String valueStr = String.valueOf(shapeIdx);
                                    tData[0][0] = fieldStr;
                                    tData[0][1] = valueStr;
                                    if (aLayer.getShapeNum() > 0) {
                                        for (int i = 0; i < aLayer.getFieldNumber(); ++i) {
                                            Field field = aLayer.getField(i);
                                            fieldStr = field.getColumnName();
                                            Object value = aLayer.getCellValue(i, shapeIdx);
                                            if (value == null) {
                                                valueStr = "";
                                            } else if (field.getDataType() == DataType.DATE) {
                                                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                                valueStr = format.format((LocalDateTime)value);
                                            } else {
                                                valueStr = value.toString();
                                            }
                                            tData[i + 1][0] = fieldStr;
                                            tData[i + 1][1] = valueStr;
                                        }
                                    }
                                    DefaultTableModel dtm = new DefaultTableModel(tData, colNames){

                                        @Override
                                        public boolean isCellEditable(int row, int column) {
                                            return false;
                                        }
                                    };
                                    this.frmIdentifer.getTable().setModel(dtm);
                                    this.frmIdentifer.repaint();
                                    if (!this.frmIdentifer.isVisible()) {
                                        this.frmIdentifer.setLocationRelativeTo(this);
                                        this.frmIdentifer.setVisible(true);
                                    }
                                    this.repaintOld();
                                    break;
                                }
                            } else {
                                if (aMLayer.getLayerType() != LayerTypes.RASTER_LAYER) break;
                                RasterLayer aRLayer = (RasterLayer)aMLayer;
                                int[] ijIdx = this.selectGridCell(aRLayer, aPoint);
                                if (ijIdx != null) {
                                    int iIdx = ijIdx[0];
                                    int jIdx = ijIdx[1];
                                    double aValue = aRLayer.getCellValue(iIdx, jIdx);
                                    if (this._frmIdentiferGrid == null) {
                                        this._frmIdentiferGrid = new FrmIdentiferGrid((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
                                    }
                                    this._frmIdentiferGrid.setIIndex(iIdx);
                                    this._frmIdentiferGrid.setJIndex(jIdx);
                                    this._frmIdentiferGrid.setCellValue(aValue);
                                    if (!this._frmIdentiferGrid.isVisible()) {
                                        this._frmIdentiferGrid.setLocationRelativeTo(this);
                                        this._frmIdentiferGrid.setVisible(true);
                                        break;
                                    }
                                }
                            }
                            break block84;
                        }
                        case EDIT_DELETE_RING: {
                            Object[] selObj;
                            MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                            if (aMLayer == null) {
                                return;
                            }
                            if (aMLayer.getLayerType() != LayerTypes.VECTOR_LAYER) {
                                return;
                            }
                            VectorLayer aLayer = (VectorLayer)aMLayer;
                            if (!aLayer.getShapeType().isPolygon() || (selObj = this.selectPolygonHole(aLayer, new PointF((float)e.getX(), (float)e.getY()))) == null) break;
                            PolygonShape selShape = (PolygonShape)selObj[0];
                            int polyIdx = (Integer)selObj[1];
                            int holeIdx = (Integer)selObj[2];
                            List hole = (List)((Polygon)selShape.getPolygons().get(polyIdx)).getHoleLines().get(holeIdx);
                            ((Polygon)selShape.getPolygons().get(polyIdx)).removeHole(holeIdx);
                            MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                            Objects.requireNonNull(mapViewUndoRedo);
                            MapViewUndoRedo.RemoveRingEdit edit = new MapViewUndoRedo.RemoveRingEdit(mapViewUndoRedo, this, selShape, hole, polyIdx, holeIdx);
                            aLayer.getUndoManager().addEdit(edit);
                            this.fireUndoEditEvent(edit);
                            this.repaintNew();
                        }
                    }
                    break block84;
                }
                if (e.getButton() == 3) {
                    switch (this._mouseTool) {
                        case SELECT_ELEMENTS: 
                        case MOVE_SELECTION: 
                        case RESIZE_SELECTION: {
                            if (this._selectedGraphics.size() <= 0) break;
                            Graphic aGraphic = this._selectedGraphics.get(0);
                            JPopupMenu jPopupMenu_Graphic = new JPopupMenu();
                            JMenu jMenu_Order = new JMenu("Order");
                            jPopupMenu_Graphic.add(jMenu_Order);
                            JMenuItem jMenuItem_BTF = new JMenuItem("Bring to Front");
                            jMenuItem_BTF.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onBringToFrontClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_BTF);
                            JMenuItem jMenuItem_STB = new JMenuItem("Send to Back");
                            jMenuItem_STB.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onSendToBackClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_STB);
                            JMenuItem jMenuItem_BF = new JMenuItem("Bring Forward");
                            jMenuItem_BF.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onBringForwardClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_BF);
                            JMenuItem jMenuItem_SB = new JMenuItem("Send Backward");
                            jMenuItem_SB.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onSendBackwardClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_SB);
                            jPopupMenu_Graphic.add(new JSeparator());
                            JMenuItem jMenuItem_Remove = new JMenuItem("Remove");
                            jMenuItem_Remove.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onRemoveGraphicClick(e);
                                }
                            });
                            jPopupMenu_Graphic.add(jMenuItem_Remove);
                            if (aGraphic.getLegend().getBreakType() == BreakTypes.POLYLINE_BREAK || aGraphic.getLegend().getBreakType() == BreakTypes.POLYGON_BREAK) {
                                JMenuItem jMenuItem_Reverse = new JMenuItem("Reverse");
                                jMenuItem_Reverse.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MapView.this.onReverseGraphicClick(e);
                                    }
                                });
                                jPopupMenu_Graphic.add(jMenuItem_Reverse);
                                if (aGraphic.getShape().getShapeType() == ShapeTypes.POLYLINE || aGraphic.getShape().getShapeType() == ShapeTypes.POLYGON) {
                                    jPopupMenu_Graphic.add(new JSeparator());
                                    JMenuItem jMenuItem_Smooth = new JMenuItem("Smooth Graphic");
                                    jMenuItem_Smooth.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            MapView.this.onGrahpicSmoothClick(e);
                                        }
                                    });
                                    jPopupMenu_Graphic.add(jMenuItem_Smooth);
                                }
                                if (aGraphic.getLegend().getBreakType() == BreakTypes.POLYGON_BREAK) {
                                    jPopupMenu_Graphic.add(new JSeparator());
                                    JMenuItem jMenuItem_Maskout = new JMenuItem("Set Maskout");
                                    if (((PolygonBreak)aGraphic.getLegend()).isMaskout()) {
                                        jMenuItem_Maskout.setText("No Maskout");
                                    }
                                    jMenuItem_Maskout.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            MapView.this.onGraphicMaskoutClick(e);
                                        }
                                    });
                                    jPopupMenu_Graphic.add(jMenuItem_Maskout);
                                }
                            }
                            if (aGraphic.getShape().getShapeType() == ShapeTypes.ELLIPSE) {
                                JMenuItem jMenuItem_Angle = new JMenuItem("Set Angle");
                                jMenuItem_Angle.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MapView.this.onAngleGraphicClick(e);
                                    }
                                });
                                jPopupMenu_Graphic.add(jMenuItem_Angle);
                            }
                            jPopupMenu_Graphic.show(this, e.getX(), e.getY());
                            break;
                        }
                        case EDIT_VERTICES: {
                            final Graphic graphic = this._selectedGraphics.get(0);
                            Shape eShape = graphic.getShape();
                            this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                            if (this._editingVerticeIndex < 0) break;
                            JPopupMenu jPopupMenu_Vertices = new JPopupMenu();
                            JMenuItem jMenuItem_Remove = new JMenuItem("Remove Vertice");
                            jMenuItem_Remove.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                    Objects.requireNonNull(mapViewUndoRedo);
                                    MapViewUndoRedo.RemoveGraphicVerticeEdit edit = new MapViewUndoRedo.RemoveGraphicVerticeEdit(mapViewUndoRedo, MapView.this, graphic, MapView.this._editingVerticeIndex);
                                    MapView.this.fireUndoEditEvent(edit);
                                    graphic.verticeRemoveUpdate(MapView.this._editingVerticeIndex);
                                    MapView.this.repaintNew();
                                }
                            });
                            jPopupMenu_Vertices.add(jMenuItem_Remove);
                            jPopupMenu_Vertices.show(this, e.getX(), e.getY());
                            break;
                        }
                        case EDIT_FEATURE_VERTICES: {
                            final VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                            final Shape fShape = selLayer.getEditingShape();
                            if (fShape == null || !fShape.isEditing()) break;
                            this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), fShape, this._editingVertices);
                            if (this._editingVerticeIndex < 0) break;
                            JPopupMenu jPopupMenu_Vertices = new JPopupMenu();
                            JMenuItem jMenuItem_Edit = new JMenuItem("Edit vertice");
                            jMenuItem_Edit.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    FrmVerticeEdit frmve = new FrmVerticeEdit((Frame)((JFrame)SwingUtilities.getWindowAncestor(MapView.this)), true);
                                    PointD point = (PointD)fShape.getPoints().get(MapView.this._editingVerticeIndex);
                                    frmve.setIndex(MapView.this._editingVerticeIndex);
                                    frmve.setPoint(point);
                                    frmve.setLocationRelativeTo(MapView.this);
                                    frmve.setVisible(true);
                                    if (frmve.isOK().booleanValue()) {
                                        double[] xy = frmve.getXY();
                                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                        Objects.requireNonNull(mapViewUndoRedo);
                                        MapViewUndoRedo.MoveFeatureVerticeEdit edit = new MapViewUndoRedo.MoveFeatureVerticeEdit(mapViewUndoRedo, MapView.this, fShape, MapView.this._editingVerticeIndex, xy[0], xy[1]);
                                        selLayer.getUndoManager().addEdit(edit);
                                        MapView.this.fireUndoEditEvent(edit);
                                        fShape.moveVertice(MapView.this._editingVerticeIndex, xy[0], xy[1]);
                                        MapView.this.repaintNew();
                                    }
                                }
                            });
                            jPopupMenu_Vertices.add(jMenuItem_Edit);
                            JMenuItem jMenuItem_Remove = new JMenuItem("Remove Vertice");
                            jMenuItem_Remove.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                    Objects.requireNonNull(mapViewUndoRedo);
                                    MapViewUndoRedo.RemoveFeatureVerticeEdit edit = new MapViewUndoRedo.RemoveFeatureVerticeEdit(mapViewUndoRedo, MapView.this, fShape, MapView.this._editingVerticeIndex);
                                    selLayer.getUndoManager().addEdit(edit);
                                    MapView.this.fireUndoEditEvent(edit);
                                    fShape.removeVertice(MapView.this._editingVerticeIndex);
                                    MapView.this.repaintNew();
                                }
                            });
                            jPopupMenu_Vertices.add(jMenuItem_Remove);
                            jPopupMenu_Vertices.show(this, e.getX(), e.getY());
                            break;
                        }
                        case EDIT_TOOL: {
                            final VectorLayer sLayer = (VectorLayer)this.getSelectedLayer();
                            final Shape sShape = sLayer.getSelectedShapes().get(0);
                            if (sShape == null) break;
                            JPopupMenu jPopupMenu_Shape = new JPopupMenu();
                            JMenuItem jMenuItem_Smooth = new JMenuItem("Smooth");
                            jMenuItem_Smooth.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onShapeSmoothClick(sLayer, sShape);
                                }
                            });
                            jPopupMenu_Shape.add(jMenuItem_Smooth);
                            JMenuItem jMenuItem_Reverse = new JMenuItem("Reverse");
                            jMenuItem_Reverse.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onShapeReverseClick(sShape);
                                }
                            });
                            jPopupMenu_Shape.add(jMenuItem_Reverse);
                            jPopupMenu_Shape.show(this, e.getX(), e.getY());
                        }
                    }
                }
                break block84;
            }
            if (clickTimes != 2) break block84;
            block14 : switch (this._mouseTool) {
                case SELECT_ELEMENTS: 
                case MOVE_SELECTION: 
                case RESIZE_SELECTION: {
                    if (this._mouseTool == MouseTools.MOVE_SELECTION) {
                        this._mouseDoubleClicked = true;
                    }
                    if (this._selectedGraphics.isEmpty()) {
                        return;
                    }
                    Graphic aGraphic = this._selectedGraphics.get(0);
                    for (Graphic aG : this._selectedGraphics.getGraphics()) {
                        aG.getShape().setSelected(false);
                    }
                    this._selectedGraphics.clear();
                    PointF mousePoint = new PointF((float)this._mouseDownPoint.x, (float)this._mouseDownPoint.y);
                    double lonShift = 0.0;
                    if (!this.selectGraphics(mousePoint, this._selectedGraphics, lonShift)) break;
                    if (this._selectedGraphics.size() > 1) {
                        aGraphic.getShape().setSelected(false);
                        int idx = this._selectedGraphics.indexOf(aGraphic);
                        if ((idx += 2) > this._selectedGraphics.size() - 1) {
                            idx -= this._selectedGraphics.size();
                        }
                        aGraphic = this._selectedGraphics.get(idx);
                        this._selectedGraphics.clear();
                        this._selectedGraphics.add(aGraphic);
                    }
                    aGraphic.getShape().setSelected(true);
                    this.repaintNew();
                    this.showSymbolSetForm(aGraphic.getLegend());
                    break;
                }
                case EDIT_NEW_FEATURE: {
                    if (this._startNewGraphic) break;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    ArrayList<PointD> points = new ArrayList<PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                        points.add(new PointD((double)pXY[0], (double)pXY[1]));
                    }
                    VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                    if (selLayer.getShapeType().isLine()) {
                        PolylineShape aPLS = new PolylineShape();
                        aPLS.setPoints(points);
                        try {
                            selLayer.editAddShape((Shape)aPLS);
                            this.repaintNew();
                            MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                            Objects.requireNonNull(mapViewUndoRedo);
                            MapViewUndoRedo.AddFeatureEdit edit = new MapViewUndoRedo.AddFeatureEdit(mapViewUndoRedo, this, selLayer, (Shape)aPLS);
                            selLayer.getUndoManager().addEdit(edit);
                            this.fireUndoEditEvent(edit);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break;
                    }
                    if (!selLayer.getShapeType().isPolygon() || points.size() <= 2) break;
                    PolygonShape aPGS = new PolygonShape();
                    points.add((PointD)((PointD)points.get(0)).clone());
                    aPGS.setPoints(points);
                    try {
                        selLayer.editAddShape((Shape)aPGS);
                        this.repaintNew();
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddFeatureEdit edit = new MapViewUndoRedo.AddFeatureEdit(mapViewUndoRedo, this, selLayer, (Shape)aPGS);
                        selLayer.getUndoManager().addEdit(edit);
                        this.fireUndoEditEvent(edit);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case EDIT_ADD_RING: 
                case EDIT_FILL_RING: 
                case EDIT_REFORM_FEATURE: 
                case EDIT_SPLIT_FEATURE: {
                    if (this._startNewGraphic) break;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    ArrayList<PointD> points = new ArrayList<PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                        points.add(new PointD((double)pXY[0], (double)pXY[1]));
                    }
                    VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                    if (!selLayer.getShapeType().isPolygon() && !selLayer.getShapeType().isLine() || points.size() < 2) break;
                    switch (this._mouseTool) {
                        case EDIT_ADD_RING: 
                        case EDIT_FILL_RING: {
                            if (selLayer.getShapeType().isPolygon()) {
                                PolygonShape aPGS = new PolygonShape();
                                points.add((PointD)((PointD)points.get(0)).clone());
                                aPGS.setPoints(points);
                                PolygonShape tPGS = (PolygonShape)selLayer.findShape_contains((Shape)aPGS);
                                if (tPGS == null) break block14;
                                int holeIdx = tPGS.addHole(points, 0);
                                if (this._mouseTool == MouseTools.EDIT_FILL_RING) {
                                    try {
                                        selLayer.editAddShape((Shape)aPGS);
                                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                        Objects.requireNonNull(mapViewUndoRedo);
                                        MapViewUndoRedo.FillRingEdit edit = new MapViewUndoRedo.FillRingEdit(mapViewUndoRedo, this, selLayer, tPGS, aPGS, 0, holeIdx);
                                        selLayer.getUndoManager().addEdit(edit);
                                        this.fireUndoEditEvent(edit);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                } else {
                                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                    Objects.requireNonNull(mapViewUndoRedo);
                                    MapViewUndoRedo.AddRingEdit edit = new MapViewUndoRedo.AddRingEdit(mapViewUndoRedo, this, tPGS, points, 0, holeIdx);
                                    selLayer.getUndoManager().addEdit(edit);
                                    this.fireUndoEditEvent(edit);
                                }
                                this.repaintNew();
                                break;
                            }
                            break block84;
                        }
                        case EDIT_REFORM_FEATURE: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            Shape r = selLayer.findReformShape(aPLS);
                            if (r != null) {
                                Shape shape = r.reform((Shape)aPLS);
                                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                Objects.requireNonNull(mapViewUndoRedo);
                                MapViewUndoRedo.ReplaceFeatureEdit edit = new MapViewUndoRedo.ReplaceFeatureEdit(mapViewUndoRedo, this, selLayer, r, shape);
                                selLayer.getUndoManager().addEdit(edit);
                                this.fireUndoEditEvent(edit);
                                r.cloneValue(shape);
                            }
                            this.repaintNew();
                            break;
                        }
                        case EDIT_SPLIT_FEATURE: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            Shape r = selLayer.findShape_crosses((Shape)aPLS);
                            if (r != null) {
                                List shapes = r.split((Shape)aPLS);
                                selLayer.editRemoveShape(r);
                                for (Shape s : shapes) {
                                    try {
                                        selLayer.editAddShape(s);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                Objects.requireNonNull(mapViewUndoRedo);
                                MapViewUndoRedo.SplitFeatureEdit edit = new MapViewUndoRedo.SplitFeatureEdit(mapViewUndoRedo, this, selLayer, r, shapes);
                                selLayer.getUndoManager().addEdit(edit);
                                this.fireUndoEditEvent(edit);
                                this.paintLayers();
                                this.repaintNew();
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case NEW_POLYGON: 
                case NEW_POLYLINE: 
                case NEW_CURVE: 
                case NEW_CURVE_POLYGON: 
                case NEW_FREEHAND: 
                case SELECT_FEATURES_POLYGON: {
                    PolygonShape aPGS;
                    if (this._startNewGraphic) break;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    ArrayList<PointD> points = new ArrayList<PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                        points.add(new PointD((double)pXY[0], (double)pXY[1]));
                    }
                    Graphic aGraphic = null;
                    switch (this._mouseTool) {
                        case NEW_POLYLINE: 
                        case NEW_FREEHAND: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            aGraphic = new Graphic((Shape)aPLS, (ColorBreak)((PolylineBreak)this._defPolylineBreak.clone()));
                            break;
                        }
                        case NEW_POLYGON: {
                            if (points.size() <= 2) break;
                            aPGS = new PolygonShape();
                            points.add((PointD)((PointD)points.get(0)).clone());
                            aPGS.setPoints(points);
                            aGraphic = new Graphic((Shape)aPGS, (ColorBreak)((PolygonBreak)this._defPolygonBreak.clone()));
                            break;
                        }
                        case NEW_CURVE: {
                            CurveLineShape aCLS = new CurveLineShape();
                            aCLS.setPoints(points);
                            aGraphic = new Graphic((Shape)aCLS, (ColorBreak)((PolylineBreak)this._defPolylineBreak.clone()));
                            break;
                        }
                        case NEW_CURVE_POLYGON: {
                            if (points.size() <= 2) break;
                            CurvePolygonShape aCPS = new CurvePolygonShape();
                            points.add((PointD)((PointD)points.get(0)).clone());
                            aCPS.setPoints(points);
                            aGraphic = new Graphic((Shape)aCPS, (ColorBreak)((PolygonBreak)this._defPolygonBreak.clone()));
                        }
                    }
                    if (this._mouseTool == MouseTools.SELECT_FEATURES_POLYGON) {
                        MapLayer layer = this.getLayerByHandle(this._selectedLayer);
                        if (layer == null) {
                            return;
                        }
                        if (layer.getLayerType() != LayerTypes.VECTOR_LAYER) {
                            return;
                        }
                        aPGS = new PolygonShape();
                        points.add((PointD)((PointD)points.get(0)).clone());
                        aPGS.setPoints(points);
                        VectorLayer aLayer = (VectorLayer)layer;
                        if (!e.isControlDown() && !e.isShiftDown()) {
                            aLayer.clearSelectedShapes();
                        }
                        aLayer.selectShapes(aPGS);
                        this.fireShapeSelectedEvent();
                        break;
                    }
                    if (aGraphic != null) {
                        this._graphicCollection.add(aGraphic);
                        this.repaintNew();
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    this.repaintOld();
                    break;
                }
                case EDIT_VERTICES: {
                    int idx;
                    if (this._selectedGraphics.size() <= 0) break;
                    Graphic graphic = this._selectedGraphics.get(0);
                    Shape eShape = graphic.getShape();
                    this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                    if (this._editingVerticeIndex >= 0 || (idx = this.isOnRing(new Point(e.getX(), e.getY()), eShape)) < 0) break;
                    float[] pXY = this.screenToProj(e.getX(), e.getY());
                    PointD point = new PointD((double)pXY[0], (double)pXY[1]);
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicVerticeEdit edit = new MapViewUndoRedo.AddGraphicVerticeEdit(mapViewUndoRedo, this, graphic, idx, point);
                    this.fireUndoEditEvent(edit);
                    graphic.verticeAddUpdate(idx, point);
                    this.repaintNew();
                    break;
                }
                case EDIT_FEATURE_VERTICES: {
                    int idx;
                    VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                    Shape eShape = selLayer.getEditingShape();
                    if (eShape == null || !eShape.isEditing()) break;
                    this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                    if (this._editingVerticeIndex >= 0 || (idx = this.isOnRing(new Point(e.getX(), e.getY()), eShape)) < 0) break;
                    float[] pXY = this.screenToProj(e.getX(), e.getY());
                    PointD point = new PointD((double)pXY[0], (double)pXY[1]);
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddFeatureVerticeEdit edit = new MapViewUndoRedo.AddFeatureVerticeEdit(mapViewUndoRedo, this, eShape, idx, point);
                    selLayer.getUndoManager().addEdit(edit);
                    this.fireUndoEditEvent(edit);
                    eShape.addVertice(idx, point);
                    this.repaintNew();
                }
            }
        }
    }

    private void onBringToFrontClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx < this._graphicCollection.size() - 1) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(aG);
            this.repaintNew();
        }
    }

    private void onSendToBackClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx > 0) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(0, aG);
            this.repaintNew();
        }
    }

    private void onBringForwardClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx < this._graphicCollection.size() - 1) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(idx + 1, aG);
            this.repaintNew();
        }
    }

    private void onSendBackwardClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx > 0) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(idx - 1, aG);
            this.repaintNew();
        }
    }

    private void onRemoveGraphicClick(ActionEvent e) {
        this.removeSelectedGraphics();
        this._startNewGraphic = true;
        this.repaintNew();
    }

    private void onReverseGraphicClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        List points = aGraphic.getShape().getPoints();
        Collections.reverse(points);
        aGraphic.getShape().setPoints(points);
        this.repaintNew();
    }

    private void onAngleGraphicClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        EllipseShape es = (EllipseShape)aGraphic.getShape();
        String angleStr = JOptionPane.showInputDialog(this, "Ellipse angle:", Float.valueOf(es.getAngle()));
        if (angleStr != null) {
            es.setAngle(Float.parseFloat(angleStr));
            this.repaintNew();
        }
    }

    private void onGrahpicSmoothClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        List pointList = new ArrayList<wcontour.global.PointD>();
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        for (PointD aP : aGraphic.getShape().getPoints()) {
            pointList.add(new wcontour.global.PointD(aP.X, aP.Y));
        }
        if (aGraphic.getShape().getShapeType() == ShapeTypes.POLYGON) {
            pointList.add((wcontour.global.PointD)pointList.get(0));
        }
        pointList = Contour.smoothPoints(pointList);
        for (PointD aP : pointList) {
            newPoints.add(new PointD(aP.X, aP.Y));
        }
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.SmoothGraphicEdit edit = new MapViewUndoRedo.SmoothGraphicEdit(mapViewUndoRedo, this, aGraphic, newPoints);
        this.fireUndoEditEvent(edit);
        aGraphic.getShape().setPoints(newPoints);
        this.repaintNew();
    }

    private void onShapeSmoothClick(VectorLayer layer, Shape shape) {
        List pointList = new ArrayList<wcontour.global.PointD>();
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        for (PointD aP : shape.getPoints()) {
            pointList.add(new wcontour.global.PointD(aP.X, aP.Y));
        }
        if (shape.getShapeType() == ShapeTypes.POLYGON) {
            pointList.add((wcontour.global.PointD)pointList.get(0));
        }
        pointList = Contour.smoothPoints(pointList);
        for (PointD aP : pointList) {
            newPoints.add(new PointD(aP.X, aP.Y));
        }
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.SmoothFeatureEdit edit = new MapViewUndoRedo.SmoothFeatureEdit(mapViewUndoRedo, this, shape, newPoints);
        layer.getUndoManager().addEdit(edit);
        this.fireUndoEditEvent(edit);
        shape.setPoints(newPoints);
        this.repaintNew();
    }

    private void onShapeReverseClick(Shape shape) {
        shape.reverse();
        this.repaintNew();
    }

    private void onGraphicMaskoutClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        ((PolygonBreak)aGraphic.getLegend()).setMaskout(!((PolygonBreak)aGraphic.getLegend()).isMaskout());
        this.repaintNew();
    }

    void onMouseWheelMoved(MouseWheelEvent e) {
        double lonRan = this._drawExtent.maxX - this._drawExtent.minX;
        double latRan = this._drawExtent.maxY - this._drawExtent.minY;
        double mouseLon = this._drawExtent.minX + lonRan / 2.0;
        double mouseLat = this._drawExtent.minY + latRan / 2.0;
        double ZoomF = 1.0f + (float)e.getWheelRotation() / 10.0f;
        double MinX = mouseLon - lonRan / 2.0 * ZoomF;
        double MaxX = mouseLon + lonRan / 2.0 * ZoomF;
        double MinY = mouseLat - latRan / 2.0 * ZoomF;
        double MaxY = mouseLat + latRan / 2.0 * ZoomF;
        Extent oldExtent = (Extent)this._viewExtent.clone();
        if (!this._highSpeedWheelZoom) {
            this.zoomToExtent(MinX, MaxX, MinY, MaxY);
        } else {
            this._paintScale /= ZoomF;
            float nWidth = (float)this.getWidth() * (float)this._paintScale;
            float nHeight = (float)this.getHeight() * (float)this._paintScale;
            float nx = ((float)this.getWidth() - nWidth) / 2.0f;
            float ny = ((float)this.getHeight() - nHeight) / 2.0f;
            this._xShift = (int)nx;
            this._yShift = (int)ny;
            this.repaintOld();
            this._viewExtent = new Extent(MinX, MaxX, MinY, MaxY);
            this.refreshXYScale();
            this._lastMouseWheelTime = LocalDateTime.now();
            if (!this._mouseWheelDetctionTimer.isRunning()) {
                this._mouseWheelDetctionTimer.start();
            }
        }
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.ZoomEdit edit = new MapViewUndoRedo.ZoomEdit(mapViewUndoRedo, this, oldExtent, (Extent)this._viewExtent.clone());
        this.fireUndoEditEvent(edit);
    }

    void onKeyTyped(KeyEvent e) {
    }

    void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            switch (this._mouseTool) {
                case SELECT_ELEMENTS: 
                case CREATE_SELECTION: {
                    this.removeSelectedGraphics();
                    this._startNewGraphic = true;
                    this.repaintNew();
                    break;
                }
                case EDIT_TOOL: {
                    VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                    List<Shape> selShapes = layer.getSelectedShapes();
                    if (selShapes.size() > 0) {
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.RemoveFeaturesEdit edit = new MapViewUndoRedo.RemoveFeaturesEdit(mapViewUndoRedo, this, layer, selShapes);
                        layer.getUndoManager().addEdit(edit);
                        this.fireUndoEditEvent(edit);
                        for (Shape shape : selShapes) {
                            layer.editRemoveShape(shape);
                        }
                    }
                    this.repaintNew();
                }
            }
        }
    }

    void onKeyReleased(KeyEvent e) {
    }

    public int addLayer(MapLayer aLayer) {
        int handle = this.getNewLayerHandle();
        aLayer.setHandle(handle);
        switch (aLayer.getLayerType()) {
            case VECTOR_LAYER: 
            case RASTER_LAYER: {
                this.projectLayer(aLayer, false);
            }
        }
        this.layers.add(aLayer);
        this.fireLayersUpdatedEvent();
        this._extent = this.getLayersWholeExtent();
        if (this.layers.size() == 1) {
            this.zoomToExtent(this._extent);
        } else {
            this.repaintNew();
        }
        return handle;
    }

    public int addLayer(int index, MapLayer aLayer) {
        int handle = this.getNewLayerHandle();
        aLayer.setHandle(handle);
        switch (aLayer.getLayerType()) {
            case VECTOR_LAYER: 
            case RASTER_LAYER: {
                this.projectLayer(aLayer);
            }
        }
        this.layers.add(index, aLayer);
        this.fireLayersUpdatedEvent();
        this._extent = this.getLayersWholeExtent();
        if (this.layers.size() == 1) {
            this.zoomToExtent(this._extent);
        } else {
            this.repaintNew();
        }
        return handle;
    }

    public int addWindLayer(VectorLayer aLayer, boolean EarthWind) {
        int handle = this.getNewLayerHandle();
        aLayer.setHandle(handle);
        ProjectionInfo aProjInfo = aLayer.getProjInfo();
        ProjectionInfo GeoProjInfo = KnownCoordinateSystems.geographic.world.WGS1984;
        if (!aLayer.getProjInfo().equals(this._projection.getProjInfo())) {
            if (EarthWind) {
                if (aProjInfo.getProjectionName() == ProjectionNames.LongLat) {
                    GeoProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo());
                } else {
                    GeoProjectionUtil.projectWindLayer(aLayer, this._projection.getProjInfo(), false);
                    GeoProjectionUtil.projectLayerAngle(aLayer, GeoProjInfo, this._projection.getProjInfo());
                }
            } else {
                GeoProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo());
            }
        }
        this.layers.add(aLayer);
        this._extent = this.getLayersWholeExtent();
        this.repaintNew();
        this.fireLayersUpdatedEvent();
        return handle;
    }

    private void projectLayer(MapLayer layer) {
        switch (layer.getLayerType()) {
            case VECTOR_LAYER: {
                VectorLayer aLayer = (VectorLayer)layer;
                boolean projectLabels = false;
                if (aLayer.getLabelPoints().size() > 0) {
                    projectLabels = true;
                }
                if (aLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                GeoProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo(), projectLabels);
                break;
            }
            case RASTER_LAYER: {
                RasterLayer rLayer = (RasterLayer)layer;
                if (rLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                GeoProjectionUtil.projectLayer(rLayer, this._projection.getProjInfo());
            }
        }
    }

    private void projectLayer(MapLayer layer, boolean projectLabels) {
        switch (layer.getLayerType()) {
            case VECTOR_LAYER: {
                VectorLayer aLayer = (VectorLayer)layer;
                if (aLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                GeoProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo(), projectLabels);
                break;
            }
            case RASTER_LAYER: {
                RasterLayer rLayer = (RasterLayer)layer;
                if (rLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                GeoProjectionUtil.projectLayer(rLayer, this._projection.getProjInfo());
            }
        }
    }

    public int getNewLayerHandle() {
        int handle = 0;
        for (MapLayer layer : this.layers) {
            if (handle >= layer.getHandle()) continue;
            handle = layer.getHandle();
        }
        return ++handle;
    }

    public MapLayer getSelectedLayer() {
        return this.getLayerByHandle(this._selectedLayer);
    }

    public Extent getLayersWholeExtent() {
        Extent aExtent = new Extent();
        for (int i = 0; i < this.layers.size(); ++i) {
            Extent bExtent = ((MapLayer)this.layers.get(i)).getExtent();
            aExtent = i == 0 ? bExtent : MIMath.getLagerExtent((Extent)aExtent, (Extent)bExtent);
        }
        return aExtent;
    }

    public Extent getMeteoLayersExtent() {
        Extent aExtent = null;
        int n = 0;
        for (MapLayer layer : this.layers) {
            if (!layer.getFileName().isEmpty()) continue;
            Extent bExtent = layer.getExtent();
            aExtent = n == 0 ? bExtent : MIMath.getLagerExtent((Extent)aExtent, (Extent)bExtent);
            ++n;
        }
        return aExtent;
    }

    public int getLayerHandleFromName(String name) {
        int handle = -1;
        for (MapLayer layer : this.layers) {
            if (!layer.getLayerName().equals(name)) continue;
            handle = layer.getHandle();
            break;
        }
        return handle;
    }

    public int getLayerHandleFromIdx(int lIdx) {
        return ((MapLayer)this.layers.get(lIdx)).getHandle();
    }

    public MapLayer getLayerByHandle(int handle) {
        MapLayer aLayer = null;
        for (MapLayer layer : this.layers) {
            if (layer.getHandle() != handle) continue;
            aLayer = layer;
            break;
        }
        return aLayer;
    }

    public MapLayer getLayer(String name) {
        MapLayer aLayer = null;
        for (MapLayer ml : this.layers) {
            if (!ml.getLayerName().equals(name)) continue;
            aLayer = ml;
            break;
        }
        return aLayer;
    }

    public int getLayerIdxFromHandle(int handle) {
        int lIdx = -1;
        for (int i = 0; i < this.layers.size(); ++i) {
            if (((MapLayer)this.layers.get(i)).getHandle() != handle) continue;
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public void moveLayer(int lPreIdx, int lNewIdx) {
        if (lNewIdx > lPreIdx) {
            if (lNewIdx == this.layers.size() - 1) {
                this.layers.add((MapLayer)this.layers.get(lPreIdx));
            } else {
                this.layers.add(lNewIdx + 1, (MapLayer)this.layers.get(lPreIdx));
            }
            this.layers.remove(lPreIdx);
        } else {
            this.layers.add(lNewIdx, (MapLayer)this.layers.get(lPreIdx));
            this.layers.remove(lPreIdx + 1);
        }
    }

    public void removeLayer(int aIdx) {
        this.layers.remove(aIdx);
        this._extent = this.getLayersWholeExtent();
    }

    public void removeLayerHandle(int handle) {
        int lIdx = this.getLayerIdxFromHandle(handle);
        if (lIdx >= 0) {
            this.removeLayer(lIdx);
        }
    }

    public void removeLayer(MapLayer aLayer) {
        int aIdx = this.getLayerIdxFromHandle(aLayer.getHandle());
        this.removeLayer(aIdx);
    }

    public void removeAllLayers() {
        int aNum = this.layers.size();
        for (int i = 0; i < aNum; ++i) {
            this.removeLayer(0);
        }
        this.repaintNew();
    }

    public int getLineLayerIdx() {
        int lIdx = -1;
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (((MapLayer)this.layers.get(i)).getLayerType() == LayerTypes.VECTOR_LAYER) {
                VectorLayer bLayer = (VectorLayer)this.layers.get(i);
                switch (bLayer.getShapeType()) {
                    case POLYLINE: 
                    case POLYLINE_Z: 
                    case POLYGON: 
                    case POLYGON_M: 
                    case POLYGON_Z: 
                    case POLYLINE_M: {
                        lIdx = i;
                    }
                }
                if (lIdx <= -1) continue;
                break;
            }
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public int getPolygonLayerIdx() {
        int lIdx = -1;
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (((MapLayer)this.layers.get(i)).getLayerType() == LayerTypes.VECTOR_LAYER) {
                VectorLayer bLayer = (VectorLayer)this.layers.get(i);
                switch (bLayer.getShapeType()) {
                    case POLYGON: 
                    case POLYGON_M: 
                    case POLYGON_Z: {
                        lIdx = i;
                    }
                }
                if (lIdx <= -1) continue;
                break;
            }
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public int getImageLayerIdx() {
        int lIdx = -1;
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (((MapLayer)this.layers.get(i)).getLayerType() != LayerTypes.IMAGE_LAYER && ((MapLayer)this.layers.get(i)).getLayerType() != LayerTypes.RASTER_LAYER && ((MapLayer)this.layers.get(i)).getLayerType() != LayerTypes.WEB_MAP_LAYER) continue;
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public boolean hasWebMapLayer() {
        for (MapLayer layer : this.layers) {
            if (layer.getLayerType() != LayerTypes.WEB_MAP_LAYER) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        MapLayer aLayer;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.newPaint) {
            this.paintGraphics(g2);
        } else {
            AffineTransform mx = new AffineTransform();
            mx.translate(this._xShift, this._yShift);
            mx.scale(this._paintScale, this._paintScale);
            AffineTransformOp aop = new AffineTransformOp(mx, 2);
            g2.drawImage(this._mapBitmap, aop, 0, 0);
        }
        if (this._dragMode) {
            switch (this._mouseTool) {
                case ZOOM_IN: {
                    int aWidth = Math.abs(this._mouseLastPos.x - this._mouseDownPoint.x);
                    int aHeight = Math.abs(this._mouseLastPos.y - this._mouseDownPoint.y);
                    int aX = Math.min(this._mouseLastPos.x, this._mouseDownPoint.x);
                    int aY = Math.min(this._mouseLastPos.y, this._mouseDownPoint.y);
                    g2.setColor(this.getForeground());
                    float[] dash1 = new float[]{2.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(new java.awt.Rectangle(aX, aY, aWidth, aHeight));
                    break;
                }
                case MOVE_SELECTION: 
                case EDIT_MOVE_SELECTION: {
                    java.awt.Rectangle rect = new java.awt.Rectangle();
                    rect.x = this._selectedRectangle.x + this._mouseLastPos.x - this._mouseDownPoint.x;
                    rect.y = this._selectedRectangle.y + this._mouseLastPos.y - this._mouseDownPoint.y;
                    rect.width = this._selectedRectangle.width;
                    rect.height = this._selectedRectangle.height;
                    g2.setColor(Color.red);
                    float[] dash2 = new float[]{2.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash2, 0.0f));
                    g2.draw(rect);
                    break;
                }
                case RESIZE_SELECTION: {
                    g2.setColor(Color.red);
                    float[] dashPattern = new float[]{2.0f, 1.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
                    g2.draw(this._resizeRectangle);
                    break;
                }
                case SELECT_FEATURES_RECTANGLE: 
                case EDIT_TOOL: 
                case NEW_RECTANGLE: 
                case NEW_ELLIPSE: 
                case CREATE_SELECTION: {
                    int sx = Math.min(this._mouseDownPoint.x, this._mouseLastPos.x);
                    int sy = Math.min(this._mouseDownPoint.y, this._mouseLastPos.y);
                    g2.setColor(this.getForeground());
                    g2.draw(new java.awt.Rectangle(sx, sy, Math.abs(this._mouseLastPos.x - this._mouseDownPoint.x), Math.abs(this._mouseLastPos.y - this._mouseDownPoint.y)));
                    break;
                }
                case NEW_FREEHAND: 
                case SELECT_FEATURES_LASSO: {
                    ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                    points.add(new PointF((float)this._mouseLastPos.x, (float)this._mouseLastPos.y));
                    g2.setColor(this.getForeground());
                    this._graphicPoints.add(new PointF((float)this._mouseLastPos.x, (float)this._mouseLastPos.y));
                    Draw.drawPolyline(points, (Graphics2D)g2);
                    break;
                }
                case NEW_CIRCLE: 
                case SELECT_FEATURES_CIRCLE: {
                    int radius = (int)Math.sqrt(Math.pow(this._mouseLastPos.x - this._mouseDownPoint.x, 2.0) + Math.pow(this._mouseLastPos.y - this._mouseDownPoint.y, 2.0));
                    g2.setColor(this.getForeground());
                    g2.drawLine(this._mouseDownPoint.x, this._mouseDownPoint.y, this._mouseLastPos.x, this._mouseLastPos.y);
                    g2.drawOval(this._mouseDownPoint.x - radius, this._mouseDownPoint.y - radius, radius * 2, radius * 2);
                    break;
                }
                case IN_EDITING_VERTICES: 
                case EDIT_IN_EDITING_VERTICES: {
                    double[] sXY = this.projToScreen(this._editingVertices.get((int)1).X, this._editingVertices.get((int)1).Y);
                    g2.setColor(Color.black);
                    g2.drawLine((int)sXY[0], (int)sXY[1], this._mouseLastPos.x, this._mouseLastPos.y);
                    if (this._editingVertices.size() == 3) {
                        sXY = this.projToScreen(this._editingVertices.get((int)2).X, this._editingVertices.get((int)2).Y);
                        g2.drawLine((int)sXY[0], (int)sXY[1], this._mouseLastPos.x, this._mouseLastPos.y);
                    }
                    java.awt.Rectangle nRect = new java.awt.Rectangle(this._mouseLastPos.x - 3, this._mouseLastPos.y - 3, 6, 6);
                    g2.setColor(Color.cyan);
                    g2.fill(nRect);
                    g2.setColor(Color.black);
                    g2.draw(nRect);
                }
            }
        }
        block9 : switch (this._mouseTool) {
            case EDIT_NEW_FEATURE: 
            case EDIT_ADD_RING: 
            case EDIT_FILL_RING: 
            case EDIT_REFORM_FEATURE: 
            case EDIT_SPLIT_FEATURE: {
                VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                if (this._startNewGraphic) break;
                ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                points.add(new PointF((float)this._mouseLastPos.x, (float)this._mouseLastPos.y));
                g.setColor(this.getForeground());
                switch (this._mouseTool) {
                    case EDIT_REFORM_FEATURE: 
                    case EDIT_SPLIT_FEATURE: {
                        Draw.drawPolyline(points, (Graphics2D)g2);
                        break block9;
                    }
                }
                if (selLayer.getShapeType().isLine()) {
                    Draw.drawPolyline(points, (Graphics2D)g2);
                    break;
                }
                if (!selLayer.getShapeType().isPolygon()) break;
                points.add((PointF)points.get(0));
                Draw.drawPolyline(points, (Graphics2D)g2);
                break;
            }
            case NEW_POLYGON: 
            case NEW_POLYLINE: 
            case NEW_CURVE: 
            case NEW_CURVE_POLYGON: 
            case SELECT_FEATURES_POLYGON: {
                if (this._startNewGraphic) break;
                ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                points.add(new PointF((float)this._mouseLastPos.x, (float)this._mouseLastPos.y));
                g.setColor(this.getForeground());
                switch (this._mouseTool) {
                    case NEW_POLYLINE: {
                        Draw.drawPolyline(points, (Graphics2D)g2);
                        break;
                    }
                    case NEW_POLYGON: 
                    case SELECT_FEATURES_POLYGON: {
                        points.add((PointF)points.get(0));
                        Draw.drawPolyline(points, (Graphics2D)g2);
                        break;
                    }
                    case NEW_CURVE: {
                        Draw.drawCurveLine(points, (Graphics2D)g2);
                        break;
                    }
                    case NEW_CURVE_POLYGON: {
                        points.add((PointF)points.get(0));
                        Draw.drawCurveLine(points, (Graphics2D)g2);
                    }
                }
                break;
            }
            case MEASUREMENT: {
                if (this._startNewGraphic) break;
                PointF[] fpoints = this._graphicPoints.toArray(new PointF[this._graphicPoints.size()]);
                PointF[] points = new PointF[fpoints.length + 1];
                System.arraycopy(fpoints, 0, points, 0, fpoints.length);
                points[this._graphicPoints.size()] = new PointF((float)this._mouseLastPos.x, (float)this._mouseLastPos.y);
                if (this._frmMeasure.getMeasureType() == FrmMeasurement.MeasureTypes.Length) {
                    g2.setColor(Color.red);
                    g2.setStroke(new BasicStroke(2.0f));
                    Draw.drawPolyline((PointF[])points, (Graphics2D)g2);
                    break;
                }
                PointF[] ppoints = new PointF[points.length + 1];
                System.arraycopy(points, 0, ppoints, 0, points.length);
                ppoints[ppoints.length - 1] = this._graphicPoints.get(0);
                Color aColor = new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), 100);
                g.setColor(aColor);
                PolygonBreak aPB = new PolygonBreak();
                aPB.setColor(aColor);
                Draw.drawPolygon((PointF[])ppoints, (PolygonBreak)aPB, (Graphics2D)g2);
                g.setColor(Color.red);
                Draw.drawPolyline((PointF[])ppoints, (Graphics2D)g2);
            }
        }
        if (this._drawIdentiferShape && this.getSelectedLayerHandle() >= 0 && (aLayer = this.getSelectedLayer()) != null && aLayer.getLayerType() == LayerTypes.VECTOR_LAYER) {
            VectorLayer vLayer = (VectorLayer)aLayer;
            this.drawIdShape(g2, vLayer.getShapes().get(vLayer.getIdentiferShape()));
        }
        g2.dispose();
    }

    public int getWebMapZoom() {
        WebMapLayer layer = this.getWebMapLayer();
        if (layer != null) {
            return layer.getZoom();
        }
        return 0;
    }

    public void reDraw() {
        this.repaintNew();
    }

    public void reDraw(Graphics2D graphics2D, int width, int height) {
        this.paintGraphics(graphics2D);
    }

    public void repaintNew() {
        if (this.doubleBuffer) {
            this.newPaint = false;
            this.paintLayers();
        } else {
            this.newPaint = true;
            this.repaint();
            this.updateViewImage();
        }
    }

    private void repaintOld() {
        if (this.doubleBuffer) {
            this.repaint();
        } else {
            this.newPaint = false;
            this.repaint();
        }
    }

    private void updateViewImage() {
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this._mapBitmap = new BufferedImage(width, height, 2);
        Graphics2D g = this._mapBitmap.createGraphics();
        this.paint(g);
        g.dispose();
    }

    public void paintLayers() {
        if (this.getWidth() < 10 || this.getHeight() < 10) {
            return;
        }
        if (this.getLayerNum() == 0) {
            return;
        }
        if (!this._lockViewUpdate) {
            this._mapBitmap = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g = this._mapBitmap.createGraphics();
            if (this.getBackground() != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this._antiAlias) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            }
            this._xGridPosLabel.clear();
            this._yGridPosLabel.clear();
            if (this._isGeoMap) {
                this.updateLonLatLayer();
                if (this._projection.isLonLatMap()) {
                    this.drawLonLatMap(g);
                } else {
                    this.drawProjectedMap(g);
                }
            } else {
                this.draw2DMap(g);
            }
            this.repaint();
        }
    }

    public void paintGraphics(Graphics2D g) {
        if (this._lockViewUpdate) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getMaskOutGraphicsPath(g);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        }
        this._xGridPosLabel.clear();
        this._yGridPosLabel.clear();
        if (this._isGeoMap) {
            this.updateLonLatLayer();
            if (this._projection.isLonLatMap()) {
                this.drawLonLatMap(g);
            } else {
                this.drawProjectedMap(g);
            }
            this.getLonLatGridLabels();
        } else {
            this.draw2DMap(g);
        }
    }

    public void paintGraphics(Graphics2D g, Rectangle2D rect, TileLoadListener tll) {
        this.paintGraphics(g, rect, tll, true);
    }

    public void paintGraphics(Graphics2D g, Rectangle2D rect, TileLoadListener tll, boolean updateXYScale) {
        Color background;
        if (this._lockViewUpdate) {
            return;
        }
        if (updateXYScale) {
            this.refreshXYScale(rect.getWidth(), rect.getHeight());
        }
        if ((background = this.getBackground()) != null) {
            g.setColor(background);
            g.fill(rect);
        }
        AffineTransform oldMatrix = g.getTransform();
        java.awt.Rectangle oldRegion = g.getClipBounds();
        g.setClip(rect);
        this.getMaskOutGraphicsPath(g);
        g.translate(rect.getX(), rect.getY());
        this._maskOutGraphicsPath.transform(g.getTransform());
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        }
        this._xGridPosLabel.clear();
        this._yGridPosLabel.clear();
        if (this._isGeoMap) {
            this.updateLonLatLayer();
            if (this._projection.isLonLatMap()) {
                this.drawLonLatMap(g, rect.getWidth(), rect.getHeight());
            } else {
                this.drawProjectedMap(g, rect.getWidth(), rect.getHeight(), tll);
            }
            this.getLonLatGridLabels();
        } else {
            this.draw2DMap(g);
        }
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
    }

    private void drawLonLatMap(Graphics2D g) {
        this.drawLonLatMap(g, this.getWidth(), this.getHeight());
    }

    private void drawLonLatMap(Graphics2D g, double width, double heigth) {
        this.drawLayers(g, width, heigth);
        if (this._drawGridLine) {
            LegendScheme aLS = this._lonLatLayer.getLegendScheme();
            PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(0);
            aPLB.setColor(this._gridLineColor);
            aPLB.setWidth(this._gridLineSize);
            aPLB.setStyle(this._gridLineStyle);
            this.drawLonLatLayer(this._lonLatLayer, g, 0.0);
            if (this._multiGlobalDraw) {
                if (this._lonLatLayer.getExtent().minX > -360.0 && this._lonLatLayer.getExtent().maxX > 0.0) {
                    this.drawLonLatLayer(this._lonLatLayer, g, -360.0);
                }
                if (this._lonLatLayer.getExtent().maxX < 360.0 && this._lonLatLayer.getExtent().minX < 0.0) {
                    this.drawLonLatLayer(this._lonLatLayer, g, 360.0);
                }
            }
        }
        if (this._graphicCollection.size() > 0) {
            this.drawGraphicList(g, 0.0);
            if (this._multiGlobalDraw) {
                if (this._graphicCollection.getExtent().minX > -360.0 && this._graphicCollection.getExtent().maxX > 0.0) {
                    this.drawGraphicList(g, -360.0);
                }
                if (this._graphicCollection.getExtent().maxX < 360.0 && this._graphicCollection.getExtent().minX < 0.0) {
                    this.drawGraphicList(g, 360.0);
                }
            }
        }
    }

    private void drawProjectedMap(Graphics2D g) {
        this.drawProjectedMap(g, this.getWidth(), this.getHeight());
    }

    private void drawProjectedMap(Graphics2D g, int width, int height) {
        this.drawProjectedMap(g, width, height, this.tileLoadListener);
    }

    private void drawProjectedMap(Graphics2D g, double width, double height, TileLoadListener tll) {
        this.drawProjectedLayers(g, width, height, tll);
        if (this._drawGridLine) {
            this.drawLonLatLayer(this._lonLatLayer, g, 0.0);
        }
        this.drawGraphicList(g, 0.0);
    }

    private void draw2DMap(Graphics2D g) {
        this.drawLayers(g);
        this.drawXYGrid(g, this._xGridStrs, this._yGridStrs);
    }

    private void drawLayers(Graphics2D g) {
        this.drawLayers(g, this.getWidth(), this.getHeight());
    }

    private void drawLayers(Graphics2D g, double width, double height) {
        java.awt.Shape oldRegion = g.getClip();
        double geoScale = this.getGeoScale();
        for (MapLayer aLayer : this.layers) {
            if (!aLayer.isVisible() || aLayer.getVisibleScale().isEnableMinVisScale() && geoScale > aLayer.getVisibleScale().getMinVisScale() || aLayer.getVisibleScale().isEnableMaxVisScale() && geoScale < aLayer.getVisibleScale().getMaxVisScale()) continue;
            if (aLayer.isMaskout()) {
                this.setClipRegion(g);
                if (oldRegion != null) {
                    g.clip(oldRegion);
                }
            }
            switch (aLayer.getLayerType()) {
                case IMAGE_LAYER: {
                    ImageLayer aImageLayer = (ImageLayer)aLayer;
                    this.drawImage(g, aImageLayer, 0.0, width, height);
                    if (!this._multiGlobalDraw) break;
                    if (aImageLayer.getExtent().minX > -360.0 && aImageLayer.getExtent().maxX > 0.0) {
                        this.drawImage(g, aImageLayer, -360.0, width, height);
                    }
                    if (!(aImageLayer.getExtent().maxX < 360.0) || !(aImageLayer.getExtent().minX < 0.0)) break;
                    this.drawImage(g, aImageLayer, 360.0, width, height);
                    break;
                }
                case RASTER_LAYER: {
                    RasterLayer aRLayer = (RasterLayer)aLayer;
                    this.drawRasterLayer(g, aRLayer, 0.0);
                    if (!this._multiGlobalDraw) break;
                    if (aRLayer.getExtent().minX > -360.0 && aRLayer.getExtent().maxX > 0.0) {
                        this.drawRasterLayer(g, aRLayer, -360.0);
                    }
                    if (!(aRLayer.getExtent().maxX < 360.0) || !(aRLayer.getExtent().minX < 0.0)) break;
                    this.drawRasterLayer(g, aRLayer, 360.0);
                    break;
                }
                case VECTOR_LAYER: {
                    VectorLayer aVLayer = (VectorLayer)aLayer;
                    boolean isDraw = true;
                    switch (aVLayer.getLayerDrawType()) {
                        case VECTOR: {
                            if (aVLayer.getShape(0).getShapeType() != ShapeTypes.WIND_ARROW) break;
                            this.drawVectLayerWithLegendScheme(aVLayer, g, 0.0);
                            if (this._multiGlobalDraw) {
                                if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                                    this.drawVectLayerWithLegendScheme(aVLayer, g, -360.0);
                                }
                                if (aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                                    this.drawVectLayerWithLegendScheme(aVLayer, g, 360.0);
                                }
                            }
                            isDraw = false;
                            break;
                        }
                        case BARB: {
                            if (aVLayer.getShape(0).getShapeType() != ShapeTypes.WIND_BARB) break;
                            this.drawBarbLayerWithLegendScheme(aVLayer, g, 0.0);
                            if (this._multiGlobalDraw) {
                                if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                                    this.drawBarbLayerWithLegendScheme(aVLayer, g, -360.0);
                                }
                                if (aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                                    this.drawBarbLayerWithLegendScheme(aVLayer, g, 360.0);
                                }
                            }
                            isDraw = false;
                            break;
                        }
                        case STATION_MODEL: {
                            if (aVLayer.getShape(0).getShapeType() != ShapeTypes.STATION_MODEL) break;
                            this.drawStationModelLayer(aVLayer, g, 0.0);
                            if (this._multiGlobalDraw) {
                                if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                                    this.drawStationModelLayer(aVLayer, g, -360.0);
                                }
                                if (aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                                    this.drawStationModelLayer(aVLayer, g, 360.0);
                                }
                            }
                            isDraw = false;
                        }
                    }
                    if (!isDraw) break;
                    this.drawLayerWithLegendScheme(aVLayer, g, 0.0);
                    if (!this._multiGlobalDraw) break;
                    if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                        this.drawLayerWithLegendScheme(aVLayer, g, -360.0);
                    }
                    if (!(aLayer.getExtent().maxX < 360.0) || !(aLayer.getExtent().minX < 0.0)) break;
                    this.drawLayerWithLegendScheme(aVLayer, g, 360.0);
                    break;
                }
                case WEB_MAP_LAYER: {
                    WebMapLayer webLayer = (WebMapLayer)aLayer;
                    this.drawWebMapLayer(webLayer, g, width, height);
                }
            }
            if (!aLayer.isMaskout()) continue;
            g.setClip(oldRegion);
        }
        this.fixMapScale = false;
    }

    private void drawImage(Graphics2D g, ImageLayer aILayer, double LonShift, double width, double height) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aILayer.getExtent(), (double)LonShift);
        if (MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, aILayer.getInterpolation());
            double XUL = aILayer.getExtent().minX;
            double YUL = aILayer.getExtent().maxY;
            double XBR = aILayer.getExtent().maxX;
            double YBR = aILayer.getExtent().minY;
            double[] sXY = this.projToScreen(XUL - aILayer.getWorldFilePara().xScale / 2.0, YUL - aILayer.getWorldFilePara().yScale / 2.0, LonShift);
            double sX = sXY[0];
            double sY = sXY[1];
            sXY = this.projToScreen(XBR, YBR, LonShift);
            double aWidth = sXY[0] - sX;
            double aHeight = sXY[1] - sY;
            if (aWidth < 5.0 || aHeight < 5.0) {
                return;
            }
            BufferedImage dImage = new BufferedImage((int)width, (int)height, 2);
            Graphics2D dg = (Graphics2D)dImage.getGraphics();
            BufferedImage vImage = aILayer.getImage();
            double iWidth = vImage.getWidth();
            double iHeight = vImage.getHeight();
            double cw = aWidth / iWidth;
            double ch = aHeight / iHeight;
            double shx = aILayer.getWorldFilePara().xRotate;
            double shy = aILayer.getWorldFilePara().yRotate;
            AffineTransform mx = new AffineTransform();
            if (shx == 0.0 && shy == 0.0) {
                mx.translate(sX, sY);
                mx.scale(cw, ch);
            } else {
                shx = cw / aILayer.getWorldFilePara().xScale * shx;
                shy = ch / aILayer.getWorldFilePara().yScale * shy;
                mx = new AffineTransform(cw, shy, shx, ch, sX, sY);
            }
            dg.setTransform(mx);
            dg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, aILayer.getInterpolation());
            dg.drawImage((Image)vImage, 0, 0, null);
            dg.dispose();
            if (aILayer.getTransparency() > 0) {
                int transPerc = 100 - aILayer.getTransparency();
                float[] scales = new float[]{1.0f, 1.0f, 1.0f, (float)transPerc / 100.0f};
                float[] offsets = new float[4];
                RescaleOp rop = new RescaleOp(scales, offsets, null);
                g.drawImage(dImage, rop, 0, 0);
            } else {
                g.drawImage((Image)dImage, 0, 0, null);
            }
        }
    }

    private void drawImage_back(Graphics2D g, ImageLayer aILayer, double LonShift, int width, int height) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aILayer.getExtent(), (double)LonShift);
        if (MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            double XUL = aILayer.getExtent().minX;
            double YUL = aILayer.getExtent().maxY;
            double XBR = aILayer.getExtent().maxX;
            double YBR = aILayer.getExtent().minY;
            double[] sXY = this.projToScreen(XUL - aILayer.getWorldFilePara().xScale / 2.0, YUL - aILayer.getWorldFilePara().yScale / 2.0, LonShift);
            double sX = sXY[0];
            double sY = sXY[1];
            sXY = this.projToScreen(XBR, YBR, LonShift);
            double aWidth = sXY[0] - sX;
            double aHeight = sXY[1] - sY;
            if (aWidth < 5.0 || aHeight < 5.0) {
                return;
            }
            BufferedImage dImage = new BufferedImage(width, height, 2);
            Graphics2D dg = (Graphics2D)dImage.getGraphics();
            BufferedImage vImage = aILayer.getImage();
            float iWidth = vImage.getWidth();
            float iHeight = vImage.getHeight();
            float cw = (float)(aWidth / (double)iWidth);
            float ch = (float)(aHeight / (double)iHeight);
            AffineTransform mx = new AffineTransform();
            mx.translate((float)sX, (float)sY);
            mx.scale(cw, ch);
            dg.setTransform(mx);
            if (aILayer.getTransparency() > 0) {
                int transPerc = 100 - aILayer.getTransparency();
                float[] scales = new float[]{1.0f, 1.0f, 1.0f, (float)transPerc / 100.0f};
                float[] offsets = new float[4];
                RescaleOp rop = new RescaleOp(scales, offsets, null);
                dg.drawImage(vImage, rop, 0, 0);
            } else {
                dg.drawImage((Image)vImage, 0, 0, null);
            }
            dg.dispose();
            g.drawImage((Image)dImage, 0, 0, null);
        }
    }

    private void drawRasterLayer(Graphics2D g, RasterLayer aRLayer, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aRLayer.getExtent(), (double)LonShift);
        if (MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            double XUL = aRLayer.getExtent().minX;
            double YUL = aRLayer.getExtent().maxY;
            double XBR = aRLayer.getExtent().maxX;
            double YBR = aRLayer.getExtent().minY;
            double[] sXY = this.projToScreen(XUL, YUL, LonShift);
            double sX = sXY[0];
            double sY = sXY[1];
            sXY = this.projToScreen(XBR, YBR, LonShift);
            double aWidth = sXY[0] - sX;
            double aHeigh = sXY[1] - sY;
            if (aWidth < 5.0 || aHeigh < 5.0) {
                return;
            }
            BufferedImage aImage = aRLayer.getImage();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, aRLayer.getInterpolation());
            g.drawImage(aImage, (int)sX, (int)sY, (int)(sX + aWidth), (int)(sY + aHeigh), 0, 0, aImage.getWidth(), aImage.getHeight(), null);
        }
    }

    private void drawProjectedLayers(Graphics2D g) {
        this.drawProjectedLayers(g, this.getWidth(), this.getHeight());
    }

    private void drawProjectedLayers(Graphics2D g, int width, int height) {
        this.drawProjectedMap(g, width, height, this.tileLoadListener);
    }

    private void drawProjectedLayers(Graphics2D g, double width, double height, TileLoadListener tll) {
        java.awt.Shape oldRegion = g.getClip();
        for (MapLayer aLayer : this.layers) {
            if (!aLayer.isVisible()) continue;
            if (aLayer.isMaskout() && aLayer.getLayerType() != LayerTypes.WEB_MAP_LAYER) {
                this.setClipRegion(g);
                if (oldRegion != null) {
                    g.clip(oldRegion);
                }
            }
            block0 : switch (aLayer.getLayerType()) {
                case IMAGE_LAYER: {
                    ImageLayer aImageLayer = (ImageLayer)aLayer;
                    this.drawImage(g, aImageLayer, 0.0, width, height);
                    break;
                }
                case RASTER_LAYER: {
                    RasterLayer aRLayer = (RasterLayer)aLayer;
                    this.drawRasterLayer(g, aRLayer, 0.0);
                    break;
                }
                case VECTOR_LAYER: {
                    VectorLayer aVLayer = (VectorLayer)aLayer;
                    switch (aLayer.getLayerDrawType()) {
                        case VECTOR: {
                            this.drawVectLayerWithLegendScheme(aVLayer, g, 0.0);
                            break block0;
                        }
                        case BARB: {
                            this.drawBarbLayerWithLegendScheme(aVLayer, g, 0.0);
                            break block0;
                        }
                        case STATION_MODEL: {
                            this.drawStationModelLayer(aVLayer, g, 0.0);
                            break block0;
                        }
                    }
                    this.drawLayerWithLegendScheme(aVLayer, g, 0.0);
                    break;
                }
                case WEB_MAP_LAYER: {
                    WebMapLayer webLayer = (WebMapLayer)aLayer;
                    this.drawWebMapLayer(webLayer, g, width, height, tll);
                }
            }
            if (!aLayer.isMaskout()) continue;
            g.setClip(oldRegion);
        }
        this.fixMapScale = false;
    }

    public void drawLayerWithLegendScheme(VectorLayer aLayer, Graphics2D g, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aLayer.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        boolean hasDrawCharts = false;
        switch (aLayer.getShapeType()) {
            case POINT: 
            case POINT_Z: 
            case POINT_M: {
                if (aLayer.getChartSet().isDrawCharts()) {
                    this.drawLayerCharts(g, aLayer, LonShift);
                    hasDrawCharts = true;
                }
                this.drawPointLayer(aLayer, g, LonShift);
                break;
            }
            case POLYGON: 
            case POLYGON_M: 
            case POLYGON_Z: {
                this.drawPolygonLayer(aLayer, g, LonShift);
                break;
            }
            case POLYLINE: 
            case POLYLINE_Z: 
            case POLYLINE_M: {
                this.drawPolylineLayer(aLayer, g, LonShift);
            }
        }
        if (aLayer.getLabelSet().isDrawLabels()) {
            this.drawLayerLabels(g, aLayer, LonShift);
        }
        if (!hasDrawCharts && aLayer.getChartSet().isDrawCharts()) {
            this.drawLayerCharts(g, aLayer, LonShift);
        }
    }

    public void drawVectLayerWithLegendScheme(VectorLayer aLayer, Graphics2D g, double LonShift) {
        PointD aPoint;
        Extent lExtent = MIMath.shiftExtentLon((Extent)aLayer.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        PointF sPoint = new PointF(0.0f, 0.0f);
        float max = ((PointBreak)aLayer.getLegendScheme().getLegendBreaks().get(0)).getSize() * 3.0f;
        ArrayList<WindArrow> windArraws = new ArrayList<WindArrow>();
        int shapeIdx = 0;
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        for (Shape shape : aLayer.getShapes()) {
            WindArrow aArraw = (WindArrow)shape;
            aPoint = aArraw.getPoint();
            if (!(aPoint.X + LonShift < this._drawExtent.minX || aPoint.X + LonShift > this._drawExtent.maxX || aPoint.Y < this._drawExtent.minY || aPoint.Y > this._drawExtent.maxY)) {
                windArraws.add(aArraw);
                idxList.add(shapeIdx);
            }
            ++shapeIdx;
        }
        double zoom = (double)max / 30.0;
        aLayer.setDrawingZoom((float)zoom);
        LegendScheme aLS = aLayer.getLegendScheme();
        switch (aLS.getLegendType()) {
            case SINGLE_SYMBOL: {
                ArrowBreak aPB = (ArrowBreak)aLS.getLegendBreaks().get(0);
                Color color = aPB.getColor();
                for (WindArrow aArraw : windArraws) {
                    aPoint = aArraw.getPoint();
                    double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                    sPoint.X = (float)xy[0];
                    sPoint.Y = (float)xy[1];
                    Draw.drawArrow((PointF)sPoint, (WindArrow)aArraw, (ArrowBreak)aPB, (Graphics2D)g, (double)zoom);
                }
                break;
            }
            case UNIQUE_VALUE: {
                break;
            }
            case GRADUATED_COLOR: {
                for (int w = 0; w < windArraws.size(); ++w) {
                    WindArrow aArraw = (WindArrow)windArraws.get(w);
                    shapeIdx = (Integer)idxList.get(w);
                    aPoint = aArraw.getPoint();
                    double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                    sPoint.X = (float)xy[0];
                    sPoint.Y = (float)xy[1];
                    ArrowBreak aPB = (ArrowBreak)aLS.getLegendBreak(aArraw.getLegendIndex());
                    Draw.drawArrow((PointF)sPoint, (WindArrow)aArraw, (ArrowBreak)aPB, (Graphics2D)g, (double)zoom);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawBarbLayerWithLegendScheme(VectorLayer aLayer, Graphics2D g, double LonShift) {
        PointD aPoint;
        Extent lExtent = MIMath.shiftExtentLon((Extent)aLayer.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        PointF sPoint = new PointF(0.0f, 0.0f);
        LegendScheme aLS = aLayer.getLegendScheme();
        ArrayList<WindBarb> windBarbs = new ArrayList<WindBarb>();
        int shapeIdx = 0;
        for (Shape shape : aLayer.getShapes()) {
            WindBarb wBarb = (WindBarb)shape;
            aPoint = wBarb.getPoint();
            if (!(aPoint.X + LonShift < this._drawExtent.minX || aPoint.X + LonShift > this._drawExtent.maxX || aPoint.Y < this._drawExtent.minY || aPoint.Y > this._drawExtent.maxY)) {
                windBarbs.add(wBarb);
            }
            ++shapeIdx;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent extent = new Extent();
        Extent aExtent = new Extent();
        if (aLS.getLegendType() == LegendType.SINGLE_SYMBOL) {
            PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(0);
            for (WindBarb aWB : windBarbs) {
                aPoint = aWB.getPoint();
                double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                sPoint.X = (float)xy[0];
                sPoint.Y = (float)xy[1];
                if (aLayer.getAvoidCollision()) {
                    void var14_13;
                    float aSize = aPB.getSize() / 2.0f;
                    aExtent.minX = sPoint.X - aSize;
                    aExtent.maxX = sPoint.X + aSize;
                    aExtent.minY = sPoint.Y - aSize;
                    aExtent.maxY = sPoint.Y + aSize;
                    if (extentList.isEmpty()) {
                        Extent extent2 = (Extent)aExtent.clone();
                        extentList.add((Extent)aExtent.clone());
                        Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB, (Graphics2D)g);
                        continue;
                    }
                    if (!MIMath.isExtentCross((Extent)aExtent, (Extent)var14_13).booleanValue()) {
                        extentList.add((Extent)aExtent.clone());
                        Extent extent3 = MIMath.getLagerExtent((Extent)var14_13, (Extent)aExtent);
                        Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB, (Graphics2D)g);
                        continue;
                    }
                    boolean ifDraw = true;
                    for (int i = 0; i < extentList.size(); ++i) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(i))).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (!ifDraw) continue;
                    extentList.add((Extent)aExtent.clone());
                    Extent extent4 = MIMath.getLagerExtent((Extent)var14_13, (Extent)aExtent);
                    Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB, (Graphics2D)g);
                    continue;
                }
                Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB, (Graphics2D)g);
            }
        } else {
            shapeIdx = 0;
            for (WindBarb aWB : windBarbs) {
                String vStr = aLayer.getCellValue(aLS.getFieldName(), shapeIdx).toString().trim();
                double value = vStr == null || vStr.isEmpty() ? 0.0 : Double.parseDouble(vStr);
                aPoint = aWB.getPoint();
                double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                sPoint.X = (float)xy[0];
                sPoint.Y = (float)xy[1];
                if (aLayer.getAvoidCollision()) {
                    void var14_17;
                    PointBreak aPB;
                    float aSize = ((PointBreak)aLS.getLegendBreaks().get(0)).getSize() / 2.0f;
                    aExtent.minX = sPoint.X - aSize;
                    aExtent.maxX = sPoint.X + aSize;
                    aExtent.minY = sPoint.Y - aSize;
                    aExtent.maxY = sPoint.Y + aSize;
                    if (extentList.isEmpty()) {
                        Extent extent5 = (Extent)aExtent.clone();
                        extentList.add((Extent)aExtent.clone());
                        for (ColorBreak aCB : aLS.getLegendBreaks()) {
                            aPB = (PointBreak)aCB;
                            if (value != Double.parseDouble(aPB.getStartValue().toString()) && (!(value > Double.parseDouble(aPB.getStartValue().toString())) || !(value < Double.parseDouble(aPB.getEndValue().toString())))) continue;
                            Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB, (Graphics2D)g);
                        }
                    } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)var14_17).booleanValue()) {
                        extentList.add((Extent)aExtent.clone());
                        Extent extent6 = MIMath.getLagerExtent((Extent)var14_17, (Extent)aExtent);
                        for (ColorBreak aCB : aLS.getLegendBreaks()) {
                            aPB = (PointBreak)aCB;
                            if (value != Double.parseDouble(aPB.getStartValue().toString()) && (!(value > Double.parseDouble(aPB.getStartValue().toString())) || !(value < Double.parseDouble(aPB.getEndValue().toString())))) continue;
                            Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB, (Graphics2D)g);
                        }
                    } else {
                        boolean ifDraw = true;
                        for (int i = 0; i < extentList.size(); ++i) {
                            if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(i))).booleanValue()) continue;
                            ifDraw = false;
                            break;
                        }
                        if (ifDraw) {
                            extentList.add((Extent)aExtent.clone());
                            Extent extent7 = MIMath.getLagerExtent((Extent)var14_17, (Extent)aExtent);
                            for (ColorBreak aCB : aLS.getLegendBreaks()) {
                                PointBreak aPB2 = (PointBreak)aCB;
                                if (value != Double.parseDouble(aPB2.getStartValue().toString()) && (!(value > Double.parseDouble(aPB2.getStartValue().toString())) || !(value < Double.parseDouble(aPB2.getEndValue().toString())))) continue;
                                Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)aPB2, (Graphics2D)g);
                            }
                        }
                    }
                } else {
                    PointBreak pointBreak = (PointBreak)aLS.getLegendBreak(aWB.getLegendIndex());
                    Draw.drawWindBarb((PointF)sPoint, (WindBarb)aWB, (PointBreak)pointBreak, (Graphics2D)g);
                }
                ++shapeIdx;
            }
        }
    }

    private void drawLonLatLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aLayer.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        LegendScheme aLS = this._lonLatLayer.getLegendScheme();
        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(0);
        aPLB.setColor(this._gridLineColor);
        aPLB.setWidth(this._gridLineSize);
        aPLB.setStyle(this._gridLineStyle);
        for (PolylineShape polylineShape : aLayer.getShapes()) {
            if (!polylineShape.isVisible() || !aPLB.isDrawPolyline()) continue;
            this.drawLonLatPolylineShape(g, polylineShape, aPLB, LonShift);
        }
    }

    private void drawLonLatPolylineShape(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, double LonShift) {
        Extent shapeExtent = MIMath.shiftExtentLon((Extent)aPLS.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)shapeExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        List newPList = aPLS.getPoints();
        PointF[] Points = new PointF[newPList.size()];
        for (int i = 0; i < newPList.size(); ++i) {
            PointD wPoint = (PointD)newPList.get(i);
            double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
            PointF aPoint = new PointF();
            aPoint.X = (float)sXY[0];
            aPoint.Y = (float)sXY[1];
            Points[i] = aPoint;
        }
        Color aColor = aPLB.getColor();
        if (aPLS.isSelected()) {
            aColor = this._selectColor;
        }
        float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
        BasicStroke pen = new BasicStroke(aPLB.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f);
        g.setColor(aColor);
        g.setStroke(pen);
        if (aPLS.getPartNum() <= 1) {
            int p = 0;
            int i = 1;
            while (i < Points.length) {
                g.draw(new Line2D.Float(Points[p].X, Points[p].Y, Points[i].X, Points[i].Y));
                p = i++;
            }
        } else {
            for (int p = 0; p < aPLS.getPartNum(); ++p) {
                int pp;
                PointF[] Pointps;
                if (p == aPLS.getPartNum() - 1) {
                    Pointps = new PointF[aPLS.getPointNum() - aPLS.parts[p]];
                    for (pp = aPLS.parts[p]; pp < aPLS.getPointNum(); ++pp) {
                        Pointps[pp - aPLS.parts[p]] = Points[pp];
                    }
                } else {
                    Pointps = new PointF[aPLS.parts[p + 1] - aPLS.parts[p]];
                    for (pp = aPLS.parts[p]; pp < aPLS.parts[p + 1]; ++pp) {
                        Pointps[pp - aPLS.parts[p]] = Points[pp];
                    }
                }
                int f = 0;
                int i = 1;
                while (i < Pointps.length) {
                    g.draw(new Line2D.Float(Pointps[f].X, Pointps[f].Y, Pointps[i].X, Pointps[i].Y));
                    f = i++;
                }
            }
        }
    }

    private void drawPointLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        RenderingHints rend = g.getRenderingHints();
        if (this._pointAntiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        PointF aPoint = new PointF();
        LegendScheme aLS = aLayer.getLegendScheme();
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        for (PointShape pointShape : aLayer.getShapes()) {
            PointBreak aPB;
            if (!pointShape.isVisible() || pointShape.getPoint().X + LonShift < this._drawExtent.minX || pointShape.getPoint().X + LonShift > this._drawExtent.maxX || pointShape.getPoint().Y < this._drawExtent.minY || pointShape.getPoint().Y > this._drawExtent.maxY || pointShape.getLegendIndex() < 0 || !(aPB = (PointBreak)aLS.getLegendBreaks().get(pointShape.getLegendIndex())).isDrawShape()) continue;
            double[] screenXY = this.projToScreen(pointShape.getPoint().X, pointShape.getPoint().Y, LonShift);
            aPoint.X = (float)screenXY[0];
            aPoint.Y = (float)screenXY[1];
            boolean ifDraw = true;
            if (aLayer.getAvoidCollision()) {
                float aSize = aPB.getSize() / 2.0f;
                Extent aExtent = new Extent();
                aExtent.minX = aPoint.X - aSize;
                aExtent.maxX = aPoint.X + aSize;
                aExtent.minY = aPoint.Y - aSize;
                aExtent.maxY = aPoint.Y + aSize;
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                } else {
                    for (Extent extent : extentList) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)extent).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                    }
                }
            }
            if (!ifDraw) continue;
            if (pointShape.isSelected()) {
                PointBreak newPB = (PointBreak)aPB.clone();
                newPB.setColor(this._selectColor);
                newPB.setSize(10.0f);
                if (aPB.getSize() > 10.0f) {
                    newPB.setSize(aPB.getSize());
                } else {
                    newPB.setDrawOutline(false);
                }
                Draw.drawMapPoint((PointF)new PointF(aPoint.X, aPoint.Y), (PointBreak)newPB, (Graphics2D)g);
                if (!pointShape.isEditing()) continue;
                Draw.drawSelectedVertice((Graphics2D)g, (PointF)aPoint, (float)8.0f, (Color)Color.red, (Color)Color.cyan);
                continue;
            }
            Draw.drawMapPoint((PointF)aPoint, (PointBreak)aPB, (Graphics2D)g);
        }
        if (this._pointAntiAlias) {
            g.setRenderingHints(rend);
        }
    }

    private void drawStationModelLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        PointF aPoint = new PointF();
        LegendScheme aLS = aLayer.getLegendScheme();
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        for (StationModelShape stationModelShape : aLayer.getShapes()) {
            PointBreak aPB;
            if (stationModelShape.getPoint().X + LonShift < this._drawExtent.minX || stationModelShape.getPoint().X + LonShift > this._drawExtent.maxX || stationModelShape.getPoint().Y < this._drawExtent.minY || stationModelShape.getPoint().Y > this._drawExtent.maxY || stationModelShape.getLegendIndex() < 0 || !(aPB = (PointBreak)aLS.getLegendBreaks().get(stationModelShape.getLegendIndex())).isDrawShape()) continue;
            double[] screenXY = this.projToScreen(stationModelShape.getPoint().X, stationModelShape.getPoint().Y, LonShift);
            aPoint.X = (float)screenXY[0];
            aPoint.Y = (float)screenXY[1];
            boolean ifDraw = true;
            if (aLayer.getAvoidCollision()) {
                float aSize = aPB.getSize();
                Extent aExtent = new Extent();
                aExtent.minX = aPoint.X - aSize;
                aExtent.maxX = aPoint.X + aSize;
                aExtent.minY = aPoint.Y - aSize;
                aExtent.maxY = aPoint.Y + aSize;
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                } else {
                    for (Extent extent : extentList) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)extent).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                    }
                }
            }
            if (!ifDraw) continue;
            if (stationModelShape.isSelected()) {
                PointBreak newPB = (PointBreak)aPB.clone();
                newPB.setColor(this._selectColor);
                Draw.drawStationModel((Color)this._selectColor, (Color)aPB.getOutlineColor(), (PointF)aPoint, (StationModelShape)stationModelShape, (Graphics2D)g, (float)aPB.getSize(), (float)(aPB.getSize() / 8.0f * 3.0f));
                continue;
            }
            Draw.drawStationModel((Color)aPB.getColor(), (Color)aPB.getOutlineColor(), (PointF)aPoint, (StationModelShape)stationModelShape, (Graphics2D)g, (float)aPB.getSize(), (float)(aPB.getSize() / 8.0f * 3.0f));
        }
    }

    private void drawPolygonLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        LegendScheme aLS = aLayer.getLegendScheme();
        for (int s = 0; s < aLayer.getShapeNum(); ++s) {
            PolygonBreak aPGB;
            PolygonShape polygonShape = (PolygonShape)aLayer.getShapes().get(s);
            if (!polygonShape.isVisible() || polygonShape.getLegendIndex() < 0 || !(aPGB = (PolygonBreak)aLS.getLegendBreaks().get(polygonShape.getLegendIndex())).isDrawShape()) continue;
            this.drawPolygonShape(g, polygonShape, aPGB, LonShift);
        }
        for (PolygonShape polygonShape : aLayer.getShapes()) {
            if (!polygonShape.isEditing()) continue;
            ArrayList pointList = new ArrayList();
            for (Polygon aPG : polygonShape.getPolygons()) {
                int i;
                ArrayList<PointF> rPoints = new ArrayList<PointF>();
                for (i = 0; i < aPG.getOutLine().size(); ++i) {
                    PointD wPoint = (PointD)aPG.getOutLine().get(i);
                    double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                    rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
                }
                for (i = 0; i < aPG.getHoleLines().size(); ++i) {
                    for (int j = 0; j < ((List)aPG.getHoleLines().get(i)).size(); ++j) {
                        PointD wPoint = (PointD)((List)aPG.getHoleLines().get(i)).get(j);
                        double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                        rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
                    }
                }
                pointList.addAll(rPoints);
            }
            for (PointF point : pointList) {
                Draw.drawSelectedVertice((Graphics2D)g, (PointF)point, (float)8.0f, (Color)Color.red, (Color)Color.cyan);
            }
        }
    }

    private void drawPolylineLayer(VectorLayer aLayer, Graphics2D g, double lonShift) {
        LegendScheme ls = aLayer.getLegendScheme();
        if (ls.isGeometry()) {
            for (int s = 0; s < aLayer.getShapeNum(); ++s) {
                PolylineShape pls = (PolylineShape)aLayer.getShapes().get(s);
                if (!pls.isVisible()) continue;
                if (ls.getLegendBreak(0) instanceof StreamlineBreak) {
                    this.drawStreamline(g, pls, ls, lonShift);
                    continue;
                }
                this.drawPolylineShape(g, pls, ls, lonShift);
            }
        } else {
            boolean isStreamline = false;
            switch (aLayer.getLayerDrawType()) {
                case STREAMLINE: {
                    isStreamline = true;
                }
            }
            for (int s = 0; s < aLayer.getShapeNum(); ++s) {
                PolylineBreak aPLB;
                PolylineShape pls = (PolylineShape)aLayer.getShapes().get(s);
                if (!pls.isVisible() || pls.getLegendIndex() < 0 || !(aPLB = (PolylineBreak)ls.getLegendBreaks().get(pls.getLegendIndex())).isDrawPolyline() && !aPLB.isDrawSymbol()) continue;
                this.drawPolylineShape(g, pls, aPLB, lonShift, isStreamline);
            }
        }
    }

    private static float[] getDashPattern(LineStyles style) {
        float[] dashPattern = new float[]{4.0f};
        switch (style) {
            case SOLID: {
                dashPattern = null;
                break;
            }
            case DASH: {
                dashPattern = new float[]{4.0f};
                break;
            }
            case DOT: {
                dashPattern = new float[]{2.0f};
                break;
            }
            case DASH_DOT: {
                dashPattern = new float[]{10.0f, 6.0f, 2.0f, 6.0f};
                break;
            }
            case DASH_DOT_DOT: {
                dashPattern = new float[]{10.0f, 6.0f, 2.0f, 6.0f, 2.0f, 6.0f};
            }
        }
        return dashPattern;
    }

    private void drawPolylineShape(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, double LonShift, boolean isStreamline) {
        this.drawPolylineShape(g, aPLS, aPLB, LonShift, isStreamline, false, false);
    }

    private void drawPolylineShape(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, double LonShift, boolean isStreamline, boolean isSelected, boolean isIdentifer) {
        Extent shapeExtent = MIMath.shiftExtentLon((Extent)aPLS.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)shapeExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        int len1 = aPLS.getPoints().size();
        GeneralPath path = new GeneralPath(0, len1);
        Color aColor = aPLB.getColor();
        Float size = Float.valueOf(aPLB.getWidth());
        if (!isIdentifer && aPLS.isSelected()) {
            aColor = this._selectColor;
            size = Float.valueOf(2.5f);
        }
        float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
        BasicStroke pen = new BasicStroke(size.floatValue(), 0, 0, 10.0f, dashPattern, 0.0f);
        g.setColor(aColor);
        g.setStroke(pen);
        ArrayList<PointF> drawPs = new ArrayList<PointF>();
        if (aPLB.isDrawPolyline()) {
            for (Polyline aline : aPLS.getPolylines()) {
                PointF[] Points = new PointF[aline.getPointList().size()];
                for (int i = 0; i < aline.getPointList().size(); ++i) {
                    PointD wPoint = (PointD)aline.getPointList().get(i);
                    double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                    if (i == 0) {
                        path.moveTo(sXY[0], sXY[1]);
                    } else {
                        path.lineTo(sXY[0], sXY[1]);
                    }
                    Points[i] = new PointF((float)sXY[0], (float)sXY[1]);
                    drawPs.add(new PointF((float)sXY[0], (float)sXY[1]));
                }
                if (isStreamline) {
                    Draw.drawPolyline((PointF[])Points, (PolylineBreak)aPLB, (Graphics2D)g);
                }
                g.draw(path);
                path.reset();
            }
        }
        if (aPLB.isDrawSymbol()) {
            Iterator rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < drawPs.size(); ++i) {
                if (i % aPLB.getSymbolInterval() != 0) continue;
                Draw.drawPoint((PointStyle)aPLB.getSymbolStyle(), (PointF)((PointF)drawPs.get(i)), (Color)aPLB.getSymbolFillColor(), (Color)aPLB.getSymbolColor(), (float)aPLB.getSymbolSize(), (Boolean)true, (Boolean)aPLB.isFillSymbol(), (Graphics2D)g);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
        }
        if (aPLS.isEditing()) {
            for (PointF drawP : drawPs) {
                Draw.drawSelectedVertice((Graphics2D)g, (PointF)drawP, (float)8.0f, (Color)Color.red, (Color)Color.cyan);
            }
        }
        if (isSelected) {
            Extent aExtent = MIMath.getPointFsExtent(drawPs);
            g.setColor(Color.cyan);
            g.drawRect((int)aExtent.minX, (int)aExtent.minY, (int)aExtent.getWidth(), (int)aExtent.getHeight());
        }
    }

    private void drawPolylineShape(Graphics2D g, PolylineShape aPLS, LegendScheme ls, double LonShift) {
        Extent shapeExtent = MIMath.shiftExtentLon((Extent)aPLS.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)shapeExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        int len1 = aPLS.getPoints().size();
        GeneralPath path = new GeneralPath(0, len1);
        ArrayList<PointF> drawPs = new ArrayList<PointF>();
        boolean isZ = ls.getFieldName().equals("Geometry_Z");
        for (Polyline aline : aPLS.getPolylines()) {
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointZ wPoint = (PointZ)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                if (i == 0) {
                    path.moveTo(sXY[0], sXY[1]);
                } else {
                    path.lineTo(sXY[0], sXY[1]);
                    double v = isZ ? wPoint.Z : wPoint.M;
                    PolylineBreak aPLB = (PolylineBreak)ls.findLegendBreak((Number)v);
                    Color aColor = aPLB.getColor();
                    Float size = Float.valueOf(aPLB.getWidth());
                    float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
                    BasicStroke pen = new BasicStroke(size.floatValue(), 0, 0, 10.0f, dashPattern, 0.0f);
                    g.setColor(aColor);
                    g.setStroke(pen);
                    g.draw(path);
                    path.reset();
                    path.moveTo(sXY[0], sXY[1]);
                    if (aPLB.isDrawSymbol()) {
                        Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        for (int j = 0; j < drawPs.size(); ++j) {
                            Draw.drawPoint((PointStyle)aPLB.getSymbolStyle(), (PointF)new PointF((float)sXY[0], (float)sXY[1]), (Color)aPLB.getSymbolFillColor(), (Color)aPLB.getSymbolColor(), (float)aPLB.getSymbolSize(), (Boolean)true, (Boolean)aPLB.isFillSymbol(), (Graphics2D)g);
                        }
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
                    }
                }
                drawPs.add(new PointF((float)sXY[0], (float)sXY[1]));
            }
        }
        if (aPLS.isEditing()) {
            for (PointF drawP : drawPs) {
                Draw.drawSelectedVertice((Graphics2D)g, (PointF)drawP, (float)8.0f, (Color)Color.red, (Color)Color.cyan);
            }
        }
    }

    private void drawStreamline(Graphics2D g, PolylineShape aPLS, LegendScheme ls, double LonShift) {
        Extent shapeExtent = MIMath.shiftExtentLon((Extent)aPLS.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)shapeExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        int len1 = aPLS.getPoints().size();
        GeneralPath path = new GeneralPath(0, len1);
        ArrayList<PointF> drawPs = new ArrayList<PointF>();
        boolean isZ = ls.getFieldName().equals("Geometry_Z");
        StreamlineBreak slb = (StreamlineBreak)ls.getLegendBreak(0);
        int interval = slb.getInterval() * 3;
        Color color = Color.black;
        for (Polyline aline : aPLS.getPolylines()) {
            for (int i = 0; i < aline.getPointList().size(); ++i) {
                PointZ wPoint = (PointZ)aline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                if (i == 0) {
                    path.moveTo(sXY[0], sXY[1]);
                } else {
                    path.lineTo(sXY[0], sXY[1]);
                    double value = isZ ? wPoint.Z : wPoint.M;
                    PolylineBreak aPLB = (PolylineBreak)ls.findLegendBreak((Number)value);
                    color = aPLB.getColor();
                    Float size = Float.valueOf(aPLB.getWidth());
                    float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
                    BasicStroke pen = new BasicStroke(size.floatValue(), 0, 0, 10.0f, dashPattern, 0.0f);
                    g.setColor(color);
                    g.setStroke(pen);
                    g.draw(path);
                    path.reset();
                    path.moveTo(sXY[0], sXY[1]);
                    if (aPLB.isDrawSymbol()) {
                        Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        for (int j = 0; j < drawPs.size(); ++j) {
                            Draw.drawPoint((PointStyle)aPLB.getSymbolStyle(), (PointF)new PointF((float)sXY[0], (float)sXY[1]), (Color)aPLB.getSymbolFillColor(), (Color)aPLB.getSymbolColor(), (float)aPLB.getSymbolSize(), (Boolean)true, (Boolean)aPLB.isFillSymbol(), (Graphics2D)g);
                        }
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
                    }
                }
                drawPs.add(new PointF((float)sXY[0], (float)sXY[1]));
                if (i <= 1 || i >= aline.getPointList().size() - 1 || i % interval != 0) continue;
                PointF p1 = (PointF)drawPs.get(i - 1);
                PointF p2 = (PointF)drawPs.get(i);
                double u = p2.X - p1.X;
                double v = p2.Y - p1.Y;
                double radian = Math.atan(v / u);
                double angle = radian * 180.0 / Math.PI;
                angle += 90.0;
                if (u < 0.0) {
                    angle += 180.0;
                }
                if (angle >= 360.0) {
                    angle -= 360.0;
                }
                Draw.drawArraw((Graphics2D)g, (PointF)p1, (double)angle, (float)slb.getArrowHeadLength(), (float)slb.getArrowHeadWidth(), (float)slb.getArrowOverhang(), (Color)color, (Color)color);
            }
        }
        if (aPLS.isEditing()) {
            for (PointF drawP : drawPs) {
                Draw.drawSelectedVertice((Graphics2D)g, (PointF)drawP, (float)8.0f, (Color)Color.red, (Color)Color.cyan);
            }
        }
    }

    private void drawPolygonShape(Graphics2D g, PolygonShape aPGS, PolygonBreak aPGB, double LonShift) {
        this.drawPolygonShape(g, aPGS, aPGB, LonShift, false);
    }

    private void drawPolygonShape(Graphics2D g, PolygonShape aPGS, PolygonBreak aPGB, double LonShift, boolean isSelected) {
        Extent shapeExtent = MIMath.shiftExtentLon((Extent)aPGS.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)shapeExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        ArrayList<PointF> pointList = new ArrayList<PointF>();
        for (Polygon aPolygon : aPGS.getPolygons()) {
            pointList.addAll(this.drawPolygon(g, aPolygon, aPGB, LonShift, aPGS.isSelected()));
        }
        if (isSelected) {
            Extent aExtent = MIMath.getPointFsExtent(pointList);
            g.setColor(Color.red);
            g.drawRect((int)aExtent.minX, (int)aExtent.minY, (int)aExtent.getWidth(), (int)aExtent.getHeight());
        }
    }

    private List<PointF> drawPolygon(Graphics2D g, Polygon aPG, PolygonBreak aPGB, double LonShift, boolean isSelected) {
        double[] sXY;
        PointD wPoint;
        int len = aPG.getOutLine().size();
        GeneralPath path = new GeneralPath(0, len);
        path.moveTo(0.0f, 0.0f);
        ArrayList<PointF> rPoints = new ArrayList<PointF>();
        for (int i = 0; i < aPG.getOutLine().size(); ++i) {
            wPoint = (PointD)aPG.getOutLine().get(i);
            sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
            if (i == 0) {
                path.moveTo(sXY[0], sXY[1]);
            } else {
                path.lineTo(sXY[0], sXY[1]);
            }
            rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
        }
        if (aPG.hasHole()) {
            for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                List newPList = (List)aPG.getHoleLines().get(h);
                for (int j = 0; j < newPList.size(); ++j) {
                    wPoint = (PointD)newPList.get(j);
                    sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                    if (j == 0) {
                        path.moveTo(sXY[0], sXY[1]);
                        continue;
                    }
                    path.lineTo(sXY[0], sXY[1]);
                }
            }
        }
        path.closePath();
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (isSelected) {
                aColor = this._selectColor;
            }
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage((HatchStyle)aPGB.getStyle(), (int)size, (Color)aPGB.getColor(), (Color)aPGB.getBackColor(), (float)aPGB.getStyleLineWidth());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.setColor(aColor);
                g.fill(path);
            }
        } else if (isSelected) {
            g.setColor(this._selectColor);
            g.fill(path);
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(path);
        }
        return rPoints;
    }

    private void drawWebMapLayer(WebMapLayer layer, Graphics2D g, double width, double height) {
        this.drawWebMapLayer(layer, g, width, height, this.tileLoadListener);
    }

    private void drawWebMapLayer(WebMapLayer layer, Graphics2D g, double width, double height, TileLoadListener tll) {
        PointD geoCenter = this.getGeoCenter();
        layer.setAddressLocation(new GeoPosition(geoCenter.Y, geoCenter.X));
        if (!this.fixMapScale) {
            double webMapScale = layer.getWebMapScale();
            if (!MIMath.doubleEquals((double)this._scaleX, (double)webMapScale)) {
                int minZoom = layer.getTileFactory().getInfo().getMinimumZoomLevel();
                int maxZoom = layer.getTileFactory().getInfo().getMaximumZoomLevel();
                int newZoom = minZoom;
                double scale = webMapScale;
                for (int i = maxZoom; i >= minZoom; --i) {
                    layer.setZoom(i);
                    scale = this.getWebMapScale(layer, i, width, height);
                    if (!(this._scaleX < scale)) continue;
                    newZoom = i;
                    if (!(this._scaleX < webMapScale) || i >= maxZoom) break;
                    newZoom = i + 1;
                    scale = this.getWebMapScale(layer, newZoom, width, height);
                    break;
                }
                this.setScale(scale, width, height);
                layer.setWebMapScale(scale);
                layer.setZoom(newZoom);
                this.zoomLevel = newZoom;
            }
            this.fixMapScale = true;
        }
        if (layer.isMaskout()) {
            java.awt.Shape oldRegion = g.getClip();
            this.setClipRegion(g);
            if (oldRegion != null) {
                g.clip(oldRegion);
            }
        }
        layer.drawWebMapLayer(g, width, height, tll);
    }

    private void updateWebMapScale(double width, double height) {
        this.updateWebMapScale(this.getWebMapLayer(), width, height);
    }

    private void updateWebMapScale(WebMapLayer layer, double width, double height) {
        double webMapScale = layer.getWebMapScale();
        if (!MIMath.doubleEquals((double)this._scaleX, (double)webMapScale)) {
            int minZoom = layer.getTileFactory().getInfo().getMinimumZoomLevel();
            int maxZoom = layer.getTileFactory().getInfo().getMaximumZoomLevel();
            int newZoom = minZoom;
            double scale = webMapScale;
            for (int i = maxZoom; i >= minZoom; --i) {
                layer.setZoom(i);
                scale = this.getWebMapScale(layer, i, width, height);
                if (!(this._scaleX < scale)) continue;
                newZoom = i;
                if (!(this._scaleX < webMapScale) || i >= maxZoom) break;
                newZoom = i + 1;
                scale = this.getWebMapScale(layer, newZoom, width, height);
                break;
            }
            this.setScale(scale, width, height);
            layer.setWebMapScale(scale);
            layer.setZoom(newZoom);
            this.zoomLevel = newZoom;
        }
    }

    private double getWebMapScale(WebMapLayer layer, int zoom, double width, double height) {
        Point2D center = layer.getCenter();
        double minx = center.getX() - width / 2.0;
        double miny = center.getY() - height / 2.0;
        double maxx = center.getX() + width / 2.0;
        double maxy = center.getY() + height / 2.0;
        GeoPosition pos1 = GeoUtil.getPosition((Point2D)new Point2D.Double(minx, miny), (int)zoom, (TileFactoryInfo)layer.getTileFactory().getInfo());
        GeoPosition pos2 = GeoUtil.getPosition((Point2D)new Point2D.Double(maxx, maxy), (int)zoom, (TileFactoryInfo)layer.getTileFactory().getInfo());
        PointD p1 = Reproject.reprojectPoint((PointD)new PointD(pos1.getLongitude(), pos1.getLatitude()), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getProjection().getProjInfo());
        PointD p2 = Reproject.reprojectPoint((PointD)new PointD(pos2.getLongitude(), pos2.getLatitude()), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984, (ProjectionInfo)this.getProjection().getProjInfo());
        if (pos2.getLongitude() - pos1.getLongitude() < 360.0 && pos2.getLongitude() <= 180.0) {
            double xlen = Math.abs(p2.X - p1.X);
            return width / xlen;
        }
        double ylen = Math.abs(p2.Y - p1.Y);
        return height / ylen;
    }

    public WebMapLayer getWebMapLayer() {
        for (MapLayer layer : this.layers) {
            if (layer.getLayerType() != LayerTypes.WEB_MAP_LAYER) continue;
            return (WebMapLayer)layer;
        }
        return null;
    }

    public void drawGraphicList(Graphics2D g, double lonShift) {
        if (this._graphicCollection.size() > 0) {
            Extent aExtent = MIMath.shiftExtentLon((Extent)this._graphicCollection.getExtent(), (double)lonShift);
            if (!MIMath.isExtentCross((Extent)aExtent, (Extent)this._drawExtent).booleanValue()) {
                return;
            }
            Object aSM = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this._graphicCollection.getNumGraphics(); ++i) {
                Graphic graphic = this._graphicCollection.get(i);
                for (int j = 0; j < graphic.getNumGraphics(); ++j) {
                    Graphic gg = graphic.getGraphicN(j);
                    this.drawGraphic(g, gg, lonShift);
                }
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aSM);
        }
    }

    public void drawGraphic(Graphics2D g, Graphic graphic, java.awt.Rectangle rect) {
        this.refreshXYScale(rect.width, rect.height);
        AffineTransform oldMatrix = g.getTransform();
        java.awt.Rectangle oldRegion = g.getClipBounds();
        g.setClip(rect);
        this.getMaskOutGraphicsPath(g);
        g.translate(rect.x, rect.y);
        this._maskOutGraphicsPath.transform(g.getTransform());
        RenderingHints rend = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.drawGraphic(g, graphic, 0.0);
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
        g.setRenderingHints(rend);
    }

    public void drawGraphic(Graphics2D g, Graphic aGraphic, double lonShift) {
        Extent aExtent = MIMath.shiftExtentLon((Extent)aGraphic.getShape().getExtent(), (double)lonShift);
        if (MIMath.isExtentCross((Extent)aExtent, (Extent)this._drawExtent).booleanValue()) {
            Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            switch (aGraphic.getShape().getShapeType()) {
                case POLYGON: 
                case RECTANGLE: 
                case CIRCLE: 
                case CURVE_POLYGON: 
                case ELLIPSE: 
                case ARC: {
                    if (!((PolygonBreak)aGraphic.getLegend()).isMaskout()) break;
                    this.setClipRegion(g);
                }
            }
            List points = aGraphic.getShape().getPoints();
            PointF[] screenPoints = new PointF[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                double[] sXY = this.projToScreen(((PointD)points.get((int)i)).X, ((PointD)points.get((int)i)).Y, lonShift);
                screenPoints[i] = new PointF((float)sXY[0], (float)sXY[1]);
            }
            Draw.drawGraphic((PointF[])screenPoints, (Graphic)aGraphic, (Graphics2D)g, (this._mouseTool == MouseTools.EDIT_VERTICES ? 1 : 0) != 0);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
        }
    }

    private void getMaskOutGraphicsPath(Graphics2D g) {
        int aLayerHandle;
        if (this._maskOut.isMask() && (aLayerHandle = this.getLayerHandleFromName(this._maskOut.getMaskLayer())) > 0) {
            GeneralPath tPath = new GeneralPath();
            VectorLayer aLayer = (VectorLayer)this.getLayerByHandle(aLayerHandle);
            double[] lonShiftList = new double[]{0.0};
            if (this._projection.isLonLatMap()) {
                lonShiftList = new double[]{0.0, 360.0, -360.0};
            }
            for (double lonShift : lonShiftList) {
                for (PolygonShape polygonShape : aLayer.getShapes()) {
                    for (Polygon aPolygon : polygonShape.getPolygons()) {
                        GeneralPath aPath = new GeneralPath();
                        for (int i = 0; i < aPolygon.getOutLine().size(); ++i) {
                            PointD wPoint = (PointD)aPolygon.getOutLine().get(i);
                            double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, lonShift);
                            if (i == 0) {
                                aPath.moveTo(sXY[0], sXY[1]);
                                continue;
                            }
                            aPath.lineTo(sXY[0], sXY[1]);
                        }
                        tPath.append(aPath, false);
                    }
                }
            }
            this._maskOutGraphicsPath = tPath;
        }
    }

    private void setClipRegion(Graphics2D g) {
        int aLayerHandle;
        if (this._maskOut.isMask() && (aLayerHandle = this.getLayerHandleFromName(this._maskOut.getMaskLayer())) > 0) {
            this.getMaskOutGraphicsPath(g);
            g.setClip(this._maskOutGraphicsPath);
        }
    }

    public void drawIdShape(Graphics2D g, Shape aShape) {
        ArrayList<Double> lonShifts = new ArrayList<Double>();
        if (MIMath.isExtentCross((Extent)this.getViewExtent(), (Extent)aShape.getExtent()).booleanValue()) {
            lonShifts.add(new Double(0.0));
        }
        if (MIMath.isExtentCross((Extent)this.getViewExtent(), (Extent)MIMath.shiftExtentLon((Extent)aShape.getExtent(), (double)360.0)).booleanValue()) {
            lonShifts.add(new Double(360.0));
        }
        if (MIMath.isExtentCross((Extent)this.getViewExtent(), (Extent)MIMath.shiftExtentLon((Extent)aShape.getExtent(), (double)-360.0)).booleanValue()) {
            lonShifts.add(new Double(-360.0));
        }
        this.getMaskOutGraphicsPath(g);
        Iterator iterator = lonShifts.iterator();
        while (iterator.hasNext()) {
            double LonShift = (Double)iterator.next();
            switch (aShape.getShapeType()) {
                case POINT: 
                case POINT_Z: 
                case POINT_M: {
                    PointShape aPS = (PointShape)aShape;
                    double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, LonShift);
                    PointF aPoint = new PointF();
                    aPoint.X = (float)sXY[0];
                    aPoint.Y = (float)sXY[1];
                    PointBreak aPB = new PointBreak();
                    aPB.setOutlineColor(Color.red);
                    aPB.setSize(10.0f);
                    aPB.setStyle(PointStyle.SQUARE);
                    aPB.setDrawFill(false);
                    Draw.drawPoint((PointF)aPoint, (PointBreak)aPB, (Graphics2D)g);
                    break;
                }
                case POLYLINE: 
                case POLYLINE_Z: 
                case POLYLINE_M: {
                    PolylineShape aPLS = (PolylineShape)aShape;
                    PolylineBreak aPLB = new PolylineBreak();
                    aPLB.setColor(Color.red);
                    aPLB.setWidth(2.0f);
                    this.drawPolylineShape(g, aPLS, aPLB, LonShift, false, false, true);
                    break;
                }
                case POLYGON: 
                case POLYGON_M: 
                case POLYGON_Z: {
                    PolygonShape aPGS = (PolygonShape)aShape;
                    PolygonBreak aPGB = new PolygonBreak();
                    aPGB.setOutlineColor(Color.red);
                    aPGB.setOutlineSize(2.0f);
                    aPGB.setColor(Color.red);
                    this.drawPolygonShape(g, aPGS, aPGB, LonShift);
                }
            }
        }
    }

    public void drawIdShape(Graphics2D g, Shape aShape, java.awt.Rectangle rect) {
        ArrayList<Double> lonShifts = new ArrayList<Double>();
        if (MIMath.isExtentCross((Extent)this.getViewExtent(), (Extent)aShape.getExtent()).booleanValue()) {
            lonShifts.add(new Double(0.0));
        }
        if (MIMath.isExtentCross((Extent)this.getViewExtent(), (Extent)MIMath.shiftExtentLon((Extent)aShape.getExtent(), (double)360.0)).booleanValue()) {
            lonShifts.add(new Double(360.0));
        }
        if (MIMath.isExtentCross((Extent)this.getViewExtent(), (Extent)MIMath.shiftExtentLon((Extent)aShape.getExtent(), (double)-360.0)).booleanValue()) {
            lonShifts.add(new Double(-360.0));
        }
        AffineTransform oldMatrix = g.getTransform();
        java.awt.Shape oldRegion = g.getClip();
        g.setClip(rect);
        this.getMaskOutGraphicsPath(g);
        g.translate(rect.x, rect.y);
        Iterator iterator = lonShifts.iterator();
        while (iterator.hasNext()) {
            double LonShift = (Double)iterator.next();
            switch (aShape.getShapeType()) {
                case POINT: 
                case POINT_Z: 
                case POINT_M: {
                    PointShape aPS = (PointShape)aShape;
                    double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, LonShift);
                    PointF aPoint = new PointF();
                    aPoint.X = (float)sXY[0];
                    aPoint.Y = (float)sXY[1];
                    PointBreak aPB = new PointBreak();
                    aPB.setOutlineColor(Color.red);
                    aPB.setSize(10.0f);
                    aPB.setStyle(PointStyle.SQUARE);
                    aPB.setDrawFill(false);
                    Draw.drawPoint((PointF)aPoint, (PointBreak)aPB, (Graphics2D)g);
                    break;
                }
                case POLYLINE: 
                case POLYLINE_Z: 
                case POLYLINE_M: {
                    PolylineShape aPLS = (PolylineShape)aShape;
                    PolylineBreak aPLB = new PolylineBreak();
                    aPLB.setColor(Color.red);
                    aPLB.setWidth(2.0f);
                    this.drawPolylineShape(g, aPLS, aPLB, LonShift, false);
                    break;
                }
                case POLYGON: 
                case POLYGON_M: 
                case POLYGON_Z: {
                    PolygonShape aPGS = (PolygonShape)aShape;
                    PolygonBreak aPGB = new PolygonBreak();
                    aPGB.setOutlineColor(Color.red);
                    aPGB.setOutlineSize(2.0f);
                    aPGB.setColor(Color.red);
                    this.drawPolygonShape(g, aPGS, aPGB, LonShift);
                }
            }
        }
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
    }

    private void drawLayerLabels(Graphics2D g, VectorLayer aLayer, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aLayer.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        List<Graphic> LabelPoints = aLayer.getLabelPoints();
        PointF aPoint = new PointF();
        for (int i = 0; i < LabelPoints.size(); ++i) {
            Graphic aLP = LabelPoints.get(i);
            PointShape aPS = (PointShape)aLP.getShape();
            LabelBreak aLB = (LabelBreak)aLP.getLegend();
            aPS.setVisible(true);
            String LabelStr = aLB.getText();
            aPoint.X = (float)aPS.getPoint().X;
            aPoint.Y = (float)aPS.getPoint().Y;
            Font drawFont = aLB.getFont();
            if ((double)aPoint.X + LonShift < this._drawExtent.minX || (double)aPoint.X + LonShift > this._drawExtent.maxX || (double)aPoint.Y < this._drawExtent.minY || (double)aPoint.Y > this._drawExtent.maxY) continue;
            double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
            aPoint.X = (float)xy[0];
            aPoint.Y = (float)xy[1];
            FontMetrics metrics = g.getFontMetrics(drawFont);
            Dimension labSize = new Dimension(metrics.stringWidth(LabelStr), metrics.getHeight());
            switch (aLB.getAlignType()) {
                case CENTER: {
                    aPoint.X = (float)xy[0] - (float)(labSize.width / 2);
                    break;
                }
                case RIGHT: {
                    aPoint.X = (float)xy[0] - (float)labSize.width;
                }
            }
            aPoint.Y += (float)(labSize.height / 2);
            aPoint.Y -= aLB.getYShift();
            aPoint.X += aLB.getXShift();
            AffineTransform tempTrans = g.getTransform();
            if (aLB.getAngle() != 0.0f) {
                AffineTransform myTrans = (AffineTransform)tempTrans.clone();
                myTrans.translate(aPoint.X, aPoint.Y);
                myTrans.rotate((double)aLB.getAngle() * Math.PI / 180.0);
                g.setTransform(myTrans);
                aPoint.X = 0.0f;
                aPoint.Y = 0.0f;
            }
            boolean ifDraw = true;
            java.awt.Rectangle rect = this.getGraphicRectangle(g, aLP, LonShift);
            Extent aExtent = new Extent();
            aExtent.minX = rect.x;
            aExtent.maxX = rect.x + rect.width;
            aExtent.minY = rect.y;
            aExtent.maxY = rect.y + rect.height;
            if (aLayer.getLabelSet().isAvoidCollision()) {
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                } else {
                    for (int j = 0; j < extentList.size(); ++j) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(j))).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                    } else {
                        aPS.setVisible(false);
                    }
                }
            }
            if (ifDraw) {
                if (aLayer.getLabelSet().isDrawShadow()) {
                    g.setColor(aLayer.getLabelSet().getShadowColor());
                    g.fill(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, labSize.width, labSize.height));
                }
                g.setFont(drawFont);
                g.setColor(aLP.getLegend().getColor());
                g.drawString(LabelStr, aPoint.X, aPoint.Y);
                if (aPS.isSelected()) {
                    float[] dashPattern = new float[]{2.0f, 1.0f};
                    g.setColor(Color.cyan);
                    g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
                    g.draw(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, labSize.width, labSize.height));
                }
            }
            if (aLB.getAngle() == 0.0f) continue;
            g.setTransform(tempTrans);
        }
    }

    private void drawLayerCharts(Graphics2D g, VectorLayer aLayer, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon((Extent)aLayer.getExtent(), (double)LonShift);
        if (!MIMath.isExtentCross((Extent)lExtent, (Extent)this._drawExtent).booleanValue()) {
            return;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        List<ChartGraphic> chartPoints = aLayer.getChartPoints();
        PointF aPoint = new PointF();
        for (int i = 0; i < chartPoints.size(); ++i) {
            ChartGraphic aCP = chartPoints.get(i);
            PointShape aPS = (PointShape)aCP.getShape();
            ChartBreak aCB = (ChartBreak)aCP.getLegend();
            if (aCB.getChartData().isEmpty()) continue;
            PointD startPos = aCP.getStartPosition();
            aPS.setVisible(true);
            aPoint.X = (float)aPS.getPoint().X;
            aPoint.Y = (float)aPS.getPoint().Y;
            if ((double)aPoint.X + LonShift < this._drawExtent.minX || (double)aPoint.X + LonShift > this._drawExtent.maxX || (double)aPoint.Y < this._drawExtent.minY || (double)aPoint.Y > this._drawExtent.maxY) continue;
            double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
            aPoint.X = (float)xy[0];
            aPoint.Y = (float)xy[1];
            Extent aExtent = aCB.getDrawExtent((PointF)aPoint.clone());
            boolean ifDraw = true;
            if (aLayer.getChartSet().isAvoidCollision()) {
                if (extentList.isEmpty()) {
                    maxExtent = aExtent;
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross((Extent)aExtent, (Extent)maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                } else {
                    for (int j = 0; j < extentList.size(); ++j) {
                        if (!MIMath.isExtentCross((Extent)aExtent, (Extent)((Extent)extentList.get(j))).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent((Extent)maxExtent, (Extent)aExtent);
                    } else {
                        aPS.setVisible(false);
                    }
                }
            }
            if (!ifDraw) continue;
            xy = this.projToScreen(startPos.X, startPos.Y, LonShift);
            PointF sP = new PointF((float)xy[0], (float)xy[1]);
            if (Math.abs(sP.X - aPoint.X) > 5.0f || Math.abs(sP.Y - aPoint.Y) > 5.0f) {
                g.drawLine((int)sP.X, (int)sP.Y, (int)aPoint.X, (int)aPoint.Y);
            }
            aPoint.X = (float)aExtent.minX;
            aPoint.Y = (float)aExtent.maxY;
            Draw.drawChartPoint((PointF)aPoint, (ChartBreak)aCB, (Graphics2D)g);
            if (!aPS.isSelected()) continue;
            float[] dashPattern = new float[]{2.0f, 1.0f};
            g.setColor(Color.cyan);
            g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
            g.draw(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, (float)aExtent.getWidth(), (float)aExtent.getHeight()));
        }
    }

    private void drawXYGrid(Graphics2D g, List<String> XGridStrs, List<String> YGridStrs) {
        GridLabel aGL;
        String drawStr;
        double[] sXY;
        int i;
        if (this.layers.isEmpty()) {
            return;
        }
        int vXNum = (int)(this._drawExtent.maxX - this._drawExtent.minX);
        int vYNum = (int)(this._drawExtent.maxY - this._drawExtent.minY);
        int XDelt = vXNum / 10 + 1;
        int YDelt = vYNum / 10 + 1;
        PointF sP = new PointF(0.0f, 0.0f);
        PointF eP = new PointF(0.0f, 0.0f);
        float X = 0.0f;
        float Y = 0.0f;
        Color lineColor = this._gridLineColor;
        float[] dashPattern = MapView.getDashPattern(this._gridLineStyle);
        BasicStroke pen = new BasicStroke(this._gridLineSize, 0, 0, 10.0f, dashPattern, 0.0f);
        Font drawFont = new Font("Arial", 0, 10);
        if (!this._drawGridLine) {
            lineColor = this.getForeground();
            dashPattern = MapView.getDashPattern(LineStyles.SOLID);
            pen = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        }
        g.setColor(lineColor);
        g.setStroke(pen);
        g.setFont(drawFont);
        int XGridNum = XGridStrs.size();
        int YGridNum = YGridStrs.size();
        this._gridLabels = new ArrayList<GridLabel>();
        for (i = 0; i < XGridNum; i += XDelt) {
            if (!((double)i >= this._drawExtent.minX) || !((double)i <= this._drawExtent.maxX)) continue;
            sXY = this.projToScreen(i, this._drawExtent.minY, 0.0);
            sP.X = (float)sXY[0];
            sP.Y = (float)sXY[1];
            if (this._drawGridLine) {
                sXY = this.projToScreen(i, this._drawExtent.maxY, 0.0);
                eP.X = (float)sXY[0];
                eP.Y = (float)sXY[1];
                if ((double)i > this._drawExtent.minX && (double)i < this._drawExtent.maxX) {
                    g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                }
            }
            drawStr = XGridStrs.get(i);
            aGL = new GridLabel();
            aGL.setBorder(true);
            aGL.setLabPoint(new PointD((double)sP.X, (double)sP.Y));
            aGL.setLabDirection(Direction.South);
            aGL.setLabString(drawStr);
            this._gridLabels.add(aGL);
        }
        this._yGridPosLabel.clear();
        for (i = 0; i < YGridNum; i += YDelt) {
            if (!((double)i > this._drawExtent.minY) || !((double)i < this._drawExtent.maxY)) continue;
            sXY = this.projToScreen(this._drawExtent.minX, i, 0.0);
            sP.X = (float)sXY[0];
            sP.Y = (float)sXY[1];
            if (this._drawGridLine) {
                sXY = this.projToScreen(this._drawExtent.maxX, i, 0.0);
                eP.X = (float)sXY[0];
                eP.Y = (float)sXY[1];
                if ((double)i > this._drawExtent.minY && (double)i < this._drawExtent.maxY) {
                    g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                }
            }
            drawStr = YGridStrs.get(i);
            aGL = new GridLabel();
            aGL.setBorder(true);
            aGL.setLabPoint(new PointD((double)sP.X, (double)sP.Y));
            aGL.setLabDirection(Direction.Weast);
            aGL.setLabString(drawStr);
            this._gridLabels.add(aGL);
        }
    }

    public void exportToPicture(String aFile) throws FileNotFoundException, PrintException, IOException {
        if (aFile.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(aFile);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    @Override
                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        double sf1 = pf.getImageableWidth() / (double)(MapView.this.getWidth() + 1);
                        double sf2 = pf.getImageableHeight() / (double)(MapView.this.getHeight() + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        MapView.this.paintGraphics(g2);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
                out.close();
            }
        } else if (aFile.endsWith(".eps")) {
            int width = this.getWidth();
            int height = this.getHeight();
            Properties p = new Properties();
            p.setProperty("PageSize", "A5");
            PSGraphics2D g = new PSGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g);
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".pdf")) {
            int width = this.getWidth();
            int height = this.getHeight();
            try {
                Document document = new Document(new Rectangle((float)width, (float)height));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(aFile));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate pdfTemp = cb.createTemplate((float)width, (float)height);
                PdfGraphics2D g2 = new PdfGraphics2D((PdfContentByte)pdfTemp, (float)width, (float)height, true);
                this.paintGraphics((Graphics2D)g2);
                g2.dispose();
                cb.addTemplate(pdfTemp, 0.0f, 0.0f);
                document.close();
            }
            catch (DocumentException | FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (aFile.endsWith(".emf")) {
            int width = this.getWidth();
            int height = this.getHeight();
            EMFGraphics2D g = new EMFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g);
            g.endExport();
            g.dispose();
        } else {
            ImageFormats imageFormat = ImageUtil.getImageFormat((String)aFile);
            BufferedImage image = this._mapBitmap;
            switch (imageFormat) {
                case JPEG: {
                    image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                    Graphics2D g = image.createGraphics();
                    if (this.getBackground() != null) {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, image.getWidth(), image.getHeight());
                    }
                    this.paintGraphics(g);
                    g.dispose();
                }
            }
            ImageUtil.imageSave((BufferedImage)image, (String)aFile);
        }
    }

    public void exportToPicture(String fileName, Integer dpi) throws FileNotFoundException, PrintException, IOException {
        if (dpi == null) {
            this.exportToPicture(fileName);
        } else {
            File output = new File(fileName);
            output.delete();
            int width = this.getWidth();
            int height = this.getHeight();
            ImageFormats imageFormat = ImageUtil.getImageFormat((String)fileName);
            double scaleFactor = (double)dpi.intValue() / 72.0;
            int imageType = imageFormat == ImageFormats.JPEG ? 1 : 2;
            BufferedImage image = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), imageType);
            Graphics2D g = image.createGraphics();
            AffineTransform at = g.getTransform();
            at.scale(scaleFactor, scaleFactor);
            g.setTransform(at);
            this.paintGraphics(g);
            g.dispose();
            ImageUtil.imageSave((BufferedImage)image, (String)fileName, (int)dpi);
        }
    }

    private boolean saveImage_Jpeg(String file, int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage bufferedImage = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 1);
        Graphics2D g = bufferedImage.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g);
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(0.85f);
            IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (Exception e) {
            return false;
        }
        g.dispose();
        return true;
    }

    public VectorLayer generateLonLatLayer() {
        return this.generateLonLatLayer(this._gridXOrigin, this._gridYOrigin, this._gridXDelt, this._gridYDelt);
    }

    private VectorLayer generateLonLatLayer(double origin_Lon, double origin_Lat, double Delt_Lon, double Delt_Lat) {
        int shapeNum;
        double lat;
        ArrayList<PointD> PList;
        PolylineShape aPLS;
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE);
        String columnName = "Value";
        Field aDC = new Field(columnName, DataType.FLOAT);
        aLayer.editAddField(aDC);
        aDC = new Field("Longitude", DataType.STRING);
        aLayer.editAddField(aDC);
        double refLon = this._projection.getProjInfo().getRefCutLon();
        int lineNum = 0;
        Extent extent = new Extent();
        boolean isLabelLon = false;
        double lon = origin_Lon;
        block7: while (lon <= 180.0) {
            switch (this._projection.getProjInfo().getProjectionName()) {
                case LongLat: 
                case North_Polar_Stereographic_Azimuthal: 
                case South_Polar_Stereographic_Azimuthal: 
                case Stereographic_Azimuthal: {
                    break;
                }
                default: {
                    if (refLon == 180.0 || refLon == -180.0) {
                        if (lon != 180.0 && lon != -180.0) break;
                        isLabelLon = true;
                        lon = BigDecimalUtil.add((double)lon, (double)Delt_Lon);
                        continue block7;
                    }
                    if (!MIMath.doubleEquals((double)lon, (double)refLon)) break;
                    isLabelLon = true;
                    lon = BigDecimalUtil.add((double)lon, (double)Delt_Lon);
                    continue block7;
                }
            }
            aPLS = new PolylineShape();
            aPLS.setValue(lon);
            extent.minX = lon;
            extent.maxX = lon;
            extent.minY = -90.0;
            extent.maxY = 90.0;
            aPLS.setExtent(extent);
            PList = new ArrayList<PointD>();
            for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                PList.add(new PointD(lon, lat));
            }
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape((Shape)aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lon);
                    aLayer.editCellValue(1, shapeNum, (Object)"Y");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lon = BigDecimalUtil.add((double)lon, (double)Delt_Lon);
        }
        lat = origin_Lat;
        double cenLon = this._projection.getProjInfo().getCenterLon();
        double epsilon = 1.0E-10;
        while (lat <= 90.0) {
            aPLS = new PolylineShape();
            aPLS.setValue(lat);
            extent.minX = -180.0;
            extent.minY = lat;
            extent.maxY = lat;
            extent.maxX = 180.0;
            aPLS.setExtent(extent);
            PList = new ArrayList();
            for (lon = cenLon - 180.0 + epsilon; lon < cenLon + 180.0 - epsilon; lon += 1.0) {
                PList.add(new PointD(lon, lat));
            }
            PList.add(new PointD(cenLon + 180.0 - epsilon, lat));
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape((Shape)aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lat);
                    aLayer.editCellValue(1, shapeNum, (Object)"N");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lat = BigDecimalUtil.add((double)lat, (double)Delt_Lat);
        }
        Extent lExt = new Extent();
        lExt.minX = -180.0;
        lExt.maxX = 180.0;
        lExt.minY = -90.0;
        lExt.maxY = 90.0;
        aLayer.setExtent(lExt);
        aLayer.setLayerName("Map_LonLat");
        aLayer.setFileName("");
        aLayer.setLayerDrawType(LayerDrawType.MAP);
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYLINE, Color.darkGray, 1.0f));
        PolylineBreak aPLB = (PolylineBreak)aLayer.getLegendScheme().getLegendBreaks().get(0);
        aPLB.setStyle(LineStyles.DASH);
        aLayer.setVisible(true);
        return aLayer;
    }

    private VectorLayer generateLonLatLayer_bak(double origin_Lon, double origin_Lat, double Delt_Lon, double Delt_Lat) {
        int shapeNum;
        double lat;
        ArrayList<PointD> PList;
        PolylineShape aPLS;
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE);
        String columnName = "Value";
        Field aDC = new Field(columnName, DataType.FLOAT);
        aLayer.editAddField(aDC);
        aDC = new Field("Longitude", DataType.STRING);
        aLayer.editAddField(aDC);
        double refLon = this._projection.getProjInfo().getRefCutLon();
        int lineNum = 0;
        Extent extent = new Extent();
        boolean isLabelLon = false;
        double lon = origin_Lon;
        while (!(lon >= origin_Lon) || lineNum <= 0 || !(lon - Delt_Lon < origin_Lon)) {
            if (lon > 180.0) {
                lon = BigDecimalUtil.sub((double)lon, (double)360.0);
            }
            if (!this._projection.isLonLatMap()) {
                if (refLon == 180.0 || refLon == -180.0) {
                    if (lon == 180.0 || lon == -180.0) {
                        isLabelLon = true;
                        lon = BigDecimalUtil.add((double)lon, (double)Delt_Lon);
                        continue;
                    }
                } else if (MIMath.doubleEquals((double)lon, (double)refLon)) {
                    isLabelLon = true;
                    lon = BigDecimalUtil.add((double)lon, (double)Delt_Lon);
                    continue;
                }
            }
            aPLS = new PolylineShape();
            aPLS.setValue(lon);
            extent.minX = lon;
            extent.maxX = lon;
            extent.minY = -90.0;
            extent.maxY = 90.0;
            aPLS.setExtent(extent);
            PList = new ArrayList<PointD>();
            for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                PList.add(new PointD(lon, lat));
            }
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape((Shape)aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lon);
                    aLayer.editCellValue(1, shapeNum, (Object)"Y");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lon = BigDecimalUtil.add((double)lon, (double)Delt_Lon);
        }
        switch (this._projection.getProjInfo().getProjectionName()) {
            case LongLat: 
            case Oblique_Stereographic_Alternative: {
                break;
            }
            default: {
                lon = refLon - (double)1.0E-4f;
                if (lon < -180.0) {
                    lon += 360.0;
                }
                aPLS = new PolylineShape();
                aPLS.setValue(lon);
                extent.minX = lon;
                extent.maxX = lon;
                extent.minY = -90.0;
                extent.maxY = 90.0;
                aPLS.setExtent(extent);
                PList = new ArrayList();
                for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                    PList.add(new PointD(lon, lat));
                }
                aPLS.setPoints(PList);
                double value = isLabelLon ? refLon : -9999.0;
                shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape((Shape)aPLS, shapeNum)) {
                        aLayer.editCellValue(0, shapeNum, (Object)value);
                        aLayer.editCellValue(1, shapeNum, (Object)"Y");
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                }
                lon = refLon + (double)1.0E-4f;
                if (lon > 180.0) {
                    lon -= 360.0;
                }
                aPLS = new PolylineShape();
                aPLS.setValue(lon);
                extent.minX = lon;
                extent.maxX = lon;
                extent.minY = -90.0;
                extent.maxY = 90.0;
                aPLS.setExtent(extent);
                PList = new ArrayList();
                for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                    PList.add(new PointD(lon, lat));
                }
                aPLS.setPoints(PList);
                value = isLabelLon ? refLon : -9999.0;
                shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aPLS, shapeNum)) break;
                    aLayer.editCellValue(0, shapeNum, (Object)value);
                    aLayer.editCellValue(1, shapeNum, (Object)"Y");
                    break;
                }
                catch (Exception ex) {
                    Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        lat = -90.0;
        while (lat <= 90.0) {
            aPLS = new PolylineShape();
            aPLS.setValue(lat);
            extent.minX = -180.0;
            extent.minY = lat;
            extent.maxY = lat;
            extent.maxX = 180.0;
            aPLS.setExtent(extent);
            PList = new ArrayList();
            for (lon = -180.0; lon <= 180.0; lon += 1.0) {
                PList.add(new PointD(lon, lat));
            }
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape((Shape)aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lat);
                    aLayer.editCellValue(1, shapeNum, (Object)"N");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lat = BigDecimalUtil.add((double)lat, (double)Delt_Lat);
        }
        Extent lExt = new Extent();
        lExt.minX = -180.0;
        lExt.maxX = 180.0;
        lExt.minY = -90.0;
        lExt.maxY = 90.0;
        aLayer.setExtent(lExt);
        aLayer.setLayerName("Map_LonLat");
        aLayer.setFileName("");
        aLayer.setLayerDrawType(LayerDrawType.MAP);
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYLINE, Color.darkGray, 1.0f));
        PolylineBreak aPLB = (PolylineBreak)aLayer.getLegendScheme().getLegendBreaks().get(0);
        aPLB.setStyle(LineStyles.DASH);
        aLayer.setVisible(true);
        return aLayer;
    }

    private void updateLonLatLayer() {
        if (this._lonLatLayer == null || this._gridDeltChanged) {
            this._lonLatLayer = this.generateLonLatLayer();
            if (!this._projection.isLonLatMap()) {
                ProjectionInfo toProj = this._projection.getProjInfo();
                GeoProjectionUtil.projectLayer(this._lonLatLayer, toProj);
            }
            this._gridDeltChanged = false;
        }
    }

    private void getLonLatGridLabels() {
        if (this._isGeoMap) {
            ArrayList labels = new ArrayList();
            if (this._projection.isLonLatMap()) {
                if (this._lonLatLayer == null) {
                    return;
                }
                for (int i = 0; i < this._lonLatLayer.getShapeNum(); ++i) {
                    PolylineShape aPLS = (PolylineShape)this._lonLatLayer.getShapes().get(i);
                    String labStr = this._lonLatLayer.getCellValue(0, i).toString().trim();
                    labStr = DataConvert.removeTailingZeros((String)labStr);
                    float value = Float.parseFloat(labStr);
                    String isLonStr = this._lonLatLayer.getCellValue(1, i).toString();
                    boolean isLon = "Y".equals(isLonStr);
                    if (isLon) {
                        if (value == -180.0f) {
                            labStr = "180";
                        } else if (value != 0.0f && value != 180.0f) {
                            labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "W" : labStr + "E";
                        }
                    } else if (value != 0.0f) {
                        labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "S" : labStr + "N";
                    }
                    ArrayList<GridLabel> gLabels = new ArrayList<GridLabel>();
                    for (int l = 0; l < aPLS.getPolylines().size(); ++l) {
                        Polyline aPL = (Polyline)aPLS.getPolylines().get(l);
                        gLabels.addAll(GeoComputation.getGridLabels_StraightLine(aPL, this._drawExtent, isLon));
                        if (!isLon) continue;
                        ArrayList<PointD> aPList = new ArrayList<PointD>();
                        for (int j = 0; j < aPL.getPointList().size(); ++j) {
                            PointD aP = (PointD)((PointD)aPL.getPointList().get(j)).clone();
                            aP.X += 360.0;
                            aPList.add(aP);
                        }
                        aPL = new Polyline();
                        aPL.setPointList(aPList);
                        gLabels.addAll(GeoComputation.getGridLabels_StraightLine(aPL, this._drawExtent, isLon));
                        for (PointD p : aPList) {
                            PointD aP = (PointD)p.clone();
                            aP.X -= 720.0;
                        }
                        aPL = new Polyline();
                        aPL.setPointList(aPList);
                        gLabels.addAll(GeoComputation.getGridLabels_StraightLine(aPL, this._drawExtent, isLon));
                    }
                    for (GridLabel gLabel : gLabels) {
                        gLabel.setLabString(labStr);
                    }
                    labels.addAll(gLabels);
                }
            } else {
                if (this._lonLatLayer == null) {
                    return;
                }
                ArrayList gridLabels = new ArrayList();
                for (int i = 0; i < this._lonLatLayer.getShapeNum(); ++i) {
                    PolylineShape aPLS = (PolylineShape)this._lonLatLayer.getShapes().get(i);
                    String labStr = this._lonLatLayer.getCellValue(0, i).toString().trim();
                    float value = Float.parseFloat(labStr = DataConvert.removeTailingZeros((String)labStr));
                    if ((double)value == -9999.0) continue;
                    String isLonStr = this._lonLatLayer.getCellValue(1, i).toString();
                    boolean isLon = isLonStr.equals("Y");
                    if (isLon) {
                        if (value == -180.0f) {
                            labStr = "180";
                        } else if (value != 0.0f && value != 180.0f) {
                            labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "W" : labStr + "E";
                        }
                    } else {
                        if (value == 90.0f || value == -90.0f) continue;
                        if (value != 0.0f) {
                            labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "S" : labStr + "N";
                        }
                    }
                    ArrayList<GridLabel> gLabels = new ArrayList<GridLabel>();
                    for (Polyline aPL : aPLS.getPolylines()) {
                        gLabels.addAll(GeoComputation.getGridLabels(aPL, this._drawExtent, isLon));
                    }
                    for (GridLabel gLabel : gLabels) {
                        gLabel.setLabString(labStr);
                        gLabel.setValue(value);
                    }
                    gridLabels.addAll(gLabels);
                }
                switch (this._projection.getProjInfo().getProjectionName()) {
                    case Lambert_Conformal_Conic: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (!aGL.isLongitude()) {
                                    aGL.setLabDirection(Direction.North);
                                } else {
                                    if (aGL.getCoord().Y > 0.0 && Math.abs(aGL.getCoord().X) < 1000.0) continue;
                                    if (MIMath.lonDistance((float)aGL.getValue(), (float)((float)this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees())) > 60.0f) {
                                        if (aGL.getCoord().X < 0.0) {
                                            aGL.setLabDirection(Direction.Weast);
                                        } else {
                                            aGL.setLabDirection(Direction.East);
                                        }
                                    } else {
                                        aGL.setLabDirection(Direction.South);
                                    }
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Albers_Equal_Area: 
                    case Lambert_Equal_Area_Conic: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (!aGL.isLongitude()) {
                                    aGL.setLabDirection(Direction.North);
                                } else {
                                    if (aGL.getCoord().Y > 7000000.0 && Math.abs(aGL.getCoord().X) < 5000000.0) continue;
                                    if (MIMath.lonDistance((float)aGL.getValue(), (float)((float)this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees())) > 60.0f) {
                                        if (aGL.getCoord().X < 0.0) {
                                            aGL.setLabDirection(Direction.Weast);
                                        } else {
                                            aGL.setLabDirection(Direction.East);
                                        }
                                    } else {
                                        aGL.setLabDirection(Direction.South);
                                    }
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Mercator: {
                        for (GridLabel gl : gridLabels) {
                            if (!gl.isBorder() && gl.isLongitude() && gl.getCoord().Y > 1000.0) {
                                gl.setLabDirection(Direction.North);
                            }
                            labels.add(gl);
                        }
                        break;
                    }
                    case North_Polar_Stereographic_Azimuthal: 
                    case South_Polar_Stereographic_Azimuthal: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (!aGL.isLongitude() || Math.abs(aGL.getCoord().X) < 1000.0 && Math.abs(aGL.getCoord().Y) < 1000.0) continue;
                                float refLon = (float)this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
                                if (MIMath.lonDistance((float)aGL.getValue(), (float)refLon) < 45.0f) {
                                    if (this._projection.getProjInfo().getProjectionName() == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                                        aGL.setLabDirection(Direction.South);
                                    } else {
                                        aGL.setLabDirection(Direction.North);
                                    }
                                } else {
                                    refLon = MIMath.lonAdd((float)refLon, (float)180.0f);
                                    if (MIMath.lonDistance((float)aGL.getValue(), (float)refLon) < 45.0f) {
                                        if (this._projection.getProjInfo().getProjectionName() == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                                            aGL.setLabDirection(Direction.North);
                                        } else {
                                            aGL.setLabDirection(Direction.South);
                                        }
                                    } else if (aGL.getCoord().X < 0.0) {
                                        aGL.setLabDirection(Direction.Weast);
                                    } else {
                                        aGL.setLabDirection(Direction.East);
                                    }
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Robinson: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (aGL.isLongitude()) {
                                    if (aGL.getCoord().Y < 0.0) {
                                        aGL.setLabDirection(Direction.South);
                                    } else {
                                        aGL.setLabDirection(Direction.North);
                                    }
                                } else if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Molleweide: 
                    case Hammer_Eckert: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (aGL.isLongitude()) continue;
                                if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Orthographic_Azimuthal: 
                    case Geostationary_Satellite: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (aGL.isLongitude()) continue;
                                if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Oblique_Stereographic_Alternative: 
                    case Transverse_Mercator: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) continue;
                            labels.add(aGL);
                        }
                        break;
                    }
                    default: {
                        labels = gridLabels;
                    }
                }
            }
            this._gridLabels.clear();
            for (GridLabel aGL : labels) {
                double[] sXY = this.projToScreen(aGL.getCoord().X, aGL.getCoord().Y);
                aGL.setLabPoint(new PointD(sXY[0], sXY[1]));
                this._gridLabels.add(aGL);
            }
        }
    }

    public double[] projToScreen(double projX, double projY) {
        double screenX = (projX - this._drawExtent.minX) * this._scaleX;
        double screenY = (this._drawExtent.maxY - projY) * this._scaleY;
        return new double[]{screenX, screenY};
    }

    public double[] projToScreen(double projX, double projY, double LonShift) {
        double screenX = (projX + LonShift - this._drawExtent.minX) * this._scaleX;
        double screenY = (this._drawExtent.maxY - projY) * this._scaleY;
        return new double[]{screenX, screenY};
    }

    public Rectangle2D.Double projToScreen(Extent extent, double lonShift) {
        double[] sXY = this.projToScreen(extent.minX, extent.minY, lonShift);
        double[] eXY = this.projToScreen(extent.maxX, extent.maxY, lonShift);
        return new Rectangle2D.Double(sXY[0], eXY[1], Math.abs(eXY[0] - sXY[0]), Math.abs(eXY[1] - sXY[1]));
    }

    public double[] lonLatToScreen(double lon, double lat) {
        double screenX = 0.0;
        double screenY = 0.0;
        if (this._projection.isLonLatMap()) {
            double lonShift = this.getLonShift(lon);
            double[] sxy = this.projToScreen(lon, lat, lonShift);
            screenX = sxy[0];
            screenY = sxy[1];
        } else {
            ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
            ProjectionInfo toProj = this._projection.getProjInfo();
            double[][] points = new double[][]{{lon, lat}};
            try {
                Reproject.reprojectPoints((double[][])points, (ProjectionInfo)fromProj, (ProjectionInfo)toProj, (int)0, (int)1);
                double projX = points[0][0];
                double projY = points[0][1];
                double[] sxy = this.projToScreen(projX, projY);
                screenX = sxy[0];
                screenY = sxy[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new double[]{screenX, screenY};
    }

    public double[] screenToProj(double screenX, double screenY) {
        double projX = screenX / this._scaleX + this._drawExtent.minX;
        double projY = this._drawExtent.maxY - screenY / this._scaleY;
        return new double[]{projX, projY};
    }

    public double[] screenToProj(double screenX, double screenY, double zoom) {
        double projX = screenX / this._scaleX * zoom + this._drawExtent.minX;
        double projY = this._drawExtent.maxY - screenY / this._scaleY * zoom;
        return new double[]{projX, projY};
    }

    public float[] screenToProj(float screenX, float screenY) {
        float projX = (float)((double)screenX / this._scaleX + this._drawExtent.minX);
        float projY = (float)(this._drawExtent.maxY - (double)screenY / this._scaleY);
        return new float[]{projX, projY};
    }

    public float[] screenToProj(float screenX, float screenY, double LonShift) {
        float projX = (float)((double)screenX / this._scaleX + this._drawExtent.minX + LonShift);
        float projY = (float)(this._drawExtent.maxY - (double)screenY / this._scaleY);
        return new float[]{projX, projY};
    }

    private double[] getProjXYShift(PointD p, double x, double y) {
        double[] xy = this.projToScreen(p.X, p.Y);
        double[] pxy = this.screenToProj(xy[0] + x, xy[1] - y);
        double xShift = pxy[0] - p.X;
        double yShift = pxy[1] - p.Y;
        return new double[]{xShift, yShift};
    }

    private double[] getProjXYShift(Point point1, Point point2) {
        double[] pXY1 = this.screenToProj((double)point1.x, (double)point1.y);
        double[] pXY2 = this.screenToProj((double)point2.x, (double)point2.y);
        double xShift = pXY2[0] - pXY1[0];
        double yShift = pXY2[1] - pXY1[1];
        return new double[]{xShift, yShift};
    }

    public void moveShapeOnScreen(Shape aShape, double x, double y) {
        double[] sXY = this.getProjXYShift((PointD)aShape.getPoints().get(0), x, y);
        this.moveShape(aShape, sXY[0], sXY[1]);
    }

    public void moveGraphic(Graphic graphic, double x, double y, boolean screen) {
        Shape shape = graphic.getShape();
        if (screen) {
            this.moveShapeOnScreen(shape, x, y);
        } else {
            this.moveShape(shape, x, y);
        }
    }

    public void moveShapeOnScreen(Shape aShape, Point point1, Point point2) {
        double[] sXY = this.getProjXYShift(point1, point2);
        this.moveShape(aShape, sXY[0], sXY[1]);
    }

    private void moveShape(Shape aShape, double xShift, double yShift) {
        List points = aShape.getPoints();
        for (PointD aPoint : points) {
            aPoint.X += xShift;
            aPoint.Y += yShift;
        }
        aShape.setPoints(points);
    }

    public void resizeShapeOnScreen(Shape aShape, ColorBreak legend, java.awt.Rectangle newRect) {
        double[] min = this.screenToProj((double)newRect.x, (double)newRect.y + (double)newRect.height);
        double[] max = this.screenToProj((double)newRect.x + (double)newRect.width, (double)newRect.y);
        Extent newExtent = new Extent(min[0], max[0], min[1], max[1]);
        ArrayList<PointD> points = aShape.getPoints();
        Extent aExtent = aShape.getExtent();
        switch (aShape.getShapeType()) {
            case POINT: 
            case POINT_M: {
                if (legend.getBreakType() != BreakTypes.POINT_BREAK) break;
                PointBreak aPB = (PointBreak)legend;
                aPB.setSize((float)newRect.width);
                break;
            }
            case POLYLINE: 
            case POLYGON: 
            case POLYGON_M: 
            case POLYGON_Z: 
            case CIRCLE: 
            case CURVE_POLYGON: 
            case CURVE_LINE: {
                this.moveShape(aShape, newExtent.minX - aExtent.minX, newExtent.minY - aExtent.minY);
                double deltaX = newExtent.getWidth() - aExtent.getWidth();
                double deltaY = newExtent.getHeight() - aExtent.getHeight();
                for (int i = 0; i < points.size(); ++i) {
                    PointD aP = (PointD)points.get(i);
                    aP.X += deltaX * (aP.X - aExtent.minX) / aExtent.getWidth();
                    aP.Y += deltaY * (aP.Y - aExtent.minY) / aExtent.getHeight();
                    points.set(i, aP);
                }
                aShape.setPoints(points);
                break;
            }
            case RECTANGLE: 
            case ELLIPSE: {
                points = new ArrayList<PointD>();
                points.add(new PointD(newExtent.minX, newExtent.minY));
                points.add(new PointD(newExtent.minX, newExtent.maxY));
                points.add(new PointD(newExtent.maxX, newExtent.maxY));
                points.add(new PointD(newExtent.maxX, newExtent.minY));
                if (aShape.getShapeType() == ShapeTypes.RECTANGLE) {
                    points.add((PointD)((PointD)points.get(0)).clone());
                }
                aShape.setPoints(points);
            }
        }
    }

    public void resizeShapeOnScreen(Graphic graphic, java.awt.Rectangle newRect) {
        this.resizeShapeOnScreen(graphic.getShape(), graphic.getLegend(), newRect);
    }

    public double getLonShift(Extent aExtent) {
        double LonShift = 0.0;
        if (this._drawExtent.maxX < aExtent.minX) {
            LonShift = -360.0;
        }
        if (this._drawExtent.minX > aExtent.maxX) {
            LonShift = 360.0;
        }
        return LonShift;
    }

    public double getLonShift(double lon) {
        double LonShift = 0.0;
        if (this._drawExtent.maxX < lon) {
            LonShift = -360.0;
        }
        if (this._drawExtent.minX > lon) {
            LonShift = 360.0;
        }
        return LonShift;
    }

    public void zoomToExtent(Extent aExtent) {
        this._viewExtent = aExtent;
        this.refreshXYScale();
        this.repaintNew();
        this.fireViewExtentChangedEvent();
    }

    public void zoomToExtent(Extent aExtent, int width, int height) {
        this._viewExtent = aExtent;
        this.refreshXYScale(width, height);
        this.repaintNew();
        this.fireViewExtentChangedEvent();
    }

    public void zoomToExtent(double minX, double maxX, double minY, double maxY) {
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.ZoomEdit edit = new MapViewUndoRedo.ZoomEdit(mapViewUndoRedo, this, (Extent)this._viewExtent.clone(), (Extent)aExtent.clone());
        this.fireUndoEditEvent(edit);
        this.zoomToExtent(aExtent);
    }

    public void zoomToExtentScreen(double minX, double maxX, double minY, double maxY, double zoom) {
        double[] pMin = this.screenToProj(minX, maxY, zoom);
        double[] pMax = this.screenToProj(maxX, minY, zoom);
        this.zoomToExtent(pMin[0], pMax[0], pMin[1], pMax[1]);
    }

    public void zoomToExtentLonLatEx(Extent aExtent) {
        if (!this._projection.isLonLatMap()) {
            aExtent = this._projection.getProjectedExtentFromLonLat(aExtent);
        }
        this.zoomToExtent(aExtent);
    }

    public void zoomToExtentLonLatEx_back(Extent aExtent) {
        if (!this._projection.isLonLatMap()) {
            aExtent = this._projection.getProjectedExtentFromLonLat(aExtent);
        }
        this._viewExtent = aExtent;
        if (this._isGeoMap) {
            this.setCoordinateGeoMapEx(aExtent);
        } else {
            this.setCoordinateMap(aExtent);
        }
        this._drawExtent = aExtent;
        this.repaintNew();
        this.fireViewExtentChangedEvent();
    }

    private void setCoordinateGeoMap(Extent aExtent) {
        this.setCoordinateGeoMap(aExtent, this.getWidth(), this.getHeight());
    }

    private void setCoordinateGeoMap(Extent aExtent, double width, double height) {
        this._scaleX = width / (aExtent.maxX - aExtent.minX);
        this._scaleY = height / (aExtent.maxY - aExtent.minY);
        double scaleFactor = this._projection.isLonLatMap() ? this._XYScaleFactor : 1.0;
        if (this._scaleX > this._scaleY) {
            this._scaleX = this._scaleY / scaleFactor;
            double temp = aExtent.minX;
            aExtent.minX = aExtent.maxX - width / this._scaleX;
            double lonRan = (aExtent.minX - temp) / 2.0;
            aExtent.minX -= lonRan;
            aExtent.maxX -= lonRan;
        } else if (this._scaleX < this._scaleY) {
            this._scaleY = this._scaleX * scaleFactor;
            double temp = aExtent.minY;
            aExtent.minY = aExtent.maxY - height / this._scaleY;
            double latRan = (aExtent.minY - temp) / 2.0;
            aExtent.minY -= latRan;
            aExtent.maxY -= latRan;
        }
    }

    private void setCoordinateGeoMapEx(Extent aExtent) {
        this.setCoordinateGeoMapEx(aExtent, this.getWidth(), this.getHeight());
    }

    private void setCoordinateGeoMapEx(Extent aExtent, double width, double height) {
        this._scaleX = width / (aExtent.maxX - aExtent.minX);
        this._scaleY = height / (aExtent.maxY - aExtent.minY);
        double scaleFactor = this._projection.isLonLatMap() ? this._XYScaleFactor : 1.0;
        if (this._scaleX < this._scaleY) {
            this._scaleX = this._scaleY / scaleFactor;
        } else {
            this._scaleY = this._scaleX * scaleFactor;
        }
    }

    private void setCoordinateMap(Extent aExtent) {
        this.setCoordinateMap(aExtent, this.getWidth(), this.getHeight());
    }

    private void setCoordinateMap(Extent aExtent, double width, double height) {
        this._scaleX = width / (aExtent.maxX - aExtent.minX);
        this._scaleY = height / (aExtent.maxY - aExtent.minY);
    }

    private void setScale(double scale, double width, double height) {
        this._scaleX = scale;
        this._scaleY = scale;
        PointD center = (PointD)this._drawExtent.getCenterPoint().clone();
        double xlen = width / scale * 0.5;
        double ylen = height / scale * 0.5;
        this._drawExtent.minX = center.X - xlen;
        this._drawExtent.maxX = center.X + xlen;
        this._drawExtent.minY = center.Y - ylen;
        this._drawExtent.maxY = center.Y + ylen;
    }

    public void refreshXYScale() {
        this.refreshXYScale(this.getWidth(), this.getHeight());
    }

    public void refreshXYScale(double width, double height) {
        Extent aExtent = (Extent)this._viewExtent.clone();
        if (this._isGeoMap) {
            this.setCoordinateGeoMap(aExtent, width, height);
        } else {
            this.setCoordinateMap(aExtent, width, height);
        }
        this._drawExtent = aExtent;
    }

    public void refreshXYScale(Extent extent, double width, double height) {
        if (this._isGeoMap) {
            this.setCoordinateGeoMap(extent, width, height);
        } else {
            this.setCoordinateMap(extent, width, height);
        }
        this._drawExtent = extent;
    }

    public void refreshXYScaleWebMap(Extent extent, double width, double height) {
        this.setCoordinateGeoMap(extent, width, height);
        this._drawExtent = extent;
        this.updateWebMapScale(width, height);
    }

    private double getGeoWidth(double width) {
        double geoWidth = width / this._scaleX;
        if (this._projection.isLonLatMap()) {
            geoWidth *= this.getLonDistScale();
        }
        return geoWidth;
    }

    private double getLonDistScale() {
        double pY = (this._viewExtent.maxY + this._viewExtent.minY) / 2.0;
        double ProjX = 0.0;
        double ProjY = pY;
        double pProjX = 1.0;
        double pProjY = pY;
        double dx = Math.abs(ProjX - pProjX);
        double dy = Math.abs(ProjY - pProjY);
        double y = (ProjY + pProjY) / 2.0;
        double factor = Math.cos(y * Math.PI / 180.0);
        double dist = Math.sqrt((dx *= factor) * dx + dy * dy);
        return dist *= 111319.5;
    }

    public double getGeoScale() {
        double breakWidth = 1.0;
        double geoBreakWidth = this.getGeoWidth(breakWidth);
        double scale = geoBreakWidth * 100.0 / (breakWidth / 96.0 * 2.539999918);
        return scale;
    }

    public PointD getGeoCenter() {
        PointD viewCenter = this.getViewCenter();
        return Reproject.reprojectPoint((PointD)viewCenter, (ProjectionInfo)this.getProjection().getProjInfo(), (ProjectionInfo)KnownCoordinateSystems.geographic.world.WGS1984);
    }

    public PointD getViewCenter() {
        return this._viewExtent.getCenterPoint();
    }

    public void setViewCenter(PointD center) {
        PointD oldCenter = this.getViewCenter();
        double dx = center.X - oldCenter.X;
        double dy = center.Y - oldCenter.Y;
        Extent extent = this._viewExtent.shift(dx, dy);
        this.zoomToExtent(extent);
    }

    public boolean selectGraphics(PointF aPoint, GraphicCollection selectedGraphics, double lonShift) {
        this._visibleGraphics = this.getVisibleGraphics();
        return this.selectGraphics(aPoint, this._visibleGraphics, selectedGraphics, lonShift, 0);
    }

    private GraphicCollection getVisibleGraphics() {
        GraphicCollection graphicCollection = new GraphicCollection();
        for (Graphic aGraphic : this._graphicCollection.getGraphics()) {
            graphicCollection.add(aGraphic);
        }
        for (MapLayer aLayer : this.layers) {
            if (aLayer.getLayerType() != LayerTypes.VECTOR_LAYER || !aLayer.isVisible()) continue;
            VectorLayer vLayer = (VectorLayer)aLayer;
            for (Graphic graphic : vLayer.getLabelPoints()) {
                if (!graphic.getShape().isVisible()) continue;
                graphicCollection.add(graphic);
            }
            for (Graphic graphic : vLayer.getChartPoints()) {
                if (!graphic.getShape().isVisible()) continue;
                graphicCollection.add(graphic);
            }
        }
        return graphicCollection;
    }

    public boolean selectGraphics_back(PointF aPoint, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift, int limit) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            if (baseGraphics.get(0).getShape().getShapeType() == ShapeTypes.POINT) {
                for (i = 0; i < baseGraphics.size(); ++i) {
                    Graphic aGraphic = baseGraphics.get(i);
                    java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                    rect.width += limit;
                    rect.height += limit;
                    if (!MIMath.pointInRectangle((PointF)aPoint, (java.awt.Rectangle)rect)) continue;
                    selectedGraphics.add(aGraphic);
                    break;
                }
                if (selectedGraphics.size() > 0) {
                    ifCheckLonShift = false;
                    ifSel = false;
                }
            }
            if (ifCheckLonShift) {
                float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                rect.width += limit;
                rect.height += limit;
                if (!MIMath.pointInRectangle((PointF)aPoint, (java.awt.Rectangle)rect)) continue;
                selectedGraphics.add(aGraphic);
            }
        }
        return selectedGraphics.size() > 0;
    }

    public boolean selectGraphics(PointF aPoint, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift, int limit) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        double[] projXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
        double projX = projXY[0] + lonShift;
        double projY = projXY[1];
        PointD pp = new PointD(projX, projY);
        double buffer = 5.0 / this._scaleX;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            block6: for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                switch (aGraphic.getShape().getShapeType()) {
                    case POLYLINE: 
                    case CURVE_LINE: {
                        PolylineShape aPLS = (PolylineShape)aGraphic.getShape();
                        if (GeoComputation.selectPolylineShape((PointD)pp, (PolylineShape)aPLS, (double)buffer) == null) continue block6;
                        selectedGraphics.add(aGraphic);
                        continue block6;
                    }
                    default: {
                        java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                        rect.width += limit;
                        rect.height += limit;
                        if (!MIMath.pointInRectangle((PointF)aPoint, (java.awt.Rectangle)rect)) continue block6;
                        selectedGraphics.add(aGraphic);
                    }
                }
            }
            if (selectedGraphics.size() > 0) {
                ifCheckLonShift = false;
                ifSel = false;
            }
            if (ifCheckLonShift) {
                float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            projX = projXY[0] + lonShift;
            pp = new PointD(projX, projY);
            block7: for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                switch (aGraphic.getShape().getShapeType()) {
                    case POLYLINE: 
                    case CURVE_LINE: {
                        PolylineShape aPLS = (PolylineShape)aGraphic.getShape();
                        if (GeoComputation.selectPolylineShape((PointD)pp, (PolylineShape)aPLS, (double)buffer) == null) continue block7;
                        selectedGraphics.add(aGraphic);
                        continue block7;
                    }
                    default: {
                        java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                        rect.width += limit;
                        rect.height += limit;
                        if (!MIMath.pointInRectangle((PointF)aPoint, (java.awt.Rectangle)rect)) continue block7;
                        selectedGraphics.add(aGraphic);
                    }
                }
            }
        }
        return selectedGraphics.size() > 0;
    }

    public boolean selectGraphics(java.awt.Rectangle aRect, GraphicCollection selectedGraphics, double lonShift) {
        this._visibleGraphics = this.getVisibleGraphics();
        return this.selectGraphics(aRect, this._visibleGraphics, selectedGraphics, lonShift);
    }

    public boolean selectGraphics_back(java.awt.Rectangle aRect, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            if (baseGraphics.get(0).getShape().getShapeType() == ShapeTypes.POINT) {
                for (i = 0; i < baseGraphics.size(); ++i) {
                    Graphic aGraphic = baseGraphics.get(i);
                    java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                    if (!MIMath.isInclude((java.awt.Rectangle)aRect, (java.awt.Rectangle)rect)) continue;
                    selectedGraphics.add(aGraphic);
                    break;
                }
                if (selectedGraphics.size() > 0) {
                    ifCheckLonShift = false;
                    ifSel = false;
                }
            }
            if (ifCheckLonShift) {
                Point aPoint = new Point(aRect.x + aRect.width / 2, aRect.y + aRect.height / 2);
                float[] pXY = this.screenToProj(aPoint.x, aPoint.y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                if (!MIMath.isInclude((java.awt.Rectangle)aRect, (java.awt.Rectangle)rect)) continue;
                selectedGraphics.add(aGraphic);
            }
        }
        return selectedGraphics.size() > 0;
    }

    public boolean selectGraphics(java.awt.Rectangle aRect, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                if (!MIMath.isInclude((java.awt.Rectangle)aRect, (java.awt.Rectangle)rect)) continue;
                selectedGraphics.add(aGraphic);
                break;
            }
            if (selectedGraphics.size() > 0) {
                ifCheckLonShift = false;
                ifSel = false;
            }
            if (ifCheckLonShift) {
                Point aPoint = new Point(aRect.x + aRect.width / 2, aRect.y + aRect.height / 2);
                float[] pXY = this.screenToProj(aPoint.x, aPoint.y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                if (!MIMath.isInclude((java.awt.Rectangle)aRect, (java.awt.Rectangle)rect)) continue;
                selectedGraphics.add(aGraphic);
            }
        }
        return selectedGraphics.size() > 0;
    }

    private static Edge intersectElementEdge(java.awt.Rectangle screen, PointF pt, float limit) {
        Rectangle2D.Float ptRect = new Rectangle2D.Float(pt.X - limit, pt.Y - limit, 2.0f * limit, 2.0f * limit);
        if (pt.X >= (float)screen.x - limit && pt.X <= (float)screen.x + limit && pt.Y >= (float)screen.y - limit && pt.Y <= (float)screen.y + limit) {
            return Edge.TOP_LEFT;
        }
        if (pt.X >= (float)(screen.x + screen.width) - limit && pt.X <= (float)(screen.x + screen.width) + limit && pt.Y >= (float)screen.y - limit && pt.Y <= (float)screen.y + limit) {
            return Edge.TOP_RIGHT;
        }
        if (pt.X >= (float)(screen.x + screen.width) - limit && pt.X <= (float)(screen.x + screen.width) + limit && pt.Y >= (float)(screen.y + screen.height) - limit && pt.Y <= (float)(screen.y + screen.height) + limit) {
            return Edge.BOTTOM_RIGHT;
        }
        if (pt.X >= (float)screen.x - limit && pt.X <= (float)screen.x + limit && pt.Y >= (float)(screen.y + screen.height) - limit && pt.Y <= (float)(screen.y + screen.height) + limit) {
            return Edge.BOTTOM_LEFT;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y, screen.width, 1.0f))) {
            return Edge.TOP;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y, 1.0f, screen.height))) {
            return Edge.LEFT;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y + screen.height, screen.width, 1.0f))) {
            return Edge.BOTTOM;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x + screen.width, screen.y, 1.0f, screen.height))) {
            return Edge.RIGHT;
        }
        return Edge.NONE;
    }

    private PointD selectSnapVertice(Point aPoint, VectorLayer layer, int buffer) {
        PolygonShape poly = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        float[] pXY = this.screenToProj(aPoint.x - buffer, aPoint.y + buffer);
        float minX = pXY[0];
        float minY = pXY[1];
        pXY = this.screenToProj(aPoint.x + buffer, aPoint.y - buffer);
        float maxX = pXY[0];
        float maxY = pXY[1];
        points.add(new PointD((double)minX, (double)minY));
        points.add(new PointD((double)minX, (double)maxY));
        points.add(new PointD((double)maxX, (double)maxY));
        points.add(new PointD((double)maxX, (double)minY));
        points.add(new PointD((double)minX, (double)minY));
        poly.setPoints(points);
        for (Shape shape : layer.getShapes()) {
            if (shape.isEditing() || !poly.intersects(shape) || poly.within(shape)) continue;
            for (PointD p : shape.getPoints()) {
                if (!MIMath.pointInExtent((PointD)p, (Extent)poly.getExtent())) continue;
                return p;
            }
        }
        return null;
    }

    private int selectEditVertices(Point aPoint, Shape aShape, List<PointD> vertices) {
        int vIdx = -1;
        List points = aShape.getPoints();
        int buffer = 4;
        Extent aExtent = new Extent();
        float[] pXY = this.screenToProj(aPoint.x - buffer, aPoint.y + buffer);
        aExtent.minX = pXY[0];
        aExtent.minY = pXY[1];
        pXY = this.screenToProj(aPoint.x + buffer, aPoint.y - buffer);
        aExtent.maxX = pXY[0];
        aExtent.maxY = pXY[1];
        vertices.clear();
        for (int i = 0; i < points.size(); ++i) {
            if (!MIMath.pointInExtent((PointD)((PointD)points.get(i)), (Extent)aExtent)) continue;
            vIdx = i;
            vertices.add((PointD)points.get(i));
            switch (aShape.getShapeType()) {
                case POINT: 
                case POINT_Z: {
                    vertices.add((PointD)points.get(0));
                    break;
                }
                case POLYLINE: 
                case CURVE_LINE: {
                    if (i == 0) {
                        vertices.add((PointD)points.get(i + 1));
                        break;
                    }
                    if (i == points.size() - 1) {
                        vertices.add((PointD)points.get(i - 1));
                        break;
                    }
                    vertices.add((PointD)points.get(i - 1));
                    vertices.add((PointD)points.get(i + 1));
                    break;
                }
                default: {
                    if (i == 0) {
                        vertices.add((PointD)points.get(i + 1));
                        PointD aPD = (PointD)points.get(points.size() - 1);
                        if (aPD.X == ((PointD)points.get((int)i)).X && aPD.Y == ((PointD)points.get((int)i)).Y) {
                            vertices.add((PointD)points.get(points.size() - 2));
                            break;
                        }
                        vertices.add(aPD);
                        break;
                    }
                    if (i == points.size() - 1) {
                        vertices.add((PointD)points.get(i - 1));
                        PointD aPD = (PointD)points.get(0);
                        if (aPD.X == ((PointD)points.get((int)i)).X && aPD.Y == ((PointD)points.get((int)i)).Y) {
                            vertices.add((PointD)points.get(1));
                            break;
                        }
                        vertices.add((PointD)points.get(0));
                        break;
                    }
                    vertices.add((PointD)points.get(i - 1));
                    vertices.add((PointD)points.get(i + 1));
                    break;
                }
            }
            break;
        }
        return vIdx;
    }

    private int isOnRing(Point aPoint, Shape aShape) {
        int buffer = 2;
        Extent aExtent = new Extent();
        float[] pXY = this.screenToProj(aPoint.x - buffer, aPoint.y + buffer);
        aExtent.minX = pXY[0];
        aExtent.minY = pXY[1];
        pXY = this.screenToProj(aPoint.x + buffer, aPoint.y - buffer);
        aExtent.maxX = pXY[0];
        aExtent.maxY = pXY[1];
        PointD bPoint = aExtent.getCenterPoint();
        if (MIMath.isExtentCross((Extent)aExtent, (Extent)aShape.getExtent()).booleanValue()) {
            switch (aShape.getShapeType()) {
                case POLYLINE: {
                    PolylineShape lShape = (PolylineShape)aShape;
                    for (Polyline line : lShape.getPolylines()) {
                        Object sel = GeoComputation.selectPolyline((PointD)bPoint, (List)line.getPointList(), (double)(aExtent.getWidth() / 2.0));
                        if (sel == null) continue;
                        return (Integer)((Object[])sel)[0];
                    }
                    break;
                }
                case POLYGON: {
                    PolygonShape pShape = (PolygonShape)aShape;
                    for (Polygon polygon : pShape.getPolygons()) {
                        for (List points : polygon.getRings()) {
                            Object sel = GeoComputation.selectPolyline((PointD)bPoint, (List)points, (double)(aExtent.getWidth() / 2.0));
                            if (sel == null) continue;
                            return (Integer)((Object[])sel)[0];
                        }
                    }
                    break;
                }
            }
        }
        return -1;
    }

    public PolygonShape selectShape(VectorLayer layer, PointF p) {
        float sX = p.X;
        float sY = p.Y;
        double[] projXY = this.screenToProj((double)p.X, (double)p.Y);
        double projX = projXY[0];
        double projY = projXY[1];
        if (this._projection.isLonLatMap()) {
            double[] sXY;
            if (projX < layer.getExtent().minX && layer.getExtent().minX > -360.0 && layer.getExtent().maxX > 0.0) {
                sXY = this.projToScreen(projX, projY, 360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
            if (projX > layer.getExtent().maxX && layer.getExtent().maxX < 360.0 && layer.getExtent().minX < 0.0) {
                sXY = this.projToScreen(projX, projY, -360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
        }
        projXY = this.screenToProj((double)sX, (double)sY);
        projX = projXY[0];
        projY = projXY[1];
        for (int i = 0; i < layer.getShapeNum(); ++i) {
            PolygonShape shape = (PolygonShape)layer.getShapes().get(i);
            if (!GeoComputation.pointInPolygon((PolygonShape)shape, (PointD)new PointD(projX, projY))) continue;
            return shape;
        }
        return null;
    }

    public Object[] selectPolygonHole(VectorLayer layer, PointF p) {
        float sX = p.X;
        float sY = p.Y;
        double[] projXY = this.screenToProj((double)p.X, (double)p.Y);
        double projX = projXY[0];
        double projY = projXY[1];
        if (this._projection.isLonLatMap()) {
            double[] sXY;
            if (projX < layer.getExtent().minX && layer.getExtent().minX > -360.0 && layer.getExtent().maxX > 0.0) {
                sXY = this.projToScreen(projX, projY, 360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
            if (projX > layer.getExtent().maxX && layer.getExtent().maxX < 360.0 && layer.getExtent().minX < 0.0) {
                sXY = this.projToScreen(projX, projY, -360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
        }
        projXY = this.screenToProj((double)sX, (double)sY);
        projX = projXY[0];
        projY = projXY[1];
        return layer.selectPolygonHole(new PointD(projX, projY));
    }

    public List<Integer> selectShapes(VectorLayer aLayer, PointF aPoint, boolean onlyVisible, boolean isSel) {
        float sX = aPoint.X;
        float sY = aPoint.Y;
        double[] projXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
        double ProjX = projXY[0];
        double ProjY = projXY[1];
        if (this._projection.isLonLatMap()) {
            double[] sXY;
            if (ProjX < aLayer.getExtent().minX && aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                sXY = this.projToScreen(ProjX, ProjY, 360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
            if (ProjX > aLayer.getExtent().maxX && aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                sXY = this.projToScreen(ProjX, ProjY, -360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
        }
        int Buffer2 = 5;
        Extent aExtent = new Extent();
        projXY = this.screenToProj((double)sX - (double)Buffer2, (double)(sY + (float)Buffer2));
        ProjX = projXY[0];
        ProjY = projXY[1];
        aExtent.minX = ProjX;
        aExtent.minY = ProjY;
        projXY = this.screenToProj((double)sX + (double)Buffer2, (double)(sY - (float)Buffer2));
        ProjX = projXY[0];
        ProjY = projXY[1];
        aExtent.maxX = ProjX;
        aExtent.maxY = ProjY;
        List<Integer> selectedShapes = onlyVisible ? aLayer.selectShapes(aExtent, aLayer.getVisibleShapes(), isSel) : aLayer.selectShapes(aExtent, isSel);
        return selectedShapes;
    }

    public List<Integer> selectShapes(VectorLayer aLayer, PointF aPoint) {
        return this.selectShapes(aLayer, aPoint, false, false);
    }

    public List<Integer> selectShapes(VectorLayer aLayer, List<Shape> baseShapes, Rectangle2D.Float rect, boolean isSingleSel, boolean isSel) {
        Extent aExtent = new Extent();
        double[] projs = this.screenToProj(rect.getMinX(), rect.getMinY());
        aExtent.minX = projs[0];
        aExtent.maxY = projs[1];
        projs = this.screenToProj(rect.getMaxX(), rect.getMaxY());
        aExtent.maxX = projs[0];
        aExtent.minY = projs[1];
        if (this._projection.isLonLatMap()) {
            if (aExtent.maxX < aLayer.getExtent().minX && aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                aExtent = MIMath.shiftExtentLon((Extent)aExtent, (double)360.0);
            }
            if (aExtent.minX > aLayer.getExtent().maxX && aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                aExtent = MIMath.shiftExtentLon((Extent)aExtent, (double)-360.0);
            }
        }
        List<Integer> selectedShapes = aLayer.selectShapes(aExtent, baseShapes, isSingleSel);
        if (isSel) {
            for (int i : selectedShapes) {
                aLayer.getShapes().get(i).setSelected(true);
            }
        }
        return selectedShapes;
    }

    public List<Integer> selectShapes(VectorLayer aLayer, Rectangle2D.Float rect, boolean isSingleSel) {
        return this.selectShapes(aLayer, aLayer.getShapes(), rect, isSingleSel, false);
    }

    public List<Integer> selectShapes(VectorLayer aLayer, Rectangle2D.Float rect) {
        return this.selectShapes(aLayer, aLayer.getShapes(), rect, false, false);
    }

    public int[] selectGridCell(RasterLayer aLayer, PointF aPoint) {
        double LonShift = 0.0;
        double[] projXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
        double aX = projXY[0];
        double aY = projXY[1];
        if (this._projection.isLonLatMap()) {
            if (aX < aLayer.getExtent().minX && aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                LonShift = 360.0;
            }
            if (aX > aLayer.getExtent().maxX && aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                LonShift = -360.0;
            }
        }
        Extent aExtent = new Extent();
        double XDelt = aLayer.getGridData().xArray[1] - aLayer.getGridData().xArray[0];
        double YDelt = aLayer.getGridData().yArray[1] - aLayer.getGridData().yArray[0];
        aExtent.minX = (aX += (double)((float)LonShift)) - XDelt / 2.0;
        aExtent.maxX = aX + XDelt / 2.0;
        aExtent.minY = aY - YDelt / 2.0;
        aExtent.maxY = aY + YDelt / 2.0;
        int iIdx = -1;
        int jIdx = -1;
        for (int i = 0; i < aLayer.getGridData().getYNum(); ++i) {
            if (!(aLayer.getGridData().yArray[i] >= aExtent.minY) || !(aLayer.getGridData().yArray[i] <= aExtent.maxY)) continue;
            iIdx = i;
            break;
        }
        for (int j = 0; j < aLayer.getGridData().getXNum(); ++j) {
            if (!(aLayer.getGridData().xArray[j] >= aExtent.minX) || !(aLayer.getGridData().xArray[j] <= aExtent.maxX)) continue;
            jIdx = j;
            break;
        }
        if (iIdx == -1 || jIdx == -1) {
            return null;
        }
        return new int[]{iIdx, jIdx};
    }

    public java.awt.Rectangle getGraphicRectangle(Graphics2D g, Graphic aGraphic, double lonShift) {
        java.awt.Rectangle rect = new java.awt.Rectangle();
        switch (aGraphic.getShape().getShapeType()) {
            case POINT: 
            case POINT_M: {
                PointShape aPS = (PointShape)aGraphic.getShape();
                double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, lonShift);
                float aX = (float)sXY[0];
                float aY = (float)sXY[1];
                switch (aGraphic.getLegend().getBreakType()) {
                    case POINT_BREAK: {
                        PointBreak aPB = (PointBreak)aGraphic.getLegend();
                        int buffer = (int)aPB.getSize() + 2;
                        rect.x = (int)aX - buffer / 2;
                        rect.y = (int)aY - buffer / 2;
                        rect.width = buffer;
                        rect.height = buffer;
                        break;
                    }
                    case LABEL_BREAK: {
                        LabelBreak aLB = (LabelBreak)aGraphic.getLegend();
                        g.setFont(aLB.getFont());
                        Dimension labSize = Draw.getStringDimension((List)aLB.getTexts(), (int)aLB.getLineSpace(), (Graphics2D)g);
                        switch (aLB.getAlignType()) {
                            case CENTER: {
                                aX -= (float)(labSize.width / 2);
                                break;
                            }
                            case RIGHT: {
                                aX -= (float)labSize.width;
                            }
                        }
                        Dimension dim = Draw.getStringDimension((String)((String)aLB.getTexts().get(0)), (Graphics2D)g);
                        aY -= aLB.getYShift();
                        rect.x = (int)aX;
                        rect.y = (int)(aY -= (float)(dim.height / 2));
                        rect.width = labSize.width;
                        rect.height = labSize.height;
                        break;
                    }
                    case CHART_BREAK: {
                        ChartBreak aCB = (ChartBreak)aGraphic.getLegend();
                        rect = aCB.getDrawExtent(new PointF(aX, aY)).convertToRectangle();
                    }
                }
                break;
            }
            case POLYLINE: 
            case POLYGON: 
            case RECTANGLE: 
            case CIRCLE: 
            case CURVE_POLYGON: 
            case ELLIPSE: 
            case CURVE_LINE: {
                List newPList = aGraphic.getShape().getPoints();
                ArrayList<PointD> points = new ArrayList<PointD>();
                for (PointD wPoint : newPList) {
                    double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, lonShift);
                    float aX = (float)sXY[0];
                    float aY = (float)sXY[1];
                    points.add(new PointD((double)aX, (double)aY));
                }
                Extent aExtent = GeometryUtil.getPointsExtent(points);
                rect.x = (int)aExtent.minX;
                rect.y = (int)aExtent.minY;
                rect.width = (int)(aExtent.maxX - aExtent.minX);
                rect.height = (int)(aExtent.maxY - aExtent.minY);
            }
        }
        return rect;
    }

    public java.awt.Rectangle getGraphicRectangle(Graphic aGraphic, double lonShift) {
        return this.getGraphicRectangle((Graphics2D)this.getGraphics(), aGraphic, lonShift);
    }

    public java.awt.Rectangle getGraphicRectangle(Graphic aGraphic) {
        return this.getGraphicRectangle((Graphics2D)this.getGraphics(), aGraphic, 0.0);
    }

    public void addGraphic(Graphic graphic) {
        this._graphicCollection.add(graphic);
    }

    public void removeGraphic(Graphic aGraphic) {
        if (aGraphic.getClass().equals(ChartGraphic.class)) {
            for (MapLayer aLayer : this.layers) {
                VectorLayer aVLayer;
                if (aLayer.getLayerType() != LayerTypes.VECTOR_LAYER || !(aVLayer = (VectorLayer)aLayer).getChartPoints().contains((ChartGraphic)aGraphic)) continue;
                aVLayer.getChartPoints().remove((ChartGraphic)aGraphic);
                break;
            }
        } else if (this._graphicCollection.contains(aGraphic)) {
            this._graphicCollection.remove(aGraphic);
        } else {
            for (MapLayer aLayer : this.layers) {
                VectorLayer aVLayer;
                if (aLayer.getLayerType() != LayerTypes.VECTOR_LAYER || !(aVLayer = (VectorLayer)aLayer).getLabelPoints().contains(aGraphic)) continue;
                aVLayer.getLabelPoints().remove(aGraphic);
                break;
            }
        }
    }

    public void removeSelectedGraphics() {
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.RemoveGraphicsEdit edit = new MapViewUndoRedo.RemoveGraphicsEdit(mapViewUndoRedo, this, this._selectedGraphics.getGraphics());
        this.fireUndoEditEvent(edit);
        for (Graphic aGraphic : this._selectedGraphics.getGraphics()) {
            this.removeGraphic(aGraphic);
        }
        this._selectedGraphics.clear();
    }

    public void exportExtentsElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element Extents = m_Doc.createElement("Extents");
        Attr xMin = m_Doc.createAttribute("xMin");
        Attr xMax = m_Doc.createAttribute("xMax");
        Attr yMin = m_Doc.createAttribute("yMin");
        Attr yMax = m_Doc.createAttribute("yMax");
        xMin.setValue(String.valueOf(this._viewExtent.minX));
        xMax.setValue(String.valueOf(this._viewExtent.maxX));
        yMin.setValue(String.valueOf(this._viewExtent.minY));
        yMax.setValue(String.valueOf(this._viewExtent.maxY));
        Extents.setAttributeNode(xMin);
        Extents.setAttributeNode(xMax);
        Extents.setAttributeNode(yMin);
        Extents.setAttributeNode(yMax);
        parent.appendChild(Extents);
    }

    public void exportMapPropElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element mapProperty = m_Doc.createElement("MapProperty");
        Attr BackColor = m_Doc.createAttribute("BackColor");
        Attr ForeColor = m_Doc.createAttribute("ForeColor");
        Attr SmoothingMode = m_Doc.createAttribute("SmoothingMode");
        Attr pointSmoothingMode = m_Doc.createAttribute("PointSmoothingMode");
        Attr xyScaleFactor = m_Doc.createAttribute("XYScaleFactor");
        Attr multiGlobalDraw = m_Doc.createAttribute("MultiGlobalDraw");
        Attr selectColor = m_Doc.createAttribute("SelectColor");
        Attr highSpeedWheelZoom = m_Doc.createAttribute("HighSpeedWheelZoom");
        BackColor.setValue(ColorUtil.toHexEncoding((Color)this.getBackground()));
        ForeColor.setValue(ColorUtil.toHexEncoding((Color)this.getForeground()));
        SmoothingMode.setValue(String.valueOf(this._antiAlias));
        pointSmoothingMode.setValue(String.valueOf(this._pointAntiAlias));
        xyScaleFactor.setValue(String.valueOf(this._XYScaleFactor));
        multiGlobalDraw.setValue(String.valueOf(this._multiGlobalDraw));
        selectColor.setValue(ColorUtil.toHexEncoding((Color)this._selectColor));
        highSpeedWheelZoom.setValue(String.valueOf(this._highSpeedWheelZoom));
        mapProperty.setAttributeNode(BackColor);
        mapProperty.setAttributeNode(ForeColor);
        mapProperty.setAttributeNode(SmoothingMode);
        mapProperty.setAttributeNode(pointSmoothingMode);
        mapProperty.setAttributeNode(xyScaleFactor);
        mapProperty.setAttributeNode(multiGlobalDraw);
        mapProperty.setAttributeNode(selectColor);
        mapProperty.setAttributeNode(highSpeedWheelZoom);
        parent.appendChild(mapProperty);
    }

    public void exportGridLineElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element GridLine = m_Doc.createElement("GridLine");
        Attr GridLineColor = m_Doc.createAttribute("GridLineColor");
        Attr GridLineSize = m_Doc.createAttribute("GridLineSize");
        Attr GridLineStyle = m_Doc.createAttribute("GridLineStyle");
        Attr DrawGridLine = m_Doc.createAttribute("DrawGridLine");
        Attr DrawGridTickLine = m_Doc.createAttribute("DrawGridTickLine");
        GridLineColor.setValue(ColorUtil.toHexEncoding((Color)this._gridLineColor));
        GridLineSize.setValue(String.valueOf(this._gridLineSize));
        GridLineStyle.setValue(this._gridLineStyle.toString());
        DrawGridLine.setValue(String.valueOf(this._drawGridLine));
        DrawGridTickLine.setValue(String.valueOf(this._drawGridTickLine));
        GridLine.setAttributeNode(GridLineColor);
        GridLine.setAttributeNode(GridLineSize);
        GridLine.setAttributeNode(GridLineStyle);
        GridLine.setAttributeNode(DrawGridLine);
        GridLine.setAttributeNode(DrawGridTickLine);
        parent.appendChild(GridLine);
    }

    public void exportMaskOutElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element MaskOut2 = m_Doc.createElement("MaskOut");
        Attr SetMaskLayer = m_Doc.createAttribute("SetMaskLayer");
        Attr MaskLayer = m_Doc.createAttribute("MaskLayer");
        SetMaskLayer.setValue(String.valueOf(this._maskOut.isMask()));
        MaskLayer.setValue(this._maskOut.getMaskLayer());
        MaskOut2.setAttributeNode(SetMaskLayer);
        MaskOut2.setAttributeNode(MaskLayer);
        parent.appendChild(MaskOut2);
    }

    public void exportProjectionElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element Projection2 = m_Doc.createElement("Projection");
        Attr IsLonLatMap = m_Doc.createAttribute("IsLonLatMap");
        Attr ProjStr = m_Doc.createAttribute("ProjStr");
        IsLonLatMap.setValue(String.valueOf(this._projection.isLonLatMap()));
        ProjStr.setValue(this._projection.getProjInfo().toProj4String());
        Projection2.setAttributeNode(IsLonLatMap);
        Projection2.setAttributeNode(ProjStr);
        parent.appendChild(Projection2);
    }

    public void exportVectorLayerElement(org.w3c.dom.Document m_Doc, Element parent, VectorLayer aVLayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr FileName = m_Doc.createAttribute("FileName");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr ShapeType = m_Doc.createAttribute("ShapeType");
        Attr AvoidCollision = m_Doc.createAttribute("AvoidCollision");
        Attr TransparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Attr Expanded = m_Doc.createAttribute("Expanded");
        Handle.setValue(String.valueOf(aVLayer.getHandle()));
        LayerName.setValue(aVLayer.getLayerName());
        try {
            FileName.setValue(GlobalUtil.getRelativePath((String)aVLayer.getFileName(), (String)projectFilePath));
        }
        catch (IOException ex) {
            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Visible.setValue(String.valueOf(aVLayer.isVisible()));
        IsMaskout.setValue(String.valueOf(aVLayer.isMaskout()));
        LayerType.setValue(aVLayer.getLayerType().toString());
        LayerDrawType2.setValue(aVLayer.getLayerDrawType().toString());
        ShapeType.setValue(aVLayer.getShapeType().toString());
        AvoidCollision.setValue(String.valueOf(aVLayer.getAvoidCollision()));
        TransparencyPerc.setValue(String.valueOf(aVLayer.getTransparency()));
        Expanded.setValue(String.valueOf(aVLayer.isExpanded()));
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(FileName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(ShapeType);
        Layer.setAttributeNode(AvoidCollision);
        Layer.setAttributeNode(TransparencyPerc);
        Layer.setAttributeNode(Expanded);
        aVLayer.getLegendScheme().exportToXML(m_Doc, Layer);
        this.exportLabelSet(m_Doc, Layer, aVLayer.getLabelSet());
        this.exportGraphics(m_Doc, Layer, aVLayer.getLabelPoints());
        this.exportChartSet(m_Doc, Layer, aVLayer.getChartSet());
        this.exportChartGraphics(m_Doc, Layer, aVLayer.getChartPoints());
        this.exportVisibleScale(m_Doc, Layer, aVLayer.getVisibleScale());
        parent.appendChild(Layer);
    }

    private void exportLabelSet(org.w3c.dom.Document m_Doc, Element parent, LabelSet aLabelSet) {
        Element LabelSet2 = m_Doc.createElement("LabelSet");
        Attr DrawLabels = m_Doc.createAttribute("DrawLabels");
        Attr FieldName = m_Doc.createAttribute("FieldName");
        Attr FontName = m_Doc.createAttribute("FontName");
        Attr FontSize = m_Doc.createAttribute("FontSize");
        Attr LabelColor = m_Doc.createAttribute("LabelColor");
        Attr DrawShadow = m_Doc.createAttribute("DrawShadow");
        Attr ShadowColor = m_Doc.createAttribute("ShadowColor");
        Attr AlignType2 = m_Doc.createAttribute("AlignType");
        Attr Offset = m_Doc.createAttribute("Offset");
        Attr AvoidCollision = m_Doc.createAttribute("AvoidCollision");
        Attr autoDecimal = m_Doc.createAttribute("AutoDecimal");
        Attr decimalDigits = m_Doc.createAttribute("DecimalDigits");
        DrawLabels.setValue(String.valueOf(aLabelSet.isDrawLabels()));
        FieldName.setValue(aLabelSet.getFieldName());
        FontName.setValue(aLabelSet.getLabelFont().getFontName());
        FontSize.setValue(String.valueOf(aLabelSet.getLabelFont().getSize()));
        LabelColor.setValue(ColorUtil.toHexEncoding((Color)aLabelSet.getLabelColor()));
        DrawShadow.setValue(String.valueOf(aLabelSet.isDrawShadow()));
        ShadowColor.setValue(ColorUtil.toHexEncoding((Color)aLabelSet.getShadowColor()));
        AlignType2.setValue(aLabelSet.getLabelAlignType().toString());
        Offset.setValue(String.valueOf(aLabelSet.getYOffset()));
        AvoidCollision.setValue(String.valueOf(aLabelSet.isAvoidCollision()));
        autoDecimal.setValue(String.valueOf(aLabelSet.isAutoDecimal()));
        decimalDigits.setValue(String.valueOf(aLabelSet.getDecimalDigits()));
        LabelSet2.setAttributeNode(DrawLabels);
        LabelSet2.setAttributeNode(FieldName);
        LabelSet2.setAttributeNode(FontName);
        LabelSet2.setAttributeNode(FontSize);
        LabelSet2.setAttributeNode(LabelColor);
        LabelSet2.setAttributeNode(DrawShadow);
        LabelSet2.setAttributeNode(ShadowColor);
        LabelSet2.setAttributeNode(AlignType2);
        LabelSet2.setAttributeNode(Offset);
        LabelSet2.setAttributeNode(AvoidCollision);
        LabelSet2.setAttributeNode(autoDecimal);
        LabelSet2.setAttributeNode(decimalDigits);
        parent.appendChild(LabelSet2);
    }

    private void exportChartSet(org.w3c.dom.Document m_Doc, Element parent, ChartSet aChartSet) {
        Element chartSet = m_Doc.createElement("ChartSet");
        Attr drawCharts = m_Doc.createAttribute("DrawCharts");
        Attr chartType = m_Doc.createAttribute("ChartType");
        Attr fieldNames = m_Doc.createAttribute("FieldNames");
        Attr xShift = m_Doc.createAttribute("XShift");
        Attr yShift = m_Doc.createAttribute("YShift");
        Attr maxSize = m_Doc.createAttribute("MaxSize");
        Attr minSize = m_Doc.createAttribute("MinSize");
        Attr maxValue = m_Doc.createAttribute("MaxValue");
        Attr minValue = m_Doc.createAttribute("MinValue");
        Attr barWidth = m_Doc.createAttribute("BarWidth");
        Attr avoidCollision = m_Doc.createAttribute("AvoidCollision");
        Attr alignType = m_Doc.createAttribute("AlignType");
        Attr view3D = m_Doc.createAttribute("View3D");
        Attr thickness = m_Doc.createAttribute("Thickness");
        Attr drawLabel = m_Doc.createAttribute("DrawLabel");
        Attr fontName = m_Doc.createAttribute("FontName");
        Attr fontSize = m_Doc.createAttribute("FontSize");
        Attr labelColor = m_Doc.createAttribute("LabelColor");
        drawCharts.setValue(String.valueOf(aChartSet.isDrawCharts()));
        chartType.setValue(String.valueOf(aChartSet.getChartType()));
        String fns = "";
        for (int i = 0; i < aChartSet.getFieldNames().size(); ++i) {
            fns = i == 0 ? aChartSet.getFieldNames().get(i) : fns + "," + aChartSet.getFieldNames().get(i);
        }
        fieldNames.setValue(fns);
        xShift.setValue(String.valueOf(aChartSet.getXShift()));
        yShift.setValue(String.valueOf(aChartSet.getYShift()));
        maxSize.setValue(String.valueOf(aChartSet.getMaxSize()));
        minSize.setValue(String.valueOf(aChartSet.getMinSize()));
        maxValue.setValue(String.valueOf(aChartSet.getMaxValue()));
        minValue.setValue(String.valueOf(aChartSet.getMinValue()));
        barWidth.setValue(String.valueOf(aChartSet.getBarWidth()));
        avoidCollision.setValue(String.valueOf(aChartSet.isAvoidCollision()));
        alignType.setValue(aChartSet.getAlignType().toString());
        view3D.setValue(String.valueOf(aChartSet.isView3D()));
        thickness.setValue(String.valueOf(aChartSet.getThickness()));
        drawLabel.setValue(String.valueOf(aChartSet.isDrawLabel()));
        fontName.setValue(aChartSet.getLabelFont().getFontName());
        fontSize.setValue(String.valueOf(aChartSet.getLabelFont().getSize()));
        labelColor.setValue(ColorUtil.toHexEncoding((Color)aChartSet.getLabelColor()));
        chartSet.setAttributeNode(drawCharts);
        chartSet.setAttributeNode(chartType);
        chartSet.setAttributeNode(fieldNames);
        chartSet.setAttributeNode(xShift);
        chartSet.setAttributeNode(yShift);
        chartSet.setAttributeNode(maxSize);
        chartSet.setAttributeNode(minSize);
        chartSet.setAttributeNode(maxValue);
        chartSet.setAttributeNode(minValue);
        chartSet.setAttributeNode(barWidth);
        chartSet.setAttributeNode(avoidCollision);
        chartSet.setAttributeNode(alignType);
        chartSet.setAttributeNode(view3D);
        chartSet.setAttributeNode(thickness);
        chartSet.setAttributeNode(drawLabel);
        chartSet.setAttributeNode(fontName);
        chartSet.setAttributeNode(fontSize);
        chartSet.setAttributeNode(labelColor);
        aChartSet.getLegendScheme().exportToXML(m_Doc, chartSet);
        parent.appendChild(chartSet);
    }

    private void exportChartGraphics(org.w3c.dom.Document m_Doc, Element parent, List<ChartGraphic> graphicList) {
        Element graphics = m_Doc.createElement("ChartGraphics");
        for (Graphic graphic : graphicList) {
            graphic.exportToXML(m_Doc, graphics);
        }
        parent.appendChild(graphics);
    }

    public void exportGraphics(org.w3c.dom.Document m_Doc, Element parent, List<Graphic> graphicList) {
        Element graphics = m_Doc.createElement("Graphics");
        for (Graphic aGraphic : graphicList) {
            aGraphic.exportToXML(m_Doc, graphics);
        }
        parent.appendChild(graphics);
    }

    private void exportVisibleScale(org.w3c.dom.Document m_Doc, Element parent, VisibleScale visibleScale) {
        Element visibleScaleElem = m_Doc.createElement("VisibleScale");
        Attr enableMinVisScale = m_Doc.createAttribute("EnableMinVisScale");
        Attr enableMaxVisScale = m_Doc.createAttribute("EnableMaxVisScale");
        Attr minVisScale = m_Doc.createAttribute("MinVisScale");
        Attr maxVisScale = m_Doc.createAttribute("MaxVisScale");
        enableMinVisScale.setValue(String.valueOf(visibleScale.isEnableMinVisScale()));
        enableMaxVisScale.setValue(String.valueOf(visibleScale.isEnableMaxVisScale()));
        minVisScale.setValue(String.valueOf(visibleScale.getMinVisScale()));
        maxVisScale.setValue(String.valueOf(visibleScale.getMaxVisScale()));
        visibleScaleElem.setAttributeNode(enableMinVisScale);
        visibleScaleElem.setAttributeNode(enableMaxVisScale);
        visibleScaleElem.setAttributeNode(minVisScale);
        visibleScaleElem.setAttributeNode(maxVisScale);
        parent.appendChild(visibleScaleElem);
    }

    public void exportImageLayer(org.w3c.dom.Document m_Doc, Element parent, ImageLayer aILayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr FileName = m_Doc.createAttribute("FileName");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr transparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Attr transparencyColor = m_Doc.createAttribute("TransparencyColor");
        Attr setTransColor = m_Doc.createAttribute("SetTransColor");
        Attr attrInterpolation = m_Doc.createAttribute("Interpolation");
        Handle.setValue(String.valueOf(aILayer.getHandle()));
        LayerName.setValue(aILayer.getLayerName());
        try {
            FileName.setValue(GlobalUtil.getRelativePath((String)aILayer.getFileName(), (String)projectFilePath));
        }
        catch (IOException ex) {
            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Visible.setValue(String.valueOf(aILayer.isVisible()));
        IsMaskout.setValue(String.valueOf(aILayer.isMaskout()));
        LayerType.setValue(aILayer.getLayerType().toString());
        LayerDrawType2.setValue(aILayer.getLayerDrawType().toString());
        transparencyPerc.setValue(String.valueOf(aILayer.getTransparency()));
        transparencyColor.setValue(ColorUtil.toHexEncoding((Color)aILayer.getTransparencyColor()));
        setTransColor.setValue(String.valueOf(aILayer.isUseTransColor()));
        attrInterpolation.setValue(aILayer.getInterpolationStr());
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(FileName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(transparencyPerc);
        Layer.setAttributeNode(transparencyColor);
        Layer.setAttributeNode(setTransColor);
        Layer.setAttributeNode(attrInterpolation);
        this.exportVisibleScale(m_Doc, Layer, aILayer.getVisibleScale());
        parent.appendChild(Layer);
    }

    public void exportRasterLayer(org.w3c.dom.Document m_Doc, Element parent, RasterLayer aILayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr FileName = m_Doc.createAttribute("FileName");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr transparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Attr transparencyColor = m_Doc.createAttribute("TransparencyColor");
        Attr setTransColor = m_Doc.createAttribute("SetTransColor");
        Attr attrInterpolation = m_Doc.createAttribute("Interpolation");
        Handle.setValue(String.valueOf(aILayer.getHandle()));
        LayerName.setValue(aILayer.getLayerName());
        try {
            FileName.setValue(GlobalUtil.getRelativePath((String)aILayer.getFileName(), (String)projectFilePath));
        }
        catch (IOException ex) {
            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Visible.setValue(String.valueOf(aILayer.isVisible()));
        IsMaskout.setValue(String.valueOf(aILayer.isMaskout()));
        LayerType.setValue(aILayer.getLayerType().toString());
        LayerDrawType2.setValue(aILayer.getLayerDrawType().toString());
        transparencyPerc.setValue(String.valueOf(aILayer.getTransparency()));
        transparencyColor.setValue(ColorUtil.toHexEncoding((Color)aILayer.getTransparencyColor()));
        setTransColor.setValue(String.valueOf(aILayer.isUseTransColor()));
        attrInterpolation.setValue(aILayer.getInterpolationStr());
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(FileName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(transparencyPerc);
        Layer.setAttributeNode(transparencyColor);
        Layer.setAttributeNode(setTransColor);
        Layer.setAttributeNode(attrInterpolation);
        aILayer.getLegendScheme().exportToXML(m_Doc, Layer);
        this.exportVisibleScale(m_Doc, Layer, aILayer.getVisibleScale());
        parent.appendChild(Layer);
    }

    public void exportWebMapLayer(org.w3c.dom.Document m_Doc, Element parent, WebMapLayer wmLayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr webProvider = m_Doc.createAttribute("WebMapProvider");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr transparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Handle.setValue(String.valueOf(wmLayer.getHandle()));
        LayerName.setValue(wmLayer.getLayerName());
        Visible.setValue(String.valueOf(wmLayer.isVisible()));
        webProvider.setValue(wmLayer.getWebMapProvider().toString());
        IsMaskout.setValue(String.valueOf(wmLayer.isMaskout()));
        LayerType.setValue(wmLayer.getLayerType().toString());
        LayerDrawType2.setValue(wmLayer.getLayerDrawType().toString());
        transparencyPerc.setValue(String.valueOf(wmLayer.getTransparency()));
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(webProvider);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(transparencyPerc);
        parent.appendChild(Layer);
    }

    public void loadMapPropElement(Element parent) {
        Node mapProperty = parent.getElementsByTagName("MapProperty").item(0);
        try {
            Node hswz;
            Node selColor;
            Node mgd;
            Node scaleFactor;
            this.setBackground(ColorUtil.parseToColor((String)mapProperty.getAttributes().getNamedItem("BackColor").getNodeValue()));
            this.setForeground(ColorUtil.parseToColor((String)mapProperty.getAttributes().getNamedItem("ForeColor").getNodeValue()));
            this._antiAlias = Boolean.parseBoolean(mapProperty.getAttributes().getNamedItem("SmoothingMode").getNodeValue());
            Node paa = mapProperty.getAttributes().getNamedItem("PointSmoothingMode");
            if (paa != null) {
                this._pointAntiAlias = Boolean.parseBoolean(paa.getNodeValue());
            }
            if ((scaleFactor = mapProperty.getAttributes().getNamedItem("XYScaleFactor")) != null) {
                this._XYScaleFactor = Double.parseDouble(scaleFactor.getNodeValue());
            }
            if ((mgd = mapProperty.getAttributes().getNamedItem("MultiGlobalDraw")) != null) {
                this._multiGlobalDraw = Boolean.parseBoolean(mgd.getNodeValue());
            }
            if ((selColor = mapProperty.getAttributes().getNamedItem("SelectColor")) != null) {
                this._selectColor = ColorUtil.parseToColor((String)selColor.getNodeValue());
            }
            if ((hswz = mapProperty.getAttributes().getNamedItem("HighSpeedWheelZoom")) != null) {
                this._highSpeedWheelZoom = Boolean.parseBoolean(hswz.getNodeValue());
            }
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public void loadGridLineElement(Element parent) {
        Node GridLine = parent.getElementsByTagName("GridLine").item(0);
        try {
            this._gridLineColor = ColorUtil.parseToColor((String)GridLine.getAttributes().getNamedItem("GridLineColor").getNodeValue());
            this._gridLineSize = Integer.parseInt(GridLine.getAttributes().getNamedItem("GridLineSize").getNodeValue());
            this._gridLineStyle = LineStyles.valueOf((String)GridLine.getAttributes().getNamedItem("GridLineStyle").getNodeValue().toUpperCase());
            this._drawGridLine = Boolean.parseBoolean(GridLine.getAttributes().getNamedItem("DrawGridLine").getNodeValue());
            this._drawGridTickLine = Boolean.parseBoolean(GridLine.getAttributes().getNamedItem("DrawGridTickLine").getNodeValue());
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public void loadMaskOutElement(Element parent) {
        Node MaskOut2 = parent.getElementsByTagName("MaskOut").item(0);
        try {
            this._maskOut.setMask(Boolean.parseBoolean(MaskOut2.getAttributes().getNamedItem("SetMaskLayer").getNodeValue()));
            this._maskOut.setMaskLayer(MaskOut2.getAttributes().getNamedItem("MaskLayer").getNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadProjectionElement(Element parent) {
        Node Projection2 = parent.getElementsByTagName("Projection").item(0);
        try {
            this._projection.setProjStr(Projection2.getAttributes().getNamedItem("ProjStr").getNodeValue());
            if (this._projection.getProjInfo().getProjectionName() != ProjectionNames.LongLat) {
                ProjectionInfo toProj = ProjectionInfo.factory((String)this._projection.getProjStr());
                this.projectLayers(toProj);
            }
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public void loadExtentsElement(Element parent) {
        Node Extents = parent.getElementsByTagName("Extents").item(0);
        Extent aExtent = new Extent();
        aExtent.minX = Double.parseDouble(Extents.getAttributes().getNamedItem("xMin").getNodeValue());
        aExtent.maxX = Double.parseDouble(Extents.getAttributes().getNamedItem("xMax").getNodeValue());
        aExtent.minY = Double.parseDouble(Extents.getAttributes().getNamedItem("yMin").getNodeValue());
        aExtent.maxY = Double.parseDouble(Extents.getAttributes().getNamedItem("yMax").getNodeValue());
        this.setViewExtent(aExtent);
    }

    public VectorLayer loadVectorLayer(String pPath, Node aVLayer) {
        String fn = aVLayer.getAttributes().getNamedItem("FileName").getNodeValue();
        File lFile = new File(fn);
        if (!lFile.isAbsolute()) {
            Path path = Paths.get(pPath, fn);
            fn = path.normalize().toString();
        } else {
            fn = lFile.getAbsolutePath();
        }
        System.out.println(fn);
        VectorLayer aLayer = null;
        if (new File(fn).isFile()) {
            NodeList visScaleNodes;
            try {
                aLayer = (VectorLayer)MapDataManage.loadLayer(fn);
            }
            catch (IOException ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (aLayer == null) {
                return aLayer;
            }
            try {
                aLayer.setHandle(Integer.parseInt(aVLayer.getAttributes().getNamedItem("Handle").getNodeValue()));
                aLayer.setLayerName(aVLayer.getAttributes().getNamedItem("LayerName").getNodeValue());
                aLayer.setVisible(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("Visible").getNodeValue()));
                aLayer.setMaskout(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                aLayer.setTransparency(Integer.parseInt(aVLayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
                aLayer.setAvoidCollision(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("AvoidCollision").getNodeValue()));
                aLayer.setExpanded(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("Expanded").getNodeValue()));
                aLayer.setLayerDrawType(LayerDrawType.valueOfBack(aVLayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
            }
            catch (NumberFormatException | DOMException ex) {
                // empty catch block
            }
            Node LS = ((Element)aVLayer).getElementsByTagName("LegendScheme").item(0);
            LegendScheme ls = new LegendScheme(aLayer.getShapeType());
            ls.importFromXML(LS);
            aLayer.setLegendScheme(ls);
            Node labelNode = ((Element)aVLayer).getElementsByTagName("LabelSet").item(0);
            LabelSet aLabelSet = new LabelSet();
            this.loadLabelSet(labelNode, aLabelSet);
            aLayer.setLabelSet(aLabelSet);
            GraphicCollection gc = this.loadGraphicCollection((Element)aVLayer);
            aLayer.setLabelPoints(gc.getGraphics());
            NodeList chartNodes = ((Element)aVLayer).getElementsByTagName("ChartSet");
            if (chartNodes.getLength() > 0) {
                Node chartNode = chartNodes.item(0);
                ChartSet aChartSet = new ChartSet();
                this.loadChartSet(chartNode, aChartSet);
                aLayer.setChartSet(aChartSet);
                List<ChartGraphic> cgc = this.loadChartGraphicCollection((Element)aVLayer);
                aLayer.setChartPoints(cgc);
                aLayer.updateChartsProp();
            }
            if ((visScaleNodes = ((Element)aVLayer).getElementsByTagName("VisibleScale")).getLength() > 0) {
                Node visScaleNode = visScaleNodes.item(0);
                VisibleScale visScale = aLayer.getVisibleScale();
                this.loadVisibleScale(visScaleNode, visScale);
            }
        }
        return aLayer;
    }

    private void loadLabelSet(Node LabelNode, LabelSet aLabelSet) {
        try {
            aLabelSet.setDrawLabels(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("DrawLabels").getNodeValue()));
            aLabelSet.setFieldName(LabelNode.getAttributes().getNamedItem("FieldName").getNodeValue());
            String fontName = LabelNode.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(LabelNode.getAttributes().getNamedItem("FontSize").getNodeValue());
            aLabelSet.setLabelFont(new Font(fontName, 0, (int)fontSize));
            aLabelSet.setLabelColor(ColorUtil.parseToColor((String)LabelNode.getAttributes().getNamedItem("LabelColor").getNodeValue()));
            aLabelSet.setDrawShadow(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("DrawShadow").getNodeValue()));
            aLabelSet.setShadowColor(ColorUtil.parseToColor((String)LabelNode.getAttributes().getNamedItem("ShadowColor").getNodeValue()));
            aLabelSet.setLabelAlignType(AlignType.valueOfBack((String)LabelNode.getAttributes().getNamedItem("AlignType").getNodeValue()));
            aLabelSet.setYOffset(Integer.parseInt(LabelNode.getAttributes().getNamedItem("Offset").getNodeValue()));
            aLabelSet.setAvoidCollision(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("AvoidCollision").getNodeValue()));
            aLabelSet.setAutoDecimal(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("AutoDecimal").getNodeValue()));
            aLabelSet.setDecimalDigits(Integer.parseInt(LabelNode.getAttributes().getNamedItem("DecimalDigits").getNodeValue()));
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    private void loadChartSet(Node chartNode, ChartSet aChartSet) {
        try {
            aChartSet.setDrawCharts(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("DrawCharts").getNodeValue()));
            aChartSet.setChartType(ChartTypes.valueOfBack((String)chartNode.getAttributes().getNamedItem("ChartType").getNodeValue()));
            aChartSet.setFieldNames(new ArrayList<String>(Arrays.asList(chartNode.getAttributes().getNamedItem("FieldNames").getNodeValue().split(","))));
            aChartSet.setXShift(Integer.parseInt(chartNode.getAttributes().getNamedItem("XShift").getNodeValue()));
            aChartSet.setYShift(Integer.parseInt(chartNode.getAttributes().getNamedItem("YShift").getNodeValue()));
            aChartSet.setMaxSize(Integer.parseInt(chartNode.getAttributes().getNamedItem("MaxSize").getNodeValue()));
            aChartSet.setMinSize(Integer.parseInt(chartNode.getAttributes().getNamedItem("MinSize").getNodeValue()));
            aChartSet.setMaxValue(Float.parseFloat(chartNode.getAttributes().getNamedItem("MaxValue").getNodeValue()));
            aChartSet.setMinValue(Float.parseFloat(chartNode.getAttributes().getNamedItem("MinValue").getNodeValue()));
            aChartSet.setBarWidth(Integer.parseInt(chartNode.getAttributes().getNamedItem("BarWidth").getNodeValue()));
            aChartSet.setAvoidCollision(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("AvoidCollision").getNodeValue()));
            aChartSet.setAlignType(AlignType.valueOfBack((String)chartNode.getAttributes().getNamedItem("AlignType").getNodeValue()));
            aChartSet.setView3D(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("View3D").getNodeValue()));
            aChartSet.setThickness(Integer.parseInt(chartNode.getAttributes().getNamedItem("Thickness").getNodeValue()));
            aChartSet.setDrawLabel(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("DrawLabel").getNodeValue()));
            String fontName = chartNode.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(chartNode.getAttributes().getNamedItem("FontSize").getNodeValue());
            aChartSet.setLabelFont(new Font(fontName, 0, (int)fontSize));
            aChartSet.setLabelColor(ColorUtil.parseToColor((String)chartNode.getAttributes().getNamedItem("LabelColor").getNodeValue()));
        }
        catch (Exception fontName) {
            // empty catch block
        }
        Node lsNode = ((Element)chartNode).getElementsByTagName("LegendScheme").item(0);
        aChartSet.getLegendScheme().importFromXML(lsNode);
    }

    private void loadVisibleScale(Node visScaleNode, VisibleScale visibleScale) {
        try {
            visibleScale.setEnableMinVisScale(Boolean.parseBoolean(visScaleNode.getAttributes().getNamedItem("EnableMinVisScale").getNodeValue()));
            visibleScale.setEnableMaxVisScale(Boolean.parseBoolean(visScaleNode.getAttributes().getNamedItem("EnableMaxVisScale").getNodeValue()));
            visibleScale.setMinVisScale(Double.parseDouble(visScaleNode.getAttributes().getNamedItem("MinVisScale").getNodeValue()));
            visibleScale.setMaxVisScale(Double.parseDouble(visScaleNode.getAttributes().getNamedItem("MaxVisScale").getNodeValue()));
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public ImageLayer loadImageLayer(Node aILayer) {
        String aFile = aILayer.getAttributes().getNamedItem("FileName").getNodeValue();
        File lFile = new File(aFile);
        String curDir = System.getProperty("user.dir");
        if (new File(curDir).isFile()) {
            System.setProperty("user.dir", new File(curDir).getParent());
        }
        aFile = lFile.getAbsolutePath();
        ImageLayer aLayer = null;
        if (new File(aFile).exists()) {
            try {
                aLayer = MapDataManage.readImageFile(aFile);
            }
            catch (IOException ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                NodeList visScaleNodes;
                aLayer.setHandle(Integer.parseInt(aILayer.getAttributes().getNamedItem("Handle").getNodeValue()));
                aLayer.setLayerName(aILayer.getAttributes().getNamedItem("LayerName").getNodeValue());
                aLayer.setVisible(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("Visible").getNodeValue()));
                aLayer.setMaskout(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                aLayer.setLayerDrawType(LayerDrawType.valueOfBack(aILayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
                aLayer.setTransparency(Integer.parseInt(aILayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
                aLayer.setTransparencyColor(ColorUtil.parseToColor((String)aILayer.getAttributes().getNamedItem("TransparencyColor").getNodeValue()));
                aLayer.setUseTransColor(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("SetTransColor").getNodeValue()));
                Node attrInterp = aILayer.getAttributes().getNamedItem("Interpolation");
                if (attrInterp != null) {
                    aLayer.setInterpolation(attrInterp.getNodeValue());
                }
                if ((visScaleNodes = ((Element)aILayer).getElementsByTagName("VisibleScale")).getLength() > 0) {
                    Node visScaleNode = visScaleNodes.item(0);
                    VisibleScale visScale = aLayer.getVisibleScale();
                    this.loadVisibleScale(visScaleNode, visScale);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return aLayer;
    }

    public RasterLayer loadRasterLayer(Node aILayer) throws Exception {
        String aFile = aILayer.getAttributes().getNamedItem("FileName").getNodeValue();
        File lFile = new File(aFile);
        String curDir = System.getProperty("user.dir");
        if (new File(curDir).isFile()) {
            System.setProperty("user.dir", new File(curDir).getParent());
        }
        aFile = lFile.getAbsolutePath();
        RasterLayer aLayer = null;
        if (new File(aFile).exists()) {
            try {
                aLayer = (RasterLayer)MapDataManage.loadLayer(aFile);
            }
            catch (IOException ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                aLayer.setHandle(Integer.parseInt(aILayer.getAttributes().getNamedItem("Handle").getNodeValue()));
                aLayer.setLayerName(aILayer.getAttributes().getNamedItem("LayerName").getNodeValue());
                aLayer.setVisible(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("Visible").getNodeValue()));
                aLayer.setMaskout(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                aLayer.setLayerDrawType(LayerDrawType.valueOfBack(aILayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
                aLayer.setTransparency(Integer.parseInt(aILayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
                aLayer.setTransparencyColor(ColorUtil.parseToColor((String)aILayer.getAttributes().getNamedItem("TransparencyColor").getNodeValue()));
                aLayer.setUseTransColor(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("SetTransColor").getNodeValue()));
                Node attrInterp = aILayer.getAttributes().getNamedItem("Interpolation");
                if (attrInterp != null) {
                    aLayer.setInterpolation(attrInterp.getNodeValue());
                }
                Node LS = ((Element)aILayer).getElementsByTagName("LegendScheme").item(0);
                LegendScheme ls = new LegendScheme(aLayer.getShapeType());
                ls.importFromXML(LS);
                aLayer.setLegendScheme(ls);
                NodeList visScaleNodes = ((Element)aILayer).getElementsByTagName("VisibleScale");
                if (visScaleNodes.getLength() > 0) {
                    Node visScaleNode = visScaleNodes.item(0);
                    VisibleScale visScale = aLayer.getVisibleScale();
                    this.loadVisibleScale(visScaleNode, visScale);
                }
            }
            catch (NumberFormatException | DOMException runtimeException) {
                // empty catch block
            }
        }
        return aLayer;
    }

    public WebMapLayer loadWebMapLayer(Node wmLayer) throws Exception {
        WebMapLayer aLayer = new WebMapLayer();
        try {
            aLayer.setHandle(Integer.parseInt(wmLayer.getAttributes().getNamedItem("Handle").getNodeValue()));
            aLayer.setLayerName(wmLayer.getAttributes().getNamedItem("LayerName").getNodeValue());
            aLayer.setVisible(Boolean.parseBoolean(wmLayer.getAttributes().getNamedItem("Visible").getNodeValue()));
            aLayer.setWebMapProvider(WebMapProvider.valueOf((String)wmLayer.getAttributes().getNamedItem("WebMapProvider").getNodeValue()));
            aLayer.setMaskout(Boolean.parseBoolean(wmLayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
            aLayer.setLayerDrawType(LayerDrawType.valueOfBack(wmLayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
            aLayer.setTransparency(Integer.parseInt(wmLayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
        return aLayer;
    }

    public void loadGraphics(Element parent) {
        this._graphicCollection = this.loadGraphicCollection(parent);
    }

    private List<ChartGraphic> loadChartGraphicCollection(Element parent) {
        ArrayList<ChartGraphic> gc = new ArrayList<ChartGraphic>();
        Element graphics = (Element)parent.getElementsByTagName("ChartGraphics").item(0);
        if (graphics != null) {
            NodeList nList = graphics.getElementsByTagName("Graphic");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node graphicNode = nList.item(i);
                ChartGraphic aGraphic = new ChartGraphic();
                aGraphic.importFromXML((Element)graphicNode);
                gc.add(aGraphic);
            }
        }
        return gc;
    }

    private GraphicCollection loadGraphicCollection(Element parent) {
        GraphicCollection gc = new GraphicCollection();
        Node graphics = null;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            Node aNode = parent.getChildNodes().item(i);
            if (!"Graphics".equals(aNode.getNodeName())) continue;
            graphics = aNode;
            break;
        }
        if (graphics != null) {
            NodeList nList = ((Element)graphics).getElementsByTagName("Graphic");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node graphicNode = nList.item(i);
                Graphic aGraphic = new Graphic();
                aGraphic.importFromXML((Element)graphicNode);
                gc.add(aGraphic);
            }
        }
        return gc;
    }

    public void projectLayers(ProjectionInfo toProj) {
        this._projection.projectLayers(this, toProj);
        this.fireProjectionChangedEvent();
    }

    public void showMeasurementForm() {
        if (this._frmMeasure == null) {
            this._frmMeasure = new FrmMeasurement((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
            this._frmMeasure.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MapView.this.repaintOld();
                    MapView.this.setDrawIdentiferShape(false);
                }
            });
            this._frmMeasure.setLocationRelativeTo(this);
            this._frmMeasure.setVisible(true);
        } else if (!this._frmMeasure.isVisible()) {
            this._frmMeasure.setVisible(true);
        }
    }
}

